/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mscarries_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MSCARRIES_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MSCARRIES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/MsrowExpression.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMscarry;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMscarries_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMscarries_Base(void);
    // destructor
    virtual ~CMscarries_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_location {
            eAttlist_location_w  = 1,
            eAttlist_location_nw = 2,
            eAttlist_location_n  = 3,
            eAttlist_location_ne = 4,
            eAttlist_location_e  = 5,
            eAttlist_location_se = 6,
            eAttlist_location_s  = 7,
            eAttlist_location_sw = 8
        };
        
        /// Access to EAttlist_location's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_location)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TPosition;
        typedef EAttlist_location TLocation;
        typedef NCBI_NS_STD::string TCrossout;
        typedef NCBI_NS_STD::string TScriptsizemultiplier;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_position,
            e_location,
            e_crossout,
            e_scriptsizemultiplier
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 12> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TPosition
        ///  Check whether the Position data member has been assigned a value.
        bool IsSetPosition(void) const;
        /// Check whether it is safe or not to call GetPosition method.
        bool CanGetPosition(void) const;
        void ResetPosition(void);
        const TPosition& GetPosition(void) const;
        void SetPosition(const TPosition& value);
        void SetPosition(TPosition&& value);
        TPosition& SetPosition(void);
    
        /// optional
        /// typedef EAttlist_location TLocation
        ///  Check whether the Location data member has been assigned a value.
        bool IsSetLocation(void) const;
        /// Check whether it is safe or not to call GetLocation method.
        bool CanGetLocation(void) const;
        void ResetLocation(void);
        TLocation GetLocation(void) const;
        void SetLocation(TLocation value);
        TLocation& SetLocation(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TCrossout
        ///  Check whether the Crossout data member has been assigned a value.
        bool IsSetCrossout(void) const;
        /// Check whether it is safe or not to call GetCrossout method.
        bool CanGetCrossout(void) const;
        void ResetCrossout(void);
        const TCrossout& GetCrossout(void) const;
        void SetCrossout(const TCrossout& value);
        void SetCrossout(TCrossout&& value);
        TCrossout& SetCrossout(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TScriptsizemultiplier
        ///  Check whether the Scriptsizemultiplier data member has been assigned a value.
        bool IsSetScriptsizemultiplier(void) const;
        /// Check whether it is safe or not to call GetScriptsizemultiplier method.
        bool CanGetScriptsizemultiplier(void) const;
        void ResetScriptsizemultiplier(void);
        const TScriptsizemultiplier& GetScriptsizemultiplier(void) const;
        void SetScriptsizemultiplier(const TScriptsizemultiplier& value);
        void SetScriptsizemultiplier(TScriptsizemultiplier&& value);
        TScriptsizemultiplier& SetScriptsizemultiplier(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Position;
        EAttlist_location m_Location;
        NCBI_NS_STD::string m_Crossout;
        NCBI_NS_STD::string m_Scriptsizemultiplier;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_Mscarries : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_E_Mscarries(void);
        // destructor
        ~C_E_Mscarries(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        typedef CMsrowExpression C_MsrowExpression;
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,      ///< No variant selected
            e_MsrowExpression,
            e_Mscarry
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Mscarry+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef C_MsrowExpression TMsrowExpression;
        typedef CMscarry TMscarry;
    
        // getters
        // setters
    
        // typedef C_MsrowExpression TMsrowExpression
        bool IsMsrowExpression(void) const;
        const TMsrowExpression& GetMsrowExpression(void) const;
        TMsrowExpression& SetMsrowExpression(void);
        void SetMsrowExpression(TMsrowExpression& value);
    
        // typedef CMscarry TMscarry
        bool IsMscarry(void) const;
        const TMscarry& GetMscarry(void) const;
        TMscarry& SetMscarry(void);
        void SetMscarry(TMscarry& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E_Mscarries(const C_E_Mscarries& );
        C_E_Mscarries& operator=(const C_E_Mscarries& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_E_Mscarries C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Mscarries > > TMscarries;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_mscarries
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Mscarries > > TMscarries
    ///  Check whether the Mscarries data member has been assigned a value.
    bool IsSetMscarries(void) const;
    /// Check whether it is safe or not to call GetMscarries method.
    bool CanGetMscarries(void) const;
    void ResetMscarries(void);
    const TMscarries& GetMscarries(void) const;
    TMscarries& SetMscarries(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMscarries_Base(const CMscarries_Base&);
    CMscarries_Base& operator=(const CMscarries_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Mscarries > > m_Mscarries;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMscarries_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMscarries_Base::C_Attlist::TId& CMscarries_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMscarries_Base::C_Attlist::SetId(const CMscarries_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMscarries_Base::C_Attlist::SetId(CMscarries_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMscarries_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMscarries_Base::C_Attlist::TId& CMscarries_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMscarries_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMscarries_Base::C_Attlist::TXref& CMscarries_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMscarries_Base::C_Attlist::SetXref(const CMscarries_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMscarries_Base::C_Attlist::SetXref(CMscarries_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMscarries_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMscarries_Base::C_Attlist::TXref& CMscarries_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMscarries_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMscarries_Base::C_Attlist::TClass& CMscarries_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMscarries_Base::C_Attlist::SetClass(const CMscarries_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMscarries_Base::C_Attlist::SetClass(CMscarries_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMscarries_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMscarries_Base::C_Attlist::TClass& CMscarries_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMscarries_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMscarries_Base::C_Attlist::TStyle& CMscarries_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMscarries_Base::C_Attlist::SetStyle(const CMscarries_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMscarries_Base::C_Attlist::SetStyle(CMscarries_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMscarries_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMscarries_Base::C_Attlist::TStyle& CMscarries_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMscarries_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMscarries_Base::C_Attlist::THref& CMscarries_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMscarries_Base::C_Attlist::SetHref(const CMscarries_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMscarries_Base::C_Attlist::SetHref(CMscarries_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMscarries_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMscarries_Base::C_Attlist::THref& CMscarries_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMscarries_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMscarries_Base::C_Attlist::TMathcolor& CMscarries_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMscarries_Base::C_Attlist::SetMathcolor(const CMscarries_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMscarries_Base::C_Attlist::SetMathcolor(CMscarries_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMscarries_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMscarries_Base::C_Attlist::TMathcolor& CMscarries_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMscarries_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMscarries_Base::C_Attlist::TMathbackground& CMscarries_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMscarries_Base::C_Attlist::SetMathbackground(const CMscarries_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMscarries_Base::C_Attlist::SetMathbackground(CMscarries_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMscarries_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMscarries_Base::C_Attlist::TMathbackground& CMscarries_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMscarries_Base::C_Attlist::IsSetPosition(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetPosition(void) const
{
    return IsSetPosition();
}

inline
const CMscarries_Base::C_Attlist::TPosition& CMscarries_Base::C_Attlist::GetPosition(void) const
{
    if (!CanGetPosition()) {
        ThrowUnassigned(7);
    }
    return m_Position;
}

inline
void CMscarries_Base::C_Attlist::SetPosition(const CMscarries_Base::C_Attlist::TPosition& value)
{
    m_Position = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMscarries_Base::C_Attlist::SetPosition(CMscarries_Base::C_Attlist::TPosition&& value)
{
    m_Position = std::forward<CMscarries_Base::C_Attlist::TPosition>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMscarries_Base::C_Attlist::TPosition& CMscarries_Base::C_Attlist::SetPosition(void)
{
#ifdef _DEBUG
    if (!IsSetPosition()) {
        m_Position = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Position;
}

inline
bool CMscarries_Base::C_Attlist::IsSetLocation(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetLocation(void) const
{
    return IsSetLocation();
}

inline
void CMscarries_Base::C_Attlist::ResetLocation(void)
{
    m_Location = (EAttlist_location)(0);
    m_set_State[0] &= ~0x30000;
}

inline
CMscarries_Base::C_Attlist::TLocation CMscarries_Base::C_Attlist::GetLocation(void) const
{
    if (!CanGetLocation()) {
        ThrowUnassigned(8);
    }
    return m_Location;
}

inline
void CMscarries_Base::C_Attlist::SetLocation(CMscarries_Base::C_Attlist::TLocation value)
{
    m_Location = value;
    m_set_State[0] |= 0x30000;
}

inline
CMscarries_Base::C_Attlist::TLocation& CMscarries_Base::C_Attlist::SetLocation(void)
{
#ifdef _DEBUG
    if (!IsSetLocation()) {
        memset(&m_Location,UnassignedByte(),sizeof(m_Location));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Location;
}

inline
bool CMscarries_Base::C_Attlist::IsSetCrossout(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetCrossout(void) const
{
    return IsSetCrossout();
}

inline
const CMscarries_Base::C_Attlist::TCrossout& CMscarries_Base::C_Attlist::GetCrossout(void) const
{
    if (!CanGetCrossout()) {
        ThrowUnassigned(9);
    }
    return m_Crossout;
}

inline
void CMscarries_Base::C_Attlist::SetCrossout(const CMscarries_Base::C_Attlist::TCrossout& value)
{
    m_Crossout = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMscarries_Base::C_Attlist::SetCrossout(CMscarries_Base::C_Attlist::TCrossout&& value)
{
    m_Crossout = std::forward<CMscarries_Base::C_Attlist::TCrossout>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMscarries_Base::C_Attlist::TCrossout& CMscarries_Base::C_Attlist::SetCrossout(void)
{
#ifdef _DEBUG
    if (!IsSetCrossout()) {
        m_Crossout = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Crossout;
}

inline
bool CMscarries_Base::C_Attlist::IsSetScriptsizemultiplier(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMscarries_Base::C_Attlist::CanGetScriptsizemultiplier(void) const
{
    return IsSetScriptsizemultiplier();
}

inline
const CMscarries_Base::C_Attlist::TScriptsizemultiplier& CMscarries_Base::C_Attlist::GetScriptsizemultiplier(void) const
{
    if (!CanGetScriptsizemultiplier()) {
        ThrowUnassigned(10);
    }
    return m_Scriptsizemultiplier;
}

inline
void CMscarries_Base::C_Attlist::SetScriptsizemultiplier(const CMscarries_Base::C_Attlist::TScriptsizemultiplier& value)
{
    m_Scriptsizemultiplier = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMscarries_Base::C_Attlist::SetScriptsizemultiplier(CMscarries_Base::C_Attlist::TScriptsizemultiplier&& value)
{
    m_Scriptsizemultiplier = std::forward<CMscarries_Base::C_Attlist::TScriptsizemultiplier>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMscarries_Base::C_Attlist::TScriptsizemultiplier& CMscarries_Base::C_Attlist::SetScriptsizemultiplier(void)
{
#ifdef _DEBUG
    if (!IsSetScriptsizemultiplier()) {
        m_Scriptsizemultiplier = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Scriptsizemultiplier;
}

inline
CMscarries_Base::C_E_Mscarries::E_Choice CMscarries_Base::C_E_Mscarries::Which(void) const
{
    return m_choice;
}

inline
void CMscarries_Base::C_E_Mscarries::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CMscarries_Base::C_E_Mscarries::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CMscarries_Base::C_E_Mscarries::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CMscarries_Base::C_E_Mscarries::IsMsrowExpression(void) const
{
    return m_choice == e_MsrowExpression;
}

inline
bool CMscarries_Base::C_E_Mscarries::IsMscarry(void) const
{
    return m_choice == e_Mscarry;
}

inline
bool CMscarries_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMscarries_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMscarries_Base::TAttlist& CMscarries_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMscarries_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMscarries_Base::TAttlist& CMscarries_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMscarries_Base::IsSetMscarries(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMscarries_Base::CanGetMscarries(void) const
{
    return true;
}

inline
const CMscarries_Base::TMscarries& CMscarries_Base::GetMscarries(void) const
{
    return m_Mscarries;
}

inline
CMscarries_Base::TMscarries& CMscarries_Base::SetMscarries(void)
{
    m_set_State[0] |= 0x4;
    return m_Mscarries;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MSCARRIES_BASE_HPP
