/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mmultiscripts_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MMULTISCRIPTS_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MMULTISCRIPTS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/MathExpression.hpp>
#include <objtools/eutils/efetch/MultiScriptExpression.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMprescripts;
class CMultiScriptExpression;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMmultiscripts_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMmultiscripts_Base(void);
    // destructor
    virtual ~CMmultiscripts_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TSubscriptshift;
        typedef NCBI_NS_STD::string TSuperscriptshift;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_subscriptshift,
            e_superscriptshift
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSubscriptshift
        ///  Check whether the Subscriptshift data member has been assigned a value.
        bool IsSetSubscriptshift(void) const;
        /// Check whether it is safe or not to call GetSubscriptshift method.
        bool CanGetSubscriptshift(void) const;
        void ResetSubscriptshift(void);
        const TSubscriptshift& GetSubscriptshift(void) const;
        void SetSubscriptshift(const TSubscriptshift& value);
        void SetSubscriptshift(TSubscriptshift&& value);
        TSubscriptshift& SetSubscriptshift(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSuperscriptshift
        ///  Check whether the Superscriptshift data member has been assigned a value.
        bool IsSetSuperscriptshift(void) const;
        /// Check whether it is safe or not to call GetSuperscriptshift method.
        bool CanGetSuperscriptshift(void) const;
        void ResetSuperscriptshift(void);
        const TSuperscriptshift& GetSuperscriptshift(void) const;
        void SetSuperscriptshift(const TSuperscriptshift& value);
        void SetSuperscriptshift(TSuperscriptshift&& value);
        TSuperscriptshift& SetSuperscriptshift(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Subscriptshift;
        NCBI_NS_STD::string m_Superscriptshift;
    };
    typedef CMathExpression C_MathExpression;
    /////////////////////////////////////////////////////////////////////////////
    class C_MultiScriptExpression : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_MultiScriptExpression(void);
        // destructor
        ~C_MultiScriptExpression(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef CMultiScriptExpression C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CMultiScriptExpression > > TMultiScriptExpression;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_MultiScriptExpression
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CMultiScriptExpression > > TMultiScriptExpression
        ///  Check whether the MultiScriptExpression data member has been assigned a value.
        bool IsSetMultiScriptExpression(void) const;
        /// Check whether it is safe or not to call GetMultiScriptExpression method.
        bool CanGetMultiScriptExpression(void) const;
        void ResetMultiScriptExpression(void);
        const TMultiScriptExpression& GetMultiScriptExpression(void) const;
        TMultiScriptExpression& SetMultiScriptExpression(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_MultiScriptExpression(const C_MultiScriptExpression&);
        C_MultiScriptExpression& operator=(const C_MultiScriptExpression&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CMultiScriptExpression > > m_MultiScriptExpression;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_MM : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_MM(void);
        // destructor
        ~C_MM(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_E_MultiScriptExpression : public CMultiScriptExpression
        {
            typedef CMultiScriptExpression Tparent;
        public:
            C_E_MultiScriptExpression(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
        };
        // types
        typedef CMprescripts TMprescripts;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MultiScriptExpression > > TMultiScriptExpression;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_mprescripts,
            e_MultiScriptExpression
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef CMprescripts TMprescripts
        ///  Check whether the Mprescripts data member has been assigned a value.
        bool IsSetMprescripts(void) const;
        /// Check whether it is safe or not to call GetMprescripts method.
        bool CanGetMprescripts(void) const;
        void ResetMprescripts(void);
        const TMprescripts& GetMprescripts(void) const;
        void SetMprescripts(TMprescripts& value);
        TMprescripts& SetMprescripts(void);
    
        /// optional
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MultiScriptExpression > > TMultiScriptExpression
        ///  Check whether the MultiScriptExpression data member has been assigned a value.
        bool IsSetMultiScriptExpression(void) const;
        /// Check whether it is safe or not to call GetMultiScriptExpression method.
        bool CanGetMultiScriptExpression(void) const;
        void ResetMultiScriptExpression(void);
        const TMultiScriptExpression& GetMultiScriptExpression(void) const;
        TMultiScriptExpression& SetMultiScriptExpression(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_MM(const C_MM&);
        C_MM& operator=(const C_MM&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_NCBI::CRef< TMprescripts > m_Mprescripts;
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MultiScriptExpression > > m_MultiScriptExpression;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_MathExpression TMathExpression;
    typedef C_MultiScriptExpression TMultiScriptExpression;
    typedef C_MM TMM;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_MathExpression,
        e_MultiScriptExpression,
        e_MM
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef C_MathExpression TMathExpression
    ///  Check whether the MathExpression data member has been assigned a value.
    bool IsSetMathExpression(void) const;
    /// Check whether it is safe or not to call GetMathExpression method.
    bool CanGetMathExpression(void) const;
    void ResetMathExpression(void);
    const TMathExpression& GetMathExpression(void) const;
    void SetMathExpression(TMathExpression& value);
    TMathExpression& SetMathExpression(void);

    /// optional
    /// typedef C_MultiScriptExpression TMultiScriptExpression
    ///  Check whether the MultiScriptExpression data member has been assigned a value.
    bool IsSetMultiScriptExpression(void) const;
    /// Check whether it is safe or not to call GetMultiScriptExpression method.
    bool CanGetMultiScriptExpression(void) const;
    void ResetMultiScriptExpression(void);
    const TMultiScriptExpression& GetMultiScriptExpression(void) const;
    void SetMultiScriptExpression(TMultiScriptExpression& value);
    TMultiScriptExpression& SetMultiScriptExpression(void);

    /// optional
    /// typedef C_MM TMM
    ///  Check whether the MM data member has been assigned a value.
    bool IsSetMM(void) const;
    /// Check whether it is safe or not to call GetMM method.
    bool CanGetMM(void) const;
    void ResetMM(void);
    const TMM& GetMM(void) const;
    void SetMM(TMM& value);
    TMM& SetMM(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMmultiscripts_Base(const CMmultiscripts_Base&);
    CMmultiscripts_Base& operator=(const CMmultiscripts_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TMathExpression > m_MathExpression;
    NCBI_NS_NCBI::CRef< TMultiScriptExpression > m_MultiScriptExpression;
    NCBI_NS_NCBI::CRef< TMM > m_MM;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMmultiscripts_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMmultiscripts_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMmultiscripts_Base::C_Attlist::TId& CMmultiscripts_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMmultiscripts_Base::C_Attlist::SetId(const CMmultiscripts_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMmultiscripts_Base::C_Attlist::SetId(CMmultiscripts_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMmultiscripts_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMmultiscripts_Base::C_Attlist::TId& CMmultiscripts_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMmultiscripts_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMmultiscripts_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMmultiscripts_Base::C_Attlist::TXref& CMmultiscripts_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMmultiscripts_Base::C_Attlist::SetXref(const CMmultiscripts_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMmultiscripts_Base::C_Attlist::SetXref(CMmultiscripts_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMmultiscripts_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMmultiscripts_Base::C_Attlist::TXref& CMmultiscripts_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMmultiscripts_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMmultiscripts_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMmultiscripts_Base::C_Attlist::TClass& CMmultiscripts_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMmultiscripts_Base::C_Attlist::SetClass(const CMmultiscripts_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMmultiscripts_Base::C_Attlist::SetClass(CMmultiscripts_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMmultiscripts_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMmultiscripts_Base::C_Attlist::TClass& CMmultiscripts_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMmultiscripts_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMmultiscripts_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMmultiscripts_Base::C_Attlist::TStyle& CMmultiscripts_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMmultiscripts_Base::C_Attlist::SetStyle(const CMmultiscripts_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMmultiscripts_Base::C_Attlist::SetStyle(CMmultiscripts_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMmultiscripts_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMmultiscripts_Base::C_Attlist::TStyle& CMmultiscripts_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMmultiscripts_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMmultiscripts_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMmultiscripts_Base::C_Attlist::THref& CMmultiscripts_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMmultiscripts_Base::C_Attlist::SetHref(const CMmultiscripts_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMmultiscripts_Base::C_Attlist::SetHref(CMmultiscripts_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMmultiscripts_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMmultiscripts_Base::C_Attlist::THref& CMmultiscripts_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMmultiscripts_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMmultiscripts_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMmultiscripts_Base::C_Attlist::TMathcolor& CMmultiscripts_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMmultiscripts_Base::C_Attlist::SetMathcolor(const CMmultiscripts_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMmultiscripts_Base::C_Attlist::SetMathcolor(CMmultiscripts_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMmultiscripts_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMmultiscripts_Base::C_Attlist::TMathcolor& CMmultiscripts_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMmultiscripts_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMmultiscripts_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMmultiscripts_Base::C_Attlist::TMathbackground& CMmultiscripts_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMmultiscripts_Base::C_Attlist::SetMathbackground(const CMmultiscripts_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMmultiscripts_Base::C_Attlist::SetMathbackground(CMmultiscripts_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMmultiscripts_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMmultiscripts_Base::C_Attlist::TMathbackground& CMmultiscripts_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMmultiscripts_Base::C_Attlist::IsSetSubscriptshift(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMmultiscripts_Base::C_Attlist::CanGetSubscriptshift(void) const
{
    return IsSetSubscriptshift();
}

inline
const CMmultiscripts_Base::C_Attlist::TSubscriptshift& CMmultiscripts_Base::C_Attlist::GetSubscriptshift(void) const
{
    if (!CanGetSubscriptshift()) {
        ThrowUnassigned(7);
    }
    return m_Subscriptshift;
}

inline
void CMmultiscripts_Base::C_Attlist::SetSubscriptshift(const CMmultiscripts_Base::C_Attlist::TSubscriptshift& value)
{
    m_Subscriptshift = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMmultiscripts_Base::C_Attlist::SetSubscriptshift(CMmultiscripts_Base::C_Attlist::TSubscriptshift&& value)
{
    m_Subscriptshift = std::forward<CMmultiscripts_Base::C_Attlist::TSubscriptshift>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMmultiscripts_Base::C_Attlist::TSubscriptshift& CMmultiscripts_Base::C_Attlist::SetSubscriptshift(void)
{
#ifdef _DEBUG
    if (!IsSetSubscriptshift()) {
        m_Subscriptshift = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Subscriptshift;
}

inline
bool CMmultiscripts_Base::C_Attlist::IsSetSuperscriptshift(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMmultiscripts_Base::C_Attlist::CanGetSuperscriptshift(void) const
{
    return IsSetSuperscriptshift();
}

inline
const CMmultiscripts_Base::C_Attlist::TSuperscriptshift& CMmultiscripts_Base::C_Attlist::GetSuperscriptshift(void) const
{
    if (!CanGetSuperscriptshift()) {
        ThrowUnassigned(8);
    }
    return m_Superscriptshift;
}

inline
void CMmultiscripts_Base::C_Attlist::SetSuperscriptshift(const CMmultiscripts_Base::C_Attlist::TSuperscriptshift& value)
{
    m_Superscriptshift = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMmultiscripts_Base::C_Attlist::SetSuperscriptshift(CMmultiscripts_Base::C_Attlist::TSuperscriptshift&& value)
{
    m_Superscriptshift = std::forward<CMmultiscripts_Base::C_Attlist::TSuperscriptshift>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMmultiscripts_Base::C_Attlist::TSuperscriptshift& CMmultiscripts_Base::C_Attlist::SetSuperscriptshift(void)
{
#ifdef _DEBUG
    if (!IsSetSuperscriptshift()) {
        m_Superscriptshift = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Superscriptshift;
}

inline
bool CMmultiscripts_Base::C_MultiScriptExpression::IsSetMultiScriptExpression(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMmultiscripts_Base::C_MultiScriptExpression::CanGetMultiScriptExpression(void) const
{
    return true;
}

inline
const CMmultiscripts_Base::C_MultiScriptExpression::TMultiScriptExpression& CMmultiscripts_Base::C_MultiScriptExpression::GetMultiScriptExpression(void) const
{
    return m_MultiScriptExpression;
}

inline
CMmultiscripts_Base::C_MultiScriptExpression::TMultiScriptExpression& CMmultiscripts_Base::C_MultiScriptExpression::SetMultiScriptExpression(void)
{
    m_set_State[0] |= 0x1;
    return m_MultiScriptExpression;
}

inline
CMmultiscripts_Base::C_MM::C_E_MultiScriptExpression::C_E_MultiScriptExpression(void)
{
}

inline
bool CMmultiscripts_Base::C_MM::CanGetMprescripts(void) const
{
    return true;
}

inline
const CMmultiscripts_Base::C_MM::TMprescripts& CMmultiscripts_Base::C_MM::GetMprescripts(void) const
{
    if ( !m_Mprescripts ) {
        const_cast<C_MM*>(this)->ResetMprescripts();
    }
    return (*m_Mprescripts);
}

inline
bool CMmultiscripts_Base::C_MM::IsSetMultiScriptExpression(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMmultiscripts_Base::C_MM::CanGetMultiScriptExpression(void) const
{
    return true;
}

inline
const CMmultiscripts_Base::C_MM::TMultiScriptExpression& CMmultiscripts_Base::C_MM::GetMultiScriptExpression(void) const
{
    return m_MultiScriptExpression;
}

inline
CMmultiscripts_Base::C_MM::TMultiScriptExpression& CMmultiscripts_Base::C_MM::SetMultiScriptExpression(void)
{
    m_set_State[0] |= 0x4;
    return m_MultiScriptExpression;
}

inline
bool CMmultiscripts_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMmultiscripts_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMmultiscripts_Base::TAttlist& CMmultiscripts_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMmultiscripts_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMmultiscripts_Base::TAttlist& CMmultiscripts_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMmultiscripts_Base::IsSetMathExpression(void) const
{
    return m_MathExpression.NotEmpty();
}

inline
bool CMmultiscripts_Base::CanGetMathExpression(void) const
{
    return true;
}

inline
const CMmultiscripts_Base::TMathExpression& CMmultiscripts_Base::GetMathExpression(void) const
{
    if ( !m_MathExpression ) {
        const_cast<CMmultiscripts_Base*>(this)->ResetMathExpression();
    }
    return (*m_MathExpression);
}

inline
CMmultiscripts_Base::TMathExpression& CMmultiscripts_Base::SetMathExpression(void)
{
    if ( !m_MathExpression ) {
        ResetMathExpression();
    }
    return (*m_MathExpression);
}

inline
bool CMmultiscripts_Base::IsSetMultiScriptExpression(void) const
{
    return m_MultiScriptExpression.NotEmpty();
}

inline
bool CMmultiscripts_Base::CanGetMultiScriptExpression(void) const
{
    return IsSetMultiScriptExpression();
}

inline
const CMmultiscripts_Base::TMultiScriptExpression& CMmultiscripts_Base::GetMultiScriptExpression(void) const
{
    if (!CanGetMultiScriptExpression()) {
        ThrowUnassigned(2);
    }
    return (*m_MultiScriptExpression);
}

inline
bool CMmultiscripts_Base::IsSetMM(void) const
{
    return m_MM.NotEmpty();
}

inline
bool CMmultiscripts_Base::CanGetMM(void) const
{
    return IsSetMM();
}

inline
const CMmultiscripts_Base::TMM& CMmultiscripts_Base::GetMM(void) const
{
    if (!CanGetMM()) {
        ThrowUnassigned(3);
    }
    return (*m_MM);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MMULTISCRIPTS_BASE_HPP
