/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MeshHeading_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MESHHEADING_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MESHHEADING_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CDescriptorName;
class CQualifierName;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMeshHeading_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMeshHeading_Base(void);
    // destructor
    virtual ~CMeshHeading_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CDescriptorName TDescriptorName;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CQualifierName > > TQualifierName;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_DescriptorName,
        e_QualifierName
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CDescriptorName TDescriptorName
    ///  Check whether the DescriptorName data member has been assigned a value.
    bool IsSetDescriptorName(void) const;
    /// Check whether it is safe or not to call GetDescriptorName method.
    bool CanGetDescriptorName(void) const;
    void ResetDescriptorName(void);
    const TDescriptorName& GetDescriptorName(void) const;
    void SetDescriptorName(TDescriptorName& value);
    TDescriptorName& SetDescriptorName(void);
    void SetDescriptorName(const NCBI_NS_STD::string& value);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CQualifierName > > TQualifierName
    ///  Check whether the QualifierName data member has been assigned a value.
    bool IsSetQualifierName(void) const;
    /// Check whether it is safe or not to call GetQualifierName method.
    bool CanGetQualifierName(void) const;
    void ResetQualifierName(void);
    const TQualifierName& GetQualifierName(void) const;
    TQualifierName& SetQualifierName(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMeshHeading_Base(const CMeshHeading_Base&);
    CMeshHeading_Base& operator=(const CMeshHeading_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TDescriptorName > m_DescriptorName;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CQualifierName > > m_QualifierName;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMeshHeading_Base::IsSetDescriptorName(void) const
{
    return m_DescriptorName.NotEmpty();
}

inline
bool CMeshHeading_Base::CanGetDescriptorName(void) const
{
    return true;
}

inline
const CMeshHeading_Base::TDescriptorName& CMeshHeading_Base::GetDescriptorName(void) const
{
    if ( !m_DescriptorName ) {
        const_cast<CMeshHeading_Base*>(this)->ResetDescriptorName();
    }
    return (*m_DescriptorName);
}

inline
CMeshHeading_Base::TDescriptorName& CMeshHeading_Base::SetDescriptorName(void)
{
    if ( !m_DescriptorName ) {
        ResetDescriptorName();
    }
    return (*m_DescriptorName);
}

inline
bool CMeshHeading_Base::IsSetQualifierName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMeshHeading_Base::CanGetQualifierName(void) const
{
    return true;
}

inline
const CMeshHeading_Base::TQualifierName& CMeshHeading_Base::GetQualifierName(void) const
{
    return m_QualifierName;
}

inline
CMeshHeading_Base::TQualifierName& CMeshHeading_Base::SetQualifierName(void)
{
    m_set_State[0] |= 0x4;
    return m_QualifierName;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MESHHEADING_BASE_HPP
