/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file KeywordList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_KEYWORDLIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_KEYWORDLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CKeyword;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CKeywordList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CKeywordList_Base(void);
    // destructor
    virtual ~CKeywordList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_Owner {
            eAttlist_Owner_NLM      = 1,
            eAttlist_Owner_NLM_AUTO = 2,
            eAttlist_Owner_NASA     = 3,
            eAttlist_Owner_PIP      = 4,
            eAttlist_Owner_KIE      = 5,
            eAttlist_Owner_NOTNLM   = 6,
            eAttlist_Owner_HHS      = 7
        };
        
        /// Access to EAttlist_Owner's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Owner)(void);
        
        // types
        typedef EAttlist_Owner TOwner;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Owner
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_Owner_NLM
        /// typedef EAttlist_Owner TOwner
        ///  Check whether the Owner data member has been assigned a value.
        bool IsSetOwner(void) const;
        /// Check whether it is safe or not to call GetOwner method.
        bool CanGetOwner(void) const;
        void ResetOwner(void);
        void SetDefaultOwner(void);
        TOwner GetOwner(void) const;
        void SetOwner(TOwner value);
        TOwner& SetOwner(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_Owner m_Owner;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CKeyword > > TKeyword;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Keyword
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CKeyword > > TKeyword
    ///  Check whether the Keyword data member has been assigned a value.
    bool IsSetKeyword(void) const;
    /// Check whether it is safe or not to call GetKeyword method.
    bool CanGetKeyword(void) const;
    void ResetKeyword(void);
    const TKeyword& GetKeyword(void) const;
    TKeyword& SetKeyword(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CKeywordList_Base(const CKeywordList_Base&);
    CKeywordList_Base& operator=(const CKeywordList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CKeyword > > m_Keyword;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CKeywordList_Base::C_Attlist::IsSetOwner(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CKeywordList_Base::C_Attlist::CanGetOwner(void) const
{
    return true;
}

inline
void CKeywordList_Base::C_Attlist::ResetOwner(void)
{
    m_Owner = eAttlist_Owner_NLM;
    m_set_State[0] &= ~0x3;
}

inline
void CKeywordList_Base::C_Attlist::SetDefaultOwner(void)
{
    ResetOwner();
    m_set_State[0] |= 0x1;
}

inline
CKeywordList_Base::C_Attlist::TOwner CKeywordList_Base::C_Attlist::GetOwner(void) const
{
    return m_Owner;
}

inline
void CKeywordList_Base::C_Attlist::SetOwner(CKeywordList_Base::C_Attlist::TOwner value)
{
    m_Owner = value;
    m_set_State[0] |= 0x3;
}

inline
CKeywordList_Base::C_Attlist::TOwner& CKeywordList_Base::C_Attlist::SetOwner(void)
{
#ifdef _DEBUG
    if (!IsSetOwner()) {
        memset(&m_Owner,UnassignedByte(),sizeof(m_Owner));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Owner;
}

inline
bool CKeywordList_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CKeywordList_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CKeywordList_Base::TAttlist& CKeywordList_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CKeywordList_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CKeywordList_Base::TAttlist& CKeywordList_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CKeywordList_Base::IsSetKeyword(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CKeywordList_Base::CanGetKeyword(void) const
{
    return true;
}

inline
const CKeywordList_Base::TKeyword& CKeywordList_Base::GetKeyword(void) const
{
    return m_Keyword;
}

inline
CKeywordList_Base::TKeyword& CKeywordList_Base::SetKeyword(void)
{
    m_set_State[0] |= 0x4;
    return m_Keyword;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_KEYWORDLIST_BASE_HPP
