/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DateRevised_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_DATEREVISED_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_DATEREVISED_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CDay;
class CMonth;
class CYear;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CDateRevised_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CDateRevised_Base(void);
    // destructor
    virtual ~CDateRevised_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CYear TYear;
    typedef CMonth TMonth;
    typedef CDay TDay;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Year,
        e_Month,
        e_Day
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CYear TYear
    ///  Check whether the Year data member has been assigned a value.
    bool IsSetYear(void) const;
    /// Check whether it is safe or not to call GetYear method.
    bool CanGetYear(void) const;
    void ResetYear(void);
    const TYear& GetYear(void) const;
    void SetYear(TYear& value);
    TYear& SetYear(void);

    /// mandatory
    /// typedef CMonth TMonth
    ///  Check whether the Month data member has been assigned a value.
    bool IsSetMonth(void) const;
    /// Check whether it is safe or not to call GetMonth method.
    bool CanGetMonth(void) const;
    void ResetMonth(void);
    const TMonth& GetMonth(void) const;
    void SetMonth(TMonth& value);
    TMonth& SetMonth(void);

    /// mandatory
    /// typedef CDay TDay
    ///  Check whether the Day data member has been assigned a value.
    bool IsSetDay(void) const;
    /// Check whether it is safe or not to call GetDay method.
    bool CanGetDay(void) const;
    void ResetDay(void);
    const TDay& GetDay(void) const;
    void SetDay(TDay& value);
    TDay& SetDay(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDateRevised_Base(const CDateRevised_Base&);
    CDateRevised_Base& operator=(const CDateRevised_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TYear > m_Year;
    NCBI_NS_NCBI::CRef< TMonth > m_Month;
    NCBI_NS_NCBI::CRef< TDay > m_Day;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDateRevised_Base::IsSetYear(void) const
{
    return m_Year.NotEmpty();
}

inline
bool CDateRevised_Base::CanGetYear(void) const
{
    return true;
}

inline
const CDateRevised_Base::TYear& CDateRevised_Base::GetYear(void) const
{
    if ( !m_Year ) {
        const_cast<CDateRevised_Base*>(this)->ResetYear();
    }
    return (*m_Year);
}

inline
CDateRevised_Base::TYear& CDateRevised_Base::SetYear(void)
{
    if ( !m_Year ) {
        ResetYear();
    }
    return (*m_Year);
}

inline
bool CDateRevised_Base::IsSetMonth(void) const
{
    return m_Month.NotEmpty();
}

inline
bool CDateRevised_Base::CanGetMonth(void) const
{
    return true;
}

inline
const CDateRevised_Base::TMonth& CDateRevised_Base::GetMonth(void) const
{
    if ( !m_Month ) {
        const_cast<CDateRevised_Base*>(this)->ResetMonth();
    }
    return (*m_Month);
}

inline
CDateRevised_Base::TMonth& CDateRevised_Base::SetMonth(void)
{
    if ( !m_Month ) {
        ResetMonth();
    }
    return (*m_Month);
}

inline
bool CDateRevised_Base::IsSetDay(void) const
{
    return m_Day.NotEmpty();
}

inline
bool CDateRevised_Base::CanGetDay(void) const
{
    return true;
}

inline
const CDateRevised_Base::TDay& CDateRevised_Base::GetDay(void) const
{
    if ( !m_Day ) {
        const_cast<CDateRevised_Base*>(this)->ResetDay();
    }
    return (*m_Day);
}

inline
CDateRevised_Base::TDay& CDateRevised_Base::SetDay(void)
{
    if ( !m_Day ) {
        ResetDay();
    }
    return (*m_Day);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_DATEREVISED_BASE_HPP
