/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Conversion_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_CONVERSION_BASE_HPP
#define OBJECTS_VARREP_CONVERSION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CNtLocation;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CConversion_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CConversion_Base(void);
    // destructor
    virtual ~CConversion_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CNtLocation TLoc;
    typedef CNtLocation TOrigin;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_loc,
        e_origin
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CNtLocation TLoc
    ///  Check whether the Loc data member has been assigned a value.
    bool IsSetLoc(void) const;
    /// Check whether it is safe or not to call GetLoc method.
    bool CanGetLoc(void) const;
    void ResetLoc(void);
    const TLoc& GetLoc(void) const;
    void SetLoc(TLoc& value);
    TLoc& SetLoc(void);

    /// mandatory
    /// typedef CNtLocation TOrigin
    ///  Check whether the Origin data member has been assigned a value.
    bool IsSetOrigin(void) const;
    /// Check whether it is safe or not to call GetOrigin method.
    bool CanGetOrigin(void) const;
    void ResetOrigin(void);
    const TOrigin& GetOrigin(void) const;
    void SetOrigin(TOrigin& value);
    TOrigin& SetOrigin(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CConversion_Base(const CConversion_Base&);
    CConversion_Base& operator=(const CConversion_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TLoc > m_Loc;
    CRef< TOrigin > m_Origin;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CConversion_Base::IsSetLoc(void) const
{
    return m_Loc.NotEmpty();
}

inline
bool CConversion_Base::CanGetLoc(void) const
{
    return true;
}

inline
const CConversion_Base::TLoc& CConversion_Base::GetLoc(void) const
{
    if ( !m_Loc ) {
        const_cast<CConversion_Base*>(this)->ResetLoc();
    }
    return (*m_Loc);
}

inline
CConversion_Base::TLoc& CConversion_Base::SetLoc(void)
{
    if ( !m_Loc ) {
        ResetLoc();
    }
    return (*m_Loc);
}

inline
bool CConversion_Base::IsSetOrigin(void) const
{
    return m_Origin.NotEmpty();
}

inline
bool CConversion_Base::CanGetOrigin(void) const
{
    return true;
}

inline
const CConversion_Base::TOrigin& CConversion_Base::GetOrigin(void) const
{
    if ( !m_Origin ) {
        const_cast<CConversion_Base*>(this)->ResetOrigin();
    }
    return (*m_Origin);
}

inline
CConversion_Base::TOrigin& CConversion_Base::SetOrigin(void)
{
    if ( !m_Origin ) {
        ResetOrigin();
    }
    return (*m_Origin);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_CONVERSION_BASE_HPP
