/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_RetrieveTracksetReply_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_RETRIEVETRACKSETREPLY_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_RETRIEVETRACKSETREPLY_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_Message;
class CTMgr_TrackSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_RetrieveTracksetReply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_RetrieveTracksetReply_Base(void);
    // destructor
    virtual ~CTMgr_RetrieveTracksetReply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_TRACKMGR_EXPORT C_Flags : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Flags(void);
        // destructor
        ~C_Flags(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef bool TInclude_track_items;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_include_track_items
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default false
        /// typedef bool TInclude_track_items
        ///  Check whether the Include_track_items data member has been assigned a value.
        bool IsSetInclude_track_items(void) const;
        /// Check whether it is safe or not to call GetInclude_track_items method.
        bool CanGetInclude_track_items(void) const;
        void ResetInclude_track_items(void);
        void SetDefaultInclude_track_items(void);
        TInclude_track_items GetInclude_track_items(void) const;
        void SetInclude_track_items(TInclude_track_items value);
        TInclude_track_items& SetInclude_track_items(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Flags(const C_Flags&);
        C_Flags& operator=(const C_Flags&);
    
        // data
        Uint4 m_set_State[1];
        bool m_Include_track_items;
    };
    // types
    typedef list< CRef< CTMgr_Message > > TMessages;
    typedef list< CRef< CTMgr_TrackSet > > TTracksets;
    typedef C_Flags TFlags;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_messages,
        e_tracksets,
        e_flags
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CTMgr_Message > > TMessages
    ///  Check whether the Messages data member has been assigned a value.
    bool IsSetMessages(void) const;
    /// Check whether it is safe or not to call GetMessages method.
    bool CanGetMessages(void) const;
    void ResetMessages(void);
    const TMessages& GetMessages(void) const;
    TMessages& SetMessages(void);

    /// optional
    /// typedef list< CRef< CTMgr_TrackSet > > TTracksets
    ///  Check whether the Tracksets data member has been assigned a value.
    bool IsSetTracksets(void) const;
    /// Check whether it is safe or not to call GetTracksets method.
    bool CanGetTracksets(void) const;
    void ResetTracksets(void);
    const TTracksets& GetTracksets(void) const;
    TTracksets& SetTracksets(void);

    /// optional
    /// typedef C_Flags TFlags
    ///  Check whether the Flags data member has been assigned a value.
    bool IsSetFlags(void) const;
    /// Check whether it is safe or not to call GetFlags method.
    bool CanGetFlags(void) const;
    void ResetFlags(void);
    const TFlags& GetFlags(void) const;
    void SetFlags(TFlags& value);
    TFlags& SetFlags(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_RetrieveTracksetReply_Base(const CTMgr_RetrieveTracksetReply_Base&);
    CTMgr_RetrieveTracksetReply_Base& operator=(const CTMgr_RetrieveTracksetReply_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CTMgr_Message > > m_Messages;
    list< CRef< CTMgr_TrackSet > > m_Tracksets;
    CRef< TFlags > m_Flags;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_RetrieveTracksetReply_Base::C_Flags::IsSetInclude_track_items(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_RetrieveTracksetReply_Base::C_Flags::CanGetInclude_track_items(void) const
{
    return true;
}

inline
void CTMgr_RetrieveTracksetReply_Base::C_Flags::ResetInclude_track_items(void)
{
    m_Include_track_items = false;
    m_set_State[0] &= ~0x3;
}

inline
void CTMgr_RetrieveTracksetReply_Base::C_Flags::SetDefaultInclude_track_items(void)
{
    ResetInclude_track_items();
}

inline
CTMgr_RetrieveTracksetReply_Base::C_Flags::TInclude_track_items CTMgr_RetrieveTracksetReply_Base::C_Flags::GetInclude_track_items(void) const
{
    return m_Include_track_items;
}

inline
void CTMgr_RetrieveTracksetReply_Base::C_Flags::SetInclude_track_items(CTMgr_RetrieveTracksetReply_Base::C_Flags::TInclude_track_items value)
{
    m_Include_track_items = value;
    m_set_State[0] |= 0x3;
}

inline
CTMgr_RetrieveTracksetReply_Base::C_Flags::TInclude_track_items& CTMgr_RetrieveTracksetReply_Base::C_Flags::SetInclude_track_items(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_track_items()) {
        memset(&m_Include_track_items,UnassignedByte(),sizeof(m_Include_track_items));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Include_track_items;
}

inline
bool CTMgr_RetrieveTracksetReply_Base::IsSetMessages(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_RetrieveTracksetReply_Base::CanGetMessages(void) const
{
    return true;
}

inline
const CTMgr_RetrieveTracksetReply_Base::TMessages& CTMgr_RetrieveTracksetReply_Base::GetMessages(void) const
{
    return m_Messages;
}

inline
CTMgr_RetrieveTracksetReply_Base::TMessages& CTMgr_RetrieveTracksetReply_Base::SetMessages(void)
{
    m_set_State[0] |= 0x1;
    return m_Messages;
}

inline
bool CTMgr_RetrieveTracksetReply_Base::IsSetTracksets(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_RetrieveTracksetReply_Base::CanGetTracksets(void) const
{
    return true;
}

inline
const CTMgr_RetrieveTracksetReply_Base::TTracksets& CTMgr_RetrieveTracksetReply_Base::GetTracksets(void) const
{
    return m_Tracksets;
}

inline
CTMgr_RetrieveTracksetReply_Base::TTracksets& CTMgr_RetrieveTracksetReply_Base::SetTracksets(void)
{
    m_set_State[0] |= 0x4;
    return m_Tracksets;
}

inline
bool CTMgr_RetrieveTracksetReply_Base::IsSetFlags(void) const
{
    return m_Flags.NotEmpty();
}

inline
bool CTMgr_RetrieveTracksetReply_Base::CanGetFlags(void) const
{
    return IsSetFlags();
}

inline
const CTMgr_RetrieveTracksetReply_Base::TFlags& CTMgr_RetrieveTracksetReply_Base::GetFlags(void) const
{
    if (!CanGetFlags()) {
        ThrowUnassigned(2);
    }
    return (*m_Flags);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_RETRIEVETRACKSETREPLY_BASE_HPP
