/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_graph_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqres.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQRES_SEQ_GRAPH_BASE_HPP
#define OBJECTS_SEQRES_SEQ_GRAPH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CByte_graph;
class CInt_graph;
class CReal_graph;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Sequence Graph ********************************
///*
///*   for values mapped by residue or range to sequence
///*
class NCBI_SEQRES_EXPORT CSeq_graph_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_graph_Base(void);
    // destructor
    virtual ~CSeq_graph_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQRES_EXPORT C_Graph : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Graph(void);
        // destructor
        ~C_Graph(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Real,
            e_Int,
            e_Byte
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_Byte+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CReal_graph TReal;
        typedef CInt_graph TInt;
        typedef CByte_graph TByte;
    
        // getters
        // setters
    
        // typedef CReal_graph TReal
        bool IsReal(void) const;
        const TReal& GetReal(void) const;
        TReal& SetReal(void);
        void SetReal(TReal& value);
    
        // typedef CInt_graph TInt
        bool IsInt(void) const;
        const TInt& GetInt(void) const;
        TInt& SetInt(void);
        void SetInt(TInt& value);
    
        // typedef CByte_graph TByte
        bool IsByte(void) const;
        const TByte& GetByte(void) const;
        TByte& SetByte(void);
        void SetByte(TByte& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Graph(const C_Graph& );
        C_Graph& operator=(const C_Graph& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef string TTitle;
    typedef string TComment;
    typedef CSeq_loc TLoc;
    typedef string TTitle_x;
    typedef string TTitle_y;
    typedef TSeqPos TComp;
    typedef double TA;
    typedef double TB;
    typedef TSeqPos TNumval;
    typedef C_Graph TGraph;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_title,
        e_comment,
        e_loc,
        e_title_x,
        e_title_y,
        e_comp,
        e_a,
        e_b,
        e_numval,
        e_graph
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// region this applies to
    /// mandatory
    /// typedef CSeq_loc TLoc
    ///  Check whether the Loc data member has been assigned a value.
    bool IsSetLoc(void) const;
    /// Check whether it is safe or not to call GetLoc method.
    bool CanGetLoc(void) const;
    void ResetLoc(void);
    const TLoc& GetLoc(void) const;
    void SetLoc(TLoc& value);
    TLoc& SetLoc(void);

    /// title for x-axis
    /// optional
    /// typedef string TTitle_x
    ///  Check whether the Title_x data member has been assigned a value.
    bool IsSetTitle_x(void) const;
    /// Check whether it is safe or not to call GetTitle_x method.
    bool CanGetTitle_x(void) const;
    void ResetTitle_x(void);
    const TTitle_x& GetTitle_x(void) const;
    void SetTitle_x(const TTitle_x& value);
    void SetTitle_x(TTitle_x&& value);
    TTitle_x& SetTitle_x(void);

    /// optional
    /// typedef string TTitle_y
    ///  Check whether the Title_y data member has been assigned a value.
    bool IsSetTitle_y(void) const;
    /// Check whether it is safe or not to call GetTitle_y method.
    bool CanGetTitle_y(void) const;
    void ResetTitle_y(void);
    const TTitle_y& GetTitle_y(void) const;
    void SetTitle_y(const TTitle_y& value);
    void SetTitle_y(TTitle_y&& value);
    TTitle_y& SetTitle_y(void);

    /// compression (residues/value)
    /// optional
    /// typedef TSeqPos TComp
    ///  Check whether the Comp data member has been assigned a value.
    bool IsSetComp(void) const;
    /// Check whether it is safe or not to call GetComp method.
    bool CanGetComp(void) const;
    void ResetComp(void);
    TComp GetComp(void) const;
    void SetComp(TComp value);
    TComp& SetComp(void);

    /// for scaling values
    /// optional
    /// typedef double TA
    ///  Check whether the A data member has been assigned a value.
    bool IsSetA(void) const;
    /// Check whether it is safe or not to call GetA method.
    bool CanGetA(void) const;
    void ResetA(void);
    TA GetA(void) const;
    void SetA(TA value);
    TA& SetA(void);

    /// display = (a x value) + b
    /// optional
    /// typedef double TB
    ///  Check whether the B data member has been assigned a value.
    bool IsSetB(void) const;
    /// Check whether it is safe or not to call GetB method.
    bool CanGetB(void) const;
    void ResetB(void);
    TB GetB(void) const;
    void SetB(TB value);
    TB& SetB(void);

    /// number of values in graph
    /// mandatory
    /// typedef TSeqPos TNumval
    ///  Check whether the Numval data member has been assigned a value.
    bool IsSetNumval(void) const;
    /// Check whether it is safe or not to call GetNumval method.
    bool CanGetNumval(void) const;
    void ResetNumval(void);
    TNumval GetNumval(void) const;
    void SetNumval(TNumval value);
    TNumval& SetNumval(void);

    /// mandatory
    /// typedef C_Graph TGraph
    ///  Check whether the Graph data member has been assigned a value.
    bool IsSetGraph(void) const;
    /// Check whether it is safe or not to call GetGraph method.
    bool CanGetGraph(void) const;
    void ResetGraph(void);
    const TGraph& GetGraph(void) const;
    void SetGraph(TGraph& value);
    TGraph& SetGraph(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_graph_Base(const CSeq_graph_Base&);
    CSeq_graph_Base& operator=(const CSeq_graph_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Title;
    string m_Comment;
    CRef< TLoc > m_Loc;
    string m_Title_x;
    string m_Title_y;
    TSeqPos m_Comp;
    double m_A;
    double m_B;
    TSeqPos m_Numval;
    CRef< TGraph > m_Graph;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeq_graph_Base::C_Graph::E_Choice CSeq_graph_Base::C_Graph::Which(void) const
{
    return m_choice;
}

inline
void CSeq_graph_Base::C_Graph::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeq_graph_Base::C_Graph::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeq_graph_Base::C_Graph::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeq_graph_Base::C_Graph::IsReal(void) const
{
    return m_choice == e_Real;
}

inline
bool CSeq_graph_Base::C_Graph::IsInt(void) const
{
    return m_choice == e_Int;
}

inline
bool CSeq_graph_Base::C_Graph::IsByte(void) const
{
    return m_choice == e_Byte;
}

inline
bool CSeq_graph_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_graph_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CSeq_graph_Base::TTitle& CSeq_graph_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(0);
    }
    return m_Title;
}

inline
void CSeq_graph_Base::SetTitle(const CSeq_graph_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x3;
}

inline
void CSeq_graph_Base::SetTitle(CSeq_graph_Base::TTitle&& value)
{
    m_Title = std::forward<CSeq_graph_Base::TTitle>(value);
    m_set_State[0] |= 0x3;
}

inline
CSeq_graph_Base::TTitle& CSeq_graph_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Title;
}

inline
bool CSeq_graph_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_graph_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CSeq_graph_Base::TComment& CSeq_graph_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(1);
    }
    return m_Comment;
}

inline
void CSeq_graph_Base::SetComment(const CSeq_graph_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0xc;
}

inline
void CSeq_graph_Base::SetComment(CSeq_graph_Base::TComment&& value)
{
    m_Comment = std::forward<CSeq_graph_Base::TComment>(value);
    m_set_State[0] |= 0xc;
}

inline
CSeq_graph_Base::TComment& CSeq_graph_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Comment;
}

inline
bool CSeq_graph_Base::IsSetLoc(void) const
{
    return m_Loc.NotEmpty();
}

inline
bool CSeq_graph_Base::CanGetLoc(void) const
{
    return true;
}

inline
const CSeq_graph_Base::TLoc& CSeq_graph_Base::GetLoc(void) const
{
    if ( !m_Loc ) {
        const_cast<CSeq_graph_Base*>(this)->ResetLoc();
    }
    return (*m_Loc);
}

inline
CSeq_graph_Base::TLoc& CSeq_graph_Base::SetLoc(void)
{
    if ( !m_Loc ) {
        ResetLoc();
    }
    return (*m_Loc);
}

inline
bool CSeq_graph_Base::IsSetTitle_x(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSeq_graph_Base::CanGetTitle_x(void) const
{
    return IsSetTitle_x();
}

inline
const CSeq_graph_Base::TTitle_x& CSeq_graph_Base::GetTitle_x(void) const
{
    if (!CanGetTitle_x()) {
        ThrowUnassigned(3);
    }
    return m_Title_x;
}

inline
void CSeq_graph_Base::SetTitle_x(const CSeq_graph_Base::TTitle_x& value)
{
    m_Title_x = value;
    m_set_State[0] |= 0xc0;
}

inline
void CSeq_graph_Base::SetTitle_x(CSeq_graph_Base::TTitle_x&& value)
{
    m_Title_x = std::forward<CSeq_graph_Base::TTitle_x>(value);
    m_set_State[0] |= 0xc0;
}

inline
CSeq_graph_Base::TTitle_x& CSeq_graph_Base::SetTitle_x(void)
{
#ifdef _DEBUG
    if (!IsSetTitle_x()) {
        m_Title_x = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Title_x;
}

inline
bool CSeq_graph_Base::IsSetTitle_y(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSeq_graph_Base::CanGetTitle_y(void) const
{
    return IsSetTitle_y();
}

inline
const CSeq_graph_Base::TTitle_y& CSeq_graph_Base::GetTitle_y(void) const
{
    if (!CanGetTitle_y()) {
        ThrowUnassigned(4);
    }
    return m_Title_y;
}

inline
void CSeq_graph_Base::SetTitle_y(const CSeq_graph_Base::TTitle_y& value)
{
    m_Title_y = value;
    m_set_State[0] |= 0x300;
}

inline
void CSeq_graph_Base::SetTitle_y(CSeq_graph_Base::TTitle_y&& value)
{
    m_Title_y = std::forward<CSeq_graph_Base::TTitle_y>(value);
    m_set_State[0] |= 0x300;
}

inline
CSeq_graph_Base::TTitle_y& CSeq_graph_Base::SetTitle_y(void)
{
#ifdef _DEBUG
    if (!IsSetTitle_y()) {
        m_Title_y = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Title_y;
}

inline
bool CSeq_graph_Base::IsSetComp(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CSeq_graph_Base::CanGetComp(void) const
{
    return IsSetComp();
}

inline
void CSeq_graph_Base::ResetComp(void)
{
    m_Comp = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CSeq_graph_Base::TComp CSeq_graph_Base::GetComp(void) const
{
    if (!CanGetComp()) {
        ThrowUnassigned(5);
    }
    return m_Comp;
}

inline
void CSeq_graph_Base::SetComp(CSeq_graph_Base::TComp value)
{
    m_Comp = value;
    m_set_State[0] |= 0xc00;
}

inline
CSeq_graph_Base::TComp& CSeq_graph_Base::SetComp(void)
{
#ifdef _DEBUG
    if (!IsSetComp()) {
        memset(&m_Comp,UnassignedByte(),sizeof(m_Comp));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Comp;
}

inline
bool CSeq_graph_Base::IsSetA(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSeq_graph_Base::CanGetA(void) const
{
    return IsSetA();
}

inline
void CSeq_graph_Base::ResetA(void)
{
    m_A = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CSeq_graph_Base::TA CSeq_graph_Base::GetA(void) const
{
    if (!CanGetA()) {
        ThrowUnassigned(6);
    }
    return m_A;
}

inline
void CSeq_graph_Base::SetA(CSeq_graph_Base::TA value)
{
    m_A = value;
    m_set_State[0] |= 0x3000;
}

inline
CSeq_graph_Base::TA& CSeq_graph_Base::SetA(void)
{
#ifdef _DEBUG
    if (!IsSetA()) {
        memset(&m_A,UnassignedByte(),sizeof(m_A));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_A;
}

inline
bool CSeq_graph_Base::IsSetB(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CSeq_graph_Base::CanGetB(void) const
{
    return IsSetB();
}

inline
void CSeq_graph_Base::ResetB(void)
{
    m_B = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CSeq_graph_Base::TB CSeq_graph_Base::GetB(void) const
{
    if (!CanGetB()) {
        ThrowUnassigned(7);
    }
    return m_B;
}

inline
void CSeq_graph_Base::SetB(CSeq_graph_Base::TB value)
{
    m_B = value;
    m_set_State[0] |= 0xc000;
}

inline
CSeq_graph_Base::TB& CSeq_graph_Base::SetB(void)
{
#ifdef _DEBUG
    if (!IsSetB()) {
        memset(&m_B,UnassignedByte(),sizeof(m_B));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_B;
}

inline
bool CSeq_graph_Base::IsSetNumval(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CSeq_graph_Base::CanGetNumval(void) const
{
    return IsSetNumval();
}

inline
void CSeq_graph_Base::ResetNumval(void)
{
    m_Numval = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CSeq_graph_Base::TNumval CSeq_graph_Base::GetNumval(void) const
{
    if (!CanGetNumval()) {
        ThrowUnassigned(8);
    }
    return m_Numval;
}

inline
void CSeq_graph_Base::SetNumval(CSeq_graph_Base::TNumval value)
{
    m_Numval = value;
    m_set_State[0] |= 0x30000;
}

inline
CSeq_graph_Base::TNumval& CSeq_graph_Base::SetNumval(void)
{
#ifdef _DEBUG
    if (!IsSetNumval()) {
        memset(&m_Numval,UnassignedByte(),sizeof(m_Numval));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Numval;
}

inline
bool CSeq_graph_Base::IsSetGraph(void) const
{
    return m_Graph.NotEmpty();
}

inline
bool CSeq_graph_Base::CanGetGraph(void) const
{
    return true;
}

inline
const CSeq_graph_Base::TGraph& CSeq_graph_Base::GetGraph(void) const
{
    if ( !m_Graph ) {
        const_cast<CSeq_graph_Base*>(this)->ResetGraph();
    }
    return (*m_Graph);
}

inline
CSeq_graph_Base::TGraph& CSeq_graph_Base::SetGraph(void)
{
    if ( !m_Graph ) {
        ResetGraph();
    }
    return (*m_Graph);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQRES_SEQ_GRAPH_BASE_HPP
