/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file InferenceSupport_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_INFERENCESUPPORT_BASE_HPP
#define OBJECTS_SEQFEAT_INFERENCESUPPORT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/biblio/DOI.hpp>
#include <objects/biblio/PubMedId.hpp>
#include <objects/seqfeat/EvidenceCategory.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CEvidenceBasis;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CInferenceSupport_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CInferenceSupport_Base(void);
    // destructor
    virtual ~CInferenceSupport_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_not_set              =   0,
        eType_similar_to_sequence  =   1,
        eType_similar_to_aa        =   2,
        eType_similar_to_dna       =   3,
        eType_similar_to_rna       =   4,
        eType_similar_to_mrna      =   5,
        eType_similiar_to_est      =   6,
        eType_similar_to_other_rna =   7,
        eType_profile              =   8,
        eType_nucleotide_motif     =   9,
        eType_protein_motif        =  10,
        eType_ab_initio_prediction =  11,
        eType_alignment            =  12,
        eType_other                = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TCategory;
    typedef int TType;
    typedef string TOther_type;
    typedef bool TSame_species;
    typedef CEvidenceBasis TBasis;
    typedef list< CPubMedId > TPmids;
    typedef list< CDOI > TDois;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_category,
        e_type,
        e_other_type,
        e_same_species,
        e_basis,
        e_pmids,
        e_dois
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int TCategory
    ///  Check whether the Category data member has been assigned a value.
    bool IsSetCategory(void) const;
    /// Check whether it is safe or not to call GetCategory method.
    bool CanGetCategory(void) const;
    void ResetCategory(void);
    TCategory GetCategory(void) const;
    void SetCategory(TCategory value);
    TCategory& SetCategory(void);

    /// optional with default eType_not_set
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    void SetDefaultType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef string TOther_type
    ///  Check whether the Other_type data member has been assigned a value.
    bool IsSetOther_type(void) const;
    /// Check whether it is safe or not to call GetOther_type method.
    bool CanGetOther_type(void) const;
    void ResetOther_type(void);
    const TOther_type& GetOther_type(void) const;
    void SetOther_type(const TOther_type& value);
    void SetOther_type(TOther_type&& value);
    TOther_type& SetOther_type(void);

    /// optional with default false
    /// typedef bool TSame_species
    ///  Check whether the Same_species data member has been assigned a value.
    bool IsSetSame_species(void) const;
    /// Check whether it is safe or not to call GetSame_species method.
    bool CanGetSame_species(void) const;
    void ResetSame_species(void);
    void SetDefaultSame_species(void);
    TSame_species GetSame_species(void) const;
    void SetSame_species(TSame_species value);
    TSame_species& SetSame_species(void);

    /// mandatory
    /// typedef CEvidenceBasis TBasis
    ///  Check whether the Basis data member has been assigned a value.
    bool IsSetBasis(void) const;
    /// Check whether it is safe or not to call GetBasis method.
    bool CanGetBasis(void) const;
    void ResetBasis(void);
    const TBasis& GetBasis(void) const;
    void SetBasis(TBasis& value);
    TBasis& SetBasis(void);

    /// optional
    /// typedef list< CPubMedId > TPmids
    ///  Check whether the Pmids data member has been assigned a value.
    bool IsSetPmids(void) const;
    /// Check whether it is safe or not to call GetPmids method.
    bool CanGetPmids(void) const;
    void ResetPmids(void);
    const TPmids& GetPmids(void) const;
    TPmids& SetPmids(void);

    /// optional
    /// typedef list< CDOI > TDois
    ///  Check whether the Dois data member has been assigned a value.
    bool IsSetDois(void) const;
    /// Check whether it is safe or not to call GetDois method.
    bool CanGetDois(void) const;
    void ResetDois(void);
    const TDois& GetDois(void) const;
    TDois& SetDois(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CInferenceSupport_Base(const CInferenceSupport_Base&);
    CInferenceSupport_Base& operator=(const CInferenceSupport_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Category;
    int m_Type;
    string m_Other_type;
    bool m_Same_species;
    CRef< TBasis > m_Basis;
    list< CPubMedId > m_Pmids;
    list< CDOI > m_Dois;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CInferenceSupport_Base::IsSetCategory(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CInferenceSupport_Base::CanGetCategory(void) const
{
    return IsSetCategory();
}

inline
void CInferenceSupport_Base::ResetCategory(void)
{
    m_Category = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CInferenceSupport_Base::TCategory CInferenceSupport_Base::GetCategory(void) const
{
    if (!CanGetCategory()) {
        ThrowUnassigned(0);
    }
    return m_Category;
}

inline
void CInferenceSupport_Base::SetCategory(CInferenceSupport_Base::TCategory value)
{
    m_Category = value;
    m_set_State[0] |= 0x3;
}

inline
CInferenceSupport_Base::TCategory& CInferenceSupport_Base::SetCategory(void)
{
#ifdef _DEBUG
    if (!IsSetCategory()) {
        memset(&m_Category,UnassignedByte(),sizeof(m_Category));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Category;
}

inline
bool CInferenceSupport_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CInferenceSupport_Base::CanGetType(void) const
{
    return true;
}

inline
void CInferenceSupport_Base::ResetType(void)
{
    m_Type = eType_not_set;
    m_set_State[0] &= ~0xc;
}

inline
void CInferenceSupport_Base::SetDefaultType(void)
{
    ResetType();
}

inline
CInferenceSupport_Base::TType CInferenceSupport_Base::GetType(void) const
{
    return m_Type;
}

inline
void CInferenceSupport_Base::SetType(CInferenceSupport_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CInferenceSupport_Base::TType& CInferenceSupport_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
bool CInferenceSupport_Base::IsSetOther_type(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CInferenceSupport_Base::CanGetOther_type(void) const
{
    return IsSetOther_type();
}

inline
const CInferenceSupport_Base::TOther_type& CInferenceSupport_Base::GetOther_type(void) const
{
    if (!CanGetOther_type()) {
        ThrowUnassigned(2);
    }
    return m_Other_type;
}

inline
void CInferenceSupport_Base::SetOther_type(const CInferenceSupport_Base::TOther_type& value)
{
    m_Other_type = value;
    m_set_State[0] |= 0x30;
}

inline
void CInferenceSupport_Base::SetOther_type(CInferenceSupport_Base::TOther_type&& value)
{
    m_Other_type = std::forward<CInferenceSupport_Base::TOther_type>(value);
    m_set_State[0] |= 0x30;
}

inline
CInferenceSupport_Base::TOther_type& CInferenceSupport_Base::SetOther_type(void)
{
#ifdef _DEBUG
    if (!IsSetOther_type()) {
        m_Other_type = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Other_type;
}

inline
bool CInferenceSupport_Base::IsSetSame_species(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CInferenceSupport_Base::CanGetSame_species(void) const
{
    return true;
}

inline
void CInferenceSupport_Base::ResetSame_species(void)
{
    m_Same_species = false;
    m_set_State[0] &= ~0xc0;
}

inline
void CInferenceSupport_Base::SetDefaultSame_species(void)
{
    ResetSame_species();
}

inline
CInferenceSupport_Base::TSame_species CInferenceSupport_Base::GetSame_species(void) const
{
    return m_Same_species;
}

inline
void CInferenceSupport_Base::SetSame_species(CInferenceSupport_Base::TSame_species value)
{
    m_Same_species = value;
    m_set_State[0] |= 0xc0;
}

inline
CInferenceSupport_Base::TSame_species& CInferenceSupport_Base::SetSame_species(void)
{
#ifdef _DEBUG
    if (!IsSetSame_species()) {
        memset(&m_Same_species,UnassignedByte(),sizeof(m_Same_species));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Same_species;
}

inline
bool CInferenceSupport_Base::IsSetBasis(void) const
{
    return m_Basis.NotEmpty();
}

inline
bool CInferenceSupport_Base::CanGetBasis(void) const
{
    return true;
}

inline
const CInferenceSupport_Base::TBasis& CInferenceSupport_Base::GetBasis(void) const
{
    if ( !m_Basis ) {
        const_cast<CInferenceSupport_Base*>(this)->ResetBasis();
    }
    return (*m_Basis);
}

inline
CInferenceSupport_Base::TBasis& CInferenceSupport_Base::SetBasis(void)
{
    if ( !m_Basis ) {
        ResetBasis();
    }
    return (*m_Basis);
}

inline
bool CInferenceSupport_Base::IsSetPmids(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CInferenceSupport_Base::CanGetPmids(void) const
{
    return true;
}

inline
const CInferenceSupport_Base::TPmids& CInferenceSupport_Base::GetPmids(void) const
{
    return m_Pmids;
}

inline
CInferenceSupport_Base::TPmids& CInferenceSupport_Base::SetPmids(void)
{
    m_set_State[0] |= 0x400;
    return m_Pmids;
}

inline
bool CInferenceSupport_Base::IsSetDois(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CInferenceSupport_Base::CanGetDois(void) const
{
    return true;
}

inline
const CInferenceSupport_Base::TDois& CInferenceSupport_Base::GetDois(void) const
{
    return m_Dois;
}

inline
CInferenceSupport_Base::TDois& CInferenceSupport_Base::SetDois(void)
{
    m_set_State[0] |= 0x1000;
    return m_Dois;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_INFERENCESUPPORT_BASE_HPP
