/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file EvidenceBasis_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_EVIDENCEBASIS_BASE_HPP
#define OBJECTS_SEQFEAT_EVIDENCEBASIS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CProgram_id;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CEvidenceBasis_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEvidenceBasis_Base(void);
    // destructor
    virtual ~CEvidenceBasis_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CProgram_id > > TPrograms;
    typedef list< CRef< CSeq_id > > TAccessions;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_programs,
        e_accessions
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CProgram_id > > TPrograms
    ///  Check whether the Programs data member has been assigned a value.
    bool IsSetPrograms(void) const;
    /// Check whether it is safe or not to call GetPrograms method.
    bool CanGetPrograms(void) const;
    void ResetPrograms(void);
    const TPrograms& GetPrograms(void) const;
    TPrograms& SetPrograms(void);

    /// optional
    /// typedef list< CRef< CSeq_id > > TAccessions
    ///  Check whether the Accessions data member has been assigned a value.
    bool IsSetAccessions(void) const;
    /// Check whether it is safe or not to call GetAccessions method.
    bool CanGetAccessions(void) const;
    void ResetAccessions(void);
    const TAccessions& GetAccessions(void) const;
    TAccessions& SetAccessions(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEvidenceBasis_Base(const CEvidenceBasis_Base&);
    CEvidenceBasis_Base& operator=(const CEvidenceBasis_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CProgram_id > > m_Programs;
    list< CRef< CSeq_id > > m_Accessions;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEvidenceBasis_Base::IsSetPrograms(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEvidenceBasis_Base::CanGetPrograms(void) const
{
    return true;
}

inline
const CEvidenceBasis_Base::TPrograms& CEvidenceBasis_Base::GetPrograms(void) const
{
    return m_Programs;
}

inline
CEvidenceBasis_Base::TPrograms& CEvidenceBasis_Base::SetPrograms(void)
{
    m_set_State[0] |= 0x1;
    return m_Programs;
}

inline
bool CEvidenceBasis_Base::IsSetAccessions(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEvidenceBasis_Base::CanGetAccessions(void) const
{
    return true;
}

inline
const CEvidenceBasis_Base::TAccessions& CEvidenceBasis_Base::GetAccessions(void) const
{
    return m_Accessions;
}

inline
CEvidenceBasis_Base::TAccessions& CEvidenceBasis_Base::SetAccessions(void)
{
    m_set_State[0] |= 0x4;
    return m_Accessions;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_EVIDENCEBASIS_BASE_HPP
