/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_map_table_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqcode.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQCODE_SEQ_MAP_TABLE_BASE_HPP
#define OBJECTS_SEQCODE_SEQ_MAP_TABLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/seqcode/Seq_code_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// for tables of sequence mappings 
class NCBI_SEQCODE_EXPORT CSeq_map_table_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_map_table_Base(void);
    // destructor
    virtual ~CSeq_map_table_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef ESeq_code_type TFrom;
    typedef ESeq_code_type TTo;
    typedef int TNum;
    typedef int TStart_at;
    typedef list< int > TTable;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_from,
        e_to,
        e_num,
        e_start_at,
        e_table
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// code to map from
    /// mandatory
    /// typedef ESeq_code_type TFrom
    ///  Check whether the From data member has been assigned a value.
    bool IsSetFrom(void) const;
    /// Check whether it is safe or not to call GetFrom method.
    bool CanGetFrom(void) const;
    void ResetFrom(void);
    TFrom GetFrom(void) const;
    void SetFrom(TFrom value);
    TFrom& SetFrom(void);

    /// code to map to
    /// mandatory
    /// typedef ESeq_code_type TTo
    ///  Check whether the To data member has been assigned a value.
    bool IsSetTo(void) const;
    /// Check whether it is safe or not to call GetTo method.
    bool CanGetTo(void) const;
    void ResetTo(void);
    TTo GetTo(void) const;
    void SetTo(TTo value);
    TTo& SetTo(void);

    /// number of rows in table
    /// mandatory
    /// typedef int TNum
    ///  Check whether the Num data member has been assigned a value.
    bool IsSetNum(void) const;
    /// Check whether it is safe or not to call GetNum method.
    bool CanGetNum(void) const;
    void ResetNum(void);
    TNum GetNum(void) const;
    void SetNum(TNum value);
    TNum& SetNum(void);

    /// index offset of first element
    /// optional with default 0
    /// typedef int TStart_at
    ///  Check whether the Start_at data member has been assigned a value.
    bool IsSetStart_at(void) const;
    /// Check whether it is safe or not to call GetStart_at method.
    bool CanGetStart_at(void) const;
    void ResetStart_at(void);
    void SetDefaultStart_at(void);
    TStart_at GetStart_at(void) const;
    void SetStart_at(TStart_at value);
    TStart_at& SetStart_at(void);

    /// table of values, in from-to order
    /// mandatory
    /// typedef list< int > TTable
    ///  Check whether the Table data member has been assigned a value.
    bool IsSetTable(void) const;
    /// Check whether it is safe or not to call GetTable method.
    bool CanGetTable(void) const;
    void ResetTable(void);
    const TTable& GetTable(void) const;
    TTable& SetTable(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_map_table_Base(const CSeq_map_table_Base&);
    CSeq_map_table_Base& operator=(const CSeq_map_table_Base&);

    // data
    Uint4 m_set_State[1];
    ESeq_code_type m_From;
    ESeq_code_type m_To;
    int m_Num;
    int m_Start_at;
    list< int > m_Table;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_map_table_Base::IsSetFrom(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_map_table_Base::CanGetFrom(void) const
{
    return IsSetFrom();
}

inline
void CSeq_map_table_Base::ResetFrom(void)
{
    m_From = (ncbi::objects::ESeq_code_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CSeq_map_table_Base::TFrom CSeq_map_table_Base::GetFrom(void) const
{
    if (!CanGetFrom()) {
        ThrowUnassigned(0);
    }
    return m_From;
}

inline
void CSeq_map_table_Base::SetFrom(CSeq_map_table_Base::TFrom value)
{
    m_From = value;
    m_set_State[0] |= 0x3;
}

inline
CSeq_map_table_Base::TFrom& CSeq_map_table_Base::SetFrom(void)
{
#ifdef _DEBUG
    if (!IsSetFrom()) {
        memset(&m_From,UnassignedByte(),sizeof(m_From));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_From;
}

inline
bool CSeq_map_table_Base::IsSetTo(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_map_table_Base::CanGetTo(void) const
{
    return IsSetTo();
}

inline
void CSeq_map_table_Base::ResetTo(void)
{
    m_To = (ncbi::objects::ESeq_code_type)(0);
    m_set_State[0] &= ~0xc;
}

inline
CSeq_map_table_Base::TTo CSeq_map_table_Base::GetTo(void) const
{
    if (!CanGetTo()) {
        ThrowUnassigned(1);
    }
    return m_To;
}

inline
void CSeq_map_table_Base::SetTo(CSeq_map_table_Base::TTo value)
{
    m_To = value;
    m_set_State[0] |= 0xc;
}

inline
CSeq_map_table_Base::TTo& CSeq_map_table_Base::SetTo(void)
{
#ifdef _DEBUG
    if (!IsSetTo()) {
        memset(&m_To,UnassignedByte(),sizeof(m_To));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_To;
}

inline
bool CSeq_map_table_Base::IsSetNum(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeq_map_table_Base::CanGetNum(void) const
{
    return IsSetNum();
}

inline
void CSeq_map_table_Base::ResetNum(void)
{
    m_Num = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSeq_map_table_Base::TNum CSeq_map_table_Base::GetNum(void) const
{
    if (!CanGetNum()) {
        ThrowUnassigned(2);
    }
    return m_Num;
}

inline
void CSeq_map_table_Base::SetNum(CSeq_map_table_Base::TNum value)
{
    m_Num = value;
    m_set_State[0] |= 0x30;
}

inline
CSeq_map_table_Base::TNum& CSeq_map_table_Base::SetNum(void)
{
#ifdef _DEBUG
    if (!IsSetNum()) {
        memset(&m_Num,UnassignedByte(),sizeof(m_Num));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Num;
}

inline
bool CSeq_map_table_Base::IsSetStart_at(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSeq_map_table_Base::CanGetStart_at(void) const
{
    return true;
}

inline
void CSeq_map_table_Base::ResetStart_at(void)
{
    m_Start_at = 0;
    m_set_State[0] &= ~0xc0;
}

inline
void CSeq_map_table_Base::SetDefaultStart_at(void)
{
    ResetStart_at();
}

inline
CSeq_map_table_Base::TStart_at CSeq_map_table_Base::GetStart_at(void) const
{
    return m_Start_at;
}

inline
void CSeq_map_table_Base::SetStart_at(CSeq_map_table_Base::TStart_at value)
{
    m_Start_at = value;
    m_set_State[0] |= 0xc0;
}

inline
CSeq_map_table_Base::TStart_at& CSeq_map_table_Base::SetStart_at(void)
{
#ifdef _DEBUG
    if (!IsSetStart_at()) {
        memset(&m_Start_at,UnassignedByte(),sizeof(m_Start_at));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Start_at;
}

inline
bool CSeq_map_table_Base::IsSetTable(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSeq_map_table_Base::CanGetTable(void) const
{
    return true;
}

inline
const CSeq_map_table_Base::TTable& CSeq_map_table_Base::GetTable(void) const
{
    return m_Table;
}

inline
CSeq_map_table_Base::TTable& CSeq_map_table_Base::SetTable(void)
{
    m_set_State[0] |= 0x100;
    return m_Table;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQCODE_SEQ_MAP_TABLE_BASE_HPP
