/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PssmParameters_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SCOREMAT_PSSMPARAMETERS_BASE_HPP
#define OBJECTS_SCOREMAT_PSSMPARAMETERS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCoreDef;
class CFormatRpsDbParameters;
class CSite_annot_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Populated by PSSM engine of PSI-BLAST, original source for these values 
/// are the PSI-BLAST options specified using the BLAST options API
class NCBI_SCOREMAT_EXPORT CPssmParameters_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPssmParameters_Base(void);
    // destructor
    virtual ~CPssmParameters_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TPseudocount;
    typedef CFormatRpsDbParameters TRpsdbparams;
    typedef CCoreDef TConstraints;
    typedef double TBitScoreThresh;
    typedef double TBitScoreReportingThresh;
    typedef CSite_annot_set TAnnotatedSites;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_pseudocount,
        e_rpsdbparams,
        e_constraints,
        e_bitScoreThresh,
        e_bitScoreReportingThresh,
        e_annotatedSites
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// pseudocount constant used for PSSM. This field corresponds to beta in 
    /// equation 2 of Nucleic Acids Res. 2001 Jul 15;29(14):2994-3005.
    /// optional
    /// typedef int TPseudocount
    ///  Check whether the Pseudocount data member has been assigned a value.
    bool IsSetPseudocount(void) const;
    /// Check whether it is safe or not to call GetPseudocount method.
    bool CanGetPseudocount(void) const;
    void ResetPseudocount(void);
    TPseudocount GetPseudocount(void) const;
    void SetPseudocount(TPseudocount value);
    TPseudocount& SetPseudocount(void);

    /// data needed by formatrpsdb to create RPS-BLAST databases. matrixName is
    /// populated by PSI-BLAST
    /// optional
    /// typedef CFormatRpsDbParameters TRpsdbparams
    ///  Check whether the Rpsdbparams data member has been assigned a value.
    bool IsSetRpsdbparams(void) const;
    /// Check whether it is safe or not to call GetRpsdbparams method.
    bool CanGetRpsdbparams(void) const;
    void ResetRpsdbparams(void);
    const TRpsdbparams& GetRpsdbparams(void) const;
    void SetRpsdbparams(TRpsdbparams& value);
    TRpsdbparams& SetRpsdbparams(void);

    /// alignment constraints needed by sequence-structure threader
    /// and other global or local block-alignment algorithms
    /// optional
    /// typedef CCoreDef TConstraints
    ///  Check whether the Constraints data member has been assigned a value.
    bool IsSetConstraints(void) const;
    /// Check whether it is safe or not to call GetConstraints method.
    bool CanGetConstraints(void) const;
    void ResetConstraints(void);
    const TConstraints& GetConstraints(void) const;
    void SetConstraints(TConstraints& value);
    TConstraints& SetConstraints(void);

    /// bit score threshold for specific conserved domain hits
    /// optional
    /// typedef double TBitScoreThresh
    ///  Check whether the BitScoreThresh data member has been assigned a value.
    bool IsSetBitScoreThresh(void) const;
    /// Check whether it is safe or not to call GetBitScoreThresh method.
    bool CanGetBitScoreThresh(void) const;
    void ResetBitScoreThresh(void);
    TBitScoreThresh GetBitScoreThresh(void) const;
    void SetBitScoreThresh(TBitScoreThresh value);
    TBitScoreThresh& SetBitScoreThresh(void);

    /// bit score threshold for reporting any conserved domain hits
    /// optional
    /// typedef double TBitScoreReportingThresh
    ///  Check whether the BitScoreReportingThresh data member has been assigned a value.
    bool IsSetBitScoreReportingThresh(void) const;
    /// Check whether it is safe or not to call GetBitScoreReportingThresh method.
    bool CanGetBitScoreReportingThresh(void) const;
    void ResetBitScoreReportingThresh(void);
    TBitScoreReportingThresh GetBitScoreReportingThresh(void) const;
    void SetBitScoreReportingThresh(TBitScoreReportingThresh value);
    TBitScoreReportingThresh& SetBitScoreReportingThresh(void);

    /// conserved functional sites with annotations
    /// optional
    /// typedef CSite_annot_set TAnnotatedSites
    ///  Check whether the AnnotatedSites data member has been assigned a value.
    bool IsSetAnnotatedSites(void) const;
    /// Check whether it is safe or not to call GetAnnotatedSites method.
    bool CanGetAnnotatedSites(void) const;
    void ResetAnnotatedSites(void);
    const TAnnotatedSites& GetAnnotatedSites(void) const;
    void SetAnnotatedSites(TAnnotatedSites& value);
    TAnnotatedSites& SetAnnotatedSites(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPssmParameters_Base(const CPssmParameters_Base&);
    CPssmParameters_Base& operator=(const CPssmParameters_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Pseudocount;
    CRef< TRpsdbparams > m_Rpsdbparams;
    CRef< TConstraints > m_Constraints;
    double m_BitScoreThresh;
    double m_BitScoreReportingThresh;
    CRef< TAnnotatedSites > m_AnnotatedSites;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPssmParameters_Base::IsSetPseudocount(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPssmParameters_Base::CanGetPseudocount(void) const
{
    return IsSetPseudocount();
}

inline
void CPssmParameters_Base::ResetPseudocount(void)
{
    m_Pseudocount = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPssmParameters_Base::TPseudocount CPssmParameters_Base::GetPseudocount(void) const
{
    if (!CanGetPseudocount()) {
        ThrowUnassigned(0);
    }
    return m_Pseudocount;
}

inline
void CPssmParameters_Base::SetPseudocount(CPssmParameters_Base::TPseudocount value)
{
    m_Pseudocount = value;
    m_set_State[0] |= 0x3;
}

inline
CPssmParameters_Base::TPseudocount& CPssmParameters_Base::SetPseudocount(void)
{
#ifdef _DEBUG
    if (!IsSetPseudocount()) {
        memset(&m_Pseudocount,UnassignedByte(),sizeof(m_Pseudocount));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Pseudocount;
}

inline
bool CPssmParameters_Base::IsSetRpsdbparams(void) const
{
    return m_Rpsdbparams.NotEmpty();
}

inline
bool CPssmParameters_Base::CanGetRpsdbparams(void) const
{
    return IsSetRpsdbparams();
}

inline
const CPssmParameters_Base::TRpsdbparams& CPssmParameters_Base::GetRpsdbparams(void) const
{
    if (!CanGetRpsdbparams()) {
        ThrowUnassigned(1);
    }
    return (*m_Rpsdbparams);
}

inline
bool CPssmParameters_Base::IsSetConstraints(void) const
{
    return m_Constraints.NotEmpty();
}

inline
bool CPssmParameters_Base::CanGetConstraints(void) const
{
    return IsSetConstraints();
}

inline
const CPssmParameters_Base::TConstraints& CPssmParameters_Base::GetConstraints(void) const
{
    if (!CanGetConstraints()) {
        ThrowUnassigned(2);
    }
    return (*m_Constraints);
}

inline
bool CPssmParameters_Base::IsSetBitScoreThresh(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPssmParameters_Base::CanGetBitScoreThresh(void) const
{
    return IsSetBitScoreThresh();
}

inline
void CPssmParameters_Base::ResetBitScoreThresh(void)
{
    m_BitScoreThresh = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPssmParameters_Base::TBitScoreThresh CPssmParameters_Base::GetBitScoreThresh(void) const
{
    if (!CanGetBitScoreThresh()) {
        ThrowUnassigned(3);
    }
    return m_BitScoreThresh;
}

inline
void CPssmParameters_Base::SetBitScoreThresh(CPssmParameters_Base::TBitScoreThresh value)
{
    m_BitScoreThresh = value;
    m_set_State[0] |= 0xc0;
}

inline
CPssmParameters_Base::TBitScoreThresh& CPssmParameters_Base::SetBitScoreThresh(void)
{
#ifdef _DEBUG
    if (!IsSetBitScoreThresh()) {
        memset(&m_BitScoreThresh,UnassignedByte(),sizeof(m_BitScoreThresh));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_BitScoreThresh;
}

inline
bool CPssmParameters_Base::IsSetBitScoreReportingThresh(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPssmParameters_Base::CanGetBitScoreReportingThresh(void) const
{
    return IsSetBitScoreReportingThresh();
}

inline
void CPssmParameters_Base::ResetBitScoreReportingThresh(void)
{
    m_BitScoreReportingThresh = 0;
    m_set_State[0] &= ~0x300;
}

inline
CPssmParameters_Base::TBitScoreReportingThresh CPssmParameters_Base::GetBitScoreReportingThresh(void) const
{
    if (!CanGetBitScoreReportingThresh()) {
        ThrowUnassigned(4);
    }
    return m_BitScoreReportingThresh;
}

inline
void CPssmParameters_Base::SetBitScoreReportingThresh(CPssmParameters_Base::TBitScoreReportingThresh value)
{
    m_BitScoreReportingThresh = value;
    m_set_State[0] |= 0x300;
}

inline
CPssmParameters_Base::TBitScoreReportingThresh& CPssmParameters_Base::SetBitScoreReportingThresh(void)
{
#ifdef _DEBUG
    if (!IsSetBitScoreReportingThresh()) {
        memset(&m_BitScoreReportingThresh,UnassignedByte(),sizeof(m_BitScoreReportingThresh));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_BitScoreReportingThresh;
}

inline
bool CPssmParameters_Base::IsSetAnnotatedSites(void) const
{
    return m_AnnotatedSites.NotEmpty();
}

inline
bool CPssmParameters_Base::CanGetAnnotatedSites(void) const
{
    return IsSetAnnotatedSites();
}

inline
const CPssmParameters_Base::TAnnotatedSites& CPssmParameters_Base::GetAnnotatedSites(void) const
{
    if (!CanGetAnnotatedSites()) {
        ThrowUnassigned(5);
    }
    return (*m_AnnotatedSites);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_PSSMPARAMETERS_BASE_HPP
