/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Pub_set_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pub.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PUB_PUB_SET_BASE_HPP
#define OBJECTS_PUB_PUB_SET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCit_art;
class CCit_book;
class CCit_jour;
class CCit_pat;
class CCit_proc;
class CMedline_entry;
class CPub;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_PUB_EXPORT CPub_set_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPub_set_Base(void);
    // destructor
    virtual ~CPub_set_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Pub,
        e_Medline,
        e_Article,
        e_Journal,
        e_Book,
        e_Proc,         ///< proceedings of a meeting
        e_Patent
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 8 ///< == e_Patent+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef list< CRef< CPub > > TPub;
    typedef list< CRef< CMedline_entry > > TMedline;
    typedef list< CRef< CCit_art > > TArticle;
    typedef list< CRef< CCit_jour > > TJournal;
    typedef list< CRef< CCit_book > > TBook;
    typedef list< CRef< CCit_proc > > TProc;
    typedef list< CRef< CCit_pat > > TPatent;

    // getters
    // setters

    // typedef list< CRef< CPub > > TPub
    bool IsPub(void) const;
    const TPub& GetPub(void) const;
    TPub& SetPub(void);

    // typedef list< CRef< CMedline_entry > > TMedline
    bool IsMedline(void) const;
    const TMedline& GetMedline(void) const;
    TMedline& SetMedline(void);

    // typedef list< CRef< CCit_art > > TArticle
    bool IsArticle(void) const;
    const TArticle& GetArticle(void) const;
    TArticle& SetArticle(void);

    // typedef list< CRef< CCit_jour > > TJournal
    bool IsJournal(void) const;
    const TJournal& GetJournal(void) const;
    TJournal& SetJournal(void);

    // typedef list< CRef< CCit_book > > TBook
    bool IsBook(void) const;
    const TBook& GetBook(void) const;
    TBook& SetBook(void);

    // typedef list< CRef< CCit_proc > > TProc
    bool IsProc(void) const;
    const TProc& GetProc(void) const;
    TProc& SetProc(void);

    // typedef list< CRef< CCit_pat > > TPatent
    bool IsPatent(void) const;
    const TPatent& GetPatent(void) const;
    TPatent& SetPatent(void);


private:
    // copy constructor and assignment operator
    CPub_set_Base(const CPub_set_Base& );
    CPub_set_Base& operator=(const CPub_set_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TPub> m_Pub;
        NCBI_NS_NCBI::CUnionBuffer<TMedline> m_Medline;
        NCBI_NS_NCBI::CUnionBuffer<TArticle> m_Article;
        NCBI_NS_NCBI::CUnionBuffer<TJournal> m_Journal;
        NCBI_NS_NCBI::CUnionBuffer<TBook> m_Book;
        NCBI_NS_NCBI::CUnionBuffer<TProc> m_Proc;
        NCBI_NS_NCBI::CUnionBuffer<TPatent> m_Patent;
        void* m_dummy_pointer_for_alignment;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPub_set_Base::E_Choice CPub_set_Base::Which(void) const
{
    return m_choice;
}

inline
void CPub_set_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPub_set_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPub_set_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPub_set_Base::IsPub(void) const
{
    return m_choice == e_Pub;
}

inline
const CPub_set_Base::TPub& CPub_set_Base::GetPub(void) const
{
    CheckSelected(e_Pub);
    return *m_Pub;
}

inline
CPub_set_Base::TPub& CPub_set_Base::SetPub(void)
{
    Select(e_Pub, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pub;
}

inline
bool CPub_set_Base::IsMedline(void) const
{
    return m_choice == e_Medline;
}

inline
const CPub_set_Base::TMedline& CPub_set_Base::GetMedline(void) const
{
    CheckSelected(e_Medline);
    return *m_Medline;
}

inline
CPub_set_Base::TMedline& CPub_set_Base::SetMedline(void)
{
    Select(e_Medline, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Medline;
}

inline
bool CPub_set_Base::IsArticle(void) const
{
    return m_choice == e_Article;
}

inline
const CPub_set_Base::TArticle& CPub_set_Base::GetArticle(void) const
{
    CheckSelected(e_Article);
    return *m_Article;
}

inline
CPub_set_Base::TArticle& CPub_set_Base::SetArticle(void)
{
    Select(e_Article, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Article;
}

inline
bool CPub_set_Base::IsJournal(void) const
{
    return m_choice == e_Journal;
}

inline
const CPub_set_Base::TJournal& CPub_set_Base::GetJournal(void) const
{
    CheckSelected(e_Journal);
    return *m_Journal;
}

inline
CPub_set_Base::TJournal& CPub_set_Base::SetJournal(void)
{
    Select(e_Journal, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Journal;
}

inline
bool CPub_set_Base::IsBook(void) const
{
    return m_choice == e_Book;
}

inline
const CPub_set_Base::TBook& CPub_set_Base::GetBook(void) const
{
    CheckSelected(e_Book);
    return *m_Book;
}

inline
CPub_set_Base::TBook& CPub_set_Base::SetBook(void)
{
    Select(e_Book, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Book;
}

inline
bool CPub_set_Base::IsProc(void) const
{
    return m_choice == e_Proc;
}

inline
const CPub_set_Base::TProc& CPub_set_Base::GetProc(void) const
{
    CheckSelected(e_Proc);
    return *m_Proc;
}

inline
CPub_set_Base::TProc& CPub_set_Base::SetProc(void)
{
    Select(e_Proc, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Proc;
}

inline
bool CPub_set_Base::IsPatent(void) const
{
    return m_choice == e_Patent;
}

inline
const CPub_set_Base::TPatent& CPub_set_Base::GetPatent(void) const
{
    CheckSelected(e_Patent);
    return *m_Patent;
}

inline
CPub_set_Base::TPatent& CPub_set_Base::SetPatent(void)
{
    Select(e_Patent, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Patent;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PUB_PUB_SET_BASE_HPP
