/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_StereoSquarePlanar_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_STEREOSQUAREPLANAR_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_STEREOSQUAREPLANAR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Square Planar (SP4) StereoCenters
///   [Using IUPAC Stereogenic Center recommendations and terminology]
///   [Note: "-1" can be used for the Atom Identifier to represent a lone-pair or implicit hydrogen]
class NCBI_PCSUBSTANCE_EXPORT CPC_StereoSquarePlanar_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_StereoSquarePlanar_Base(void);
    // destructor
    virtual ~CPC_StereoSquarePlanar_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// StereoCenter Type
    enum EParity {
        eParity_u_shape =   1,  ///<   U shaped isomer (labove-lbelow-rbelow-rabove)
        eParity_z_shape =   2,  ///<   Z shaped isomer (labove-rabove-lbelow-rbelow)
        eParity_x_shape =   3,  ///<   X shaped isomer (labove-rbelow-rabove-lbelow)
        eParity_any     =   4,  ///<   Nonspecific mixture of isomers
        eParity_unknown = 255
    };
    
    /// Access to EParity's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EParity)(void);
    
    // types
    typedef int TCenter;
    typedef int TLbelow;
    typedef int TRbelow;
    typedef int TLabove;
    typedef int TRabove;
    typedef int TParity;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_center,
        e_lbelow,
        e_rbelow,
        e_labove,
        e_rabove,
        e_parity
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// Atom ID of Atom Center
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TCenter
    ///  Check whether the Center data member has been assigned a value.
    bool IsSetCenter(void) const;
    /// Check whether it is safe or not to call GetCenter method.
    bool CanGetCenter(void) const;
    void ResetCenter(void);
    TCenter GetCenter(void) const;
    void SetCenter(TCenter value);
    TCenter& SetCenter(void);

    /// Atom ID of Left Below Plane Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TLbelow
    ///  Check whether the Lbelow data member has been assigned a value.
    bool IsSetLbelow(void) const;
    /// Check whether it is safe or not to call GetLbelow method.
    bool CanGetLbelow(void) const;
    void ResetLbelow(void);
    TLbelow GetLbelow(void) const;
    void SetLbelow(TLbelow value);
    TLbelow& SetLbelow(void);

    /// Atom ID of Right Below Plane Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TRbelow
    ///  Check whether the Rbelow data member has been assigned a value.
    bool IsSetRbelow(void) const;
    /// Check whether it is safe or not to call GetRbelow method.
    bool CanGetRbelow(void) const;
    void ResetRbelow(void);
    TRbelow GetRbelow(void) const;
    void SetRbelow(TRbelow value);
    TRbelow& SetRbelow(void);

    /// Atom ID of Left Above Plane Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TLabove
    ///  Check whether the Labove data member has been assigned a value.
    bool IsSetLabove(void) const;
    /// Check whether it is safe or not to call GetLabove method.
    bool CanGetLabove(void) const;
    void ResetLabove(void);
    TLabove GetLabove(void) const;
    void SetLabove(TLabove value);
    TLabove& SetLabove(void);

    /// Atom ID of Right Above Plane Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TRabove
    ///  Check whether the Rabove data member has been assigned a value.
    bool IsSetRabove(void) const;
    /// Check whether it is safe or not to call GetRabove method.
    bool CanGetRabove(void) const;
    void ResetRabove(void);
    TRabove GetRabove(void) const;
    void SetRabove(TRabove value);
    TRabove& SetRabove(void);

    /// optional
    /// typedef int TParity
    ///  Check whether the Parity data member has been assigned a value.
    bool IsSetParity(void) const;
    /// Check whether it is safe or not to call GetParity method.
    bool CanGetParity(void) const;
    void ResetParity(void);
    TParity GetParity(void) const;
    void SetParity(TParity value);
    TParity& SetParity(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_StereoSquarePlanar_Base(const CPC_StereoSquarePlanar_Base&);
    CPC_StereoSquarePlanar_Base& operator=(const CPC_StereoSquarePlanar_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Center;
    int m_Lbelow;
    int m_Rbelow;
    int m_Labove;
    int m_Rabove;
    int m_Parity;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_StereoSquarePlanar_Base::IsSetCenter(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_StereoSquarePlanar_Base::CanGetCenter(void) const
{
    return IsSetCenter();
}

inline
void CPC_StereoSquarePlanar_Base::ResetCenter(void)
{
    m_Center = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_StereoSquarePlanar_Base::TCenter CPC_StereoSquarePlanar_Base::GetCenter(void) const
{
    if (!CanGetCenter()) {
        ThrowUnassigned(0);
    }
    return m_Center;
}

inline
void CPC_StereoSquarePlanar_Base::SetCenter(CPC_StereoSquarePlanar_Base::TCenter value)
{
    m_Center = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_StereoSquarePlanar_Base::TCenter& CPC_StereoSquarePlanar_Base::SetCenter(void)
{
#ifdef _DEBUG
    if (!IsSetCenter()) {
        memset(&m_Center,UnassignedByte(),sizeof(m_Center));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Center;
}

inline
bool CPC_StereoSquarePlanar_Base::IsSetLbelow(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_StereoSquarePlanar_Base::CanGetLbelow(void) const
{
    return IsSetLbelow();
}

inline
void CPC_StereoSquarePlanar_Base::ResetLbelow(void)
{
    m_Lbelow = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_StereoSquarePlanar_Base::TLbelow CPC_StereoSquarePlanar_Base::GetLbelow(void) const
{
    if (!CanGetLbelow()) {
        ThrowUnassigned(1);
    }
    return m_Lbelow;
}

inline
void CPC_StereoSquarePlanar_Base::SetLbelow(CPC_StereoSquarePlanar_Base::TLbelow value)
{
    m_Lbelow = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_StereoSquarePlanar_Base::TLbelow& CPC_StereoSquarePlanar_Base::SetLbelow(void)
{
#ifdef _DEBUG
    if (!IsSetLbelow()) {
        memset(&m_Lbelow,UnassignedByte(),sizeof(m_Lbelow));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Lbelow;
}

inline
bool CPC_StereoSquarePlanar_Base::IsSetRbelow(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_StereoSquarePlanar_Base::CanGetRbelow(void) const
{
    return IsSetRbelow();
}

inline
void CPC_StereoSquarePlanar_Base::ResetRbelow(void)
{
    m_Rbelow = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPC_StereoSquarePlanar_Base::TRbelow CPC_StereoSquarePlanar_Base::GetRbelow(void) const
{
    if (!CanGetRbelow()) {
        ThrowUnassigned(2);
    }
    return m_Rbelow;
}

inline
void CPC_StereoSquarePlanar_Base::SetRbelow(CPC_StereoSquarePlanar_Base::TRbelow value)
{
    m_Rbelow = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_StereoSquarePlanar_Base::TRbelow& CPC_StereoSquarePlanar_Base::SetRbelow(void)
{
#ifdef _DEBUG
    if (!IsSetRbelow()) {
        memset(&m_Rbelow,UnassignedByte(),sizeof(m_Rbelow));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Rbelow;
}

inline
bool CPC_StereoSquarePlanar_Base::IsSetLabove(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_StereoSquarePlanar_Base::CanGetLabove(void) const
{
    return IsSetLabove();
}

inline
void CPC_StereoSquarePlanar_Base::ResetLabove(void)
{
    m_Labove = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPC_StereoSquarePlanar_Base::TLabove CPC_StereoSquarePlanar_Base::GetLabove(void) const
{
    if (!CanGetLabove()) {
        ThrowUnassigned(3);
    }
    return m_Labove;
}

inline
void CPC_StereoSquarePlanar_Base::SetLabove(CPC_StereoSquarePlanar_Base::TLabove value)
{
    m_Labove = value;
    m_set_State[0] |= 0xc0;
}

inline
CPC_StereoSquarePlanar_Base::TLabove& CPC_StereoSquarePlanar_Base::SetLabove(void)
{
#ifdef _DEBUG
    if (!IsSetLabove()) {
        memset(&m_Labove,UnassignedByte(),sizeof(m_Labove));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Labove;
}

inline
bool CPC_StereoSquarePlanar_Base::IsSetRabove(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_StereoSquarePlanar_Base::CanGetRabove(void) const
{
    return IsSetRabove();
}

inline
void CPC_StereoSquarePlanar_Base::ResetRabove(void)
{
    m_Rabove = 0;
    m_set_State[0] &= ~0x300;
}

inline
CPC_StereoSquarePlanar_Base::TRabove CPC_StereoSquarePlanar_Base::GetRabove(void) const
{
    if (!CanGetRabove()) {
        ThrowUnassigned(4);
    }
    return m_Rabove;
}

inline
void CPC_StereoSquarePlanar_Base::SetRabove(CPC_StereoSquarePlanar_Base::TRabove value)
{
    m_Rabove = value;
    m_set_State[0] |= 0x300;
}

inline
CPC_StereoSquarePlanar_Base::TRabove& CPC_StereoSquarePlanar_Base::SetRabove(void)
{
#ifdef _DEBUG
    if (!IsSetRabove()) {
        memset(&m_Rabove,UnassignedByte(),sizeof(m_Rabove));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Rabove;
}

inline
bool CPC_StereoSquarePlanar_Base::IsSetParity(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_StereoSquarePlanar_Base::CanGetParity(void) const
{
    return IsSetParity();
}

inline
void CPC_StereoSquarePlanar_Base::ResetParity(void)
{
    m_Parity = (EParity)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CPC_StereoSquarePlanar_Base::TParity CPC_StereoSquarePlanar_Base::GetParity(void) const
{
    if (!CanGetParity()) {
        ThrowUnassigned(5);
    }
    return m_Parity;
}

inline
void CPC_StereoSquarePlanar_Base::SetParity(CPC_StereoSquarePlanar_Base::TParity value)
{
    m_Parity = value;
    m_set_State[0] |= 0xc00;
}

inline
CPC_StereoSquarePlanar_Base::TParity& CPC_StereoSquarePlanar_Base::SetParity(void)
{
#ifdef _DEBUG
    if (!IsSetParity()) {
        memset(&m_Parity,UnassignedByte(),sizeof(m_Parity));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Parity;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_STEREOSQUAREPLANAR_BASE_HPP
