/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Compound_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_COMPOUND_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_COMPOUND_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_Atoms;
class CPC_Bonds;
class CPC_CompoundType;
class CPC_Compounds;
class CPC_Coordinates;
class CPC_Count;
class CPC_Group;
class CPC_InfoData;
class CPC_StereoCenter;
class CPC_StereoGroup;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Compound Record
class NCBI_PCSUBSTANCE_EXPORT CPC_Compound_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Compound_Base(void);
    // destructor
    virtual ~CPC_Compound_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPC_CompoundType TId;
    typedef CPC_Atoms TAtoms;
    typedef CPC_Bonds TBonds;
    typedef list< CRef< CPC_StereoCenter > > TStereo;
    typedef list< CRef< CPC_Coordinates > > TCoords;
    typedef int TCharge;
    typedef list< CRef< CPC_InfoData > > TProps;
    typedef list< CRef< CPC_StereoGroup > > TStereogroups;
    typedef CPC_Count TCount;
    typedef CPC_Compounds TVbalt;
    typedef list< CRef< CPC_Group > > TGroups;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_atoms,
        e_bonds,
        e_stereo,
        e_coords,
        e_charge,
        e_props,
        e_stereogroups,
        e_count,
        e_vbalt,
        e_groups
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 12> TmemberIndex;

    // getters
    // setters

    /// Tracking Information
    /// Compound Qualifier (Type/ID)
    /// mandatory
    /// typedef CPC_CompoundType TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// AtomID/Type Information
    /// optional
    /// typedef CPC_Atoms TAtoms
    ///  Check whether the Atoms data member has been assigned a value.
    bool IsSetAtoms(void) const;
    /// Check whether it is safe or not to call GetAtoms method.
    bool CanGetAtoms(void) const;
    void ResetAtoms(void);
    const TAtoms& GetAtoms(void) const;
    void SetAtoms(TAtoms& value);
    TAtoms& SetAtoms(void);

    /// BondID/Type/Atom Information
    /// optional
    /// typedef CPC_Bonds TBonds
    ///  Check whether the Bonds data member has been assigned a value.
    bool IsSetBonds(void) const;
    /// Check whether it is safe or not to call GetBonds method.
    bool CanGetBonds(void) const;
    void ResetBonds(void);
    const TBonds& GetBonds(void) const;
    void SetBonds(TBonds& value);
    TBonds& SetBonds(void);

    /// StereoCenter Descriptions
    /// optional
    /// typedef list< CRef< CPC_StereoCenter > > TStereo
    ///  Check whether the Stereo data member has been assigned a value.
    bool IsSetStereo(void) const;
    /// Check whether it is safe or not to call GetStereo method.
    bool CanGetStereo(void) const;
    void ResetStereo(void);
    const TStereo& GetStereo(void) const;
    TStereo& SetStereo(void);

    /// 2D/3D Coordinate Sets of Compound
    /// optional
    /// typedef list< CRef< CPC_Coordinates > > TCoords
    ///  Check whether the Coords data member has been assigned a value.
    bool IsSetCoords(void) const;
    /// Check whether it is safe or not to call GetCoords method.
    bool CanGetCoords(void) const;
    void ResetCoords(void);
    const TCoords& GetCoords(void) const;
    TCoords& SetCoords(void);

    /// Provided Total Formal Charge  (Signed Integer)
    /// optional
    /// typedef int TCharge
    ///  Check whether the Charge data member has been assigned a value.
    bool IsSetCharge(void) const;
    /// Check whether it is safe or not to call GetCharge method.
    bool CanGetCharge(void) const;
    void ResetCharge(void);
    TCharge GetCharge(void) const;
    void SetCharge(TCharge value);
    TCharge& SetCharge(void);

    /// Derived (computed) Properties
    /// optional
    /// typedef list< CRef< CPC_InfoData > > TProps
    ///  Check whether the Props data member has been assigned a value.
    bool IsSetProps(void) const;
    /// Check whether it is safe or not to call GetProps method.
    bool CanGetProps(void) const;
    void ResetProps(void);
    const TProps& GetProps(void) const;
    TProps& SetProps(void);

    /// Relative stereochemistry groups
    /// optional
    /// typedef list< CRef< CPC_StereoGroup > > TStereogroups
    ///  Check whether the Stereogroups data member has been assigned a value.
    bool IsSetStereogroups(void) const;
    /// Check whether it is safe or not to call GetStereogroups method.
    bool CanGetStereogroups(void) const;
    void ResetStereogroups(void);
    const TStereogroups& GetStereogroups(void) const;
    TStereogroups& SetStereogroups(void);

    /// Counts of various properties
    /// optional
    /// typedef CPC_Count TCount
    ///  Check whether the Count data member has been assigned a value.
    bool IsSetCount(void) const;
    /// Check whether it is safe or not to call GetCount method.
    bool CanGetCount(void) const;
    void ResetCount(void);
    const TCount& GetCount(void) const;
    void SetCount(TCount& value);
    TCount& SetCount(void);

    /// Alternate Valence-Bond Forms
    /// optional
    /// typedef CPC_Compounds TVbalt
    ///  Check whether the Vbalt data member has been assigned a value.
    bool IsSetVbalt(void) const;
    /// Check whether it is safe or not to call GetVbalt method.
    bool CanGetVbalt(void) const;
    void ResetVbalt(void);
    const TVbalt& GetVbalt(void) const;
    void SetVbalt(TVbalt& value);
    TVbalt& SetVbalt(void);

    /// Superatom groups
    /// optional
    /// typedef list< CRef< CPC_Group > > TGroups
    ///  Check whether the Groups data member has been assigned a value.
    bool IsSetGroups(void) const;
    /// Check whether it is safe or not to call GetGroups method.
    bool CanGetGroups(void) const;
    void ResetGroups(void);
    const TGroups& GetGroups(void) const;
    TGroups& SetGroups(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_Compound_Base(const CPC_Compound_Base&);
    CPC_Compound_Base& operator=(const CPC_Compound_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    CRef< TAtoms > m_Atoms;
    CRef< TBonds > m_Bonds;
    list< CRef< CPC_StereoCenter > > m_Stereo;
    list< CRef< CPC_Coordinates > > m_Coords;
    int m_Charge;
    list< CRef< CPC_InfoData > > m_Props;
    list< CRef< CPC_StereoGroup > > m_Stereogroups;
    CRef< TCount > m_Count;
    CRef< TVbalt > m_Vbalt;
    list< CRef< CPC_Group > > m_Groups;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_Compound_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CPC_Compound_Base::CanGetId(void) const
{
    return true;
}

inline
const CPC_Compound_Base::TId& CPC_Compound_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CPC_Compound_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CPC_Compound_Base::TId& CPC_Compound_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CPC_Compound_Base::IsSetAtoms(void) const
{
    return m_Atoms.NotEmpty();
}

inline
bool CPC_Compound_Base::CanGetAtoms(void) const
{
    return IsSetAtoms();
}

inline
const CPC_Compound_Base::TAtoms& CPC_Compound_Base::GetAtoms(void) const
{
    if (!CanGetAtoms()) {
        ThrowUnassigned(1);
    }
    return (*m_Atoms);
}

inline
bool CPC_Compound_Base::IsSetBonds(void) const
{
    return m_Bonds.NotEmpty();
}

inline
bool CPC_Compound_Base::CanGetBonds(void) const
{
    return IsSetBonds();
}

inline
const CPC_Compound_Base::TBonds& CPC_Compound_Base::GetBonds(void) const
{
    if (!CanGetBonds()) {
        ThrowUnassigned(2);
    }
    return (*m_Bonds);
}

inline
bool CPC_Compound_Base::IsSetStereo(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_Compound_Base::CanGetStereo(void) const
{
    return true;
}

inline
const CPC_Compound_Base::TStereo& CPC_Compound_Base::GetStereo(void) const
{
    return m_Stereo;
}

inline
CPC_Compound_Base::TStereo& CPC_Compound_Base::SetStereo(void)
{
    m_set_State[0] |= 0x40;
    return m_Stereo;
}

inline
bool CPC_Compound_Base::IsSetCoords(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_Compound_Base::CanGetCoords(void) const
{
    return true;
}

inline
const CPC_Compound_Base::TCoords& CPC_Compound_Base::GetCoords(void) const
{
    return m_Coords;
}

inline
CPC_Compound_Base::TCoords& CPC_Compound_Base::SetCoords(void)
{
    m_set_State[0] |= 0x100;
    return m_Coords;
}

inline
bool CPC_Compound_Base::IsSetCharge(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_Compound_Base::CanGetCharge(void) const
{
    return IsSetCharge();
}

inline
void CPC_Compound_Base::ResetCharge(void)
{
    m_Charge = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CPC_Compound_Base::TCharge CPC_Compound_Base::GetCharge(void) const
{
    if (!CanGetCharge()) {
        ThrowUnassigned(5);
    }
    return m_Charge;
}

inline
void CPC_Compound_Base::SetCharge(CPC_Compound_Base::TCharge value)
{
    m_Charge = value;
    m_set_State[0] |= 0xc00;
}

inline
CPC_Compound_Base::TCharge& CPC_Compound_Base::SetCharge(void)
{
#ifdef _DEBUG
    if (!IsSetCharge()) {
        memset(&m_Charge,UnassignedByte(),sizeof(m_Charge));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Charge;
}

inline
bool CPC_Compound_Base::IsSetProps(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_Compound_Base::CanGetProps(void) const
{
    return true;
}

inline
const CPC_Compound_Base::TProps& CPC_Compound_Base::GetProps(void) const
{
    return m_Props;
}

inline
CPC_Compound_Base::TProps& CPC_Compound_Base::SetProps(void)
{
    m_set_State[0] |= 0x1000;
    return m_Props;
}

inline
bool CPC_Compound_Base::IsSetStereogroups(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPC_Compound_Base::CanGetStereogroups(void) const
{
    return true;
}

inline
const CPC_Compound_Base::TStereogroups& CPC_Compound_Base::GetStereogroups(void) const
{
    return m_Stereogroups;
}

inline
CPC_Compound_Base::TStereogroups& CPC_Compound_Base::SetStereogroups(void)
{
    m_set_State[0] |= 0x4000;
    return m_Stereogroups;
}

inline
bool CPC_Compound_Base::IsSetCount(void) const
{
    return m_Count.NotEmpty();
}

inline
bool CPC_Compound_Base::CanGetCount(void) const
{
    return IsSetCount();
}

inline
const CPC_Compound_Base::TCount& CPC_Compound_Base::GetCount(void) const
{
    if (!CanGetCount()) {
        ThrowUnassigned(8);
    }
    return (*m_Count);
}

inline
bool CPC_Compound_Base::IsSetVbalt(void) const
{
    return m_Vbalt.NotEmpty();
}

inline
bool CPC_Compound_Base::CanGetVbalt(void) const
{
    return IsSetVbalt();
}

inline
const CPC_Compound_Base::TVbalt& CPC_Compound_Base::GetVbalt(void) const
{
    if (!CanGetVbalt()) {
        ThrowUnassigned(9);
    }
    return (*m_Vbalt);
}

inline
bool CPC_Compound_Base::IsSetGroups(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CPC_Compound_Base::CanGetGroups(void) const
{
    return true;
}

inline
const CPC_Compound_Base::TGroups& CPC_Compound_Base::GetGroups(void) const
{
    return m_Groups;
}

inline
CPC_Compound_Base::TGroups& CPC_Compound_Base::SetGroups(void)
{
    m_set_State[0] |= 0x100000;
    return m_Groups;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_COMPOUND_BASE_HPP
