/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_RealMinMax_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY2_PC_REALMINMAX_BASE_HPP
#define OBJECTS_PCASSAY2_PC_REALMINMAX_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_pcassay2_SCOPE
#  define BEGIN_pcassay2_SCOPE BEGIN_SCOPE(pcassay2)
#  define END_pcassay2_SCOPE END_SCOPE(pcassay2)
#endif
BEGIN_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Mininum and Maximum Constraints on a Real Value (used for validating incoming data)
class CPC_RealMinMax_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_RealMinMax_Base(void);
    // destructor
    virtual ~CPC_RealMinMax_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef double TMin;
    typedef double TMax;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_min,
        e_max
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Minimum Value Allowed
    /// mandatory
    /// typedef double TMin
    ///  Check whether the Min data member has been assigned a value.
    bool IsSetMin(void) const;
    /// Check whether it is safe or not to call GetMin method.
    bool CanGetMin(void) const;
    void ResetMin(void);
    TMin GetMin(void) const;
    void SetMin(TMin value);
    TMin& SetMin(void);

    /// Maximum Value Allowed
    /// mandatory
    /// typedef double TMax
    ///  Check whether the Max data member has been assigned a value.
    bool IsSetMax(void) const;
    /// Check whether it is safe or not to call GetMax method.
    bool CanGetMax(void) const;
    void ResetMax(void);
    TMax GetMax(void) const;
    void SetMax(TMax value);
    TMax& SetMax(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_RealMinMax_Base(const CPC_RealMinMax_Base&);
    CPC_RealMinMax_Base& operator=(const CPC_RealMinMax_Base&);

    // data
    Uint4 m_set_State[1];
    double m_Min;
    double m_Max;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_RealMinMax_Base::IsSetMin(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_RealMinMax_Base::CanGetMin(void) const
{
    return IsSetMin();
}

inline
void CPC_RealMinMax_Base::ResetMin(void)
{
    m_Min = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_RealMinMax_Base::TMin CPC_RealMinMax_Base::GetMin(void) const
{
    if (!CanGetMin()) {
        ThrowUnassigned(0);
    }
    return m_Min;
}

inline
void CPC_RealMinMax_Base::SetMin(CPC_RealMinMax_Base::TMin value)
{
    m_Min = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_RealMinMax_Base::TMin& CPC_RealMinMax_Base::SetMin(void)
{
#ifdef _DEBUG
    if (!IsSetMin()) {
        memset(&m_Min,UnassignedByte(),sizeof(m_Min));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Min;
}

inline
bool CPC_RealMinMax_Base::IsSetMax(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_RealMinMax_Base::CanGetMax(void) const
{
    return IsSetMax();
}

inline
void CPC_RealMinMax_Base::ResetMax(void)
{
    m_Max = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_RealMinMax_Base::TMax CPC_RealMinMax_Base::GetMax(void) const
{
    if (!CanGetMax()) {
        ThrowUnassigned(1);
    }
    return m_Max;
}

inline
void CPC_RealMinMax_Base::SetMax(CPC_RealMinMax_Base::TMax value)
{
    m_Max = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_RealMinMax_Base::TMax& CPC_RealMinMax_Base::SetMax(void)
{
#ifdef _DEBUG
    if (!IsSetMax()) {
        memset(&m_Max,UnassignedByte(),sizeof(m_Max));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Max;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY2_PC_REALMINMAX_BASE_HPP
