/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PrintFormEnum_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'objprt.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OBJPRT_PRINTFORMENUM_BASE_HPP
#define OBJECTS_OBJPRT_PRINTFORMENUM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_OBJPRT_EXPORT CPrintFormEnum_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPrintFormEnum_Base(void);
    // destructor
    virtual ~CPrintFormEnum_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< string > TValues;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_values
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< string > TValues
    ///  Check whether the Values data member has been assigned a value.
    bool IsSetValues(void) const;
    /// Check whether it is safe or not to call GetValues method.
    bool CanGetValues(void) const;
    void ResetValues(void);
    const TValues& GetValues(void) const;
    TValues& SetValues(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPrintFormEnum_Base(const CPrintFormEnum_Base&);
    CPrintFormEnum_Base& operator=(const CPrintFormEnum_Base&);

    // data
    Uint4 m_set_State[1];
    list< string > m_Values;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPrintFormEnum_Base::IsSetValues(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPrintFormEnum_Base::CanGetValues(void) const
{
    return true;
}

inline
const CPrintFormEnum_Base::TValues& CPrintFormEnum_Base::GetValues(void) const
{
    return m_Values;
}

inline
CPrintFormEnum_Base::TValues& CPrintFormEnum_Base::SetValues(void)
{
    m_set_State[0] |= 0x1;
    return m_Values;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OBJPRT_PRINTFORMENUM_BASE_HPP
