/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Other_feature_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_OTHER_FEATURE_BASE_HPP
#define OBJECTS_MMDB3_OTHER_FEATURE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/mmdb3/Biostruc_feature_id.hpp>
#include <objects/mmdb3/Biostruc_feature_set_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Other-feature allows for specifying location via reference to another
/// Biostruc-feature and its location.
class NCBI_MMDB3_EXPORT COther_feature_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    COther_feature_Base(void);
    // destructor
    virtual ~COther_feature_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBiostruc_id TBiostruc_id;
    typedef CBiostruc_feature_set_id TSet;
    typedef CBiostruc_feature_id TFeature;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_biostruc_id,
        e_set,
        e_feature
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CBiostruc_id TBiostruc_id
    ///  Check whether the Biostruc_id data member has been assigned a value.
    bool IsSetBiostruc_id(void) const;
    /// Check whether it is safe or not to call GetBiostruc_id method.
    bool CanGetBiostruc_id(void) const;
    void ResetBiostruc_id(void);
    const TBiostruc_id& GetBiostruc_id(void) const;
    void SetBiostruc_id(TBiostruc_id& value);
    TBiostruc_id& SetBiostruc_id(void);

    /// mandatory
    /// typedef CBiostruc_feature_set_id TSet
    ///  Check whether the Set data member has been assigned a value.
    bool IsSetSet(void) const;
    /// Check whether it is safe or not to call GetSet method.
    bool CanGetSet(void) const;
    void ResetSet(void);
    const TSet& GetSet(void) const;
    void SetSet(const TSet& value);
    TSet& SetSet(void);

    /// mandatory
    /// typedef CBiostruc_feature_id TFeature
    ///  Check whether the Feature data member has been assigned a value.
    bool IsSetFeature(void) const;
    /// Check whether it is safe or not to call GetFeature method.
    bool CanGetFeature(void) const;
    void ResetFeature(void);
    const TFeature& GetFeature(void) const;
    void SetFeature(const TFeature& value);
    TFeature& SetFeature(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    COther_feature_Base(const COther_feature_Base&);
    COther_feature_Base& operator=(const COther_feature_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TBiostruc_id > m_Biostruc_id;
    CBiostruc_feature_set_id m_Set;
    CBiostruc_feature_id m_Feature;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool COther_feature_Base::IsSetBiostruc_id(void) const
{
    return m_Biostruc_id.NotEmpty();
}

inline
bool COther_feature_Base::CanGetBiostruc_id(void) const
{
    return true;
}

inline
const COther_feature_Base::TBiostruc_id& COther_feature_Base::GetBiostruc_id(void) const
{
    if ( !m_Biostruc_id ) {
        const_cast<COther_feature_Base*>(this)->ResetBiostruc_id();
    }
    return (*m_Biostruc_id);
}

inline
COther_feature_Base::TBiostruc_id& COther_feature_Base::SetBiostruc_id(void)
{
    if ( !m_Biostruc_id ) {
        ResetBiostruc_id();
    }
    return (*m_Biostruc_id);
}

inline
bool COther_feature_Base::IsSetSet(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool COther_feature_Base::CanGetSet(void) const
{
    return IsSetSet();
}

inline
void COther_feature_Base::ResetSet(void)
{
    m_Set = CBiostruc_feature_set_id(0);
    m_set_State[0] &= ~0xc;
}

inline
const COther_feature_Base::TSet& COther_feature_Base::GetSet(void) const
{
    if (!CanGetSet()) {
        ThrowUnassigned(1);
    }
    return m_Set;
}

inline
void COther_feature_Base::SetSet(const COther_feature_Base::TSet& value)
{
    m_Set = value;
    m_set_State[0] |= 0xc;
}

inline
COther_feature_Base::TSet& COther_feature_Base::SetSet(void)
{
    m_set_State[0] |= 0x4;
    return m_Set;
}

inline
bool COther_feature_Base::IsSetFeature(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool COther_feature_Base::CanGetFeature(void) const
{
    return IsSetFeature();
}

inline
void COther_feature_Base::ResetFeature(void)
{
    m_Feature = CBiostruc_feature_id(0);
    m_set_State[0] &= ~0x30;
}

inline
const COther_feature_Base::TFeature& COther_feature_Base::GetFeature(void) const
{
    if (!CanGetFeature()) {
        ThrowUnassigned(2);
    }
    return m_Feature;
}

inline
void COther_feature_Base::SetFeature(const COther_feature_Base::TFeature& value)
{
    m_Feature = value;
    m_set_State[0] |= 0x30;
}

inline
COther_feature_Base::TFeature& COther_feature_Base::SetFeature(void)
{
    m_set_State[0] |= 0x10;
    return m_Feature;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_OTHER_FEATURE_BASE_HPP
