/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Biostruc_script_step_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_BIOSTRUC_SCRIPT_STEP_BASE_HPP
#define OBJECTS_MMDB3_BIOSTRUC_SCRIPT_STEP_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/mmdb3/Step_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class COther_feature;
class CTransform;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CBiostruc_script_step_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBiostruc_script_step_Base(void);
    // destructor
    virtual ~CBiostruc_script_step_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CStep_id TStep_id;
    typedef string TStep_name;
    typedef list< CRef< COther_feature > > TFeature_do;
    typedef CTransform TCamera_move;
    typedef int TPause;
    typedef bool TWaitevent;
    typedef int TExtra;
    typedef CStep_id TJump;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_step_id,
        e_step_name,
        e_feature_do,
        e_camera_move,
        e_pause,
        e_waitevent,
        e_extra,
        e_jump
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CStep_id TStep_id
    ///  Check whether the Step_id data member has been assigned a value.
    bool IsSetStep_id(void) const;
    /// Check whether it is safe or not to call GetStep_id method.
    bool CanGetStep_id(void) const;
    void ResetStep_id(void);
    const TStep_id& GetStep_id(void) const;
    void SetStep_id(const TStep_id& value);
    TStep_id& SetStep_id(void);

    /// optional
    /// typedef string TStep_name
    ///  Check whether the Step_name data member has been assigned a value.
    bool IsSetStep_name(void) const;
    /// Check whether it is safe or not to call GetStep_name method.
    bool CanGetStep_name(void) const;
    void ResetStep_name(void);
    const TStep_name& GetStep_name(void) const;
    void SetStep_name(const TStep_name& value);
    void SetStep_name(TStep_name&& value);
    TStep_name& SetStep_name(void);

    /// optional
    /// typedef list< CRef< COther_feature > > TFeature_do
    ///  Check whether the Feature_do data member has been assigned a value.
    bool IsSetFeature_do(void) const;
    /// Check whether it is safe or not to call GetFeature_do method.
    bool CanGetFeature_do(void) const;
    void ResetFeature_do(void);
    const TFeature_do& GetFeature_do(void) const;
    TFeature_do& SetFeature_do(void);

    /// optional
    /// typedef CTransform TCamera_move
    ///  Check whether the Camera_move data member has been assigned a value.
    bool IsSetCamera_move(void) const;
    /// Check whether it is safe or not to call GetCamera_move method.
    bool CanGetCamera_move(void) const;
    void ResetCamera_move(void);
    const TCamera_move& GetCamera_move(void) const;
    void SetCamera_move(TCamera_move& value);
    TCamera_move& SetCamera_move(void);

    /// optional with default 10
    /// typedef int TPause
    ///  Check whether the Pause data member has been assigned a value.
    bool IsSetPause(void) const;
    /// Check whether it is safe or not to call GetPause method.
    bool CanGetPause(void) const;
    void ResetPause(void);
    void SetDefaultPause(void);
    TPause GetPause(void) const;
    void SetPause(TPause value);
    TPause& SetPause(void);

    /// mandatory
    /// typedef bool TWaitevent
    ///  Check whether the Waitevent data member has been assigned a value.
    bool IsSetWaitevent(void) const;
    /// Check whether it is safe or not to call GetWaitevent method.
    bool CanGetWaitevent(void) const;
    void ResetWaitevent(void);
    TWaitevent GetWaitevent(void) const;
    void SetWaitevent(TWaitevent value);
    TWaitevent& SetWaitevent(void);

    /// mandatory
    /// typedef int TExtra
    ///  Check whether the Extra data member has been assigned a value.
    bool IsSetExtra(void) const;
    /// Check whether it is safe or not to call GetExtra method.
    bool CanGetExtra(void) const;
    void ResetExtra(void);
    TExtra GetExtra(void) const;
    void SetExtra(TExtra value);
    TExtra& SetExtra(void);

    /// optional
    /// typedef CStep_id TJump
    ///  Check whether the Jump data member has been assigned a value.
    bool IsSetJump(void) const;
    /// Check whether it is safe or not to call GetJump method.
    bool CanGetJump(void) const;
    void ResetJump(void);
    const TJump& GetJump(void) const;
    void SetJump(const TJump& value);
    TJump& SetJump(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBiostruc_script_step_Base(const CBiostruc_script_step_Base&);
    CBiostruc_script_step_Base& operator=(const CBiostruc_script_step_Base&);

    // data
    Uint4 m_set_State[1];
    CStep_id m_Step_id;
    string m_Step_name;
    list< CRef< COther_feature > > m_Feature_do;
    CRef< TCamera_move > m_Camera_move;
    int m_Pause;
    bool m_Waitevent;
    int m_Extra;
    CStep_id m_Jump;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBiostruc_script_step_Base::IsSetStep_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBiostruc_script_step_Base::CanGetStep_id(void) const
{
    return IsSetStep_id();
}

inline
void CBiostruc_script_step_Base::ResetStep_id(void)
{
    m_Step_id = CStep_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CBiostruc_script_step_Base::TStep_id& CBiostruc_script_step_Base::GetStep_id(void) const
{
    if (!CanGetStep_id()) {
        ThrowUnassigned(0);
    }
    return m_Step_id;
}

inline
void CBiostruc_script_step_Base::SetStep_id(const CBiostruc_script_step_Base::TStep_id& value)
{
    m_Step_id = value;
    m_set_State[0] |= 0x3;
}

inline
CBiostruc_script_step_Base::TStep_id& CBiostruc_script_step_Base::SetStep_id(void)
{
    m_set_State[0] |= 0x1;
    return m_Step_id;
}

inline
bool CBiostruc_script_step_Base::IsSetStep_name(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBiostruc_script_step_Base::CanGetStep_name(void) const
{
    return IsSetStep_name();
}

inline
const CBiostruc_script_step_Base::TStep_name& CBiostruc_script_step_Base::GetStep_name(void) const
{
    if (!CanGetStep_name()) {
        ThrowUnassigned(1);
    }
    return m_Step_name;
}

inline
void CBiostruc_script_step_Base::SetStep_name(const CBiostruc_script_step_Base::TStep_name& value)
{
    m_Step_name = value;
    m_set_State[0] |= 0xc;
}

inline
void CBiostruc_script_step_Base::SetStep_name(CBiostruc_script_step_Base::TStep_name&& value)
{
    m_Step_name = std::forward<CBiostruc_script_step_Base::TStep_name>(value);
    m_set_State[0] |= 0xc;
}

inline
CBiostruc_script_step_Base::TStep_name& CBiostruc_script_step_Base::SetStep_name(void)
{
#ifdef _DEBUG
    if (!IsSetStep_name()) {
        m_Step_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Step_name;
}

inline
bool CBiostruc_script_step_Base::IsSetFeature_do(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBiostruc_script_step_Base::CanGetFeature_do(void) const
{
    return true;
}

inline
const CBiostruc_script_step_Base::TFeature_do& CBiostruc_script_step_Base::GetFeature_do(void) const
{
    return m_Feature_do;
}

inline
CBiostruc_script_step_Base::TFeature_do& CBiostruc_script_step_Base::SetFeature_do(void)
{
    m_set_State[0] |= 0x10;
    return m_Feature_do;
}

inline
bool CBiostruc_script_step_Base::IsSetCamera_move(void) const
{
    return m_Camera_move.NotEmpty();
}

inline
bool CBiostruc_script_step_Base::CanGetCamera_move(void) const
{
    return IsSetCamera_move();
}

inline
const CBiostruc_script_step_Base::TCamera_move& CBiostruc_script_step_Base::GetCamera_move(void) const
{
    if (!CanGetCamera_move()) {
        ThrowUnassigned(3);
    }
    return (*m_Camera_move);
}

inline
bool CBiostruc_script_step_Base::IsSetPause(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBiostruc_script_step_Base::CanGetPause(void) const
{
    return true;
}

inline
void CBiostruc_script_step_Base::ResetPause(void)
{
    m_Pause = 10;
    m_set_State[0] &= ~0x300;
}

inline
void CBiostruc_script_step_Base::SetDefaultPause(void)
{
    ResetPause();
}

inline
CBiostruc_script_step_Base::TPause CBiostruc_script_step_Base::GetPause(void) const
{
    return m_Pause;
}

inline
void CBiostruc_script_step_Base::SetPause(CBiostruc_script_step_Base::TPause value)
{
    m_Pause = value;
    m_set_State[0] |= 0x300;
}

inline
CBiostruc_script_step_Base::TPause& CBiostruc_script_step_Base::SetPause(void)
{
#ifdef _DEBUG
    if (!IsSetPause()) {
        memset(&m_Pause,UnassignedByte(),sizeof(m_Pause));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Pause;
}

inline
bool CBiostruc_script_step_Base::IsSetWaitevent(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CBiostruc_script_step_Base::CanGetWaitevent(void) const
{
    return IsSetWaitevent();
}

inline
void CBiostruc_script_step_Base::ResetWaitevent(void)
{
    m_Waitevent = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CBiostruc_script_step_Base::TWaitevent CBiostruc_script_step_Base::GetWaitevent(void) const
{
    if (!CanGetWaitevent()) {
        ThrowUnassigned(5);
    }
    return m_Waitevent;
}

inline
void CBiostruc_script_step_Base::SetWaitevent(CBiostruc_script_step_Base::TWaitevent value)
{
    m_Waitevent = value;
    m_set_State[0] |= 0xc00;
}

inline
CBiostruc_script_step_Base::TWaitevent& CBiostruc_script_step_Base::SetWaitevent(void)
{
#ifdef _DEBUG
    if (!IsSetWaitevent()) {
        memset(&m_Waitevent,UnassignedByte(),sizeof(m_Waitevent));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Waitevent;
}

inline
bool CBiostruc_script_step_Base::IsSetExtra(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CBiostruc_script_step_Base::CanGetExtra(void) const
{
    return IsSetExtra();
}

inline
void CBiostruc_script_step_Base::ResetExtra(void)
{
    m_Extra = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CBiostruc_script_step_Base::TExtra CBiostruc_script_step_Base::GetExtra(void) const
{
    if (!CanGetExtra()) {
        ThrowUnassigned(6);
    }
    return m_Extra;
}

inline
void CBiostruc_script_step_Base::SetExtra(CBiostruc_script_step_Base::TExtra value)
{
    m_Extra = value;
    m_set_State[0] |= 0x3000;
}

inline
CBiostruc_script_step_Base::TExtra& CBiostruc_script_step_Base::SetExtra(void)
{
#ifdef _DEBUG
    if (!IsSetExtra()) {
        memset(&m_Extra,UnassignedByte(),sizeof(m_Extra));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Extra;
}

inline
bool CBiostruc_script_step_Base::IsSetJump(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CBiostruc_script_step_Base::CanGetJump(void) const
{
    return IsSetJump();
}

inline
void CBiostruc_script_step_Base::ResetJump(void)
{
    m_Jump = CStep_id(0);
    m_set_State[0] &= ~0xc000;
}

inline
const CBiostruc_script_step_Base::TJump& CBiostruc_script_step_Base::GetJump(void) const
{
    if (!CanGetJump()) {
        ThrowUnassigned(7);
    }
    return m_Jump;
}

inline
void CBiostruc_script_step_Base::SetJump(const CBiostruc_script_step_Base::TJump& value)
{
    m_Jump = value;
    m_set_State[0] |= 0xc000;
}

inline
CBiostruc_script_step_Base::TJump& CBiostruc_script_step_Base::SetJump(void)
{
    m_set_State[0] |= 0x4000;
    return m_Jump;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_BIOSTRUC_SCRIPT_STEP_BASE_HPP
