/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Autofix_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_AUTOFIX_ACTION_BASE_HPP
#define OBJECTS_MACRO_AUTOFIX_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAutofix_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAutofix_action_Base(void);
    // destructor
    virtual ~CAutofix_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TTest_name;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_test_name
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TTest_name
    ///  Check whether the Test_name data member has been assigned a value.
    bool IsSetTest_name(void) const;
    /// Check whether it is safe or not to call GetTest_name method.
    bool CanGetTest_name(void) const;
    void ResetTest_name(void);
    const TTest_name& GetTest_name(void) const;
    void SetTest_name(const TTest_name& value);
    void SetTest_name(TTest_name&& value);
    TTest_name& SetTest_name(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAutofix_action_Base(const CAutofix_action_Base&);
    CAutofix_action_Base& operator=(const CAutofix_action_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Test_name;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAutofix_action_Base::IsSetTest_name(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAutofix_action_Base::CanGetTest_name(void) const
{
    return IsSetTest_name();
}

inline
const CAutofix_action_Base::TTest_name& CAutofix_action_Base::GetTest_name(void) const
{
    if (!CanGetTest_name()) {
        ThrowUnassigned(0);
    }
    return m_Test_name;
}

inline
void CAutofix_action_Base::SetTest_name(const CAutofix_action_Base::TTest_name& value)
{
    m_Test_name = value;
    m_set_State[0] |= 0x3;
}

inline
void CAutofix_action_Base::SetTest_name(CAutofix_action_Base::TTest_name&& value)
{
    m_Test_name = std::forward<CAutofix_action_Base::TTest_name>(value);
    m_set_State[0] |= 0x3;
}

inline
CAutofix_action_Base::TTest_name& CAutofix_action_Base::SetTest_name(void)
{
#ifdef _DEBUG
    if (!IsSetTest_name()) {
        m_Test_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Test_name;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_AUTOFIX_ACTION_BASE_HPP
