/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Apply_feature_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_APPLY_FEATURE_ACTION_BASE_HPP
#define OBJECTS_MACRO_APPLY_FEATURE_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Macro_feature_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CFeat_qual_legal_set;
class CLocation_choice;
class CSequence_list_choice;
class CSource_qual_val_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CApply_feature_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CApply_feature_action_Base(void);
    // destructor
    virtual ~CApply_feature_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EMacro_feature_type TType;
    typedef bool TPartial5;
    typedef bool TPartial3;
    typedef bool TPlus_strand;
    typedef CLocation_choice TLocation;
    typedef CSequence_list_choice TSeq_list;
    typedef bool TAdd_redundant;
    typedef bool TAdd_mrna;
    typedef bool TApply_to_parts;
    typedef int TOnly_seg_num;
    typedef CFeat_qual_legal_set TFields;
    typedef CSource_qual_val_set TSrc_fields;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_partial5,
        e_partial3,
        e_plus_strand,
        e_location,
        e_seq_list,
        e_add_redundant,
        e_add_mrna,
        e_apply_to_parts,
        e_only_seg_num,
        e_fields,
        e_src_fields
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 13> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EMacro_feature_type TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional with default false
    /// typedef bool TPartial5
    ///  Check whether the Partial5 data member has been assigned a value.
    bool IsSetPartial5(void) const;
    /// Check whether it is safe or not to call GetPartial5 method.
    bool CanGetPartial5(void) const;
    void ResetPartial5(void);
    void SetDefaultPartial5(void);
    TPartial5 GetPartial5(void) const;
    void SetPartial5(TPartial5 value);
    TPartial5& SetPartial5(void);

    /// optional with default false
    /// typedef bool TPartial3
    ///  Check whether the Partial3 data member has been assigned a value.
    bool IsSetPartial3(void) const;
    /// Check whether it is safe or not to call GetPartial3 method.
    bool CanGetPartial3(void) const;
    void ResetPartial3(void);
    void SetDefaultPartial3(void);
    TPartial3 GetPartial3(void) const;
    void SetPartial3(TPartial3 value);
    TPartial3& SetPartial3(void);

    /// optional with default true
    /// typedef bool TPlus_strand
    ///  Check whether the Plus_strand data member has been assigned a value.
    bool IsSetPlus_strand(void) const;
    /// Check whether it is safe or not to call GetPlus_strand method.
    bool CanGetPlus_strand(void) const;
    void ResetPlus_strand(void);
    void SetDefaultPlus_strand(void);
    TPlus_strand GetPlus_strand(void) const;
    void SetPlus_strand(TPlus_strand value);
    TPlus_strand& SetPlus_strand(void);

    /// mandatory
    /// typedef CLocation_choice TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(TLocation& value);
    TLocation& SetLocation(void);

    /// mandatory
    /// typedef CSequence_list_choice TSeq_list
    ///  Check whether the Seq_list data member has been assigned a value.
    bool IsSetSeq_list(void) const;
    /// Check whether it is safe or not to call GetSeq_list method.
    bool CanGetSeq_list(void) const;
    void ResetSeq_list(void);
    const TSeq_list& GetSeq_list(void) const;
    void SetSeq_list(TSeq_list& value);
    TSeq_list& SetSeq_list(void);

    /// optional with default true
    /// typedef bool TAdd_redundant
    ///  Check whether the Add_redundant data member has been assigned a value.
    bool IsSetAdd_redundant(void) const;
    /// Check whether it is safe or not to call GetAdd_redundant method.
    bool CanGetAdd_redundant(void) const;
    void ResetAdd_redundant(void);
    void SetDefaultAdd_redundant(void);
    TAdd_redundant GetAdd_redundant(void) const;
    void SetAdd_redundant(TAdd_redundant value);
    TAdd_redundant& SetAdd_redundant(void);

    /// optional with default false
    /// typedef bool TAdd_mrna
    ///  Check whether the Add_mrna data member has been assigned a value.
    bool IsSetAdd_mrna(void) const;
    /// Check whether it is safe or not to call GetAdd_mrna method.
    bool CanGetAdd_mrna(void) const;
    void ResetAdd_mrna(void);
    void SetDefaultAdd_mrna(void);
    TAdd_mrna GetAdd_mrna(void) const;
    void SetAdd_mrna(TAdd_mrna value);
    TAdd_mrna& SetAdd_mrna(void);

    /// optional with default false
    /// typedef bool TApply_to_parts
    ///  Check whether the Apply_to_parts data member has been assigned a value.
    bool IsSetApply_to_parts(void) const;
    /// Check whether it is safe or not to call GetApply_to_parts method.
    bool CanGetApply_to_parts(void) const;
    void ResetApply_to_parts(void);
    void SetDefaultApply_to_parts(void);
    TApply_to_parts GetApply_to_parts(void) const;
    void SetApply_to_parts(TApply_to_parts value);
    TApply_to_parts& SetApply_to_parts(void);

    /// optional with default -1
    /// typedef int TOnly_seg_num
    ///  Check whether the Only_seg_num data member has been assigned a value.
    bool IsSetOnly_seg_num(void) const;
    /// Check whether it is safe or not to call GetOnly_seg_num method.
    bool CanGetOnly_seg_num(void) const;
    void ResetOnly_seg_num(void);
    void SetDefaultOnly_seg_num(void);
    TOnly_seg_num GetOnly_seg_num(void) const;
    void SetOnly_seg_num(TOnly_seg_num value);
    TOnly_seg_num& SetOnly_seg_num(void);

    /// optional
    /// typedef CFeat_qual_legal_set TFields
    ///  Check whether the Fields data member has been assigned a value.
    bool IsSetFields(void) const;
    /// Check whether it is safe or not to call GetFields method.
    bool CanGetFields(void) const;
    void ResetFields(void);
    const TFields& GetFields(void) const;
    void SetFields(TFields& value);
    TFields& SetFields(void);

    /// optional
    /// typedef CSource_qual_val_set TSrc_fields
    ///  Check whether the Src_fields data member has been assigned a value.
    bool IsSetSrc_fields(void) const;
    /// Check whether it is safe or not to call GetSrc_fields method.
    bool CanGetSrc_fields(void) const;
    void ResetSrc_fields(void);
    const TSrc_fields& GetSrc_fields(void) const;
    void SetSrc_fields(TSrc_fields& value);
    TSrc_fields& SetSrc_fields(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CApply_feature_action_Base(const CApply_feature_action_Base&);
    CApply_feature_action_Base& operator=(const CApply_feature_action_Base&);

    // data
    Uint4 m_set_State[1];
    EMacro_feature_type m_Type;
    bool m_Partial5;
    bool m_Partial3;
    bool m_Plus_strand;
    CRef< TLocation > m_Location;
    CRef< TSeq_list > m_Seq_list;
    bool m_Add_redundant;
    bool m_Add_mrna;
    bool m_Apply_to_parts;
    int m_Only_seg_num;
    CRef< TFields > m_Fields;
    CRef< TSrc_fields > m_Src_fields;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CApply_feature_action_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CApply_feature_action_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CApply_feature_action_Base::ResetType(void)
{
    m_Type = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CApply_feature_action_Base::TType CApply_feature_action_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CApply_feature_action_Base::SetType(CApply_feature_action_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CApply_feature_action_Base::TType& CApply_feature_action_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CApply_feature_action_Base::IsSetPartial5(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CApply_feature_action_Base::CanGetPartial5(void) const
{
    return true;
}

inline
void CApply_feature_action_Base::ResetPartial5(void)
{
    m_Partial5 = false;
    m_set_State[0] &= ~0xc;
}

inline
void CApply_feature_action_Base::SetDefaultPartial5(void)
{
    ResetPartial5();
}

inline
CApply_feature_action_Base::TPartial5 CApply_feature_action_Base::GetPartial5(void) const
{
    return m_Partial5;
}

inline
void CApply_feature_action_Base::SetPartial5(CApply_feature_action_Base::TPartial5 value)
{
    m_Partial5 = value;
    m_set_State[0] |= 0xc;
}

inline
CApply_feature_action_Base::TPartial5& CApply_feature_action_Base::SetPartial5(void)
{
#ifdef _DEBUG
    if (!IsSetPartial5()) {
        memset(&m_Partial5,UnassignedByte(),sizeof(m_Partial5));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Partial5;
}

inline
bool CApply_feature_action_Base::IsSetPartial3(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CApply_feature_action_Base::CanGetPartial3(void) const
{
    return true;
}

inline
void CApply_feature_action_Base::ResetPartial3(void)
{
    m_Partial3 = false;
    m_set_State[0] &= ~0x30;
}

inline
void CApply_feature_action_Base::SetDefaultPartial3(void)
{
    ResetPartial3();
}

inline
CApply_feature_action_Base::TPartial3 CApply_feature_action_Base::GetPartial3(void) const
{
    return m_Partial3;
}

inline
void CApply_feature_action_Base::SetPartial3(CApply_feature_action_Base::TPartial3 value)
{
    m_Partial3 = value;
    m_set_State[0] |= 0x30;
}

inline
CApply_feature_action_Base::TPartial3& CApply_feature_action_Base::SetPartial3(void)
{
#ifdef _DEBUG
    if (!IsSetPartial3()) {
        memset(&m_Partial3,UnassignedByte(),sizeof(m_Partial3));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Partial3;
}

inline
bool CApply_feature_action_Base::IsSetPlus_strand(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CApply_feature_action_Base::CanGetPlus_strand(void) const
{
    return true;
}

inline
void CApply_feature_action_Base::ResetPlus_strand(void)
{
    m_Plus_strand = true;
    m_set_State[0] &= ~0xc0;
}

inline
void CApply_feature_action_Base::SetDefaultPlus_strand(void)
{
    ResetPlus_strand();
}

inline
CApply_feature_action_Base::TPlus_strand CApply_feature_action_Base::GetPlus_strand(void) const
{
    return m_Plus_strand;
}

inline
void CApply_feature_action_Base::SetPlus_strand(CApply_feature_action_Base::TPlus_strand value)
{
    m_Plus_strand = value;
    m_set_State[0] |= 0xc0;
}

inline
CApply_feature_action_Base::TPlus_strand& CApply_feature_action_Base::SetPlus_strand(void)
{
#ifdef _DEBUG
    if (!IsSetPlus_strand()) {
        memset(&m_Plus_strand,UnassignedByte(),sizeof(m_Plus_strand));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Plus_strand;
}

inline
bool CApply_feature_action_Base::IsSetLocation(void) const
{
    return m_Location.NotEmpty();
}

inline
bool CApply_feature_action_Base::CanGetLocation(void) const
{
    return true;
}

inline
const CApply_feature_action_Base::TLocation& CApply_feature_action_Base::GetLocation(void) const
{
    if ( !m_Location ) {
        const_cast<CApply_feature_action_Base*>(this)->ResetLocation();
    }
    return (*m_Location);
}

inline
CApply_feature_action_Base::TLocation& CApply_feature_action_Base::SetLocation(void)
{
    if ( !m_Location ) {
        ResetLocation();
    }
    return (*m_Location);
}

inline
bool CApply_feature_action_Base::IsSetSeq_list(void) const
{
    return m_Seq_list.NotEmpty();
}

inline
bool CApply_feature_action_Base::CanGetSeq_list(void) const
{
    return true;
}

inline
const CApply_feature_action_Base::TSeq_list& CApply_feature_action_Base::GetSeq_list(void) const
{
    if ( !m_Seq_list ) {
        const_cast<CApply_feature_action_Base*>(this)->ResetSeq_list();
    }
    return (*m_Seq_list);
}

inline
CApply_feature_action_Base::TSeq_list& CApply_feature_action_Base::SetSeq_list(void)
{
    if ( !m_Seq_list ) {
        ResetSeq_list();
    }
    return (*m_Seq_list);
}

inline
bool CApply_feature_action_Base::IsSetAdd_redundant(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CApply_feature_action_Base::CanGetAdd_redundant(void) const
{
    return true;
}

inline
void CApply_feature_action_Base::ResetAdd_redundant(void)
{
    m_Add_redundant = true;
    m_set_State[0] &= ~0x3000;
}

inline
void CApply_feature_action_Base::SetDefaultAdd_redundant(void)
{
    ResetAdd_redundant();
}

inline
CApply_feature_action_Base::TAdd_redundant CApply_feature_action_Base::GetAdd_redundant(void) const
{
    return m_Add_redundant;
}

inline
void CApply_feature_action_Base::SetAdd_redundant(CApply_feature_action_Base::TAdd_redundant value)
{
    m_Add_redundant = value;
    m_set_State[0] |= 0x3000;
}

inline
CApply_feature_action_Base::TAdd_redundant& CApply_feature_action_Base::SetAdd_redundant(void)
{
#ifdef _DEBUG
    if (!IsSetAdd_redundant()) {
        memset(&m_Add_redundant,UnassignedByte(),sizeof(m_Add_redundant));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Add_redundant;
}

inline
bool CApply_feature_action_Base::IsSetAdd_mrna(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CApply_feature_action_Base::CanGetAdd_mrna(void) const
{
    return true;
}

inline
void CApply_feature_action_Base::ResetAdd_mrna(void)
{
    m_Add_mrna = false;
    m_set_State[0] &= ~0xc000;
}

inline
void CApply_feature_action_Base::SetDefaultAdd_mrna(void)
{
    ResetAdd_mrna();
}

inline
CApply_feature_action_Base::TAdd_mrna CApply_feature_action_Base::GetAdd_mrna(void) const
{
    return m_Add_mrna;
}

inline
void CApply_feature_action_Base::SetAdd_mrna(CApply_feature_action_Base::TAdd_mrna value)
{
    m_Add_mrna = value;
    m_set_State[0] |= 0xc000;
}

inline
CApply_feature_action_Base::TAdd_mrna& CApply_feature_action_Base::SetAdd_mrna(void)
{
#ifdef _DEBUG
    if (!IsSetAdd_mrna()) {
        memset(&m_Add_mrna,UnassignedByte(),sizeof(m_Add_mrna));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Add_mrna;
}

inline
bool CApply_feature_action_Base::IsSetApply_to_parts(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CApply_feature_action_Base::CanGetApply_to_parts(void) const
{
    return true;
}

inline
void CApply_feature_action_Base::ResetApply_to_parts(void)
{
    m_Apply_to_parts = false;
    m_set_State[0] &= ~0x30000;
}

inline
void CApply_feature_action_Base::SetDefaultApply_to_parts(void)
{
    ResetApply_to_parts();
}

inline
CApply_feature_action_Base::TApply_to_parts CApply_feature_action_Base::GetApply_to_parts(void) const
{
    return m_Apply_to_parts;
}

inline
void CApply_feature_action_Base::SetApply_to_parts(CApply_feature_action_Base::TApply_to_parts value)
{
    m_Apply_to_parts = value;
    m_set_State[0] |= 0x30000;
}

inline
CApply_feature_action_Base::TApply_to_parts& CApply_feature_action_Base::SetApply_to_parts(void)
{
#ifdef _DEBUG
    if (!IsSetApply_to_parts()) {
        memset(&m_Apply_to_parts,UnassignedByte(),sizeof(m_Apply_to_parts));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Apply_to_parts;
}

inline
bool CApply_feature_action_Base::IsSetOnly_seg_num(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CApply_feature_action_Base::CanGetOnly_seg_num(void) const
{
    return true;
}

inline
void CApply_feature_action_Base::ResetOnly_seg_num(void)
{
    m_Only_seg_num = -1;
    m_set_State[0] &= ~0xc0000;
}

inline
void CApply_feature_action_Base::SetDefaultOnly_seg_num(void)
{
    ResetOnly_seg_num();
}

inline
CApply_feature_action_Base::TOnly_seg_num CApply_feature_action_Base::GetOnly_seg_num(void) const
{
    return m_Only_seg_num;
}

inline
void CApply_feature_action_Base::SetOnly_seg_num(CApply_feature_action_Base::TOnly_seg_num value)
{
    m_Only_seg_num = value;
    m_set_State[0] |= 0xc0000;
}

inline
CApply_feature_action_Base::TOnly_seg_num& CApply_feature_action_Base::SetOnly_seg_num(void)
{
#ifdef _DEBUG
    if (!IsSetOnly_seg_num()) {
        memset(&m_Only_seg_num,UnassignedByte(),sizeof(m_Only_seg_num));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Only_seg_num;
}

inline
bool CApply_feature_action_Base::IsSetFields(void) const
{
    return m_Fields.NotEmpty();
}

inline
bool CApply_feature_action_Base::CanGetFields(void) const
{
    return IsSetFields();
}

inline
const CApply_feature_action_Base::TFields& CApply_feature_action_Base::GetFields(void) const
{
    if (!CanGetFields()) {
        ThrowUnassigned(10);
    }
    return (*m_Fields);
}

inline
bool CApply_feature_action_Base::IsSetSrc_fields(void) const
{
    return m_Src_fields.NotEmpty();
}

inline
bool CApply_feature_action_Base::CanGetSrc_fields(void) const
{
    return IsSetSrc_fields();
}

inline
const CApply_feature_action_Base::TSrc_fields& CApply_feature_action_Base::GetSrc_fields(void) const
{
    if (!CanGetSrc_fields()) {
        ThrowUnassigned(11);
    }
    return (*m_Src_fields);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_APPLY_FEATURE_ACTION_BASE_HPP
