/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file INSDXref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'insdseq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_INSDSEQ_INSDXREF_BASE_HPP
#define OBJECTS_INSDSEQ_INSDXREF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// INSDXref provides a method for referring to records in
/// other databases. INSDXref_dbname is a string value that
/// provides the name of the database, and INSDXref_dbname
/// is a string value that provides the record's identifier
/// in that database.
class NCBI_INSDSEQ_EXPORT CINSDXref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CINSDXref_Base(void);
    // destructor
    virtual ~CINSDXref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TDbname;
    typedef string TId;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_dbname,
        e_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TDbname
    ///  Check whether the Dbname data member has been assigned a value.
    bool IsSetDbname(void) const;
    /// Check whether it is safe or not to call GetDbname method.
    bool CanGetDbname(void) const;
    void ResetDbname(void);
    const TDbname& GetDbname(void) const;
    void SetDbname(const TDbname& value);
    void SetDbname(TDbname&& value);
    TDbname& SetDbname(void);

    /// mandatory
    /// typedef string TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    void SetId(TId&& value);
    TId& SetId(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CINSDXref_Base(const CINSDXref_Base&);
    CINSDXref_Base& operator=(const CINSDXref_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Dbname;
    string m_Id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CINSDXref_Base::IsSetDbname(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CINSDXref_Base::CanGetDbname(void) const
{
    return IsSetDbname();
}

inline
const CINSDXref_Base::TDbname& CINSDXref_Base::GetDbname(void) const
{
    if (!CanGetDbname()) {
        ThrowUnassigned(0);
    }
    return m_Dbname;
}

inline
void CINSDXref_Base::SetDbname(const CINSDXref_Base::TDbname& value)
{
    m_Dbname = value;
    m_set_State[0] |= 0x3;
}

inline
void CINSDXref_Base::SetDbname(CINSDXref_Base::TDbname&& value)
{
    m_Dbname = std::forward<CINSDXref_Base::TDbname>(value);
    m_set_State[0] |= 0x3;
}

inline
CINSDXref_Base::TDbname& CINSDXref_Base::SetDbname(void)
{
#ifdef _DEBUG
    if (!IsSetDbname()) {
        m_Dbname = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Dbname;
}

inline
bool CINSDXref_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CINSDXref_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CINSDXref_Base::TId& CINSDXref_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(1);
    }
    return m_Id;
}

inline
void CINSDXref_Base::SetId(const CINSDXref_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0xc;
}

inline
void CINSDXref_Base::SetId(CINSDXref_Base::TId&& value)
{
    m_Id = std::forward<CINSDXref_Base::TId>(value);
    m_set_State[0] |= 0xc;
}

inline
CINSDXref_Base::TId& CINSDXref_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_INSDSEQ_INSDXREF_BASE_HPP
