/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_Sequence_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_SEQUENCE_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_SEQUENCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/genomecoll/GC_SequenceRole.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDelta_ext;
class CGC_SequenceStats;
class CGC_TaggedSequences;
class CGC_TypedSeqId;
class CSeq_annot;
class CSeq_descr;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// GC-Sequence:
/// Used for scaffolds, scaffold-sets and components in Gencoll terminology.
/// Theoretically can support sequences decsribed with more levels than
/// Chromosome / scaffold-set/scaffold/component.
/// The meaning of the GC-Sequence record - if it is component, scaffold or
/// or scaffold-set, is defined by its context.
/// ??? DO WE NEED A FIELD TO SPECIFY WHAT LEVEL IT IS???
///
/// GC-Sequences are made of GC-Sequences: At the lowest level there is only one
/// seq-id of a component with no further structure.
class NCBI_GENOME_COLLECTION_EXPORT CGC_Sequence_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_Sequence_Base(void);
    // destructor
    virtual ~CGC_Sequence_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EPatch_type {
        ePatch_type_novel =   0,
        ePatch_type_fix   =   1,
        ePatch_type_other = 255  ///< stopper
    };
    
    /// Access to EPatch_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EPatch_type)(void);
    
    // types
    typedef CSeq_id TSeq_id;
    typedef list< CRef< CGC_TypedSeqId > > TSeq_id_synonyms;
    typedef CSeq_descr TDescr;
    typedef list< CRef< CSeq_annot > > TAnnot;
    typedef list< CRef< CGC_TaggedSequences > > TSequences;
    typedef CDelta_ext TStructure;
    typedef CGC_SequenceStats TStats;
    typedef int TPatch_type;
    typedef list< int > TRoles;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seq_id,
        e_seq_id_synonyms,
        e_descr,
        e_annot,
        e_sequences,
        e_structure,
        e_stats,
        e_patch_type,
        e_roles
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// identifiers are: Local / gpipe-satellite / genbank / refseq
    /// local is merely local name (or maybe with WGS accession??)
    /// others are accession/ver/gi
    ///
    /// Main identifier:
    /// we will report the one that matches the context of who asked.
    /// mandatory
    /// typedef CSeq_id TSeq_id
    ///  Check whether the Seq_id data member has been assigned a value.
    bool IsSetSeq_id(void) const;
    /// Check whether it is safe or not to call GetSeq_id method.
    bool CanGetSeq_id(void) const;
    void ResetSeq_id(void);
    const TSeq_id& GetSeq_id(void) const;
    void SetSeq_id(TSeq_id& value);
    TSeq_id& SetSeq_id(void);

    /// Other known identifiers: Local / gpipe-satellite / genbank / refseq
    /// optional
    /// typedef list< CRef< CGC_TypedSeqId > > TSeq_id_synonyms
    ///  Check whether the Seq_id_synonyms data member has been assigned a value.
    bool IsSetSeq_id_synonyms(void) const;
    /// Check whether it is safe or not to call GetSeq_id_synonyms method.
    bool CanGetSeq_id_synonyms(void) const;
    void ResetSeq_id_synonyms(void);
    const TSeq_id_synonyms& GetSeq_id_synonyms(void) const;
    TSeq_id_synonyms& SetSeq_id_synonyms(void);

    /// Various attributes assigned at this level:
    /// biosrc, comments, publications...
    /// optional
    /// typedef CSeq_descr TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(TDescr& value);
    TDescr& SetDescr(void);

    /// Feature annotation;
    /// Contains Pseudo Autosomal regions on chromosomes and scaffolds in the
    /// following format:
    ///   Id = <ID of PAR (ex:"PAR#1")>
    ///   Desc (set of Annot-descr)
    ///      Name: "pseudo autosomal region"
    ///       Region (seq-loc): int (seq-interval)
    ///          Id:  <GI of chromosome>
    ///            From: <start-position of region>
    ///            To : <end-position of region>
    ///      Data: locs (set of seq-loc):
    ///         List of int (seq-interval):
    ///            Id: GI of scaffold
    ///              From/to: position on scaffold that belongs to this PAR region.
    ///                  <and repeat this for additional scaffolds on same PAR region>
    ///
    /// in alt-loci units - contain alignment of this sequence to the primary
    /// unit
    /// optional
    /// typedef list< CRef< CSeq_annot > > TAnnot
    ///  Check whether the Annot data member has been assigned a value.
    bool IsSetAnnot(void) const;
    /// Check whether it is safe or not to call GetAnnot method.
    bool CanGetAnnot(void) const;
    void ResetAnnot(void);
    const TAnnot& GetAnnot(void) const;
    TAnnot& SetAnnot(void);

    /// placed: populated both on chromosome and scaffold levels
    /// unlocalized: populated on chromosome level
    /// optional
    /// typedef list< CRef< CGC_TaggedSequences > > TSequences
    ///  Check whether the Sequences data member has been assigned a value.
    bool IsSetSequences(void) const;
    /// Check whether it is safe or not to call GetSequences method.
    bool CanGetSequences(void) const;
    void ResetSequences(void);
    const TSequences& GetSequences(void) const;
    TSequences& SetSequences(void);

    /// locations of ordered scaffolds/components
    /// optional
    /// typedef CDelta_ext TStructure
    ///  Check whether the Structure data member has been assigned a value.
    bool IsSetStructure(void) const;
    /// Check whether it is safe or not to call GetStructure method.
    bool CanGetStructure(void) const;
    void ResetStructure(void);
    const TStructure& GetStructure(void) const;
    void SetStructure(TStructure& value);
    TStructure& SetStructure(void);

    /// statistics
    /// optional
    /// typedef CGC_SequenceStats TStats
    ///  Check whether the Stats data member has been assigned a value.
    bool IsSetStats(void) const;
    /// Check whether it is safe or not to call GetStats method.
    bool CanGetStats(void) const;
    void ResetStats(void);
    const TStats& GetStats(void) const;
    void SetStats(TStats& value);
    TStats& SetStats(void);

    /// optional
    /// typedef int TPatch_type
    ///  Check whether the Patch_type data member has been assigned a value.
    bool IsSetPatch_type(void) const;
    /// Check whether it is safe or not to call GetPatch_type method.
    bool CanGetPatch_type(void) const;
    void ResetPatch_type(void);
    TPatch_type GetPatch_type(void) const;
    void SetPatch_type(TPatch_type value);
    TPatch_type& SetPatch_type(void);

    /// sequence-role: what role(s) does this sequence have in the assembly
    /// optional
    /// typedef list< int > TRoles
    ///  Check whether the Roles data member has been assigned a value.
    bool IsSetRoles(void) const;
    /// Check whether it is safe or not to call GetRoles method.
    bool CanGetRoles(void) const;
    void ResetRoles(void);
    const TRoles& GetRoles(void) const;
    TRoles& SetRoles(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_Sequence_Base(const CGC_Sequence_Base&);
    CGC_Sequence_Base& operator=(const CGC_Sequence_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSeq_id > m_Seq_id;
    list< CRef< CGC_TypedSeqId > > m_Seq_id_synonyms;
    CRef< TDescr > m_Descr;
    list< CRef< CSeq_annot > > m_Annot;
    list< CRef< CGC_TaggedSequences > > m_Sequences;
    CRef< TStructure > m_Structure;
    CRef< TStats > m_Stats;
    int m_Patch_type;
    list< int > m_Roles;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_Sequence_Base::IsSetSeq_id(void) const
{
    return m_Seq_id.NotEmpty();
}

inline
bool CGC_Sequence_Base::CanGetSeq_id(void) const
{
    return true;
}

inline
const CGC_Sequence_Base::TSeq_id& CGC_Sequence_Base::GetSeq_id(void) const
{
    if ( !m_Seq_id ) {
        const_cast<CGC_Sequence_Base*>(this)->ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
CGC_Sequence_Base::TSeq_id& CGC_Sequence_Base::SetSeq_id(void)
{
    if ( !m_Seq_id ) {
        ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
bool CGC_Sequence_Base::IsSetSeq_id_synonyms(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGC_Sequence_Base::CanGetSeq_id_synonyms(void) const
{
    return true;
}

inline
const CGC_Sequence_Base::TSeq_id_synonyms& CGC_Sequence_Base::GetSeq_id_synonyms(void) const
{
    return m_Seq_id_synonyms;
}

inline
CGC_Sequence_Base::TSeq_id_synonyms& CGC_Sequence_Base::SetSeq_id_synonyms(void)
{
    m_set_State[0] |= 0x4;
    return m_Seq_id_synonyms;
}

inline
bool CGC_Sequence_Base::IsSetDescr(void) const
{
    return m_Descr.NotEmpty();
}

inline
bool CGC_Sequence_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CGC_Sequence_Base::TDescr& CGC_Sequence_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(2);
    }
    return (*m_Descr);
}

inline
bool CGC_Sequence_Base::IsSetAnnot(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGC_Sequence_Base::CanGetAnnot(void) const
{
    return true;
}

inline
const CGC_Sequence_Base::TAnnot& CGC_Sequence_Base::GetAnnot(void) const
{
    return m_Annot;
}

inline
CGC_Sequence_Base::TAnnot& CGC_Sequence_Base::SetAnnot(void)
{
    m_set_State[0] |= 0x40;
    return m_Annot;
}

inline
bool CGC_Sequence_Base::IsSetSequences(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CGC_Sequence_Base::CanGetSequences(void) const
{
    return true;
}

inline
const CGC_Sequence_Base::TSequences& CGC_Sequence_Base::GetSequences(void) const
{
    return m_Sequences;
}

inline
CGC_Sequence_Base::TSequences& CGC_Sequence_Base::SetSequences(void)
{
    m_set_State[0] |= 0x100;
    return m_Sequences;
}

inline
bool CGC_Sequence_Base::IsSetStructure(void) const
{
    return m_Structure.NotEmpty();
}

inline
bool CGC_Sequence_Base::CanGetStructure(void) const
{
    return IsSetStructure();
}

inline
const CGC_Sequence_Base::TStructure& CGC_Sequence_Base::GetStructure(void) const
{
    if (!CanGetStructure()) {
        ThrowUnassigned(5);
    }
    return (*m_Structure);
}

inline
bool CGC_Sequence_Base::IsSetStats(void) const
{
    return m_Stats.NotEmpty();
}

inline
bool CGC_Sequence_Base::CanGetStats(void) const
{
    return IsSetStats();
}

inline
const CGC_Sequence_Base::TStats& CGC_Sequence_Base::GetStats(void) const
{
    if (!CanGetStats()) {
        ThrowUnassigned(6);
    }
    return (*m_Stats);
}

inline
bool CGC_Sequence_Base::IsSetPatch_type(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CGC_Sequence_Base::CanGetPatch_type(void) const
{
    return IsSetPatch_type();
}

inline
void CGC_Sequence_Base::ResetPatch_type(void)
{
    m_Patch_type = (EPatch_type)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CGC_Sequence_Base::TPatch_type CGC_Sequence_Base::GetPatch_type(void) const
{
    if (!CanGetPatch_type()) {
        ThrowUnassigned(7);
    }
    return m_Patch_type;
}

inline
void CGC_Sequence_Base::SetPatch_type(CGC_Sequence_Base::TPatch_type value)
{
    m_Patch_type = value;
    m_set_State[0] |= 0xc000;
}

inline
CGC_Sequence_Base::TPatch_type& CGC_Sequence_Base::SetPatch_type(void)
{
#ifdef _DEBUG
    if (!IsSetPatch_type()) {
        memset(&m_Patch_type,UnassignedByte(),sizeof(m_Patch_type));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Patch_type;
}

inline
bool CGC_Sequence_Base::IsSetRoles(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CGC_Sequence_Base::CanGetRoles(void) const
{
    return true;
}

inline
const CGC_Sequence_Base::TRoles& CGC_Sequence_Base::GetRoles(void) const
{
    return m_Roles;
}

inline
CGC_Sequence_Base::TRoles& CGC_Sequence_Base::SetRoles(void)
{
    m_set_State[0] |= 0x10000;
    return m_Roles;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_SEQUENCE_BASE_HPP
