/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_SeqIdAlias_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_SEQIDALIAS_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_SEQIDALIAS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Seq-id-alias
/// a sequence has multiple seq-ids - refseq, genbank, local
/// and each one has both gi and accession.version
/// We cannot provide them as simply a list of seq-ids since it will be
/// unclear which gi goes with which accession, therefore we group the
/// related ones as alias pair.
class NCBI_GENOME_COLLECTION_EXPORT CGC_SeqIdAlias_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_SeqIdAlias_Base(void);
    // destructor
    virtual ~CGC_SeqIdAlias_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ESimilarity {
        eSimilarity_unknown   =   0,
        eSimilarity_identical =   1,
        eSimilarity_different = 255
    };
    
    /// Access to ESimilarity's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESimilarity)(void);
    
    // types
    typedef CSeq_id TPublic;
    typedef CSeq_id TGpipe;
    typedef CSeq_id TGi;
    typedef int TSimilarity;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_public,
        e_gpipe,
        e_gi,
        e_similarity
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// the refseq/genbank accession
    /// mandatory
    /// typedef CSeq_id TPublic
    ///  Check whether the Public data member has been assigned a value.
    bool IsSetPublic(void) const;
    /// Check whether it is safe or not to call GetPublic method.
    bool CanGetPublic(void) const;
    void ResetPublic(void);
    const TPublic& GetPublic(void) const;
    void SetPublic(TPublic& value);
    TPublic& SetPublic(void);

    /// the gpipe accession
    /// optional
    /// typedef CSeq_id TGpipe
    ///  Check whether the Gpipe data member has been assigned a value.
    bool IsSetGpipe(void) const;
    /// Check whether it is safe or not to call GetGpipe method.
    bool CanGetGpipe(void) const;
    void ResetGpipe(void);
    const TGpipe& GetGpipe(void) const;
    void SetGpipe(TGpipe& value);
    TGpipe& SetGpipe(void);

    /// optional since not all sequences have GIs
    /// Similarity: relationship between this synonym to main seqid of the
    /// GC-Sequence
    /// Can be expanded to multiple level of identicality
    /// can use bitmap to flag ambiguity between different levels
    /// optional
    /// typedef CSeq_id TGi
    ///  Check whether the Gi data member has been assigned a value.
    bool IsSetGi(void) const;
    /// Check whether it is safe or not to call GetGi method.
    bool CanGetGi(void) const;
    void ResetGi(void);
    const TGi& GetGi(void) const;
    void SetGi(TGi& value);
    TGi& SetGi(void);

    /// mandatory
    /// typedef int TSimilarity
    ///  Check whether the Similarity data member has been assigned a value.
    bool IsSetSimilarity(void) const;
    /// Check whether it is safe or not to call GetSimilarity method.
    bool CanGetSimilarity(void) const;
    void ResetSimilarity(void);
    TSimilarity GetSimilarity(void) const;
    void SetSimilarity(TSimilarity value);
    TSimilarity& SetSimilarity(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_SeqIdAlias_Base(const CGC_SeqIdAlias_Base&);
    CGC_SeqIdAlias_Base& operator=(const CGC_SeqIdAlias_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TPublic > m_Public;
    CRef< TGpipe > m_Gpipe;
    CRef< TGi > m_Gi;
    int m_Similarity;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_SeqIdAlias_Base::IsSetPublic(void) const
{
    return m_Public.NotEmpty();
}

inline
bool CGC_SeqIdAlias_Base::CanGetPublic(void) const
{
    return true;
}

inline
const CGC_SeqIdAlias_Base::TPublic& CGC_SeqIdAlias_Base::GetPublic(void) const
{
    if ( !m_Public ) {
        const_cast<CGC_SeqIdAlias_Base*>(this)->ResetPublic();
    }
    return (*m_Public);
}

inline
CGC_SeqIdAlias_Base::TPublic& CGC_SeqIdAlias_Base::SetPublic(void)
{
    if ( !m_Public ) {
        ResetPublic();
    }
    return (*m_Public);
}

inline
bool CGC_SeqIdAlias_Base::IsSetGpipe(void) const
{
    return m_Gpipe.NotEmpty();
}

inline
bool CGC_SeqIdAlias_Base::CanGetGpipe(void) const
{
    return IsSetGpipe();
}

inline
const CGC_SeqIdAlias_Base::TGpipe& CGC_SeqIdAlias_Base::GetGpipe(void) const
{
    if (!CanGetGpipe()) {
        ThrowUnassigned(1);
    }
    return (*m_Gpipe);
}

inline
bool CGC_SeqIdAlias_Base::IsSetGi(void) const
{
    return m_Gi.NotEmpty();
}

inline
bool CGC_SeqIdAlias_Base::CanGetGi(void) const
{
    return IsSetGi();
}

inline
const CGC_SeqIdAlias_Base::TGi& CGC_SeqIdAlias_Base::GetGi(void) const
{
    if (!CanGetGi()) {
        ThrowUnassigned(2);
    }
    return (*m_Gi);
}

inline
bool CGC_SeqIdAlias_Base::IsSetSimilarity(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGC_SeqIdAlias_Base::CanGetSimilarity(void) const
{
    return IsSetSimilarity();
}

inline
void CGC_SeqIdAlias_Base::ResetSimilarity(void)
{
    m_Similarity = (ESimilarity)(0);
    m_set_State[0] &= ~0xc0;
}

inline
CGC_SeqIdAlias_Base::TSimilarity CGC_SeqIdAlias_Base::GetSimilarity(void) const
{
    if (!CanGetSimilarity()) {
        ThrowUnassigned(3);
    }
    return m_Similarity;
}

inline
void CGC_SeqIdAlias_Base::SetSimilarity(CGC_SeqIdAlias_Base::TSimilarity value)
{
    m_Similarity = value;
    m_set_State[0] |= 0xc0;
}

inline
CGC_SeqIdAlias_Base::TSimilarity& CGC_SeqIdAlias_Base::SetSimilarity(void)
{
#ifdef _DEBUG
    if (!IsSetSimilarity()) {
        memset(&m_Similarity,UnassignedByte(),sizeof(m_Similarity));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Similarity;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_SEQIDALIAS_BASE_HPP
