/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file User_object_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'general.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENERAL_USER_OBJECT_BASE_HPP
#define OBJECTS_GENERAL_USER_OBJECT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CObject_id;
class CUser_field;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///**** User-object **********************************************
///*
///*   a general object for a user defined structured data item
///*    used by Seq-feat and Seq-descr
class NCBI_GENERAL_EXPORT CUser_object_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CUser_object_Base(void);
    // destructor
    virtual ~CUser_object_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TClass;
    typedef CObject_id TType;
    typedef vector< CRef< CUser_field > > TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_class,
        e_type,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// endeavor which designed this object
    /// optional
    /// typedef string TClass
    ///  Check whether the Class data member has been assigned a value.
    bool IsSetClass(void) const;
    /// Check whether it is safe or not to call GetClass method.
    bool CanGetClass(void) const;
    void ResetClass(void);
    const TClass& GetClass(void) const;
    void SetClass(const TClass& value);
    void SetClass(TClass&& value);
    TClass& SetClass(void);

    /// type of object within class
    /// mandatory
    /// typedef CObject_id TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    const TType& GetType(void) const;
    void SetType(TType& value);
    TType& SetType(void);

    /// the object itself
    /// mandatory
    /// typedef vector< CRef< CUser_field > > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CUser_object_Base(const CUser_object_Base&);
    CUser_object_Base& operator=(const CUser_object_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Class;
    CRef< TType > m_Type;
    vector< CRef< CUser_field > > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CUser_object_Base::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CUser_object_Base::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CUser_object_Base::TClass& CUser_object_Base::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(0);
    }
    return m_Class;
}

inline
void CUser_object_Base::SetClass(const CUser_object_Base::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x3;
}

inline
void CUser_object_Base::SetClass(CUser_object_Base::TClass&& value)
{
    m_Class = std::forward<CUser_object_Base::TClass>(value);
    m_set_State[0] |= 0x3;
}

inline
CUser_object_Base::TClass& CUser_object_Base::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Class;
}

inline
bool CUser_object_Base::IsSetType(void) const
{
    return m_Type.NotEmpty();
}

inline
bool CUser_object_Base::CanGetType(void) const
{
    return true;
}

inline
const CUser_object_Base::TType& CUser_object_Base::GetType(void) const
{
    if ( !m_Type ) {
        const_cast<CUser_object_Base*>(this)->ResetType();
    }
    return (*m_Type);
}

inline
CUser_object_Base::TType& CUser_object_Base::SetType(void)
{
    if ( !m_Type ) {
        ResetType();
    }
    return (*m_Type);
}

inline
bool CUser_object_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CUser_object_Base::CanGetData(void) const
{
    return true;
}

inline
const CUser_object_Base::TData& CUser_object_Base::GetData(void) const
{
    return m_Data;
}

inline
CUser_object_Base::TData& CUser_object_Base::SetData(void)
{
    m_set_State[0] |= 0x10;
    return m_Data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENERAL_USER_OBJECT_BASE_HPP
