/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file FeatDefGroupSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'featdef.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_FEATDEF_FEATDEFGROUPSET_BASE_HPP
#define OBJECTS_FEATDEF_FEATDEFGROUPSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CFeatDefSet;
class CFeatDispGroupSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_FEATDEF_EXPORT CFeatDefGroupSet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CFeatDefGroupSet_Base(void);
    // destructor
    virtual ~CFeatDefGroupSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CFeatDispGroupSet TGroups;
    typedef CFeatDefSet TDefs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_groups,
        e_defs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CFeatDispGroupSet TGroups
    ///  Check whether the Groups data member has been assigned a value.
    bool IsSetGroups(void) const;
    /// Check whether it is safe or not to call GetGroups method.
    bool CanGetGroups(void) const;
    void ResetGroups(void);
    const TGroups& GetGroups(void) const;
    void SetGroups(TGroups& value);
    TGroups& SetGroups(void);

    /// mandatory
    /// typedef CFeatDefSet TDefs
    ///  Check whether the Defs data member has been assigned a value.
    bool IsSetDefs(void) const;
    /// Check whether it is safe or not to call GetDefs method.
    bool CanGetDefs(void) const;
    void ResetDefs(void);
    const TDefs& GetDefs(void) const;
    void SetDefs(TDefs& value);
    TDefs& SetDefs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CFeatDefGroupSet_Base(const CFeatDefGroupSet_Base&);
    CFeatDefGroupSet_Base& operator=(const CFeatDefGroupSet_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TGroups > m_Groups;
    CRef< TDefs > m_Defs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CFeatDefGroupSet_Base::IsSetGroups(void) const
{
    return m_Groups.NotEmpty();
}

inline
bool CFeatDefGroupSet_Base::CanGetGroups(void) const
{
    return true;
}

inline
const CFeatDefGroupSet_Base::TGroups& CFeatDefGroupSet_Base::GetGroups(void) const
{
    if ( !m_Groups ) {
        const_cast<CFeatDefGroupSet_Base*>(this)->ResetGroups();
    }
    return (*m_Groups);
}

inline
CFeatDefGroupSet_Base::TGroups& CFeatDefGroupSet_Base::SetGroups(void)
{
    if ( !m_Groups ) {
        ResetGroups();
    }
    return (*m_Groups);
}

inline
bool CFeatDefGroupSet_Base::IsSetDefs(void) const
{
    return m_Defs.NotEmpty();
}

inline
bool CFeatDefGroupSet_Base::CanGetDefs(void) const
{
    return true;
}

inline
const CFeatDefGroupSet_Base::TDefs& CFeatDefGroupSet_Base::GetDefs(void) const
{
    if ( !m_Defs ) {
        const_cast<CFeatDefGroupSet_Base*>(this)->ResetDefs();
    }
    return (*m_Defs);
}

inline
CFeatDefGroupSet_Base::TDefs& CFeatDefGroupSet_Base::SetDefs(void)
{
    if ( !m_Defs ) {
        ResetDefs();
    }
    return (*m_Defs);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_FEATDEF_FEATDEFGROUPSET_BASE_HPP
