/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ExchangeSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_EXCHANGESET_BASE_HPP
#define OBJECTS_DOCSUM_EXCHANGESET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAssay;
class CBaseURL;
class CRs;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///Set of dbSNP refSNP docsums, version 3.4
class NCBI_DOCSUM_EXPORT CExchangeSet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CExchangeSet_Base(void);
    // destructor
    virtual ~CExchangeSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef string TSetType;
        typedef string TSetDepth;
        typedef string TSpecVersion;
        typedef int TDbSnpBuild;
        typedef string TGenerated;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_setType,
            e_setDepth,
            e_specVersion,
            e_dbSnpBuild,
            e_generated
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;
    
        // getters
        // setters
    
        ///set-type: full dump; from query; single
        ///						refSNP
        /// optional
        /// typedef string TSetType
        ///  Check whether the SetType data member has been assigned a value.
        bool IsSetSetType(void) const;
        /// Check whether it is safe or not to call GetSetType method.
        bool CanGetSetType(void) const;
        void ResetSetType(void);
        const TSetType& GetSetType(void) const;
        void SetSetType(const TSetType& value);
        void SetSetType(TSetType&& value);
        TSetType& SetSetType(void);
    
        ///content depth: brief XML (only refSNP properties and summary
        ///						subSNP element content); full XML (full refSNP, full subSNP content; all
        ///						flanking sequences) 
        /// optional
        /// typedef string TSetDepth
        ///  Check whether the SetDepth data member has been assigned a value.
        bool IsSetSetDepth(void) const;
        /// Check whether it is safe or not to call GetSetDepth method.
        bool CanGetSetDepth(void) const;
        void ResetSetDepth(void);
        const TSetDepth& GetSetDepth(void) const;
        void SetSetDepth(const TSetDepth& value);
        void SetSetDepth(TSetDepth&& value);
        TSetDepth& SetSetDepth(void);
    
        ///version number of docsum.asn/docsum.dtd
        ///						specification
        /// optional
        /// typedef string TSpecVersion
        ///  Check whether the SpecVersion data member has been assigned a value.
        bool IsSetSpecVersion(void) const;
        /// Check whether it is safe or not to call GetSpecVersion method.
        bool CanGetSpecVersion(void) const;
        void ResetSpecVersion(void);
        const TSpecVersion& GetSpecVersion(void) const;
        void SetSpecVersion(const TSpecVersion& value);
        void SetSpecVersion(TSpecVersion&& value);
        TSpecVersion& SetSpecVersion(void);
    
        ///build number of database for this export
        /// optional
        /// typedef int TDbSnpBuild
        ///  Check whether the DbSnpBuild data member has been assigned a value.
        bool IsSetDbSnpBuild(void) const;
        /// Check whether it is safe or not to call GetDbSnpBuild method.
        bool CanGetDbSnpBuild(void) const;
        void ResetDbSnpBuild(void);
        TDbSnpBuild GetDbSnpBuild(void) const;
        void SetDbSnpBuild(TDbSnpBuild value);
        TDbSnpBuild& SetDbSnpBuild(void);
    
        ///Generated date
        /// optional
        /// typedef string TGenerated
        ///  Check whether the Generated data member has been assigned a value.
        bool IsSetGenerated(void) const;
        /// Check whether it is safe or not to call GetGenerated method.
        bool CanGetGenerated(void) const;
        void ResetGenerated(void);
        const TGenerated& GetGenerated(void) const;
        void SetGenerated(const TGenerated& value);
        void SetGenerated(TGenerated&& value);
        TGenerated& SetGenerated(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        string m_SetType;
        string m_SetDepth;
        string m_SpecVersion;
        int m_DbSnpBuild;
        string m_Generated;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_SourceDatabase : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_SourceDatabase(void);
        // destructor
        ~C_SourceDatabase(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef int TTaxId;
            typedef string TOrganism;
            typedef string TDbSnpOrgAbbr;
            typedef string TGpipeOrgAbbr;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_taxId,
                e_organism,
                e_dbSnpOrgAbbr,
                e_gpipeOrgAbbr
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;
        
            // getters
            // setters
        
            ///NCBI taxonomy ID for
            ///									variation
            /// mandatory
            /// typedef int TTaxId
            ///  Check whether the TaxId data member has been assigned a value.
            bool IsSetTaxId(void) const;
            /// Check whether it is safe or not to call GetTaxId method.
            bool CanGetTaxId(void) const;
            void ResetTaxId(void);
            TTaxId GetTaxId(void) const;
            void SetTaxId(TTaxId value);
            TTaxId& SetTaxId(void);
        
            ///common name for species used as part of database
            ///									name.
            /// mandatory
            /// typedef string TOrganism
            ///  Check whether the Organism data member has been assigned a value.
            bool IsSetOrganism(void) const;
            /// Check whether it is safe or not to call GetOrganism method.
            bool CanGetOrganism(void) const;
            void ResetOrganism(void);
            const TOrganism& GetOrganism(void) const;
            void SetOrganism(const TOrganism& value);
            void SetOrganism(TOrganism&& value);
            TOrganism& SetOrganism(void);
        
            ///organism abbreviation used in dbSNP.
            /// optional
            /// typedef string TDbSnpOrgAbbr
            ///  Check whether the DbSnpOrgAbbr data member has been assigned a value.
            bool IsSetDbSnpOrgAbbr(void) const;
            /// Check whether it is safe or not to call GetDbSnpOrgAbbr method.
            bool CanGetDbSnpOrgAbbr(void) const;
            void ResetDbSnpOrgAbbr(void);
            const TDbSnpOrgAbbr& GetDbSnpOrgAbbr(void) const;
            void SetDbSnpOrgAbbr(const TDbSnpOrgAbbr& value);
            void SetDbSnpOrgAbbr(TDbSnpOrgAbbr&& value);
            TDbSnpOrgAbbr& SetDbSnpOrgAbbr(void);
        
            ///organism abbreviation used within NCBI genome
            ///									pipeline data dumps.
            /// optional
            /// typedef string TGpipeOrgAbbr
            ///  Check whether the GpipeOrgAbbr data member has been assigned a value.
            bool IsSetGpipeOrgAbbr(void) const;
            /// Check whether it is safe or not to call GetGpipeOrgAbbr method.
            bool CanGetGpipeOrgAbbr(void) const;
            void ResetGpipeOrgAbbr(void);
            const TGpipeOrgAbbr& GetGpipeOrgAbbr(void) const;
            void SetGpipeOrgAbbr(const TGpipeOrgAbbr& value);
            void SetGpipeOrgAbbr(TGpipeOrgAbbr&& value);
            TGpipeOrgAbbr& SetGpipeOrgAbbr(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            int m_TaxId;
            string m_Organism;
            string m_DbSnpOrgAbbr;
            string m_GpipeOrgAbbr;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_sourceDatabase
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        /// mandatory
        ///  Check whether the SourceDatabase data member has been assigned a value.
        bool IsSetSourceDatabase(void) const;
        /// Check whether it is safe or not to call GetSourceDatabase method.
        bool CanGetSourceDatabase(void) const;
        void ResetSourceDatabase(void);
        void SetSourceDatabase(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_SourceDatabase(const C_SourceDatabase&);
        C_SourceDatabase& operator=(const C_SourceDatabase&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Query : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Query(void);
        // destructor
        ~C_Query(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef string TDate;
            typedef string TString;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_date,
                e_string
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            ///yyyy-mm-dd
            /// optional
            /// typedef string TDate
            ///  Check whether the Date data member has been assigned a value.
            bool IsSetDate(void) const;
            /// Check whether it is safe or not to call GetDate method.
            bool CanGetDate(void) const;
            void ResetDate(void);
            const TDate& GetDate(void) const;
            void SetDate(const TDate& value);
            void SetDate(TDate&& value);
            TDate& SetDate(void);
        
            ///Query terms or search
            ///									constraints
            /// optional
            /// typedef string TString
            ///  Check whether the String data member has been assigned a value.
            bool IsSetString(void) const;
            /// Check whether it is safe or not to call GetString method.
            bool CanGetString(void) const;
            void ResetString(void);
            const TString& GetString(void) const;
            void SetString(const TString& value);
            void SetString(TString&& value);
            TString& SetString(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            string m_Date;
            string m_String;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_query
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        /// mandatory
        ///  Check whether the Query data member has been assigned a value.
        bool IsSetQuery(void) const;
        /// Check whether it is safe or not to call GetQuery method.
        bool CanGetQuery(void) const;
        void ResetQuery(void);
        void SetQuery(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Query(const C_Query&);
        C_Query& operator=(const C_Query&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Summary : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Summary(void);
        // destructor
        ~C_Summary(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef int TNumRsIds;
            typedef Int8 TTotalSeqLength;
            typedef int TNumContigHits;
            typedef int TNumGeneHits;
            typedef int TNumGiHits;
            typedef int TNum3dStructs;
            typedef int TNumAlleleFreqs;
            typedef int TNumStsHits;
            typedef int TNumUnigeneCids;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_numRsIds,
                e_totalSeqLength,
                e_numContigHits,
                e_numGeneHits,
                e_numGiHits,
                e_num3dStructs,
                e_numAlleleFreqs,
                e_numStsHits,
                e_numUnigeneCids
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;
        
            // getters
            // setters
        
            ///Total number of refsnp-ids in this exchange set
            /// optional
            /// typedef int TNumRsIds
            ///  Check whether the NumRsIds data member has been assigned a value.
            bool IsSetNumRsIds(void) const;
            /// Check whether it is safe or not to call GetNumRsIds method.
            bool CanGetNumRsIds(void) const;
            void ResetNumRsIds(void);
            TNumRsIds GetNumRsIds(void) const;
            void SetNumRsIds(TNumRsIds value);
            TNumRsIds& SetNumRsIds(void);
        
            ///Total length of exemplar flanking
            ///									sequences
            /// optional
            /// typedef Int8 TTotalSeqLength
            ///  Check whether the TotalSeqLength data member has been assigned a value.
            bool IsSetTotalSeqLength(void) const;
            /// Check whether it is safe or not to call GetTotalSeqLength method.
            bool CanGetTotalSeqLength(void) const;
            void ResetTotalSeqLength(void);
            TTotalSeqLength GetTotalSeqLength(void) const;
            void SetTotalSeqLength(TTotalSeqLength value);
            TTotalSeqLength& SetTotalSeqLength(void);
        
            ///Total number of contig locations from
            ///									SNPContigLoc
            /// optional
            /// typedef int TNumContigHits
            ///  Check whether the NumContigHits data member has been assigned a value.
            bool IsSetNumContigHits(void) const;
            /// Check whether it is safe or not to call GetNumContigHits method.
            bool CanGetNumContigHits(void) const;
            void ResetNumContigHits(void);
            TNumContigHits GetNumContigHits(void) const;
            void SetNumContigHits(TNumContigHits value);
            TNumContigHits& SetNumContigHits(void);
        
            ///Total number of locus ids from
            ///									SNPContigLocusId
            /// optional
            /// typedef int TNumGeneHits
            ///  Check whether the NumGeneHits data member has been assigned a value.
            bool IsSetNumGeneHits(void) const;
            /// Check whether it is safe or not to call GetNumGeneHits method.
            bool CanGetNumGeneHits(void) const;
            void ResetNumGeneHits(void);
            TNumGeneHits GetNumGeneHits(void) const;
            void SetNumGeneHits(TNumGeneHits value);
            TNumGeneHits& SetNumGeneHits(void);
        
            ///Total number of gi hits from
            ///									MapLink
            /// optional
            /// typedef int TNumGiHits
            ///  Check whether the NumGiHits data member has been assigned a value.
            bool IsSetNumGiHits(void) const;
            /// Check whether it is safe or not to call GetNumGiHits method.
            bool CanGetNumGiHits(void) const;
            void ResetNumGiHits(void);
            TNumGiHits GetNumGiHits(void) const;
            void SetNumGiHits(TNumGiHits value);
            TNumGiHits& SetNumGiHits(void);
        
            ///Total number of 3D structures from
            ///									SNP3D
            /// optional
            /// typedef int TNum3dStructs
            ///  Check whether the Num3dStructs data member has been assigned a value.
            bool IsSetNum3dStructs(void) const;
            /// Check whether it is safe or not to call GetNum3dStructs method.
            bool CanGetNum3dStructs(void) const;
            void ResetNum3dStructs(void);
            TNum3dStructs GetNum3dStructs(void) const;
            void SetNum3dStructs(TNum3dStructs value);
            TNum3dStructs& SetNum3dStructs(void);
        
            ///Total number of allele frequences from
            ///									SubPopAllele
            /// optional
            /// typedef int TNumAlleleFreqs
            ///  Check whether the NumAlleleFreqs data member has been assigned a value.
            bool IsSetNumAlleleFreqs(void) const;
            /// Check whether it is safe or not to call GetNumAlleleFreqs method.
            bool CanGetNumAlleleFreqs(void) const;
            void ResetNumAlleleFreqs(void);
            TNumAlleleFreqs GetNumAlleleFreqs(void) const;
            void SetNumAlleleFreqs(TNumAlleleFreqs value);
            TNumAlleleFreqs& SetNumAlleleFreqs(void);
        
            ///Total number of STS hits from
            ///									SnpInSts
            /// optional
            /// typedef int TNumStsHits
            ///  Check whether the NumStsHits data member has been assigned a value.
            bool IsSetNumStsHits(void) const;
            /// Check whether it is safe or not to call GetNumStsHits method.
            bool CanGetNumStsHits(void) const;
            void ResetNumStsHits(void);
            TNumStsHits GetNumStsHits(void) const;
            void SetNumStsHits(TNumStsHits value);
            TNumStsHits& SetNumStsHits(void);
        
            ///Total number of unigene cluster ids from
            ///									UnigeneSnp
            /// optional
            /// typedef int TNumUnigeneCids
            ///  Check whether the NumUnigeneCids data member has been assigned a value.
            bool IsSetNumUnigeneCids(void) const;
            /// Check whether it is safe or not to call GetNumUnigeneCids method.
            bool CanGetNumUnigeneCids(void) const;
            void ResetNumUnigeneCids(void);
            TNumUnigeneCids GetNumUnigeneCids(void) const;
            void SetNumUnigeneCids(TNumUnigeneCids value);
            TNumUnigeneCids& SetNumUnigeneCids(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            int m_NumRsIds;
            Int8 m_TotalSeqLength;
            int m_NumContigHits;
            int m_NumGeneHits;
            int m_NumGiHits;
            int m_Num3dStructs;
            int m_NumAlleleFreqs;
            int m_NumStsHits;
            int m_NumUnigeneCids;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_summary
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        /// mandatory
        ///  Check whether the Summary data member has been assigned a value.
        bool IsSetSummary(void) const;
        /// Check whether it is safe or not to call GetSummary method.
        bool CanGetSummary(void) const;
        void ResetSummary(void);
        void SetSummary(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Summary(const C_Summary&);
        C_Summary& operator=(const C_Summary&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_SourceDatabase TSourceDatabase;
    typedef list< CRef< CRs > > TRs;
    typedef CAssay TAssay;
    typedef C_Query TQuery;
    typedef C_Summary TSummary;
    typedef list< CRef< CBaseURL > > TBaseURL;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_sourceDatabase,
        e_rs,
        e_assay,
        e_query,
        e_summary,
        e_baseURL
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef C_SourceDatabase TSourceDatabase
    ///  Check whether the SourceDatabase data member has been assigned a value.
    bool IsSetSourceDatabase(void) const;
    /// Check whether it is safe or not to call GetSourceDatabase method.
    bool CanGetSourceDatabase(void) const;
    void ResetSourceDatabase(void);
    const TSourceDatabase& GetSourceDatabase(void) const;
    void SetSourceDatabase(TSourceDatabase& value);
    TSourceDatabase& SetSourceDatabase(void);

    /// optional
    /// typedef list< CRef< CRs > > TRs
    ///  Check whether the Rs data member has been assigned a value.
    bool IsSetRs(void) const;
    /// Check whether it is safe or not to call GetRs method.
    bool CanGetRs(void) const;
    void ResetRs(void);
    const TRs& GetRs(void) const;
    TRs& SetRs(void);

    /// optional
    /// typedef CAssay TAssay
    ///  Check whether the Assay data member has been assigned a value.
    bool IsSetAssay(void) const;
    /// Check whether it is safe or not to call GetAssay method.
    bool CanGetAssay(void) const;
    void ResetAssay(void);
    const TAssay& GetAssay(void) const;
    void SetAssay(TAssay& value);
    TAssay& SetAssay(void);

    /// optional
    /// typedef C_Query TQuery
    ///  Check whether the Query data member has been assigned a value.
    bool IsSetQuery(void) const;
    /// Check whether it is safe or not to call GetQuery method.
    bool CanGetQuery(void) const;
    void ResetQuery(void);
    const TQuery& GetQuery(void) const;
    void SetQuery(TQuery& value);
    TQuery& SetQuery(void);

    /// optional
    /// typedef C_Summary TSummary
    ///  Check whether the Summary data member has been assigned a value.
    bool IsSetSummary(void) const;
    /// Check whether it is safe or not to call GetSummary method.
    bool CanGetSummary(void) const;
    void ResetSummary(void);
    const TSummary& GetSummary(void) const;
    void SetSummary(TSummary& value);
    TSummary& SetSummary(void);

    /// optional
    /// typedef list< CRef< CBaseURL > > TBaseURL
    ///  Check whether the BaseURL data member has been assigned a value.
    bool IsSetBaseURL(void) const;
    /// Check whether it is safe or not to call GetBaseURL method.
    bool CanGetBaseURL(void) const;
    void ResetBaseURL(void);
    const TBaseURL& GetBaseURL(void) const;
    TBaseURL& SetBaseURL(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CExchangeSet_Base(const CExchangeSet_Base&);
    CExchangeSet_Base& operator=(const CExchangeSet_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
    CRef< TSourceDatabase > m_SourceDatabase;
    list< CRef< CRs > > m_Rs;
    CRef< TAssay > m_Assay;
    CRef< TQuery > m_Query;
    CRef< TSummary > m_Summary;
    list< CRef< CBaseURL > > m_BaseURL;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CExchangeSet_Base::C_Attlist::IsSetSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CExchangeSet_Base::C_Attlist::CanGetSetType(void) const
{
    return IsSetSetType();
}

inline
const CExchangeSet_Base::C_Attlist::TSetType& CExchangeSet_Base::C_Attlist::GetSetType(void) const
{
    if (!CanGetSetType()) {
        ThrowUnassigned(0);
    }
    return m_SetType;
}

inline
void CExchangeSet_Base::C_Attlist::SetSetType(const CExchangeSet_Base::C_Attlist::TSetType& value)
{
    m_SetType = value;
    m_set_State[0] |= 0x3;
}

inline
void CExchangeSet_Base::C_Attlist::SetSetType(CExchangeSet_Base::C_Attlist::TSetType&& value)
{
    m_SetType = std::forward<CExchangeSet_Base::C_Attlist::TSetType>(value);
    m_set_State[0] |= 0x3;
}

inline
CExchangeSet_Base::C_Attlist::TSetType& CExchangeSet_Base::C_Attlist::SetSetType(void)
{
#ifdef _DEBUG
    if (!IsSetSetType()) {
        m_SetType = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_SetType;
}

inline
bool CExchangeSet_Base::C_Attlist::IsSetSetDepth(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CExchangeSet_Base::C_Attlist::CanGetSetDepth(void) const
{
    return IsSetSetDepth();
}

inline
const CExchangeSet_Base::C_Attlist::TSetDepth& CExchangeSet_Base::C_Attlist::GetSetDepth(void) const
{
    if (!CanGetSetDepth()) {
        ThrowUnassigned(1);
    }
    return m_SetDepth;
}

inline
void CExchangeSet_Base::C_Attlist::SetSetDepth(const CExchangeSet_Base::C_Attlist::TSetDepth& value)
{
    m_SetDepth = value;
    m_set_State[0] |= 0xc;
}

inline
void CExchangeSet_Base::C_Attlist::SetSetDepth(CExchangeSet_Base::C_Attlist::TSetDepth&& value)
{
    m_SetDepth = std::forward<CExchangeSet_Base::C_Attlist::TSetDepth>(value);
    m_set_State[0] |= 0xc;
}

inline
CExchangeSet_Base::C_Attlist::TSetDepth& CExchangeSet_Base::C_Attlist::SetSetDepth(void)
{
#ifdef _DEBUG
    if (!IsSetSetDepth()) {
        m_SetDepth = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_SetDepth;
}

inline
bool CExchangeSet_Base::C_Attlist::IsSetSpecVersion(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CExchangeSet_Base::C_Attlist::CanGetSpecVersion(void) const
{
    return IsSetSpecVersion();
}

inline
const CExchangeSet_Base::C_Attlist::TSpecVersion& CExchangeSet_Base::C_Attlist::GetSpecVersion(void) const
{
    if (!CanGetSpecVersion()) {
        ThrowUnassigned(2);
    }
    return m_SpecVersion;
}

inline
void CExchangeSet_Base::C_Attlist::SetSpecVersion(const CExchangeSet_Base::C_Attlist::TSpecVersion& value)
{
    m_SpecVersion = value;
    m_set_State[0] |= 0x30;
}

inline
void CExchangeSet_Base::C_Attlist::SetSpecVersion(CExchangeSet_Base::C_Attlist::TSpecVersion&& value)
{
    m_SpecVersion = std::forward<CExchangeSet_Base::C_Attlist::TSpecVersion>(value);
    m_set_State[0] |= 0x30;
}

inline
CExchangeSet_Base::C_Attlist::TSpecVersion& CExchangeSet_Base::C_Attlist::SetSpecVersion(void)
{
#ifdef _DEBUG
    if (!IsSetSpecVersion()) {
        m_SpecVersion = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_SpecVersion;
}

inline
bool CExchangeSet_Base::C_Attlist::IsSetDbSnpBuild(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CExchangeSet_Base::C_Attlist::CanGetDbSnpBuild(void) const
{
    return IsSetDbSnpBuild();
}

inline
void CExchangeSet_Base::C_Attlist::ResetDbSnpBuild(void)
{
    m_DbSnpBuild = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CExchangeSet_Base::C_Attlist::TDbSnpBuild CExchangeSet_Base::C_Attlist::GetDbSnpBuild(void) const
{
    if (!CanGetDbSnpBuild()) {
        ThrowUnassigned(3);
    }
    return m_DbSnpBuild;
}

inline
void CExchangeSet_Base::C_Attlist::SetDbSnpBuild(CExchangeSet_Base::C_Attlist::TDbSnpBuild value)
{
    m_DbSnpBuild = value;
    m_set_State[0] |= 0xc0;
}

inline
CExchangeSet_Base::C_Attlist::TDbSnpBuild& CExchangeSet_Base::C_Attlist::SetDbSnpBuild(void)
{
#ifdef _DEBUG
    if (!IsSetDbSnpBuild()) {
        memset(&m_DbSnpBuild,UnassignedByte(),sizeof(m_DbSnpBuild));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_DbSnpBuild;
}

inline
bool CExchangeSet_Base::C_Attlist::IsSetGenerated(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CExchangeSet_Base::C_Attlist::CanGetGenerated(void) const
{
    return IsSetGenerated();
}

inline
const CExchangeSet_Base::C_Attlist::TGenerated& CExchangeSet_Base::C_Attlist::GetGenerated(void) const
{
    if (!CanGetGenerated()) {
        ThrowUnassigned(4);
    }
    return m_Generated;
}

inline
void CExchangeSet_Base::C_Attlist::SetGenerated(const CExchangeSet_Base::C_Attlist::TGenerated& value)
{
    m_Generated = value;
    m_set_State[0] |= 0x300;
}

inline
void CExchangeSet_Base::C_Attlist::SetGenerated(CExchangeSet_Base::C_Attlist::TGenerated&& value)
{
    m_Generated = std::forward<CExchangeSet_Base::C_Attlist::TGenerated>(value);
    m_set_State[0] |= 0x300;
}

inline
CExchangeSet_Base::C_Attlist::TGenerated& CExchangeSet_Base::C_Attlist::SetGenerated(void)
{
#ifdef _DEBUG
    if (!IsSetGenerated()) {
        m_Generated = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Generated;
}

inline
bool CExchangeSet_Base::C_SourceDatabase::C_Attlist::IsSetTaxId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CExchangeSet_Base::C_SourceDatabase::C_Attlist::CanGetTaxId(void) const
{
    return IsSetTaxId();
}

inline
void CExchangeSet_Base::C_SourceDatabase::C_Attlist::ResetTaxId(void)
{
    m_TaxId = 0;
    m_set_State[0] &= ~0x3;
}

inline
CExchangeSet_Base::C_SourceDatabase::C_Attlist::TTaxId CExchangeSet_Base::C_SourceDatabase::C_Attlist::GetTaxId(void) const
{
    if (!CanGetTaxId()) {
        ThrowUnassigned(0);
    }
    return m_TaxId;
}

inline
void CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetTaxId(CExchangeSet_Base::C_SourceDatabase::C_Attlist::TTaxId value)
{
    m_TaxId = value;
    m_set_State[0] |= 0x3;
}

inline
CExchangeSet_Base::C_SourceDatabase::C_Attlist::TTaxId& CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetTaxId(void)
{
#ifdef _DEBUG
    if (!IsSetTaxId()) {
        memset(&m_TaxId,UnassignedByte(),sizeof(m_TaxId));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_TaxId;
}

inline
bool CExchangeSet_Base::C_SourceDatabase::C_Attlist::IsSetOrganism(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CExchangeSet_Base::C_SourceDatabase::C_Attlist::CanGetOrganism(void) const
{
    return IsSetOrganism();
}

inline
const CExchangeSet_Base::C_SourceDatabase::C_Attlist::TOrganism& CExchangeSet_Base::C_SourceDatabase::C_Attlist::GetOrganism(void) const
{
    if (!CanGetOrganism()) {
        ThrowUnassigned(1);
    }
    return m_Organism;
}

inline
void CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetOrganism(const CExchangeSet_Base::C_SourceDatabase::C_Attlist::TOrganism& value)
{
    m_Organism = value;
    m_set_State[0] |= 0xc;
}

inline
void CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetOrganism(CExchangeSet_Base::C_SourceDatabase::C_Attlist::TOrganism&& value)
{
    m_Organism = std::forward<CExchangeSet_Base::C_SourceDatabase::C_Attlist::TOrganism>(value);
    m_set_State[0] |= 0xc;
}

inline
CExchangeSet_Base::C_SourceDatabase::C_Attlist::TOrganism& CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetOrganism(void)
{
#ifdef _DEBUG
    if (!IsSetOrganism()) {
        m_Organism = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Organism;
}

inline
bool CExchangeSet_Base::C_SourceDatabase::C_Attlist::IsSetDbSnpOrgAbbr(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CExchangeSet_Base::C_SourceDatabase::C_Attlist::CanGetDbSnpOrgAbbr(void) const
{
    return IsSetDbSnpOrgAbbr();
}

inline
const CExchangeSet_Base::C_SourceDatabase::C_Attlist::TDbSnpOrgAbbr& CExchangeSet_Base::C_SourceDatabase::C_Attlist::GetDbSnpOrgAbbr(void) const
{
    if (!CanGetDbSnpOrgAbbr()) {
        ThrowUnassigned(2);
    }
    return m_DbSnpOrgAbbr;
}

inline
void CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetDbSnpOrgAbbr(const CExchangeSet_Base::C_SourceDatabase::C_Attlist::TDbSnpOrgAbbr& value)
{
    m_DbSnpOrgAbbr = value;
    m_set_State[0] |= 0x30;
}

inline
void CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetDbSnpOrgAbbr(CExchangeSet_Base::C_SourceDatabase::C_Attlist::TDbSnpOrgAbbr&& value)
{
    m_DbSnpOrgAbbr = std::forward<CExchangeSet_Base::C_SourceDatabase::C_Attlist::TDbSnpOrgAbbr>(value);
    m_set_State[0] |= 0x30;
}

inline
CExchangeSet_Base::C_SourceDatabase::C_Attlist::TDbSnpOrgAbbr& CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetDbSnpOrgAbbr(void)
{
#ifdef _DEBUG
    if (!IsSetDbSnpOrgAbbr()) {
        m_DbSnpOrgAbbr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_DbSnpOrgAbbr;
}

inline
bool CExchangeSet_Base::C_SourceDatabase::C_Attlist::IsSetGpipeOrgAbbr(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CExchangeSet_Base::C_SourceDatabase::C_Attlist::CanGetGpipeOrgAbbr(void) const
{
    return IsSetGpipeOrgAbbr();
}

inline
const CExchangeSet_Base::C_SourceDatabase::C_Attlist::TGpipeOrgAbbr& CExchangeSet_Base::C_SourceDatabase::C_Attlist::GetGpipeOrgAbbr(void) const
{
    if (!CanGetGpipeOrgAbbr()) {
        ThrowUnassigned(3);
    }
    return m_GpipeOrgAbbr;
}

inline
void CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetGpipeOrgAbbr(const CExchangeSet_Base::C_SourceDatabase::C_Attlist::TGpipeOrgAbbr& value)
{
    m_GpipeOrgAbbr = value;
    m_set_State[0] |= 0xc0;
}

inline
void CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetGpipeOrgAbbr(CExchangeSet_Base::C_SourceDatabase::C_Attlist::TGpipeOrgAbbr&& value)
{
    m_GpipeOrgAbbr = std::forward<CExchangeSet_Base::C_SourceDatabase::C_Attlist::TGpipeOrgAbbr>(value);
    m_set_State[0] |= 0xc0;
}

inline
CExchangeSet_Base::C_SourceDatabase::C_Attlist::TGpipeOrgAbbr& CExchangeSet_Base::C_SourceDatabase::C_Attlist::SetGpipeOrgAbbr(void)
{
#ifdef _DEBUG
    if (!IsSetGpipeOrgAbbr()) {
        m_GpipeOrgAbbr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_GpipeOrgAbbr;
}

inline
bool CExchangeSet_Base::C_SourceDatabase::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CExchangeSet_Base::C_SourceDatabase::CanGetAttlist(void) const
{
    return true;
}

inline
const CExchangeSet_Base::C_SourceDatabase::TAttlist& CExchangeSet_Base::C_SourceDatabase::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_SourceDatabase*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CExchangeSet_Base::C_SourceDatabase::TAttlist& CExchangeSet_Base::C_SourceDatabase::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CExchangeSet_Base::C_SourceDatabase::IsSetSourceDatabase(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CExchangeSet_Base::C_SourceDatabase::CanGetSourceDatabase(void) const
{
    return false;
}

inline
void CExchangeSet_Base::C_SourceDatabase::ResetSourceDatabase(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CExchangeSet_Base::C_SourceDatabase::SetSourceDatabase(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CExchangeSet_Base::C_Query::C_Attlist::IsSetDate(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CExchangeSet_Base::C_Query::C_Attlist::CanGetDate(void) const
{
    return IsSetDate();
}

inline
const CExchangeSet_Base::C_Query::C_Attlist::TDate& CExchangeSet_Base::C_Query::C_Attlist::GetDate(void) const
{
    if (!CanGetDate()) {
        ThrowUnassigned(0);
    }
    return m_Date;
}

inline
void CExchangeSet_Base::C_Query::C_Attlist::SetDate(const CExchangeSet_Base::C_Query::C_Attlist::TDate& value)
{
    m_Date = value;
    m_set_State[0] |= 0x3;
}

inline
void CExchangeSet_Base::C_Query::C_Attlist::SetDate(CExchangeSet_Base::C_Query::C_Attlist::TDate&& value)
{
    m_Date = std::forward<CExchangeSet_Base::C_Query::C_Attlist::TDate>(value);
    m_set_State[0] |= 0x3;
}

inline
CExchangeSet_Base::C_Query::C_Attlist::TDate& CExchangeSet_Base::C_Query::C_Attlist::SetDate(void)
{
#ifdef _DEBUG
    if (!IsSetDate()) {
        m_Date = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Date;
}

inline
bool CExchangeSet_Base::C_Query::C_Attlist::IsSetString(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CExchangeSet_Base::C_Query::C_Attlist::CanGetString(void) const
{
    return IsSetString();
}

inline
const CExchangeSet_Base::C_Query::C_Attlist::TString& CExchangeSet_Base::C_Query::C_Attlist::GetString(void) const
{
    if (!CanGetString()) {
        ThrowUnassigned(1);
    }
    return m_String;
}

inline
void CExchangeSet_Base::C_Query::C_Attlist::SetString(const CExchangeSet_Base::C_Query::C_Attlist::TString& value)
{
    m_String = value;
    m_set_State[0] |= 0xc;
}

inline
void CExchangeSet_Base::C_Query::C_Attlist::SetString(CExchangeSet_Base::C_Query::C_Attlist::TString&& value)
{
    m_String = std::forward<CExchangeSet_Base::C_Query::C_Attlist::TString>(value);
    m_set_State[0] |= 0xc;
}

inline
CExchangeSet_Base::C_Query::C_Attlist::TString& CExchangeSet_Base::C_Query::C_Attlist::SetString(void)
{
#ifdef _DEBUG
    if (!IsSetString()) {
        m_String = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_String;
}

inline
bool CExchangeSet_Base::C_Query::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CExchangeSet_Base::C_Query::CanGetAttlist(void) const
{
    return true;
}

inline
const CExchangeSet_Base::C_Query::TAttlist& CExchangeSet_Base::C_Query::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_Query*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CExchangeSet_Base::C_Query::TAttlist& CExchangeSet_Base::C_Query::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CExchangeSet_Base::C_Query::IsSetQuery(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CExchangeSet_Base::C_Query::CanGetQuery(void) const
{
    return false;
}

inline
void CExchangeSet_Base::C_Query::ResetQuery(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CExchangeSet_Base::C_Query::SetQuery(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::IsSetNumRsIds(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::CanGetNumRsIds(void) const
{
    return IsSetNumRsIds();
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::ResetNumRsIds(void)
{
    m_NumRsIds = 0;
    m_set_State[0] &= ~0x3;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumRsIds CExchangeSet_Base::C_Summary::C_Attlist::GetNumRsIds(void) const
{
    if (!CanGetNumRsIds()) {
        ThrowUnassigned(0);
    }
    return m_NumRsIds;
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::SetNumRsIds(CExchangeSet_Base::C_Summary::C_Attlist::TNumRsIds value)
{
    m_NumRsIds = value;
    m_set_State[0] |= 0x3;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumRsIds& CExchangeSet_Base::C_Summary::C_Attlist::SetNumRsIds(void)
{
#ifdef _DEBUG
    if (!IsSetNumRsIds()) {
        memset(&m_NumRsIds,UnassignedByte(),sizeof(m_NumRsIds));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_NumRsIds;
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::IsSetTotalSeqLength(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::CanGetTotalSeqLength(void) const
{
    return IsSetTotalSeqLength();
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::ResetTotalSeqLength(void)
{
    m_TotalSeqLength = 0;
    m_set_State[0] &= ~0xc;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TTotalSeqLength CExchangeSet_Base::C_Summary::C_Attlist::GetTotalSeqLength(void) const
{
    if (!CanGetTotalSeqLength()) {
        ThrowUnassigned(1);
    }
    return m_TotalSeqLength;
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::SetTotalSeqLength(CExchangeSet_Base::C_Summary::C_Attlist::TTotalSeqLength value)
{
    m_TotalSeqLength = value;
    m_set_State[0] |= 0xc;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TTotalSeqLength& CExchangeSet_Base::C_Summary::C_Attlist::SetTotalSeqLength(void)
{
#ifdef _DEBUG
    if (!IsSetTotalSeqLength()) {
        memset(&m_TotalSeqLength,UnassignedByte(),sizeof(m_TotalSeqLength));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_TotalSeqLength;
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::IsSetNumContigHits(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::CanGetNumContigHits(void) const
{
    return IsSetNumContigHits();
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::ResetNumContigHits(void)
{
    m_NumContigHits = 0;
    m_set_State[0] &= ~0x30;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumContigHits CExchangeSet_Base::C_Summary::C_Attlist::GetNumContigHits(void) const
{
    if (!CanGetNumContigHits()) {
        ThrowUnassigned(2);
    }
    return m_NumContigHits;
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::SetNumContigHits(CExchangeSet_Base::C_Summary::C_Attlist::TNumContigHits value)
{
    m_NumContigHits = value;
    m_set_State[0] |= 0x30;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumContigHits& CExchangeSet_Base::C_Summary::C_Attlist::SetNumContigHits(void)
{
#ifdef _DEBUG
    if (!IsSetNumContigHits()) {
        memset(&m_NumContigHits,UnassignedByte(),sizeof(m_NumContigHits));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_NumContigHits;
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::IsSetNumGeneHits(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::CanGetNumGeneHits(void) const
{
    return IsSetNumGeneHits();
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::ResetNumGeneHits(void)
{
    m_NumGeneHits = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumGeneHits CExchangeSet_Base::C_Summary::C_Attlist::GetNumGeneHits(void) const
{
    if (!CanGetNumGeneHits()) {
        ThrowUnassigned(3);
    }
    return m_NumGeneHits;
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::SetNumGeneHits(CExchangeSet_Base::C_Summary::C_Attlist::TNumGeneHits value)
{
    m_NumGeneHits = value;
    m_set_State[0] |= 0xc0;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumGeneHits& CExchangeSet_Base::C_Summary::C_Attlist::SetNumGeneHits(void)
{
#ifdef _DEBUG
    if (!IsSetNumGeneHits()) {
        memset(&m_NumGeneHits,UnassignedByte(),sizeof(m_NumGeneHits));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_NumGeneHits;
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::IsSetNumGiHits(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::CanGetNumGiHits(void) const
{
    return IsSetNumGiHits();
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::ResetNumGiHits(void)
{
    m_NumGiHits = 0;
    m_set_State[0] &= ~0x300;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumGiHits CExchangeSet_Base::C_Summary::C_Attlist::GetNumGiHits(void) const
{
    if (!CanGetNumGiHits()) {
        ThrowUnassigned(4);
    }
    return m_NumGiHits;
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::SetNumGiHits(CExchangeSet_Base::C_Summary::C_Attlist::TNumGiHits value)
{
    m_NumGiHits = value;
    m_set_State[0] |= 0x300;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumGiHits& CExchangeSet_Base::C_Summary::C_Attlist::SetNumGiHits(void)
{
#ifdef _DEBUG
    if (!IsSetNumGiHits()) {
        memset(&m_NumGiHits,UnassignedByte(),sizeof(m_NumGiHits));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_NumGiHits;
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::IsSetNum3dStructs(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::CanGetNum3dStructs(void) const
{
    return IsSetNum3dStructs();
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::ResetNum3dStructs(void)
{
    m_Num3dStructs = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNum3dStructs CExchangeSet_Base::C_Summary::C_Attlist::GetNum3dStructs(void) const
{
    if (!CanGetNum3dStructs()) {
        ThrowUnassigned(5);
    }
    return m_Num3dStructs;
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::SetNum3dStructs(CExchangeSet_Base::C_Summary::C_Attlist::TNum3dStructs value)
{
    m_Num3dStructs = value;
    m_set_State[0] |= 0xc00;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNum3dStructs& CExchangeSet_Base::C_Summary::C_Attlist::SetNum3dStructs(void)
{
#ifdef _DEBUG
    if (!IsSetNum3dStructs()) {
        memset(&m_Num3dStructs,UnassignedByte(),sizeof(m_Num3dStructs));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Num3dStructs;
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::IsSetNumAlleleFreqs(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::CanGetNumAlleleFreqs(void) const
{
    return IsSetNumAlleleFreqs();
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::ResetNumAlleleFreqs(void)
{
    m_NumAlleleFreqs = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumAlleleFreqs CExchangeSet_Base::C_Summary::C_Attlist::GetNumAlleleFreqs(void) const
{
    if (!CanGetNumAlleleFreqs()) {
        ThrowUnassigned(6);
    }
    return m_NumAlleleFreqs;
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::SetNumAlleleFreqs(CExchangeSet_Base::C_Summary::C_Attlist::TNumAlleleFreqs value)
{
    m_NumAlleleFreqs = value;
    m_set_State[0] |= 0x3000;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumAlleleFreqs& CExchangeSet_Base::C_Summary::C_Attlist::SetNumAlleleFreqs(void)
{
#ifdef _DEBUG
    if (!IsSetNumAlleleFreqs()) {
        memset(&m_NumAlleleFreqs,UnassignedByte(),sizeof(m_NumAlleleFreqs));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_NumAlleleFreqs;
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::IsSetNumStsHits(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::CanGetNumStsHits(void) const
{
    return IsSetNumStsHits();
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::ResetNumStsHits(void)
{
    m_NumStsHits = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumStsHits CExchangeSet_Base::C_Summary::C_Attlist::GetNumStsHits(void) const
{
    if (!CanGetNumStsHits()) {
        ThrowUnassigned(7);
    }
    return m_NumStsHits;
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::SetNumStsHits(CExchangeSet_Base::C_Summary::C_Attlist::TNumStsHits value)
{
    m_NumStsHits = value;
    m_set_State[0] |= 0xc000;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumStsHits& CExchangeSet_Base::C_Summary::C_Attlist::SetNumStsHits(void)
{
#ifdef _DEBUG
    if (!IsSetNumStsHits()) {
        memset(&m_NumStsHits,UnassignedByte(),sizeof(m_NumStsHits));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_NumStsHits;
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::IsSetNumUnigeneCids(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::C_Attlist::CanGetNumUnigeneCids(void) const
{
    return IsSetNumUnigeneCids();
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::ResetNumUnigeneCids(void)
{
    m_NumUnigeneCids = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumUnigeneCids CExchangeSet_Base::C_Summary::C_Attlist::GetNumUnigeneCids(void) const
{
    if (!CanGetNumUnigeneCids()) {
        ThrowUnassigned(8);
    }
    return m_NumUnigeneCids;
}

inline
void CExchangeSet_Base::C_Summary::C_Attlist::SetNumUnigeneCids(CExchangeSet_Base::C_Summary::C_Attlist::TNumUnigeneCids value)
{
    m_NumUnigeneCids = value;
    m_set_State[0] |= 0x30000;
}

inline
CExchangeSet_Base::C_Summary::C_Attlist::TNumUnigeneCids& CExchangeSet_Base::C_Summary::C_Attlist::SetNumUnigeneCids(void)
{
#ifdef _DEBUG
    if (!IsSetNumUnigeneCids()) {
        memset(&m_NumUnigeneCids,UnassignedByte(),sizeof(m_NumUnigeneCids));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_NumUnigeneCids;
}

inline
bool CExchangeSet_Base::C_Summary::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CExchangeSet_Base::C_Summary::CanGetAttlist(void) const
{
    return true;
}

inline
const CExchangeSet_Base::C_Summary::TAttlist& CExchangeSet_Base::C_Summary::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_Summary*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CExchangeSet_Base::C_Summary::TAttlist& CExchangeSet_Base::C_Summary::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CExchangeSet_Base::C_Summary::IsSetSummary(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CExchangeSet_Base::C_Summary::CanGetSummary(void) const
{
    return false;
}

inline
void CExchangeSet_Base::C_Summary::ResetSummary(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CExchangeSet_Base::C_Summary::SetSummary(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CExchangeSet_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CExchangeSet_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CExchangeSet_Base::TAttlist& CExchangeSet_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CExchangeSet_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CExchangeSet_Base::TAttlist& CExchangeSet_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CExchangeSet_Base::IsSetSourceDatabase(void) const
{
    return m_SourceDatabase.NotEmpty();
}

inline
bool CExchangeSet_Base::CanGetSourceDatabase(void) const
{
    return IsSetSourceDatabase();
}

inline
const CExchangeSet_Base::TSourceDatabase& CExchangeSet_Base::GetSourceDatabase(void) const
{
    if (!CanGetSourceDatabase()) {
        ThrowUnassigned(1);
    }
    return (*m_SourceDatabase);
}

inline
bool CExchangeSet_Base::IsSetRs(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CExchangeSet_Base::CanGetRs(void) const
{
    return true;
}

inline
const CExchangeSet_Base::TRs& CExchangeSet_Base::GetRs(void) const
{
    return m_Rs;
}

inline
CExchangeSet_Base::TRs& CExchangeSet_Base::SetRs(void)
{
    m_set_State[0] |= 0x10;
    return m_Rs;
}

inline
bool CExchangeSet_Base::IsSetAssay(void) const
{
    return m_Assay.NotEmpty();
}

inline
bool CExchangeSet_Base::CanGetAssay(void) const
{
    return IsSetAssay();
}

inline
const CExchangeSet_Base::TAssay& CExchangeSet_Base::GetAssay(void) const
{
    if (!CanGetAssay()) {
        ThrowUnassigned(3);
    }
    return (*m_Assay);
}

inline
bool CExchangeSet_Base::IsSetQuery(void) const
{
    return m_Query.NotEmpty();
}

inline
bool CExchangeSet_Base::CanGetQuery(void) const
{
    return IsSetQuery();
}

inline
const CExchangeSet_Base::TQuery& CExchangeSet_Base::GetQuery(void) const
{
    if (!CanGetQuery()) {
        ThrowUnassigned(4);
    }
    return (*m_Query);
}

inline
bool CExchangeSet_Base::IsSetSummary(void) const
{
    return m_Summary.NotEmpty();
}

inline
bool CExchangeSet_Base::CanGetSummary(void) const
{
    return IsSetSummary();
}

inline
const CExchangeSet_Base::TSummary& CExchangeSet_Base::GetSummary(void) const
{
    if (!CanGetSummary()) {
        ThrowUnassigned(5);
    }
    return (*m_Summary);
}

inline
bool CExchangeSet_Base::IsSetBaseURL(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CExchangeSet_Base::CanGetBaseURL(void) const
{
    return true;
}

inline
const CExchangeSet_Base::TBaseURL& CExchangeSet_Base::GetBaseURL(void) const
{
    return m_BaseURL;
}

inline
CExchangeSet_Base::TBaseURL& CExchangeSet_Base::SetBaseURL(void)
{
    m_set_State[0] |= 0x1000;
    return m_BaseURL;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_EXCHANGESET_BASE_HPP
