/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_view_settings_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_VIEW_SETTINGS_BASE_HPP
#define OBJECTS_CN3D_CN3D_VIEW_SETTINGS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCn3d_GL_matrix;
class CCn3d_vector;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// parameters used to set up the camera in Cn3D
class NCBI_CN3D_EXPORT CCn3d_view_settings_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_view_settings_Base(void);
    // destructor
    virtual ~CCn3d_view_settings_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef double TCamera_distance;
    typedef double TCamera_angle_rad;
    typedef double TCamera_look_at_X;
    typedef double TCamera_look_at_Y;
    typedef double TCamera_clip_near;
    typedef double TCamera_clip_far;
    typedef CCn3d_GL_matrix TMatrix;
    typedef CCn3d_vector TRotation_center;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_camera_distance,
        e_camera_angle_rad,
        e_camera_look_at_X,
        e_camera_look_at_Y,
        e_camera_clip_near,
        e_camera_clip_far,
        e_matrix,
        e_rotation_center
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// camera on +Z axis this distance from origin
    /// mandatory
    /// typedef double TCamera_distance
    ///  Check whether the Camera_distance data member has been assigned a value.
    bool IsSetCamera_distance(void) const;
    /// Check whether it is safe or not to call GetCamera_distance method.
    bool CanGetCamera_distance(void) const;
    void ResetCamera_distance(void);
    TCamera_distance GetCamera_distance(void) const;
    void SetCamera_distance(TCamera_distance value);
    TCamera_distance& SetCamera_distance(void);

    /// camera angle
    /// mandatory
    /// typedef double TCamera_angle_rad
    ///  Check whether the Camera_angle_rad data member has been assigned a value.
    bool IsSetCamera_angle_rad(void) const;
    /// Check whether it is safe or not to call GetCamera_angle_rad method.
    bool CanGetCamera_angle_rad(void) const;
    void ResetCamera_angle_rad(void);
    TCamera_angle_rad GetCamera_angle_rad(void) const;
    void SetCamera_angle_rad(TCamera_angle_rad value);
    TCamera_angle_rad& SetCamera_angle_rad(void);

    /// X,Y of point in Z=0 plane camera points at
    /// mandatory
    /// typedef double TCamera_look_at_X
    ///  Check whether the Camera_look_at_X data member has been assigned a value.
    bool IsSetCamera_look_at_X(void) const;
    /// Check whether it is safe or not to call GetCamera_look_at_X method.
    bool CanGetCamera_look_at_X(void) const;
    void ResetCamera_look_at_X(void);
    TCamera_look_at_X GetCamera_look_at_X(void) const;
    void SetCamera_look_at_X(TCamera_look_at_X value);
    TCamera_look_at_X& SetCamera_look_at_X(void);

    /// mandatory
    /// typedef double TCamera_look_at_Y
    ///  Check whether the Camera_look_at_Y data member has been assigned a value.
    bool IsSetCamera_look_at_Y(void) const;
    /// Check whether it is safe or not to call GetCamera_look_at_Y method.
    bool CanGetCamera_look_at_Y(void) const;
    void ResetCamera_look_at_Y(void);
    TCamera_look_at_Y GetCamera_look_at_Y(void) const;
    void SetCamera_look_at_Y(TCamera_look_at_Y value);
    TCamera_look_at_Y& SetCamera_look_at_Y(void);

    /// distance of clipping planes from camera
    /// mandatory
    /// typedef double TCamera_clip_near
    ///  Check whether the Camera_clip_near data member has been assigned a value.
    bool IsSetCamera_clip_near(void) const;
    /// Check whether it is safe or not to call GetCamera_clip_near method.
    bool CanGetCamera_clip_near(void) const;
    void ResetCamera_clip_near(void);
    TCamera_clip_near GetCamera_clip_near(void) const;
    void SetCamera_clip_near(TCamera_clip_near value);
    TCamera_clip_near& SetCamera_clip_near(void);

    /// mandatory
    /// typedef double TCamera_clip_far
    ///  Check whether the Camera_clip_far data member has been assigned a value.
    bool IsSetCamera_clip_far(void) const;
    /// Check whether it is safe or not to call GetCamera_clip_far method.
    bool CanGetCamera_clip_far(void) const;
    void ResetCamera_clip_far(void);
    TCamera_clip_far GetCamera_clip_far(void) const;
    void SetCamera_clip_far(TCamera_clip_far value);
    TCamera_clip_far& SetCamera_clip_far(void);

    /// transformation of objects in the scene
    /// mandatory
    /// typedef CCn3d_GL_matrix TMatrix
    ///  Check whether the Matrix data member has been assigned a value.
    bool IsSetMatrix(void) const;
    /// Check whether it is safe or not to call GetMatrix method.
    bool CanGetMatrix(void) const;
    void ResetMatrix(void);
    const TMatrix& GetMatrix(void) const;
    void SetMatrix(TMatrix& value);
    TMatrix& SetMatrix(void);

    /// center of rotation of whole scene
    /// mandatory
    /// typedef CCn3d_vector TRotation_center
    ///  Check whether the Rotation_center data member has been assigned a value.
    bool IsSetRotation_center(void) const;
    /// Check whether it is safe or not to call GetRotation_center method.
    bool CanGetRotation_center(void) const;
    void ResetRotation_center(void);
    const TRotation_center& GetRotation_center(void) const;
    void SetRotation_center(TRotation_center& value);
    TRotation_center& SetRotation_center(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_view_settings_Base(const CCn3d_view_settings_Base&);
    CCn3d_view_settings_Base& operator=(const CCn3d_view_settings_Base&);

    // data
    Uint4 m_set_State[1];
    double m_Camera_distance;
    double m_Camera_angle_rad;
    double m_Camera_look_at_X;
    double m_Camera_look_at_Y;
    double m_Camera_clip_near;
    double m_Camera_clip_far;
    CRef< TMatrix > m_Matrix;
    CRef< TRotation_center > m_Rotation_center;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_view_settings_Base::IsSetCamera_distance(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_view_settings_Base::CanGetCamera_distance(void) const
{
    return IsSetCamera_distance();
}

inline
void CCn3d_view_settings_Base::ResetCamera_distance(void)
{
    m_Camera_distance = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCn3d_view_settings_Base::TCamera_distance CCn3d_view_settings_Base::GetCamera_distance(void) const
{
    if (!CanGetCamera_distance()) {
        ThrowUnassigned(0);
    }
    return m_Camera_distance;
}

inline
void CCn3d_view_settings_Base::SetCamera_distance(CCn3d_view_settings_Base::TCamera_distance value)
{
    m_Camera_distance = value;
    m_set_State[0] |= 0x3;
}

inline
CCn3d_view_settings_Base::TCamera_distance& CCn3d_view_settings_Base::SetCamera_distance(void)
{
#ifdef _DEBUG
    if (!IsSetCamera_distance()) {
        memset(&m_Camera_distance,UnassignedByte(),sizeof(m_Camera_distance));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Camera_distance;
}

inline
bool CCn3d_view_settings_Base::IsSetCamera_angle_rad(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCn3d_view_settings_Base::CanGetCamera_angle_rad(void) const
{
    return IsSetCamera_angle_rad();
}

inline
void CCn3d_view_settings_Base::ResetCamera_angle_rad(void)
{
    m_Camera_angle_rad = 0;
    m_set_State[0] &= ~0xc;
}

inline
CCn3d_view_settings_Base::TCamera_angle_rad CCn3d_view_settings_Base::GetCamera_angle_rad(void) const
{
    if (!CanGetCamera_angle_rad()) {
        ThrowUnassigned(1);
    }
    return m_Camera_angle_rad;
}

inline
void CCn3d_view_settings_Base::SetCamera_angle_rad(CCn3d_view_settings_Base::TCamera_angle_rad value)
{
    m_Camera_angle_rad = value;
    m_set_State[0] |= 0xc;
}

inline
CCn3d_view_settings_Base::TCamera_angle_rad& CCn3d_view_settings_Base::SetCamera_angle_rad(void)
{
#ifdef _DEBUG
    if (!IsSetCamera_angle_rad()) {
        memset(&m_Camera_angle_rad,UnassignedByte(),sizeof(m_Camera_angle_rad));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Camera_angle_rad;
}

inline
bool CCn3d_view_settings_Base::IsSetCamera_look_at_X(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCn3d_view_settings_Base::CanGetCamera_look_at_X(void) const
{
    return IsSetCamera_look_at_X();
}

inline
void CCn3d_view_settings_Base::ResetCamera_look_at_X(void)
{
    m_Camera_look_at_X = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCn3d_view_settings_Base::TCamera_look_at_X CCn3d_view_settings_Base::GetCamera_look_at_X(void) const
{
    if (!CanGetCamera_look_at_X()) {
        ThrowUnassigned(2);
    }
    return m_Camera_look_at_X;
}

inline
void CCn3d_view_settings_Base::SetCamera_look_at_X(CCn3d_view_settings_Base::TCamera_look_at_X value)
{
    m_Camera_look_at_X = value;
    m_set_State[0] |= 0x30;
}

inline
CCn3d_view_settings_Base::TCamera_look_at_X& CCn3d_view_settings_Base::SetCamera_look_at_X(void)
{
#ifdef _DEBUG
    if (!IsSetCamera_look_at_X()) {
        memset(&m_Camera_look_at_X,UnassignedByte(),sizeof(m_Camera_look_at_X));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Camera_look_at_X;
}

inline
bool CCn3d_view_settings_Base::IsSetCamera_look_at_Y(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCn3d_view_settings_Base::CanGetCamera_look_at_Y(void) const
{
    return IsSetCamera_look_at_Y();
}

inline
void CCn3d_view_settings_Base::ResetCamera_look_at_Y(void)
{
    m_Camera_look_at_Y = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CCn3d_view_settings_Base::TCamera_look_at_Y CCn3d_view_settings_Base::GetCamera_look_at_Y(void) const
{
    if (!CanGetCamera_look_at_Y()) {
        ThrowUnassigned(3);
    }
    return m_Camera_look_at_Y;
}

inline
void CCn3d_view_settings_Base::SetCamera_look_at_Y(CCn3d_view_settings_Base::TCamera_look_at_Y value)
{
    m_Camera_look_at_Y = value;
    m_set_State[0] |= 0xc0;
}

inline
CCn3d_view_settings_Base::TCamera_look_at_Y& CCn3d_view_settings_Base::SetCamera_look_at_Y(void)
{
#ifdef _DEBUG
    if (!IsSetCamera_look_at_Y()) {
        memset(&m_Camera_look_at_Y,UnassignedByte(),sizeof(m_Camera_look_at_Y));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Camera_look_at_Y;
}

inline
bool CCn3d_view_settings_Base::IsSetCamera_clip_near(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCn3d_view_settings_Base::CanGetCamera_clip_near(void) const
{
    return IsSetCamera_clip_near();
}

inline
void CCn3d_view_settings_Base::ResetCamera_clip_near(void)
{
    m_Camera_clip_near = 0;
    m_set_State[0] &= ~0x300;
}

inline
CCn3d_view_settings_Base::TCamera_clip_near CCn3d_view_settings_Base::GetCamera_clip_near(void) const
{
    if (!CanGetCamera_clip_near()) {
        ThrowUnassigned(4);
    }
    return m_Camera_clip_near;
}

inline
void CCn3d_view_settings_Base::SetCamera_clip_near(CCn3d_view_settings_Base::TCamera_clip_near value)
{
    m_Camera_clip_near = value;
    m_set_State[0] |= 0x300;
}

inline
CCn3d_view_settings_Base::TCamera_clip_near& CCn3d_view_settings_Base::SetCamera_clip_near(void)
{
#ifdef _DEBUG
    if (!IsSetCamera_clip_near()) {
        memset(&m_Camera_clip_near,UnassignedByte(),sizeof(m_Camera_clip_near));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Camera_clip_near;
}

inline
bool CCn3d_view_settings_Base::IsSetCamera_clip_far(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CCn3d_view_settings_Base::CanGetCamera_clip_far(void) const
{
    return IsSetCamera_clip_far();
}

inline
void CCn3d_view_settings_Base::ResetCamera_clip_far(void)
{
    m_Camera_clip_far = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CCn3d_view_settings_Base::TCamera_clip_far CCn3d_view_settings_Base::GetCamera_clip_far(void) const
{
    if (!CanGetCamera_clip_far()) {
        ThrowUnassigned(5);
    }
    return m_Camera_clip_far;
}

inline
void CCn3d_view_settings_Base::SetCamera_clip_far(CCn3d_view_settings_Base::TCamera_clip_far value)
{
    m_Camera_clip_far = value;
    m_set_State[0] |= 0xc00;
}

inline
CCn3d_view_settings_Base::TCamera_clip_far& CCn3d_view_settings_Base::SetCamera_clip_far(void)
{
#ifdef _DEBUG
    if (!IsSetCamera_clip_far()) {
        memset(&m_Camera_clip_far,UnassignedByte(),sizeof(m_Camera_clip_far));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Camera_clip_far;
}

inline
bool CCn3d_view_settings_Base::IsSetMatrix(void) const
{
    return m_Matrix.NotEmpty();
}

inline
bool CCn3d_view_settings_Base::CanGetMatrix(void) const
{
    return true;
}

inline
const CCn3d_view_settings_Base::TMatrix& CCn3d_view_settings_Base::GetMatrix(void) const
{
    if ( !m_Matrix ) {
        const_cast<CCn3d_view_settings_Base*>(this)->ResetMatrix();
    }
    return (*m_Matrix);
}

inline
CCn3d_view_settings_Base::TMatrix& CCn3d_view_settings_Base::SetMatrix(void)
{
    if ( !m_Matrix ) {
        ResetMatrix();
    }
    return (*m_Matrix);
}

inline
bool CCn3d_view_settings_Base::IsSetRotation_center(void) const
{
    return m_Rotation_center.NotEmpty();
}

inline
bool CCn3d_view_settings_Base::CanGetRotation_center(void) const
{
    return true;
}

inline
const CCn3d_view_settings_Base::TRotation_center& CCn3d_view_settings_Base::GetRotation_center(void) const
{
    if ( !m_Rotation_center ) {
        const_cast<CCn3d_view_settings_Base*>(this)->ResetRotation_center();
    }
    return (*m_Rotation_center);
}

inline
CCn3d_view_settings_Base::TRotation_center& CCn3d_view_settings_Base::SetRotation_center(void)
{
    if ( !m_Rotation_center ) {
        ResetRotation_center();
    }
    return (*m_Rotation_center);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_VIEW_SETTINGS_BASE_HPP
