/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Triangle_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_TRIANGLE_BASE_HPP
#define OBJECTS_CDD_TRIANGLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CScore_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// definition for matrix of pairwise "distances", stored as the upper 
/// triangle of a squared n x n matrix (excluding the diagonal), this is
/// supposed to store pairwise percentages of identical residues, pairwise
/// alignment scores or E-values from pairwise BLAST sequence comparisons
class NCBI_CDD_EXPORT CTriangle_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTriangle_Base(void);
    // destructor
    virtual ~CTriangle_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNelements;
    typedef CScore_set TScores;
    typedef list< int > TDiv_ranks;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_nelements,
        e_scores,
        e_div_ranks
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TNelements
    ///  Check whether the Nelements data member has been assigned a value.
    bool IsSetNelements(void) const;
    /// Check whether it is safe or not to call GetNelements method.
    bool CanGetNelements(void) const;
    void ResetNelements(void);
    TNelements GetNelements(void) const;
    void SetNelements(TNelements value);
    TNelements& SetNelements(void);

    /// optional
    /// typedef CScore_set TScores
    ///  Check whether the Scores data member has been assigned a value.
    bool IsSetScores(void) const;
    /// Check whether it is safe or not to call GetScores method.
    bool CanGetScores(void) const;
    void ResetScores(void);
    const TScores& GetScores(void) const;
    void SetScores(TScores& value);
    TScores& SetScores(void);

    /// optional
    /// typedef list< int > TDiv_ranks
    ///  Check whether the Div_ranks data member has been assigned a value.
    bool IsSetDiv_ranks(void) const;
    /// Check whether it is safe or not to call GetDiv_ranks method.
    bool CanGetDiv_ranks(void) const;
    void ResetDiv_ranks(void);
    const TDiv_ranks& GetDiv_ranks(void) const;
    TDiv_ranks& SetDiv_ranks(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTriangle_Base(const CTriangle_Base&);
    CTriangle_Base& operator=(const CTriangle_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Nelements;
    CRef< TScores > m_Scores;
    list< int > m_Div_ranks;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTriangle_Base::IsSetNelements(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTriangle_Base::CanGetNelements(void) const
{
    return IsSetNelements();
}

inline
void CTriangle_Base::ResetNelements(void)
{
    m_Nelements = 0;
    m_set_State[0] &= ~0x3;
}

inline
CTriangle_Base::TNelements CTriangle_Base::GetNelements(void) const
{
    if (!CanGetNelements()) {
        ThrowUnassigned(0);
    }
    return m_Nelements;
}

inline
void CTriangle_Base::SetNelements(CTriangle_Base::TNelements value)
{
    m_Nelements = value;
    m_set_State[0] |= 0x3;
}

inline
CTriangle_Base::TNelements& CTriangle_Base::SetNelements(void)
{
#ifdef _DEBUG
    if (!IsSetNelements()) {
        memset(&m_Nelements,UnassignedByte(),sizeof(m_Nelements));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Nelements;
}

inline
bool CTriangle_Base::IsSetScores(void) const
{
    return m_Scores.NotEmpty();
}

inline
bool CTriangle_Base::CanGetScores(void) const
{
    return IsSetScores();
}

inline
const CTriangle_Base::TScores& CTriangle_Base::GetScores(void) const
{
    if (!CanGetScores()) {
        ThrowUnassigned(1);
    }
    return (*m_Scores);
}

inline
bool CTriangle_Base::IsSetDiv_ranks(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTriangle_Base::CanGetDiv_ranks(void) const
{
    return true;
}

inline
const CTriangle_Base::TDiv_ranks& CTriangle_Base::GetDiv_ranks(void) const
{
    return m_Div_ranks;
}

inline
CTriangle_Base::TDiv_ranks& CTriangle_Base::SetDiv_ranks(void)
{
    m_set_State[0] |= 0x10;
    return m_Div_ranks;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_TRIANGLE_BASE_HPP
