/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file blastclient_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLASTCLIENT_BASE_HPP
#define OBJECTS_BLAST_BLASTCLIENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/blast/Blast4_reply.hpp>
#include <objects/blast/Blast4_reply_body.hpp>
#include <objects/blast/Blast4_request.hpp>
#include <objects/blast/Blast4_request_body.hpp>
#include <serial/rpcbase.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4Client_Base : public CRPCClient<CBlast4_request, CBlast4_reply>
{
    typedef CRPCClient<CBlast4_request, CBlast4_reply> Tparent;
public:
    // constructor
    CBlast4Client_Base(void);
    // destructor
    virtual ~CBlast4Client_Base(void);

    typedef CBlast4_request TRequest;
    typedef CBlast4_reply TReply;
    typedef CBlast4_request_body TRequestChoice;
    typedef CBlast4_reply_body TReplyChoice;

    virtual void Ask(const TRequest& request, TReply& reply);
    virtual void Ask(const TRequest& request, TReply& reply,
                     TReplyChoice::E_Choice wanted);


    virtual const TRequest& GetDefaultRequest(void) const;
    virtual TRequest&       SetDefaultRequest(void);
    virtual void            SetDefaultRequest(const TRequest& request);

    virtual void Ask(const TRequestChoice& req, TReply& reply);
    virtual void Ask(const TRequestChoice& req, TReply& reply,
                     TReplyChoice::E_Choice wanted);

    virtual CRef<CBlast4_finish_params_reply> AskFinish_params
        (const CBlast4_finish_params_request& req, TReply* reply = 0);

    virtual CRef<CBlast4_get_databases_reply> AskGet_databases
        (TReply* reply = 0);

    virtual CRef<CBlast4_get_matrices_reply> AskGet_matrices
        (TReply* reply = 0);

    virtual CRef<CBlast4_get_parameters_reply> AskGet_parameters
        (TReply* reply = 0);

    virtual CRef<CBlast4_get_paramsets_reply> AskGet_paramsets
        (TReply* reply = 0);

    virtual CRef<CBlast4_get_programs_reply> AskGet_programs
        (TReply* reply = 0);

    virtual CRef<CBlast4_get_search_results_reply> AskGet_search_results
        (const CBlast4_get_search_results_request& req, TReply* reply = 0);

    virtual CRef<CBlast4_get_sequences_reply> AskGet_sequences
        (const CBlast4_get_sequences_request& req, TReply* reply = 0);

    virtual CRef<CBlast4_queue_search_reply> AskQueue_search
        (const CBlast4_queue_search_request& req, TReply* reply = 0);

    virtual CRef<CBlast4_get_request_info_reply> AskGet_request_info
        (const CBlast4_get_request_info_request& req, TReply* reply = 0);

    virtual CRef<CBlast4_get_seq_parts_reply> AskGet_sequence_parts
        (const CBlast4_get_seq_parts_request& req, TReply* reply = 0);

    virtual CRef<CBlast4_get_windowmasked_taxids_reply> AskGet_windowmasked_taxids
        (TReply* reply = 0);

    virtual CRef<CBlast4_get_protocol_info_reply> AskGet_protocol_info
        (const CBlast4_get_protocol_info_request& req, TReply* reply = 0);

    virtual CRef<CBlast4_get_search_info_reply> AskGet_search_info
        (const CBlast4_get_search_info_request& req, TReply* reply = 0);

    virtual CRef<CBlast4_get_databases_ex_reply> AskGet_databases_ex
        (const CBlast4_get_databases_ex_request& req, TReply* reply = 0);


private:
    CRef<TRequest> m_DefaultRequest;

    TReplyChoice& x_Choice(TReply& reply);
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CBlast4Client_Base::TReplyChoice& CBlast4Client_Base::x_Choice(CBlast4Client_Base::TReply& reply)
{
    return reply.SetBody();
}

inline
void CBlast4Client_Base::Ask(const CBlast4Client_Base::TRequest& request, CBlast4Client_Base::TReply& reply)
{
    Tparent::Ask(request, reply);
}


inline
const CBlast4Client_Base::TRequest& CBlast4Client_Base::GetDefaultRequest(void) const
{
    return *m_DefaultRequest;
}

inline
CBlast4Client_Base::TRequest& CBlast4Client_Base::SetDefaultRequest(void)
{
    return *m_DefaultRequest;
}

inline
void CBlast4Client_Base::SetDefaultRequest(const CBlast4Client_Base::TRequest& request)
{
    m_DefaultRequest->Assign(request);
}


///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLASTCLIENT_BASE_HPP
