/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_queue_search_reques_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_QUEUE_SEARCH_REQUES_BASE_HPP
#define OBJECTS_BLAST_BLAST4_QUEUE_SEARCH_REQUES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_parameters;
class CBlast4_queries;
class CBlast4_subject;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Options have been broken down into three groups as part of the BLAST
/// API work.  The algorithm options essentially correspond to those
/// options available via the CBlastOptions class.
/// For definitions of the names used in the Blast4-parameter structures, see
/// c++/{include,src}/objects/blast/names.[hc]pp in the NCBI C++ toolkit.
///   algorithm-options: Options for BLAST (ie. seq comparison) algorithm.
///   program-options:   Options for controlling program execution and/or 
///                      database filtering
///   format-options:    Options for formatting BLAST results, clients should
///                      use this only if applicable, otherwise they should be
///                      ignored
class NCBI_BLAST_EXPORT CBlast4_queue_search_request_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_queue_search_request_Base(void);
    // destructor
    virtual ~CBlast4_queue_search_request_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TProgram;
    typedef string TService;
    typedef CBlast4_queries TQueries;
    typedef CBlast4_subject TSubject;
    typedef string TParamset;
    typedef CBlast4_parameters TAlgorithm_options;
    typedef CBlast4_parameters TProgram_options;
    typedef CBlast4_parameters TFormat_options;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_program,
        e_service,
        e_queries,
        e_subject,
        e_paramset,
        e_algorithm_options,
        e_program_options,
        e_format_options
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TProgram
    ///  Check whether the Program data member has been assigned a value.
    bool IsSetProgram(void) const;
    /// Check whether it is safe or not to call GetProgram method.
    bool CanGetProgram(void) const;
    void ResetProgram(void);
    const TProgram& GetProgram(void) const;
    void SetProgram(const TProgram& value);
    void SetProgram(TProgram&& value);
    TProgram& SetProgram(void);

    /// mandatory
    /// typedef string TService
    ///  Check whether the Service data member has been assigned a value.
    bool IsSetService(void) const;
    /// Check whether it is safe or not to call GetService method.
    bool CanGetService(void) const;
    void ResetService(void);
    const TService& GetService(void) const;
    void SetService(const TService& value);
    void SetService(TService&& value);
    TService& SetService(void);

    /// mandatory
    /// typedef CBlast4_queries TQueries
    ///  Check whether the Queries data member has been assigned a value.
    bool IsSetQueries(void) const;
    /// Check whether it is safe or not to call GetQueries method.
    bool CanGetQueries(void) const;
    void ResetQueries(void);
    const TQueries& GetQueries(void) const;
    void SetQueries(TQueries& value);
    TQueries& SetQueries(void);

    /// mandatory
    /// typedef CBlast4_subject TSubject
    ///  Check whether the Subject data member has been assigned a value.
    bool IsSetSubject(void) const;
    /// Check whether it is safe or not to call GetSubject method.
    bool CanGetSubject(void) const;
    void ResetSubject(void);
    const TSubject& GetSubject(void) const;
    void SetSubject(TSubject& value);
    TSubject& SetSubject(void);

    /// This field contains a task description
    /// optional
    /// typedef string TParamset
    ///  Check whether the Paramset data member has been assigned a value.
    bool IsSetParamset(void) const;
    /// Check whether it is safe or not to call GetParamset method.
    bool CanGetParamset(void) const;
    void ResetParamset(void);
    const TParamset& GetParamset(void) const;
    void SetParamset(const TParamset& value);
    void SetParamset(TParamset&& value);
    TParamset& SetParamset(void);

    /// optional
    /// typedef CBlast4_parameters TAlgorithm_options
    ///  Check whether the Algorithm_options data member has been assigned a value.
    bool IsSetAlgorithm_options(void) const;
    /// Check whether it is safe or not to call GetAlgorithm_options method.
    bool CanGetAlgorithm_options(void) const;
    void ResetAlgorithm_options(void);
    const TAlgorithm_options& GetAlgorithm_options(void) const;
    void SetAlgorithm_options(TAlgorithm_options& value);
    TAlgorithm_options& SetAlgorithm_options(void);

    /// optional
    /// typedef CBlast4_parameters TProgram_options
    ///  Check whether the Program_options data member has been assigned a value.
    bool IsSetProgram_options(void) const;
    /// Check whether it is safe or not to call GetProgram_options method.
    bool CanGetProgram_options(void) const;
    void ResetProgram_options(void);
    const TProgram_options& GetProgram_options(void) const;
    void SetProgram_options(TProgram_options& value);
    TProgram_options& SetProgram_options(void);

    /// optional
    /// typedef CBlast4_parameters TFormat_options
    ///  Check whether the Format_options data member has been assigned a value.
    bool IsSetFormat_options(void) const;
    /// Check whether it is safe or not to call GetFormat_options method.
    bool CanGetFormat_options(void) const;
    void ResetFormat_options(void);
    const TFormat_options& GetFormat_options(void) const;
    void SetFormat_options(TFormat_options& value);
    TFormat_options& SetFormat_options(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_queue_search_request_Base(const CBlast4_queue_search_request_Base&);
    CBlast4_queue_search_request_Base& operator=(const CBlast4_queue_search_request_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Program;
    string m_Service;
    CRef< TQueries > m_Queries;
    CRef< TSubject > m_Subject;
    string m_Paramset;
    CRef< TAlgorithm_options > m_Algorithm_options;
    CRef< TProgram_options > m_Program_options;
    CRef< TFormat_options > m_Format_options;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_queue_search_request_Base::IsSetProgram(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_queue_search_request_Base::CanGetProgram(void) const
{
    return IsSetProgram();
}

inline
const CBlast4_queue_search_request_Base::TProgram& CBlast4_queue_search_request_Base::GetProgram(void) const
{
    if (!CanGetProgram()) {
        ThrowUnassigned(0);
    }
    return m_Program;
}

inline
void CBlast4_queue_search_request_Base::SetProgram(const CBlast4_queue_search_request_Base::TProgram& value)
{
    m_Program = value;
    m_set_State[0] |= 0x3;
}

inline
void CBlast4_queue_search_request_Base::SetProgram(CBlast4_queue_search_request_Base::TProgram&& value)
{
    m_Program = std::forward<CBlast4_queue_search_request_Base::TProgram>(value);
    m_set_State[0] |= 0x3;
}

inline
CBlast4_queue_search_request_Base::TProgram& CBlast4_queue_search_request_Base::SetProgram(void)
{
#ifdef _DEBUG
    if (!IsSetProgram()) {
        m_Program = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Program;
}

inline
bool CBlast4_queue_search_request_Base::IsSetService(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_queue_search_request_Base::CanGetService(void) const
{
    return IsSetService();
}

inline
const CBlast4_queue_search_request_Base::TService& CBlast4_queue_search_request_Base::GetService(void) const
{
    if (!CanGetService()) {
        ThrowUnassigned(1);
    }
    return m_Service;
}

inline
void CBlast4_queue_search_request_Base::SetService(const CBlast4_queue_search_request_Base::TService& value)
{
    m_Service = value;
    m_set_State[0] |= 0xc;
}

inline
void CBlast4_queue_search_request_Base::SetService(CBlast4_queue_search_request_Base::TService&& value)
{
    m_Service = std::forward<CBlast4_queue_search_request_Base::TService>(value);
    m_set_State[0] |= 0xc;
}

inline
CBlast4_queue_search_request_Base::TService& CBlast4_queue_search_request_Base::SetService(void)
{
#ifdef _DEBUG
    if (!IsSetService()) {
        m_Service = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Service;
}

inline
bool CBlast4_queue_search_request_Base::IsSetQueries(void) const
{
    return m_Queries.NotEmpty();
}

inline
bool CBlast4_queue_search_request_Base::CanGetQueries(void) const
{
    return true;
}

inline
const CBlast4_queue_search_request_Base::TQueries& CBlast4_queue_search_request_Base::GetQueries(void) const
{
    if ( !m_Queries ) {
        const_cast<CBlast4_queue_search_request_Base*>(this)->ResetQueries();
    }
    return (*m_Queries);
}

inline
CBlast4_queue_search_request_Base::TQueries& CBlast4_queue_search_request_Base::SetQueries(void)
{
    if ( !m_Queries ) {
        ResetQueries();
    }
    return (*m_Queries);
}

inline
bool CBlast4_queue_search_request_Base::IsSetSubject(void) const
{
    return m_Subject.NotEmpty();
}

inline
bool CBlast4_queue_search_request_Base::CanGetSubject(void) const
{
    return true;
}

inline
const CBlast4_queue_search_request_Base::TSubject& CBlast4_queue_search_request_Base::GetSubject(void) const
{
    if ( !m_Subject ) {
        const_cast<CBlast4_queue_search_request_Base*>(this)->ResetSubject();
    }
    return (*m_Subject);
}

inline
CBlast4_queue_search_request_Base::TSubject& CBlast4_queue_search_request_Base::SetSubject(void)
{
    if ( !m_Subject ) {
        ResetSubject();
    }
    return (*m_Subject);
}

inline
bool CBlast4_queue_search_request_Base::IsSetParamset(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBlast4_queue_search_request_Base::CanGetParamset(void) const
{
    return IsSetParamset();
}

inline
const CBlast4_queue_search_request_Base::TParamset& CBlast4_queue_search_request_Base::GetParamset(void) const
{
    if (!CanGetParamset()) {
        ThrowUnassigned(4);
    }
    return m_Paramset;
}

inline
void CBlast4_queue_search_request_Base::SetParamset(const CBlast4_queue_search_request_Base::TParamset& value)
{
    m_Paramset = value;
    m_set_State[0] |= 0x300;
}

inline
void CBlast4_queue_search_request_Base::SetParamset(CBlast4_queue_search_request_Base::TParamset&& value)
{
    m_Paramset = std::forward<CBlast4_queue_search_request_Base::TParamset>(value);
    m_set_State[0] |= 0x300;
}

inline
CBlast4_queue_search_request_Base::TParamset& CBlast4_queue_search_request_Base::SetParamset(void)
{
#ifdef _DEBUG
    if (!IsSetParamset()) {
        m_Paramset = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Paramset;
}

inline
bool CBlast4_queue_search_request_Base::IsSetAlgorithm_options(void) const
{
    return m_Algorithm_options.NotEmpty();
}

inline
bool CBlast4_queue_search_request_Base::CanGetAlgorithm_options(void) const
{
    return IsSetAlgorithm_options();
}

inline
const CBlast4_queue_search_request_Base::TAlgorithm_options& CBlast4_queue_search_request_Base::GetAlgorithm_options(void) const
{
    if (!CanGetAlgorithm_options()) {
        ThrowUnassigned(5);
    }
    return (*m_Algorithm_options);
}

inline
bool CBlast4_queue_search_request_Base::IsSetProgram_options(void) const
{
    return m_Program_options.NotEmpty();
}

inline
bool CBlast4_queue_search_request_Base::CanGetProgram_options(void) const
{
    return IsSetProgram_options();
}

inline
const CBlast4_queue_search_request_Base::TProgram_options& CBlast4_queue_search_request_Base::GetProgram_options(void) const
{
    if (!CanGetProgram_options()) {
        ThrowUnassigned(6);
    }
    return (*m_Program_options);
}

inline
bool CBlast4_queue_search_request_Base::IsSetFormat_options(void) const
{
    return m_Format_options.NotEmpty();
}

inline
bool CBlast4_queue_search_request_Base::CanGetFormat_options(void) const
{
    return IsSetFormat_options();
}

inline
const CBlast4_queue_search_request_Base::TFormat_options& CBlast4_queue_search_request_Base::GetFormat_options(void) const
{
    if (!CanGetFormat_options()) {
        ThrowUnassigned(7);
    }
    return (*m_Format_options);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_QUEUE_SEARCH_REQUES_BASE_HPP
