/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_alignment_for_query_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_ALIGNMENT_FOR_QUERY_BASE_HPP
#define OBJECTS_BLAST_BLAST4_ALIGNMENT_FOR_QUERY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_simple_alignment;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Alignments for one query, compiled from the raw SeqAlign results
class NCBI_BLAST_EXPORT CBlast4_alignments_for_query_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_alignments_for_query_Base(void);
    // destructor
    virtual ~CBlast4_alignments_for_query_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TQuery_id;
    typedef list< CRef< CBlast4_simple_alignment > > TAlignments;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_query_id,
        e_alignments
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Query sequence identifier
    /// (present if query is not a local id in the SeqAlign)
    /// mandatory
    /// typedef string TQuery_id
    ///  Check whether the Query_id data member has been assigned a value.
    bool IsSetQuery_id(void) const;
    /// Check whether it is safe or not to call GetQuery_id method.
    bool CanGetQuery_id(void) const;
    void ResetQuery_id(void);
    const TQuery_id& GetQuery_id(void) const;
    void SetQuery_id(const TQuery_id& value);
    void SetQuery_id(TQuery_id&& value);
    TQuery_id& SetQuery_id(void);

    /// All the alignments for this query
    /// mandatory
    /// typedef list< CRef< CBlast4_simple_alignment > > TAlignments
    ///  Check whether the Alignments data member has been assigned a value.
    bool IsSetAlignments(void) const;
    /// Check whether it is safe or not to call GetAlignments method.
    bool CanGetAlignments(void) const;
    void ResetAlignments(void);
    const TAlignments& GetAlignments(void) const;
    TAlignments& SetAlignments(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_alignments_for_query_Base(const CBlast4_alignments_for_query_Base&);
    CBlast4_alignments_for_query_Base& operator=(const CBlast4_alignments_for_query_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Query_id;
    list< CRef< CBlast4_simple_alignment > > m_Alignments;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_alignments_for_query_Base::IsSetQuery_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_alignments_for_query_Base::CanGetQuery_id(void) const
{
    return IsSetQuery_id();
}

inline
const CBlast4_alignments_for_query_Base::TQuery_id& CBlast4_alignments_for_query_Base::GetQuery_id(void) const
{
    if (!CanGetQuery_id()) {
        ThrowUnassigned(0);
    }
    return m_Query_id;
}

inline
void CBlast4_alignments_for_query_Base::SetQuery_id(const CBlast4_alignments_for_query_Base::TQuery_id& value)
{
    m_Query_id = value;
    m_set_State[0] |= 0x3;
}

inline
void CBlast4_alignments_for_query_Base::SetQuery_id(CBlast4_alignments_for_query_Base::TQuery_id&& value)
{
    m_Query_id = std::forward<CBlast4_alignments_for_query_Base::TQuery_id>(value);
    m_set_State[0] |= 0x3;
}

inline
CBlast4_alignments_for_query_Base::TQuery_id& CBlast4_alignments_for_query_Base::SetQuery_id(void)
{
#ifdef _DEBUG
    if (!IsSetQuery_id()) {
        m_Query_id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Query_id;
}

inline
bool CBlast4_alignments_for_query_Base::IsSetAlignments(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_alignments_for_query_Base::CanGetAlignments(void) const
{
    return true;
}

inline
const CBlast4_alignments_for_query_Base::TAlignments& CBlast4_alignments_for_query_Base::GetAlignments(void) const
{
    return m_Alignments;
}

inline
CBlast4_alignments_for_query_Base::TAlignments& CBlast4_alignments_for_query_Base::SetAlignments(void)
{
    m_set_State[0] |= 0x4;
    return m_Alignments;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_ALIGNMENT_FOR_QUERY_BASE_HPP
