/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Auth_list_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_AUTH_LIST_BASE_HPP
#define OBJECTS_BIBLIO_AUTH_LIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <serial/delaybuf.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAffil;
class CAuthor;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Authorship Group
class NCBI_BIBLIO_EXPORT CAuth_list_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAuth_list_Base(void);
    // destructor
    virtual ~CAuth_list_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_BIBLIO_EXPORT C_Names : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Names(void);
        // destructor
        ~C_Names(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Std,          ///< full citations
            e_Ml,           ///< MEDLINE, semi-structured
            e_Str           ///< free for all
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_Str+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef list< CRef< CAuthor > > TStd;
        typedef list< string > TMl;
        typedef list< string > TStr;
    
        // getters
        // setters
    
        // typedef list< CRef< CAuthor > > TStd
        bool IsStd(void) const;
        const TStd& GetStd(void) const;
        TStd& SetStd(void);
    
        // typedef list< string > TMl
        bool IsMl(void) const;
        const TMl& GetMl(void) const;
        TMl& SetMl(void);
    
        // typedef list< string > TStr
        bool IsStr(void) const;
        const TStr& GetStr(void) const;
        TStr& SetStr(void);
    
    
    private:
        // copy constructor and assignment operator
        C_Names(const C_Names& );
        C_Names& operator=(const C_Names& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<TStd> m_Std;
            NCBI_NS_NCBI::CUnionBuffer<TMl> m_Ml;
            NCBI_NS_NCBI::CUnionBuffer<TStr> m_Str;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef C_Names TNames;
    typedef CAffil TAffil;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_names,
        e_affil
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Names TNames
    ///  Check whether the Names data member has been assigned a value.
    bool IsSetNames(void) const;
    /// Check whether it is safe or not to call GetNames method.
    bool CanGetNames(void) const;
    void ResetNames(void);
    const TNames& GetNames(void) const;
    void SetNames(TNames& value);
    TNames& SetNames(void);

    /// author affiliation
    /// optional
    /// typedef CAffil TAffil
    ///  Check whether the Affil data member has been assigned a value.
    bool IsSetAffil(void) const;
    /// Check whether it is safe or not to call GetAffil method.
    bool CanGetAffil(void) const;
    void ResetAffil(void);
    const TAffil& GetAffil(void) const;
    void SetAffil(TAffil& value);
    TAffil& SetAffil(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAuth_list_Base(const CAuth_list_Base&);
    CAuth_list_Base& operator=(const CAuth_list_Base&);

    // data
    Uint4 m_set_State[1];
    mutable NCBI_NS_NCBI::CDelayBuffer m_delay_Names;
    CRef< TNames > m_Names;
    CRef< TAffil > m_Affil;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CAuth_list_Base::C_Names::E_Choice CAuth_list_Base::C_Names::Which(void) const
{
    return m_choice;
}

inline
void CAuth_list_Base::C_Names::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CAuth_list_Base::C_Names::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CAuth_list_Base::C_Names::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CAuth_list_Base::C_Names::IsStd(void) const
{
    return m_choice == e_Std;
}

inline
const CAuth_list_Base::C_Names::TStd& CAuth_list_Base::C_Names::GetStd(void) const
{
    CheckSelected(e_Std);
    return *m_Std;
}

inline
CAuth_list_Base::C_Names::TStd& CAuth_list_Base::C_Names::SetStd(void)
{
    Select(e_Std, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Std;
}

inline
bool CAuth_list_Base::C_Names::IsMl(void) const
{
    return m_choice == e_Ml;
}

inline
const CAuth_list_Base::C_Names::TMl& CAuth_list_Base::C_Names::GetMl(void) const
{
    CheckSelected(e_Ml);
    return *m_Ml;
}

inline
CAuth_list_Base::C_Names::TMl& CAuth_list_Base::C_Names::SetMl(void)
{
    Select(e_Ml, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ml;
}

inline
bool CAuth_list_Base::C_Names::IsStr(void) const
{
    return m_choice == e_Str;
}

inline
const CAuth_list_Base::C_Names::TStr& CAuth_list_Base::C_Names::GetStr(void) const
{
    CheckSelected(e_Str);
    return *m_Str;
}

inline
CAuth_list_Base::C_Names::TStr& CAuth_list_Base::C_Names::SetStr(void)
{
    Select(e_Str, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Str;
}

inline
bool CAuth_list_Base::IsSetNames(void) const
{
    if ( m_delay_Names )
        return true;
    return m_Names.NotEmpty();
}

inline
bool CAuth_list_Base::CanGetNames(void) const
{
    return true;
}

inline
const CAuth_list_Base::TNames& CAuth_list_Base::GetNames(void) const
{
    m_delay_Names.Update();
    if ( !m_Names ) {
        const_cast<CAuth_list_Base*>(this)->ResetNames();
    }
    return (*m_Names);
}

inline
CAuth_list_Base::TNames& CAuth_list_Base::SetNames(void)
{
    m_delay_Names.Update();
    if ( !m_Names ) {
        ResetNames();
    }
    return (*m_Names);
}

inline
bool CAuth_list_Base::IsSetAffil(void) const
{
    return m_Affil.NotEmpty();
}

inline
bool CAuth_list_Base::CanGetAffil(void) const
{
    return IsSetAffil();
}

inline
const CAuth_list_Base::TAffil& CAuth_list_Base::GetAffil(void) const
{
    if (!CanGetAffil()) {
        ThrowUnassigned(1);
    }
    return (*m_Affil);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_AUTH_LIST_BASE_HPP
