/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.BoardPainter;
import free.chess.ChessMove;
import free.chess.ChessPiece;
import free.chess.DefaultBoardPainter;
import free.chess.DefaultPiecePainter;
import free.chess.Move;
import free.chess.Piece;
import free.chess.PiecePainter;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;
import free.chess.WildVariant;

public class ChesslikeGenericVariant
implements WildVariant {
    private static final ChessPiece[] WHITE_PROMOTION_TARGETS = new ChessPiece[]{ChessPiece.WHITE_QUEEN, ChessPiece.WHITE_ROOK, ChessPiece.WHITE_BISHOP, ChessPiece.WHITE_KNIGHT};
    private static final ChessPiece[] BLACK_PROMOTION_TARGETS = new ChessPiece[]{ChessPiece.BLACK_QUEEN, ChessPiece.BLACK_ROOK, ChessPiece.BLACK_BISHOP, ChessPiece.BLACK_KNIGHT};
    public static final ChessMove WHITE_SHORT_CASTLING = new ChessMove(Square.parseSquare("e1"), Square.parseSquare("g1"), Player.WHITE_PLAYER, false, true, false, null, -1, null, "O-O");
    public static final ChessMove WHITE_LONG_CASTLING = new ChessMove(Square.parseSquare("e1"), Square.parseSquare("c1"), Player.WHITE_PLAYER, false, false, true, null, -1, null, "O-O-O");
    public static final ChessMove BLACK_SHORT_CASTLING = new ChessMove(Square.parseSquare("e8"), Square.parseSquare("g8"), Player.BLACK_PLAYER, false, true, false, null, -1, null, "O-O");
    public static final ChessMove BLACK_LONG_CASTLING = new ChessMove(Square.parseSquare("e8"), Square.parseSquare("c8"), Player.BLACK_PLAYER, false, false, true, null, -1, null, "O-O-O");
    private final String initialPositionFEN;
    private final String variantName;

    public ChesslikeGenericVariant(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("The initial position argument may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The variant name argument may not be null");
        }
        this.initialPositionFEN = string;
        this.variantName = string2;
    }

    public boolean isEnPassant(Position position, Square square, Square square2, ChessPiece chessPiece) {
        if (chessPiece != null) {
            return false;
        }
        ChessPiece chessPiece2 = (ChessPiece)position.getPieceAt(square);
        ChessPiece chessPiece3 = (ChessPiece)position.getPieceAt(square2);
        if (chessPiece2.isPawn()) {
            Square square3 = Square.getInstance(square2.getFile(), square.getRank());
            ChessPiece chessPiece4 = (ChessPiece)position.getPieceAt(square3);
            if (chessPiece3 != null) {
                return false;
            }
            if (chessPiece4 == null) {
                return false;
            }
            if (!chessPiece4.isPawn()) {
                return false;
            }
            if (chessPiece4.isSameColor(chessPiece2)) {
                return false;
            }
            if (Math.abs(square.getFile() - square2.getFile()) != 1) {
                return false;
            }
            if (chessPiece2.isWhite()) {
                return square.getRank() == 4 && square2.getRank() == 5;
            }
            return square.getRank() == 3 && square2.getRank() == 2;
        }
        return false;
    }

    public boolean isShortCastling(Position position, Square square, Square square2, ChessPiece chessPiece) {
        if (chessPiece != null) {
            return false;
        }
        ChessPiece chessPiece2 = (ChessPiece)position.getPieceAt(square);
        ChessPiece chessPiece3 = (ChessPiece)position.getPieceAt(square2);
        if (chessPiece3 != null) {
            return false;
        }
        if (chessPiece2 == ChessPiece.WHITE_KING) {
            if (!square.equals("e1")) {
                return false;
            }
            if (!square2.equals("g1")) {
                return false;
            }
            if (position.getPieceAt("h1") != ChessPiece.WHITE_ROOK) {
                return false;
            }
            return position.getPieceAt("f1") == null;
        }
        if (chessPiece2 == ChessPiece.BLACK_KING) {
            if (!square.equals("e8")) {
                return false;
            }
            if (!square2.equals("g8")) {
                return false;
            }
            if (position.getPieceAt("h8") != ChessPiece.BLACK_ROOK) {
                return false;
            }
            return position.getPieceAt("f8") == null;
        }
        return false;
    }

    public boolean isLongCastling(Position position, Square square, Square square2, ChessPiece chessPiece) {
        if (chessPiece != null) {
            return false;
        }
        ChessPiece chessPiece2 = (ChessPiece)position.getPieceAt(square);
        ChessPiece chessPiece3 = (ChessPiece)position.getPieceAt(square2);
        if (chessPiece3 != null) {
            return false;
        }
        if (chessPiece2 == ChessPiece.WHITE_KING) {
            if (!square.equals("e1")) {
                return false;
            }
            if (!square2.equals("c1")) {
                return false;
            }
            if (position.getPieceAt("a1") != ChessPiece.WHITE_ROOK) {
                return false;
            }
            if (position.getPieceAt("b1") != null) {
                return false;
            }
            return position.getPieceAt("d1") == null;
        }
        if (chessPiece2 == ChessPiece.BLACK_KING) {
            if (!square.equals("e8")) {
                return false;
            }
            if (!square2.equals("c8")) {
                return false;
            }
            if (position.getPieceAt("a8") != ChessPiece.BLACK_ROOK) {
                return false;
            }
            if (position.getPieceAt("b8") != null) {
                return false;
            }
            return position.getPieceAt("d8") == null;
        }
        return false;
    }

    public ChessPiece getCapturedPiece(Position position, Square square, Square square2, ChessPiece chessPiece) {
        boolean bl = this.isEnPassant(position, square, square2, chessPiece);
        return this.getCapturedPiece(position, square, square2, chessPiece, bl);
    }

    public ChessPiece getCapturedPiece(Position position, Square square, Square square2, ChessPiece chessPiece, boolean bl) {
        ChessPiece chessPiece2 = (ChessPiece)position.getPieceAt(square);
        ChessPiece chessPiece3 = (ChessPiece)position.getPieceAt(square2);
        if (bl) {
            return chessPiece2.isWhite() ? ChessPiece.BLACK_PAWN : ChessPiece.WHITE_PAWN;
        }
        return chessPiece3;
    }

    public int getDoublePawnPushFile(Position position, Square square, Square square2) {
        Piece piece = position.getPieceAt(square);
        if (piece == ChessPiece.WHITE_PAWN && square.getRank() == 1 && square2.getRank() == 3 && square.getFile() == square2.getFile() && position.getPieceAt(Square.getInstance(square2.getFile(), 2)) == null || piece == ChessPiece.BLACK_PAWN && square.getRank() == 6 && square2.getRank() == 4 && square.getFile() == square2.getFile() && position.getPieceAt(Square.getInstance(square2.getFile(), 5)) == null) {
            return square.getFile();
        }
        return -1;
    }

    protected void checkPosition(Position position) {
        if (!position.getVariant().equals(this)) {
            throw new IllegalArgumentException("Wrong position variant: " + position.getVariant());
        }
    }

    public void init(Position position) {
        this.checkPosition(position);
        position.setFEN(this.initialPositionFEN);
    }

    public Piece[] getPromotionTargets(Position position, Square square, Square square2) {
        this.checkPosition(position);
        return ChesslikeGenericVariant.getChessPromotionTargets(position, square, square2);
    }

    public static Piece[] getChessPromotionTargets(Position position, Square square, Square square2) {
        ChessPiece chessPiece = (ChessPiece)position.getPieceAt(square);
        if (square2.getRank() == 7 && chessPiece == ChessPiece.WHITE_PAWN) {
            return (Piece[])WHITE_PROMOTION_TARGETS.clone();
        }
        if (square2.getRank() == 0 && chessPiece == ChessPiece.BLACK_PAWN) {
            return (Piece[])BLACK_PROMOTION_TARGETS.clone();
        }
        return null;
    }

    public Move createMove(Position position, Square square, Square square2, Piece piece, String string) {
        this.checkPosition(position);
        return this.createChessMove(position, square, square2, piece, string);
    }

    public ChessMove createChessMove(Position position, Square square, Square square2, Piece piece, String string) {
        if (piece != null && !(piece instanceof ChessPiece)) {
            throw new IllegalArgumentException("Wrong promotion target type: " + piece.getClass());
        }
        Piece piece2 = position.getPieceAt(square);
        if (piece2 == null) {
            throw new IllegalArgumentException("The moving piece may not be null");
        }
        Player player = piece2.getPlayer();
        ChessPiece chessPiece = (ChessPiece)piece;
        boolean bl = this.isEnPassant(position, square, square2, chessPiece);
        boolean bl2 = this.isShortCastling(position, square, square2, chessPiece);
        boolean bl3 = this.isLongCastling(position, square, square2, chessPiece);
        ChessPiece chessPiece2 = this.getCapturedPiece(position, square, square2, chessPiece, bl);
        int n = this.getDoublePawnPushFile(position, square, square2);
        return new ChessMove(square, square2, player, bl, bl2, bl3, chessPiece2, n, chessPiece, string);
    }

    public Move createMove(Position position, Move move) {
        this.checkPosition(position);
        if (!(move instanceof ChessMove)) {
            throw new IllegalArgumentException("Wrong move type: " + move.getClass());
        }
        ChessMove chessMove = (ChessMove)move;
        return this.createMove(position, chessMove.getStartingSquare(), chessMove.getEndingSquare(), chessMove.getPromotionTarget(), chessMove.getStringRepresentation());
    }

    public Move createShortCastling(Position position) {
        this.checkPosition(position);
        Player player = position.getCurrentPlayer();
        if (player.isWhite()) {
            return WHITE_SHORT_CASTLING;
        }
        return BLACK_SHORT_CASTLING;
    }

    public Move createLongCastling(Position position) {
        this.checkPosition(position);
        Player player = position.getCurrentPlayer();
        if (player.isWhite()) {
            return WHITE_LONG_CASTLING;
        }
        return BLACK_LONG_CASTLING;
    }

    public void makeMove(Move move, Position position, Position.Modifier modifier) {
        this.checkPosition(position);
        if (!(move instanceof ChessMove)) {
            throw new IllegalArgumentException("Wrong move type: " + move.getClass());
        }
        ChessMove chessMove = (ChessMove)move;
        this.makeChessMove(chessMove, position, modifier);
    }

    public void makeChessMove(ChessMove chessMove, Position position, Position.Modifier modifier) {
        Square square = chessMove.getStartingSquare();
        Square square2 = chessMove.getEndingSquare();
        ChessPiece chessPiece = (ChessPiece)position.getPieceAt(square);
        modifier.setPieceAt(null, square);
        if (chessMove.isPromotion()) {
            modifier.setPieceAt(chessMove.getPromotionTarget(), square2);
        } else {
            modifier.setPieceAt(chessPiece, square2);
        }
        if (chessMove.isEnPassant()) {
            modifier.setPieceAt(null, Square.getInstance(square2.getFile(), square.getRank()));
        }
        if (chessMove.isCastling()) {
            int n = chessMove.isShortCastling() ? 7 : 0;
            int n2 = chessMove.isShortCastling() ? 5 : 3;
            Square square3 = Square.getInstance(n, square.getRank());
            Square square4 = Square.getInstance(n2, square.getRank());
            ChessPiece chessPiece2 = (ChessPiece)position.getPieceAt(square3);
            modifier.setPieceAt(null, square3);
            modifier.setPieceAt(chessPiece2, square4);
        }
        modifier.setCurrentPlayer(chessMove.getPlayer().getOpponent());
    }

    public Piece parsePiece(String string) {
        return ChesslikeGenericVariant.parseChessPiece(string);
    }

    public static ChessPiece parseChessPiece(String string) {
        return ChessPiece.fromShortString(string);
    }

    public String pieceToString(Piece piece) {
        if (!(piece instanceof ChessPiece)) {
            throw new IllegalArgumentException("The piece must be an instance of ChessPiece.");
        }
        return ChesslikeGenericVariant.chessPieceToString((ChessPiece)piece);
    }

    public static String chessPieceToString(ChessPiece chessPiece) {
        return chessPiece.toShortString();
    }

    public PiecePainter createDefaultPiecePainter() {
        return new DefaultPiecePainter();
    }

    public BoardPainter createDefaultBoardPainter() {
        return new DefaultBoardPainter();
    }

    public String getName() {
        return this.variantName;
    }

    public String toString() {
        return this.getName();
    }
}

