/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchInstructionByOpcodeVisitor {
    public static Instruction visit(Instruction instruction, int opcode) throws RuntimeException {
        if (instruction == null) {
            throw new RuntimeException("Null instruction");
        }
        if (instruction.opcode == opcode) {
            return instruction;
        }
        switch (instruction.opcode) {
            case 190: {
                return SearchInstructionByOpcodeVisitor.visit(((ArrayLength)instruction).arrayref, opcode);
            }
            case 83: 
            case 272: {
                return SearchInstructionByOpcodeVisitor.visit(((ArrayStoreInstruction)instruction).arrayref, opcode);
            }
            case 191: {
                return SearchInstructionByOpcodeVisitor.visit(((AThrow)instruction).value, opcode);
            }
            case 266: {
                return SearchInstructionByOpcodeVisitor.visit(((UnaryOperatorInstruction)instruction).value, opcode);
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(boi.value1, opcode);
                if (tmp != null) {
                    return tmp;
                }
                return SearchInstructionByOpcodeVisitor.visit(boi.value2, opcode);
            }
            case 192: {
                return SearchInstructionByOpcodeVisitor.visit(((CheckCast)instruction).objectref, opcode);
            }
            case 54: 
            case 58: 
            case 269: {
                return SearchInstructionByOpcodeVisitor.visit(((StoreInstruction)instruction).valueref, opcode);
            }
            case 264: {
                return SearchInstructionByOpcodeVisitor.visit(((DupStore)instruction).objectref, opcode);
            }
            case 275: 
            case 276: {
                return SearchInstructionByOpcodeVisitor.visit(((ConvertInstruction)instruction).value, opcode);
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(ifCmp.value1, opcode);
                if (tmp != null) {
                    return tmp;
                }
                return SearchInstructionByOpcodeVisitor.visit(ifCmp.value2, opcode);
            }
            case 260: 
            case 262: {
                return SearchInstructionByOpcodeVisitor.visit(((IfInstruction)instruction).value, opcode);
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    Instruction tmp = SearchInstructionByOpcodeVisitor.visit(branchList.get(i), opcode);
                    if (tmp != null) {
                        return tmp;
                    }
                    --i;
                }
                break;
            }
            case 193: {
                return SearchInstructionByOpcodeVisitor.visit(((InstanceOf)instruction).objectref, opcode);
            }
            case 182: 
            case 183: 
            case 185: {
                Instruction result = SearchInstructionByOpcodeVisitor.visit(((InvokeNoStaticInstruction)instruction).objectref, opcode);
                if (result != null) {
                    return result;
                }
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    Instruction tmp = SearchInstructionByOpcodeVisitor.visit(list.get(i), opcode);
                    if (tmp != null) {
                        return tmp;
                    }
                    --i;
                }
                break;
            }
            case 171: {
                return SearchInstructionByOpcodeVisitor.visit(((LookupSwitch)instruction).key, opcode);
            }
            case 194: {
                return SearchInstructionByOpcodeVisitor.visit(((MonitorEnter)instruction).objectref, opcode);
            }
            case 195: {
                return SearchInstructionByOpcodeVisitor.visit(((MonitorExit)instruction).objectref, opcode);
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    Instruction tmp = SearchInstructionByOpcodeVisitor.visit(dimensions[i], opcode);
                    if (tmp != null) {
                        return tmp;
                    }
                    --i;
                }
                break;
            }
            case 188: {
                return SearchInstructionByOpcodeVisitor.visit(((NewArray)instruction).dimension, opcode);
            }
            case 189: {
                return SearchInstructionByOpcodeVisitor.visit(((ANewArray)instruction).dimension, opcode);
            }
            case 87: {
                return SearchInstructionByOpcodeVisitor.visit(((Pop)instruction).objectref, opcode);
            }
            case 181: {
                PutField putField = (PutField)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(putField.objectref, opcode);
                if (tmp != null) {
                    return tmp;
                }
                return SearchInstructionByOpcodeVisitor.visit(putField.valueref, opcode);
            }
            case 179: {
                return SearchInstructionByOpcodeVisitor.visit(((PutStatic)instruction).valueref, opcode);
            }
            case 273: {
                return SearchInstructionByOpcodeVisitor.visit(((ReturnInstruction)instruction).valueref, opcode);
            }
            case 170: {
                return SearchInstructionByOpcodeVisitor.visit(((TableSwitch)instruction).key, opcode);
            }
            case 280: {
                return SearchInstructionByOpcodeVisitor.visit(((TernaryOpStore)instruction).objectref, opcode);
            }
            case 277: 
            case 278: {
                return SearchInstructionByOpcodeVisitor.visit(((IncInstruction)instruction).value, opcode);
            }
            case 180: {
                return SearchInstructionByOpcodeVisitor.visit(((GetField)instruction).objectref, opcode);
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(iai.newArray, opcode);
                if (tmp != null) {
                    return tmp;
                }
                if (iai.values == null) break;
                return SearchInstructionByOpcodeVisitor.visit(iai.values, opcode);
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(to.value1, opcode);
                if (tmp != null) {
                    return tmp;
                }
                return SearchInstructionByOpcodeVisitor.visit(to.value2, opcode);
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(ft.instructions, opcode);
                if (tmp != null) {
                    return tmp;
                }
                List<FastTry.FastCatch> catches = ft.catches;
                int i = catches.size() - 1;
                while (i >= 0) {
                    tmp = SearchInstructionByOpcodeVisitor.visit(catches.get((int)i).instructions, opcode);
                    if (tmp != null) {
                        return tmp;
                    }
                    --i;
                }
                if (ft.finallyInstructions == null) break;
                return SearchInstructionByOpcodeVisitor.visit(ft.finallyInstructions, opcode);
            }
            case 319: {
                FastSynchronized fsy = (FastSynchronized)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(fsy.monitor, opcode);
                if (tmp != null) {
                    return tmp;
                }
                return SearchInstructionByOpcodeVisitor.visit(fsy.instructions, opcode);
            }
            case 304: {
                Instruction tmp;
                FastFor ff = (FastFor)instruction;
                if (ff.init != null && (tmp = SearchInstructionByOpcodeVisitor.visit(ff.init, opcode)) != null) {
                    return tmp;
                }
                if (ff.inc != null && (tmp = SearchInstructionByOpcodeVisitor.visit(ff.inc, opcode)) != null) {
                    return tmp;
                }
            }
            case 301: 
            case 302: 
            case 306: {
                Instruction tmp;
                FastTestList ftl = (FastTestList)instruction;
                if (ftl.test != null && (tmp = SearchInstructionByOpcodeVisitor.visit(ftl.test, opcode)) != null) {
                    return tmp;
                }
            }
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).instructions;
                if (instructions == null) break;
                return SearchInstructionByOpcodeVisitor.visit(instructions, opcode);
            }
            case 305: {
                FastForEach ffe = (FastForEach)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(ffe.variable, opcode);
                if (tmp != null) {
                    return tmp;
                }
                tmp = SearchInstructionByOpcodeVisitor.visit(ffe.values, opcode);
                if (tmp != null) {
                    return tmp;
                }
                return SearchInstructionByOpcodeVisitor.visit(ffe.instructions, opcode);
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(ft2l.test, opcode);
                if (tmp != null) {
                    return tmp;
                }
                tmp = SearchInstructionByOpcodeVisitor.visit(ft2l.instructions, opcode);
                if (tmp != null) {
                    return tmp;
                }
                return SearchInstructionByOpcodeVisitor.visit(ft2l.instructions2, opcode);
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                FastInstruction fi = (FastInstruction)instruction;
                if (fi.instruction == null) break;
                return SearchInstructionByOpcodeVisitor.visit(fi.instruction, opcode);
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.instruction == null) break;
                return SearchInstructionByOpcodeVisitor.visit(fd.instruction, opcode);
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch fs = (FastSwitch)instruction;
                Instruction tmp = SearchInstructionByOpcodeVisitor.visit(fs.test, opcode);
                if (tmp != null) {
                    return tmp;
                }
                FastSwitch.Pair[] pairs = fs.pairs;
                int i = pairs.length - 1;
                while (i >= 0) {
                    List<Instruction> instructions = pairs[i].getInstructions();
                    if (instructions != null && (tmp = SearchInstructionByOpcodeVisitor.visit(instructions, opcode)) != null) {
                        return tmp;
                    }
                    --i;
                }
                break;
            }
            case 320: {
                FastLabel fla = (FastLabel)instruction;
                if (fla.instruction == null) break;
                return SearchInstructionByOpcodeVisitor.visit(fla.instruction, opcode);
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not search instruction in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
        return null;
    }

    private static Instruction visit(List<Instruction> instructions, int opcode) throws RuntimeException {
        int i = instructions.size() - 1;
        while (i >= 0) {
            Instruction instruction = SearchInstructionByOpcodeVisitor.visit(instructions.get(i), opcode);
            if (instruction != null) {
                return instruction;
            }
            --i;
        }
        return null;
    }
}

