/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.gogui.gui.AntialiasingEditorPane;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.utils.Platform;

public class Help
extends JDialog
implements ActionListener,
HyperlinkListener {
    private int m_historyIndex = -1;
    private static final long serialVersionUID = 0L;
    private JButton m_buttonBack;
    private JButton m_buttonForward;
    private final JEditorPane m_editorPane;
    private List m_history = new ArrayList();
    private final URL m_contents;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Help(Frame frame, URL uRL) {
        super(frame, "Documentation - GoGui");
        this.m_contents = uRL;
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        container.add(jPanel);
        jPanel.add((Component)this.createButtons(), "North");
        this.m_editorPane = new AntialiasingEditorPane();
        this.m_editorPane.setEditable(false);
        this.m_editorPane.addHyperlinkListener(this);
        int n = GuiUtils.getDefaultMonoFontSize() * 50;
        int n2 = GuiUtils.getDefaultMonoFontSize() * 60;
        JScrollPane jScrollPane = new JScrollPane(this.m_editorPane, 22, 31);
        jScrollPane.setPreferredSize(new Dimension(n, n2));
        jPanel.add((Component)jScrollPane, "Center");
        this.pack();
        this.loadURL(this.m_contents);
        this.appendHistory(this.m_contents);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("back")) {
            this.back();
        } else if (string.equals("close")) {
            this.setVisible(false);
        } else if (string.equals("contents")) {
            this.loadURL(this.m_contents);
            this.appendHistory(this.m_contents);
        } else if (string.equals("forward")) {
            this.forward();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            String string = uRL.getProtocol();
            if (string.equals("jar") || string.equals("file")) {
                this.loadURL(uRL);
                this.appendHistory(uRL);
            } else {
                this.openExternal(uRL);
            }
        }
    }

    private void appendHistory(URL uRL) {
        if (this.m_historyIndex >= 0 && this.getHistory(this.m_historyIndex).equals(uRL)) {
            return;
        }
        if (this.m_historyIndex + 1 < this.m_history.size()) {
            if (!this.getHistory(this.m_historyIndex + 1).equals(uRL)) {
                this.m_history = this.m_history.subList(0, this.m_historyIndex + 1);
                this.m_history.add(uRL);
            }
        } else {
            this.m_history.add(uRL);
        }
        ++this.m_historyIndex;
        this.historyChanged();
    }

    private void back() {
        if (!$assertionsDisabled && this.m_historyIndex <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_historyIndex >= this.m_history.size()) {
            throw new AssertionError();
        }
        --this.m_historyIndex;
        this.loadURL(this.getHistory(this.m_historyIndex));
        this.historyChanged();
    }

    private JComponent createButtons() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.createToolBarButton("gohome.png", "contents", "Table of Contents"));
        this.m_buttonBack = this.createToolBarButton("back.png", "back", "Back");
        jToolBar.add(this.m_buttonBack);
        this.m_buttonForward = this.createToolBarButton("forward.png", "forward", "Forward");
        jToolBar.add(this.m_buttonForward);
        jToolBar.setRollover(true);
        jToolBar.setFloatable(false);
        jToolBar.putClientProperty("jgoodies.headerStyle", "Single");
        return jToolBar;
    }

    private JButton createToolBarButton(String string, String string2, String string3) {
        JButton jButton = new JButton();
        jButton.setActionCommand(string2);
        jButton.setToolTipText(string3);
        jButton.addActionListener(this);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        URL uRL = classLoader.getResource("net/sf/gogui/images/" + string);
        if (uRL == null) {
            jButton.setText(string2);
        } else {
            ImageIcon imageIcon = new ImageIcon(uRL, string2);
            jButton.setIcon(imageIcon);
        }
        jButton.setFocusable(false);
        return jButton;
    }

    private void forward() {
        if (!$assertionsDisabled && this.m_historyIndex + 1 >= this.m_history.size()) {
            throw new AssertionError();
        }
        ++this.m_historyIndex;
        this.loadURL(this.getHistory(this.m_historyIndex));
        this.historyChanged();
    }

    private URL getHistory(int n) {
        return (URL)this.m_history.get(n);
    }

    private void historyChanged() {
        boolean bl = this.m_historyIndex > 0;
        boolean bl2 = this.m_historyIndex < this.m_history.size() - 1;
        this.m_buttonBack.setEnabled(bl);
        this.m_buttonForward.setEnabled(bl2);
    }

    private void loadURL(URL uRL) {
        try {
            this.m_editorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            SimpleDialogs.showError(this, "Could not load page\n" + uRL.toString() + ":\n" + iOException.getMessage());
        }
    }

    private void openExternal(URL uRL) {
        if (!Platform.openInExternalBrowser(uRL)) {
            this.loadURL(uRL);
        }
        this.appendHistory(uRL);
    }

    static {
        $assertionsDisabled = !Help.class.desiredAssertionStatus();
    }
}

