%%%
%%% test programs of the UNFOLD/FOLD constraint transformer
%%%
member(X,[X|Y]).
member(X,[Y|Z]):-member(X,Z).
append([],X,X).
append([A|X],Y,[A|Z]):-append(X,Y,Z).

%%
%% constraint transformation examples
%%
@ member(X,[a,b,c]),member(X,[b,c,d]).    
% solution = c0(X_0)
% c0(b).
% c0(c).

@ member(X,[a,b,c]),member(X,[j,k,l]).   %% -> transformation fails
% solution = fail.

@ member(A,X),append(X,Y,Z).    %% needs fold transformation
% solution = c2(X_1, Y_2, Z_3, A_0)
% c4(V0_0, V1_1, V2_2, [V0_0 | V3_3]) :- append(V1_1, V2_2, V3_3).
% c3(V0_0, V1_1, V2_2, [V0_0 | V3_3], V4_4) :- c2(V1_1, V2_2, V3_3, V4_4).
% c2([V0_0 | V1_1], V2_2, V3_3, V0_0) :- c4(V0_0, V1_1, V2_2, V3_3).
% c2([V0_0 | V1_1], V2_2, V3_3, V4_4) :- c3(V0_0, V1_1, V2_2, V3_3, V4_4).

