/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events;

import com.carrotsearch.ant.tasks.junit4.events.AbstractEvent;
import com.carrotsearch.ant.tasks.junit4.events.EventType;
import com.carrotsearch.ant.tasks.junit4.events.IDescribable;
import com.carrotsearch.ant.tasks.junit4.events.JsonHelpers;
import com.carrotsearch.ant.tasks.junit4.events.mirrors.FailureMirror;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonReader;
import com.carrotsearch.ant.tasks.junit4.gson.stream.JsonWriter;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public abstract class FailureEvent
extends AbstractEvent
implements IDescribable {
    private FailureMirror failure;

    public FailureEvent(EventType eventType) {
        super(eventType);
    }

    protected void setFailure(Failure failure) {
        if (this.failure != null) {
            throw new IllegalStateException("Set only once.");
        }
        this.failure = new FailureMirror(failure);
    }

    public FailureMirror getFailure() {
        return this.failure;
    }

    @Override
    public Description getDescription() {
        return this.failure.getDescription();
    }

    @Override
    public void serialize(JsonWriter jsonWriter) {
        jsonWriter.beginObject();
        jsonWriter.name("description");
        FailureEvent.writeDescription(jsonWriter, this.failure.getDescription());
        jsonWriter.name("message").value(this.failure.getMessage());
        jsonWriter.name("trace").value(this.failure.getTrace());
        jsonWriter.name("throwableString").value(this.failure.getThrowableString());
        jsonWriter.name("throwableClass").value(this.failure.getThrowableClass());
        jsonWriter.name("assertionViolation").value(this.failure.isAssertionViolation());
        jsonWriter.name("assumptionViolation").value(this.failure.isAssumptionViolation());
        jsonWriter.endObject();
    }

    @Override
    public void deserialize(JsonReader jsonReader) {
        jsonReader.beginObject();
        FailureEvent.expectProperty(jsonReader, "description");
        Description description = JsonHelpers.readDescription(jsonReader);
        String string = FailureEvent.readStringOrNullProperty(jsonReader, "message");
        String string2 = FailureEvent.readStringOrNullProperty(jsonReader, "trace");
        String string3 = FailureEvent.readStringOrNullProperty(jsonReader, "throwableString");
        String string4 = FailureEvent.readStringOrNullProperty(jsonReader, "throwableClass");
        boolean bl = FailureEvent.readBoolean(jsonReader, "assertionViolation");
        boolean bl2 = FailureEvent.readBoolean(jsonReader, "assumptionViolation");
        this.failure = new FailureMirror(description, string, string2, string3, string4, bl, bl2);
        jsonReader.endObject();
    }
}

