/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.web.Container;

public class RESTServlet
extends HttpServlet {
    static final Map<String, String> DEFAULT_METHOD = new HashMap<String, String>();
    static final Set<String> DEFAULT_VERB = new HashSet<String>();
    protected Container container;
    Config config;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = servletConfig.getInitParameter("config");
        JSON jSON = new JSON();
        if (string == null) {
            HashMap hashMap = new HashMap();
            Enumeration object = (Enumeration)Container.cast(servletConfig.getInitParameterNames());
            while (object.hasMoreElements()) {
                hashMap.put(object.nextElement(), servletConfig.getInitParameter((String)object.nextElement()));
            }
            string = jSON.format(hashMap);
        }
        try {
            this.config = jSON.parse((CharSequence)string, Config.class);
            if (this.config.container == null) {
                this.config.container = Container.class;
            }
            this.container = jSON.parse((CharSequence)string, this.config.container);
            this.container.init(this);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        if (this.config.definitions == null) {
            this.config.definitions = new HashMap<String, Pattern>();
        }
        if (!this.config.definitions.containsKey("package")) {
            this.config.definitions.put("package", Pattern.compile(".+"));
        }
        if (this.config.errors == null) {
            this.config.errors = Collections.emptyMap();
        }
        if (this.config.method == null) {
            this.config.method = DEFAULT_METHOD;
        }
        if (this.config.verb == null) {
            this.config.verb = DEFAULT_VERB;
        }
        if (this.config.mappings == null) {
            this.config.mappings = Collections.emptyMap();
        }
        for (Map.Entry entry : this.config.mappings.entrySet()) {
            ((RouteMapping)entry.getValue()).init((String)entry.getKey(), this.config);
        }
    }

    protected void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doREST(httpServletRequest, httpServletResponse);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doREST(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doREST(httpServletRequest, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doREST(httpServletRequest, httpServletResponse);
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doREST(httpServletRequest, httpServletResponse);
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doREST(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doREST(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = httpServletRequest.getContextPath().equals("/") ? httpServletRequest.getRequestURI() : httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
        Route route = null;
        for (RouteMapping routeMapping : this.config.mappings.values()) {
            route = routeMapping.matches(httpServletRequest, string);
            if (route == null) continue;
            this.container.debug("Route found: " + httpServletRequest.getMethod() + " " + string);
            break;
        }
        if (route == null) {
            httpServletResponse.sendError(404, "Not Found");
            return;
        }
        if (route.getHttpMethod() == null || route.getRestMethod() == null) {
            this.container.debug("Method mapping not found: " + route.getHttpMethod());
            httpServletResponse.sendError(405, "Method Not Allowed");
            return;
        }
        int n = 200;
        Object var6_8 = null;
        LinkedHashMap<String, Object> linkedHashMap = null;
        if ("GET".equals(httpServletRequest.getMethod())) {
            String string2 = route.getParameter("callback");
        } else if ("POST".equals(route.getHttpMethod())) {
            n = 201;
        }
        this.container.start(httpServletRequest, httpServletResponse);
        JSON jSON = this.container.createJSON(httpServletRequest.getLocale());
        try {
            object = route.getComponentClass(this.container);
            Object object2 = this.container.getComponent((String)object);
            if (object2 == null) {
                throw new ClassNotFoundException("Component not found: " + (String)object);
            }
            List<Map<?, ?>> list = null;
            if (Container.isJSONType(httpServletRequest.getContentType())) {
                Object t = jSON.parse(httpServletRequest.getReader());
                if (t instanceof List) {
                    list = (List)Container.cast(t);
                    if (list.isEmpty()) {
                        list = new ArrayList(1);
                        list.add(route.getParameterMap());
                    } else if (list.get(0) instanceof Map) {
                        list.set(0, route.mergeParameterMap((Map)list.get(0)));
                    }
                } else {
                    if (!(t instanceof Map)) throw new IllegalArgumentException("failed to convert parameters from JSON.");
                    list = new ArrayList(1);
                    list.add(route.mergeParameterMap((Map)t));
                }
            } else {
                list = new ArrayList(1);
                list.add(route.getParameterMap());
            }
            Method method = this.container.getMethod(object2, route.getRestMethod(), list);
            if (method == null) {
                throw new NoSuchMethodException("Method not found: " + route.getRestMethod());
            }
            jSON.setContext(object2);
            linkedHashMap = this.container.execute(jSON, object2, method, list);
        }
        catch (Exception exception) {
            if (exception instanceof ClassNotFoundException) {
                this.container.debug("Class Not Found.", exception);
                httpServletResponse.sendError(404, "Not Found");
                httpServletResponse.flushBuffer();
            } else if (exception instanceof NoSuchMethodException) {
                this.container.debug("Method Not Found.", exception);
                httpServletResponse.sendError(404, "Not Found");
                httpServletResponse.flushBuffer();
            } else if (exception instanceof JSONException) {
                this.container.debug("Fails to parse JSON.", exception);
                httpServletResponse.sendError(400, "Bad Request");
                httpServletResponse.flushBuffer();
            } else if (exception instanceof InvocationTargetException) {
                Throwable throwable = exception.getCause();
                this.container.debug("Cause error on invocation.", throwable);
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof IllegalStateException || throwable instanceof UnsupportedOperationException) {
                    httpServletResponse.sendError(404, "Not Found");
                    httpServletResponse.flushBuffer();
                } else if (throwable instanceof IllegalArgumentException) {
                    httpServletResponse.sendError(400, "Bad Request");
                    httpServletResponse.flushBuffer();
                } else {
                    Integer n2 = null;
                    for (Map.Entry<String, Integer> entry : this.config.errors.entrySet()) {
                        Class<?> clazz = ClassUtil.findClass(entry.getKey());
                        if (!clazz.isAssignableFrom(throwable.getClass()) || entry.getValue() == null) continue;
                        n2 = entry.getValue();
                        break;
                    }
                    if (n2 != null) {
                        httpServletResponse.setStatus(n2.intValue());
                        LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
                        linkedHashMap2.put("name", throwable.getClass().getSimpleName());
                        linkedHashMap2.put("message", throwable.getMessage());
                        linkedHashMap2.put("data", throwable);
                        linkedHashMap = linkedHashMap2;
                    } else {
                        httpServletResponse.sendError(500, "Internal Server Error");
                        httpServletResponse.flushBuffer();
                    }
                }
            } else {
                this.container.error("Internal error occurred.", exception);
                httpServletResponse.sendError(500, "Internal Server Error");
                httpServletResponse.flushBuffer();
            }
        }
        finally {
            this.container.end(httpServletRequest, httpServletResponse);
        }
        if (httpServletResponse.isCommitted()) {
            return;
        }
        if (linkedHashMap == null || linkedHashMap instanceof CharSequence || linkedHashMap instanceof Boolean || linkedHashMap instanceof Number || linkedHashMap instanceof Date) {
            if (n != 201) {
                n = 204;
            }
            httpServletResponse.setStatus(n);
            return;
        } else {
            void var6_10;
            httpServletResponse.setContentType(var6_10 != null ? "text/javascript" : "application/json");
            object = httpServletResponse.getWriter();
            jSON.setPrettyPrint(this.container.isDebugMode());
            if (var6_10 != null) {
                ((Writer)object).append((CharSequence)var6_10).append("(");
            }
            jSON.format((Object)linkedHashMap, (Appendable)object);
            if (var6_10 == null) return;
            ((Writer)object).append(");");
        }
    }

    public void destroy() {
        this.container.destory();
        super.destroy();
    }

    static {
        DEFAULT_METHOD.put("GET", "find");
        DEFAULT_METHOD.put("POST", "create");
        DEFAULT_METHOD.put("PUT", "update");
        DEFAULT_METHOD.put("DELETE", "delete");
        DEFAULT_VERB.add("HEAD");
        DEFAULT_VERB.add("GET");
        DEFAULT_VERB.add("POST");
        DEFAULT_VERB.add("PUT");
        DEFAULT_VERB.add("DELETE");
        DEFAULT_VERB.add("OPTIONS");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Route {
        static final Pattern REPLACE_PATTERN = Pattern.compile("\\$\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\}");
        String target;
        String httpMethod;
        String restMethod;
        Map<Object, Object> params;

        public Route(String string, String string2, String string3, Map<String, Object> map) throws IOException {
            this.httpMethod = string;
            this.restMethod = string2;
            this.target = string3;
            this.params = (Map)Container.cast(map);
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public String getRestMethod() {
            return this.restMethod;
        }

        public String getParameter(String string) {
            Object object;
            Object object2 = this.params.get(string);
            if (object2 instanceof Map && (object = (Map)object2).containsKey(null)) {
                object2 = object.get(null);
            }
            if (object2 instanceof List && !(object = (List)object2).isEmpty()) {
                object2 = object.get(0);
            }
            return object2 instanceof String ? (String)object2 : null;
        }

        public Map<?, ?> getParameterMap() {
            return this.params;
        }

        public String getComponentClass(Container container) {
            Matcher matcher = REPLACE_PATTERN.matcher(this.target);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string = matcher.group(1);
                String string2 = this.getParameter(string);
                if (string.equals("class") && container.namingConversion) {
                    string2 = ClassUtil.toUpperCamel(string2);
                } else if (string.equals("package")) {
                    string2 = string2.replace('/', '.');
                }
                matcher.appendReplacement(stringBuffer, string2 != null ? string2 : "");
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        public Map<?, ?> mergeParameterMap(Map<?, ?> map) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (this.params.containsKey(entry.getKey())) {
                    Object object;
                    Object object2 = this.params.get(entry.getKey());
                    if (object2 instanceof Map) {
                        object = (Map)object2;
                        if (object.containsKey(null)) {
                            object2 = object.get(null);
                            if (object2 instanceof List) {
                                ((List)object2).add(entry.getValue());
                                continue;
                            }
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            arrayList.add(object2);
                            arrayList.add(entry.getValue());
                            object.put(null, arrayList);
                            continue;
                        }
                        object.put(null, entry.getValue());
                        continue;
                    }
                    if (object2 instanceof List) {
                        ((List)object2).add(entry.getValue());
                        continue;
                    }
                    object = new ArrayList();
                    object.add(object2);
                    object.add(entry.getValue());
                    this.params.put(entry.getKey(), object);
                    continue;
                }
                this.params.put(entry.getKey(), entry.getValue());
            }
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RouteMapping {
        static final Pattern PLACE_PATTERN = Pattern.compile("\\{\\s*(\\p{javaJavaIdentifierStart}[\\p{javaJavaIdentifierPart}\\.-]*)\\s*(?::\\s*((?:[^{}]|\\{[^{}]*\\})*)\\s*)?\\}");
        static final Pattern DEFAULT_PATTERN = Pattern.compile("[^/().]+");
        public String target;
        public Map<String, String> method;
        public Set<String> verb;
        Config config;
        Pattern pattern;
        List<String> names;

        public void init(String string, Config config) {
            this.config = config;
            this.names = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer("^\\Q");
            Matcher matcher = PLACE_PATTERN.matcher(string);
            while (matcher.find()) {
                Pattern pattern;
                String string2 = matcher.group(1);
                this.names.add(string2);
                Pattern pattern2 = pattern = matcher.group(2) != null ? Pattern.compile(matcher.group(2)) : null;
                if (pattern == null && config.definitions.containsKey(string2)) {
                    pattern = config.definitions.get(string2);
                }
                if (pattern == null) {
                    pattern = DEFAULT_PATTERN;
                }
                matcher.appendReplacement(stringBuffer, "\\\\E(" + pattern.pattern().replaceAll("\\((?!\\?)", "(?:").replace("\\", "\\\\") + ")\\\\Q");
            }
            matcher.appendTail(stringBuffer);
            stringBuffer.append("\\E$");
            this.pattern = Pattern.compile(stringBuffer.toString());
        }

        public Route matches(HttpServletRequest httpServletRequest, String string) throws IOException {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                Object object;
                String string2;
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                for (int i = 0; i < this.names.size(); ++i) {
                    string2 = this.names.get(i);
                    object = matcher.group(i + 1);
                    if (hashMap.containsKey(string2)) {
                        Object v = hashMap.get(string2);
                        if (v instanceof List) {
                            ((List)v).add(object);
                            continue;
                        }
                        ArrayList<Object> arrayList = new ArrayList<Object>(2);
                        arrayList.add(v);
                        arrayList.add(object);
                        continue;
                    }
                    hashMap.put(string2, object);
                }
                String string3 = httpServletRequest.getParameter("_method");
                if (string3 == null) {
                    string3 = httpServletRequest.getMethod();
                }
                if (string3 != null) {
                    string3 = string3.toUpperCase();
                }
                if (this.verb != null && !this.verb.contains(string3)) {
                    string3 = null;
                } else if (!this.config.verb.contains(string3)) {
                    string3 = null;
                }
                string2 = hashMap.get("method");
                if (string2 instanceof List) {
                    object = (List)((Object)string2);
                    String string4 = string2 = !object.isEmpty() ? (String)object.get(0) : null;
                }
                if (string2 == null && this.method != null) {
                    string2 = this.method.get(string3);
                }
                if (string2 == null) {
                    string2 = this.config.method.get(string3);
                }
                RouteMapping.parseParameter(httpServletRequest.getParameterMap(), hashMap);
                return new Route(string3, string2, this.target, hashMap);
            }
            return null;
        }

        static void parseParameter(Map<String, String[]> map, Map<Object, Object> stringArray) {
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                String[] stringArray2;
                Object object;
                Object object2;
                String string = entry.getKey();
                boolean bl = false;
                if (string.endsWith("[]")) {
                    string = string.substring(0, string.length() - 2);
                    bl = true;
                }
                String[] stringArray3 = entry.getValue();
                int n = 0;
                int n2 = 0;
                String[] stringArray4 = stringArray;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '.' || c == '[') {
                        object2 = string.substring(n, n2 == 93 ? i - 1 : i);
                        object = stringArray4.get(object2);
                        if (object instanceof Map) {
                            stringArray4 = (String[])object;
                        } else {
                            stringArray2 = new LinkedHashMap();
                            if (object != null) {
                                stringArray2.put(null, object);
                            }
                            stringArray4.put(object2, stringArray2);
                            stringArray4 = stringArray2;
                        }
                        n = i + 1;
                    }
                    n2 = c;
                }
                string = string.substring(n, n2 == 93 ? string.length() - 1 : string.length());
                Object object3 = string;
                if (string.length() > 0 && string.charAt(0) >= '0' && string.charAt(0) >= '9') {
                    try {
                        object3 = new BigDecimal(string);
                    }
                    catch (Exception exception) {
                        object3 = string;
                    }
                }
                if (stringArray4.containsKey(object3)) {
                    Object object4 = stringArray4.get(object3);
                    if (object4 instanceof Map) {
                        String string2;
                        int n3;
                        int n4;
                        object2 = (Map)object4;
                        if (object2.containsKey(null)) {
                            object4 = object2.get(null);
                            if (object4 instanceof List) {
                                object = (List)object4;
                                stringArray2 = stringArray3;
                                n4 = stringArray2.length;
                                for (n3 = 0; n3 < n4; ++n3) {
                                    string2 = stringArray2[n3];
                                    object.add(string2);
                                }
                                continue;
                            }
                            object = new ArrayList(stringArray3.length + 1);
                            object.add(object4);
                            stringArray2 = stringArray3;
                            n4 = stringArray2.length;
                            for (n3 = 0; n3 < n4; ++n3) {
                                string2 = stringArray2[n3];
                                object.add(string2);
                            }
                            object2.put(null, object);
                            continue;
                        }
                        if (bl || stringArray3.length > 1) {
                            object = new ArrayList(stringArray3.length);
                            stringArray2 = stringArray3;
                            n4 = stringArray2.length;
                            for (n3 = 0; n3 < n4; ++n3) {
                                string2 = stringArray2[n3];
                                object.add(string2);
                            }
                            object2.put(null, object);
                            continue;
                        }
                        object2.put(null, stringArray3.length > 0 ? stringArray3[0] : null);
                        continue;
                    }
                    if (object4 instanceof List) {
                        object2 = (List)object4;
                        for (String string3 : stringArray3) {
                            object2.add(string3);
                        }
                        continue;
                    }
                    object2 = new ArrayList(stringArray3.length + 1);
                    object2.add(object4);
                    for (String string4 : stringArray3) {
                        object2.add(string4);
                    }
                    stringArray4.put(object3, object2);
                    continue;
                }
                if (bl || stringArray3.length > 1) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(stringArray3.length);
                    for (String string5 : stringArray3) {
                        arrayList.add(string5);
                    }
                    stringArray4.put(object3, arrayList);
                    continue;
                }
                stringArray4.put(object3, stringArray3.length > 0 ? stringArray3[0] : null);
            }
        }
    }

    static class Config {
        public Class<? extends Container> container;
        @JSONHint(anonym="target")
        public Map<String, RouteMapping> mappings;
        public Map<String, Pattern> definitions;
        public Map<String, Integer> errors;
        public Map<String, String> method;
        public Set<String> verb;

        Config() {
        }
    }
}

