/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.AbstractDragControler;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableDragSource;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DragControlerGlassPane;
import com.vlsolutions.swing.docking.ShapeOutlinePainter;
import com.vlsolutions.swing.docking.ShapePainterStrategy;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class HeavyWeightDragControler
extends AbstractDragControler {
    private boolean paintBackgroundUnderDragRect = UIManager.getBoolean("DragControler.paintBackgroundUnderDragRect");

    HeavyWeightDragControler(DockingDesktop desktop) {
        super(desktop);
    }

    @Override
    protected Component findComponentAt(Container container, int x, int y) {
        Rectangle bounds = new Rectangle();
        int count = container.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = container.getComponent(i);
            if (!child.isVisible()) continue;
            child.getBounds(bounds);
            if (!bounds.contains(x, y)) continue;
            if (child instanceof Container) {
                Component found = this.findComponentAt((Container)child, x - bounds.x, y - bounds.y);
                if (found != null) {
                    return found;
                }
                return child;
            }
            if (child instanceof HeavyShape || child instanceof HeavyLabel) continue;
            return child;
        }
        return null;
    }

    @Override
    protected ShapePainterStrategy createShapePainterStrategy(Window w) {
        return new HWShapePainterStrategy(w);
    }

    @Override
    public Dockable getDockable() {
        if (this.dockableDragSource != null) {
            return this.dockableDragSource.getDockable();
        }
        return null;
    }

    private class HeavyLabel
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private Color textColor = Color.WHITE;
        private Color textFillColor = new Color(128, 128, 128);
        private Color textBorderColor = new Color(64, 64, 64);
        private String name;
        private Icon icon;

        public HeavyLabel() {
            this.setEnabled(false);
        }

        public void setZOrder() {
            try {
                Method m = Container.class.getMethod("setComponentZOrder", Component.class, Integer.TYPE);
                m.invoke((Object)this.getParent(), this, new Integer(0));
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public void moveToCenter(Rectangle shapeBounds) {
            Font f = this.getFont();
            if (f != null) {
                FontMetrics fm = this.getFontMetrics(f);
                int w = fm.stringWidth(this.name) + 10;
                int h = fm.getHeight() + 5;
                this.setBounds(shapeBounds.x + shapeBounds.width / 2 - w / 2, shapeBounds.y + shapeBounds.height / 2 - h / 2, w, h);
            }
        }

        @Override
        public void paint(Graphics g) {
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(this.name);
            int h = fm.getHeight();
            g.setColor(this.textFillColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.textBorderColor);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(this.textColor);
            g.drawString(this.name, this.getWidth() / 2 - w / 2, this.getHeight() / 2 + h / 2);
        }
    }

    private class HeavyShape
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private Rectangle cachedShapeBounds;
        private BufferedImage desktopImage;
        private Image subImage;
        private Rectangle subImageBounds;
        private ShapeOutlinePainter outlinePainter = new ShapeOutlinePainter();
        private HeavyLabel label = new HeavyLabel();

        public HeavyShape() {
            this.setEnabled(false);
        }

        public void setZOrder() {
            try {
                Method m = Container.class.getMethod("setComponentZOrder", Component.class, Integer.TYPE);
                m.invoke((Object)this.getParent(), this, new Integer(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.label.setZOrder();
        }

        private void startDrag() {
            Container parent = this.getParent();
            if (HeavyWeightDragControler.this.paintBackgroundUnderDragRect) {
                if (this.desktopImage == null || this.desktopImage.getWidth() != parent.getWidth() || this.desktopImage.getHeight() != parent.getHeight()) {
                    this.desktopImage = (BufferedImage)parent.createImage(parent.getWidth(), parent.getHeight());
                    this.subImage = null;
                }
                Graphics g = this.desktopImage.getGraphics();
                parent.paint(g);
                g.dispose();
            }
        }

        @Override
        public void paint(Graphics g) {
            if (HeavyWeightDragControler.this.dropShape != null) {
                Point p = SwingUtilities.convertPoint((Component)((Object)HeavyWeightDragControler.this.dropReceiver), 0, 0, this.getParent());
                Rectangle r = HeavyWeightDragControler.this.dropShape.getBounds();
                int shapeX = r.x;
                int shapeY = r.y;
                if (HeavyWeightDragControler.this.paintBackgroundUnderDragRect) {
                    r.x += p.x;
                    r.y += p.y;
                    r.width += 2;
                    r.height += 2;
                    if (r.x + r.width > this.desktopImage.getWidth()) {
                        r.width = this.desktopImage.getWidth() - r.x;
                    }
                    if (r.y + r.height > this.desktopImage.getHeight()) {
                        r.height = this.desktopImage.getHeight() - r.y;
                    }
                    if (this.subImage == null || !r.equals(this.subImageBounds)) {
                        this.subImageBounds = r;
                        this.subImage = this.desktopImage.getSubimage(r.x, r.y, r.width, r.height);
                    }
                    g.drawImage(this.subImage, 0, 0, null);
                }
                Shape s = AffineTransform.getTranslateInstance(-shapeX, -shapeY).createTransformedShape(HeavyWeightDragControler.this.dropShape);
                Graphics2D g2 = (Graphics2D)g;
                this.outlinePainter.paintShape(g2, s);
            }
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.label.setVisible(visible);
        }

        @Override
        public void setCursor(Cursor cursor) {
            super.setCursor(cursor);
            this.label.setCursor(cursor);
        }

        public void moveToShape(Shape newShape) {
            this.setVisible(true);
            Shape s = HeavyWeightDragControler.this.dropShape;
            Container container = this.getParent();
            Point p = SwingUtilities.convertPoint((Component)((Object)HeavyWeightDragControler.this.dropReceiver), 0, 0, container);
            Rectangle r = HeavyWeightDragControler.this.dropShape.getBounds();
            r.x += p.x;
            r.y += p.y;
            r.width += 2;
            r.height += 2;
            if (r.x + r.width > container.getWidth()) {
                r.width = container.getWidth() - r.x;
            }
            if (r.y + r.height > container.getHeight()) {
                r.height = container.getHeight() - r.y;
            }
            if (!r.equals(this.cachedShapeBounds)) {
                this.setBounds(r);
                this.cachedShapeBounds = r;
                this.label.moveToCenter(r);
            }
        }
    }

    private class HWShapePainterStrategy
    implements ShapePainterStrategy {
        private DragControlerGlassPane dragGlassPane;
        private Component oldGlassPane;
        private boolean oldGlassPaneVisible;
        private Window window;
        private boolean isDragStarted;
        private HeavyShape heavyShape;

        public HWShapePainterStrategy(Window window) {
            this.dragGlassPane = new DragControlerGlassPane(HeavyWeightDragControler.this);
            this.oldGlassPane = null;
            this.oldGlassPaneVisible = false;
            this.window = null;
            this.isDragStarted = false;
            this.window = window;
            this.dragGlassPane.setPaintShapes(false);
            this.heavyShape = new HeavyShape();
        }

        @Override
        public void showDragCursor() {
            this.dragGlassPane.showDragCursor();
            this.heavyShape.setCursor(this.dragGlassPane.getCursor());
        }

        @Override
        public void showStopDragCursor() {
            this.dragGlassPane.showStopDragCursor();
            this.heavyShape.setCursor(this.dragGlassPane.getCursor());
        }

        @Override
        public void showSwapDragCursor() {
            this.dragGlassPane.showSwapDragCursor();
            this.heavyShape.setCursor(this.dragGlassPane.getCursor());
        }

        @Override
        public void showFloatCursor() {
            this.dragGlassPane.showFloatCursor();
            this.heavyShape.setCursor(this.dragGlassPane.getCursor());
        }

        @Override
        public void repaint() {
            if (HeavyWeightDragControler.this.dropShape != null) {
                this.heavyShape.moveToShape(HeavyWeightDragControler.this.dropShape);
            } else if (this.heavyShape.isVisible()) {
                this.heavyShape.setVisible(false);
            }
        }

        @Override
        public void startDrag(DockableDragSource source) {
            if (this.isDragStarted || source == null) {
                return;
            }
            Window aboveWindow = this.window;
            this.isDragStarted = true;
            if (this.heavyShape.getParent() == null) {
                if (aboveWindow instanceof JFrame) {
                    JFrame fr = (JFrame)aboveWindow;
                    fr.getLayeredPane().add((Component)this.heavyShape, JLayeredPane.DRAG_LAYER);
                    this.heavyShape.validate();
                    fr.getLayeredPane().add((Component)this.heavyShape.label, JLayeredPane.DRAG_LAYER);
                } else if (aboveWindow instanceof JDialog) {
                    JDialog dlg = (JDialog)aboveWindow;
                    dlg.getLayeredPane().add((Component)this.heavyShape, JLayeredPane.DRAG_LAYER);
                    this.heavyShape.validate();
                    dlg.getLayeredPane().add((Component)this.heavyShape.label, JLayeredPane.DRAG_LAYER);
                }
                this.heavyShape.setZOrder();
            }
            this.heavyShape.label.setName(source.getDockable().getDockKey().getName());
            this.heavyShape.startDrag();
            if (aboveWindow instanceof JFrame) {
                this.oldGlassPane = ((JFrame)aboveWindow).getGlassPane();
                this.oldGlassPaneVisible = this.oldGlassPane.isVisible();
                ((JFrame)aboveWindow).setGlassPane(this.dragGlassPane);
                this.dragGlassPane.setVisible(true);
            } else if (aboveWindow instanceof JDialog) {
                this.oldGlassPane = ((JDialog)aboveWindow).getGlassPane();
                this.oldGlassPaneVisible = this.oldGlassPane.isVisible();
                ((JDialog)aboveWindow).setGlassPane(this.dragGlassPane);
                this.dragGlassPane.setVisible(true);
            }
        }

        @Override
        public void endDrag() {
            this.heavyShape.setVisible(false);
            Window aboveWindow = this.window;
            if (aboveWindow instanceof JFrame) {
                ((JFrame)aboveWindow).setGlassPane(this.oldGlassPane);
            } else if (aboveWindow instanceof JDialog) {
                ((JDialog)aboveWindow).setGlassPane(this.oldGlassPane);
            }
            this.oldGlassPane.setVisible(this.oldGlassPaneVisible);
            this.isDragStarted = false;
        }
    }
}

