/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.util;

import java.util.Arrays;

public class CharsCharSequence
implements CharSequence {
    private char[] chars;
    private int start;
    private int end;

    public CharsCharSequence(char[] chars) {
        this(chars, 0, chars.length);
    }

    public CharsCharSequence(char[] chars, int start, int end) {
        if (chars.length < end) {
            throw new ArrayIndexOutOfBoundsException(end);
        }
        this.chars = chars;
        this.start = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        int i = this.start + index;
        if (i >= this.end) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.chars[i];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharsCharSequence(this.chars, this.start + start, this.start + end);
    }

    public char[] toCharArray() {
        return Arrays.copyOfRange(this.chars, this.start, this.end);
    }

    public char[] subChars(int start, int end) {
        int e = this.start + end;
        if (e >= end) {
            throw new ArrayIndexOutOfBoundsException(e);
        }
        return Arrays.copyOfRange(this.chars, this.start + start, this.start + end);
    }
}

