/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.theme;

import java.awt.Color;
import java.awt.Toolkit;
import java.io.IOException;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.omegat.gui.theme.DelegatingLookAndFeel;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.gui.ResourcesUtil;
import org.omegat.util.gui.RoundedCornerBorder;
import org.omegat.util.gui.UIDesignManager;

public class DefaultFlatTheme
extends DelegatingLookAndFeel {
    private static final String NAME = OStrings.getString("THEME_OMEGAT_DEFAULT_NAME");

    public static void loadPlugins() {
        UIManager.installLookAndFeel(NAME, DefaultFlatTheme.class.getName());
    }

    public static void unloadPlugins() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getID() {
        return "OmegaT";
    }

    @Override
    public String getDescription() {
        return OStrings.getString("THEME_OMEGAT_DEFAULT_DESCRIPTION");
    }

    @Override
    public UIDefaults getDefaults() {
        return DefaultFlatTheme.setDefaults(this.systemLookAndFeel.getDefaults(), this.systemLookAndFeel.getID());
    }

    public static UIDefaults setDefaults(UIDefaults defaults, String lafId) {
        Color standardBgColor = defaults.getColor("Panel.background");
        Color activeTitleBgColor = DefaultFlatTheme.adjustRGB(standardBgColor, 8);
        Color bottomAreaBgColor = DefaultFlatTheme.adjustRGB(standardBgColor, -16);
        Color borderColor = DefaultFlatTheme.adjustRGB(standardBgColor, -83);
        defaults.put("OmegaTBorder.color", borderColor);
        Color statusAreaColor = DefaultFlatTheme.adjustRGB(standardBgColor, -151);
        try {
            UIDesignManager.loadDefaultColors(defaults);
        }
        catch (IOException e) {
            Log.log(e);
        }
        UIManager.put("VLDocking.highlight", activeTitleBgColor);
        UIManager.put("VLDocking.shadow", statusAreaColor);
        int outside = 5;
        UIManager.put("DockingDesktop.border", new EmptyBorder(outside, outside, outside, outside));
        int panel = 2;
        UIManager.put("DockView.singleDockableBorder", new EmptyBorder(panel, panel, panel, panel));
        int maxPanel = outside + panel;
        UIManager.put("DockView.maximizedDockableBorder", new EmptyBorder(maxPanel, maxPanel, maxPanel, maxPanel));
        defaults.put("OmegaTDockablePanel.border", new MatteBorder(1, 1, 1, 1, borderColor));
        defaults.put("OmegaTDockablePanelViewport.border", new EmptyBorder(0, 0, 0, 0));
        defaults.put("OmegaTDockablePanel.isProportionalMargins", (Object)true);
        if (Platform.isMacOSX()) {
            UIManager.put("DockView.tabbedDockableBorder", new MatteBorder(0, 5, 5, 5, new Color(0xE6E6E6)));
        } else if (DefaultFlatTheme.isWindowsLAF(lafId) && !DefaultFlatTheme.isWindowsClassicLAF(lafId)) {
            UIManager.put("DockView.tabbedDockableBorder", new MatteBorder(2, 5, 5, 5, Color.WHITE));
        } else {
            UIManager.put("DockView.tabbedDockableBorder", new MatteBorder(5, 5, 5, 5, standardBgColor));
        }
        int cornerRadius = DefaultFlatTheme.isFlatWindows() ? 0 : 8;
        Color activeTitleText = defaults.getColor("Label.foreground");
        Color inactiveTitleText = DefaultFlatTheme.adjustRGB(activeTitleText, 128);
        UIManager.put("DockViewTitleBar.border", new RoundedCornerBorder(cornerRadius, borderColor, 0));
        defaults.put("InternalFrame.activeTitleForeground", activeTitleText);
        defaults.put("InternalFrame.activeTitleBackground", activeTitleBgColor);
        defaults.put("InternalFrame.inactiveTitleForeground", inactiveTitleText);
        defaults.put("InternalFrame.inactiveTitleBackground", standardBgColor);
        UIManager.put("DockViewTitleBar.disableCustomPaint", true);
        UIManager.put("AutoHideButtonPanel.bottomBorder", new CompoundBorder(new MatteBorder(1, 0, 0, 0, borderColor), new EmptyBorder(0, 2 * outside, 0, 2 * outside)));
        UIManager.put("AutoHideButtonPanel.background", bottomAreaBgColor);
        UIManager.put("AutoHideButton.expandBorderBottom", new RoundedCornerBorder(cornerRadius, borderColor, 2));
        UIManager.put("AutoHideButton.background", standardBgColor);
        defaults.put("OmegaTStatusArea.border", new MatteBorder(1, 1, 1, 1, statusAreaColor));
        defaults.put("OmegaTMainWindowBottomMargin.border", new EmptyBorder(0, 2 * outside, outside, 2 * outside));
        defaults.put("OmegaTEditorFilter.border", new MatteBorder(1, 1, 0, 1, borderColor));
        defaults.put("activeCaption", Color.WHITE);
        defaults.put("activeCaptionBorder", borderColor);
        defaults.put("inactiveCaption", standardBgColor);
        defaults.put("inactiveCaptionBorder", borderColor);
        UIManager.put("DockViewTitleBar.maximize", DefaultFlatTheme.getIcon("appbar.app.tall.inactive.png"));
        UIManager.put("DockViewTitleBar.maximize.rollover", DefaultFlatTheme.getIcon("appbar.app.tall.png"));
        UIManager.put("DockViewTitleBar.maximize.pressed", DefaultFlatTheme.getIcon("appbar.app.tall.pressed.png"));
        UIManager.put("DockViewTitleBar.restore", DefaultFlatTheme.getIcon("appbar.window.restore.inactive.png"));
        UIManager.put("DockViewTitleBar.restore.rollover", DefaultFlatTheme.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.restore.pressed", DefaultFlatTheme.getIcon("appbar.window.restore.pressed.png"));
        UIManager.put("DockViewTitleBar.hide", DefaultFlatTheme.getIcon("appbar.hide.inactive.png"));
        UIManager.put("DockViewTitleBar.hide.rollover", DefaultFlatTheme.getIcon("appbar.hide.png"));
        UIManager.put("DockViewTitleBar.hide.pressed", DefaultFlatTheme.getIcon("appbar.hide.pressed.png"));
        UIManager.put("DockViewTitleBar.float", DefaultFlatTheme.getIcon("appbar.fullscreen.inactive.png"));
        UIManager.put("DockViewTitleBar.float.rollover", DefaultFlatTheme.getIcon("appbar.fullscreen.png"));
        UIManager.put("DockViewTitleBar.float.pressed", DefaultFlatTheme.getIcon("appbar.fullscreen.pressed.png"));
        UIManager.put("DockViewTitleBar.dock", DefaultFlatTheme.getIcon("appbar.window.restore.inactive.png"));
        UIManager.put("DockViewTitleBar.dock.rollover", DefaultFlatTheme.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.dock.pressed", DefaultFlatTheme.getIcon("appbar.window.restore.pressed.png"));
        UIManager.put("DockViewTitleBar.attach", DefaultFlatTheme.getIcon("appbar.dock.window.inactive.png"));
        UIManager.put("DockViewTitleBar.attach.rollover", DefaultFlatTheme.getIcon("appbar.dock.window.png"));
        UIManager.put("DockViewTitleBar.attach.pressed", DefaultFlatTheme.getIcon("appbar.dock.window.pressed.png"));
        UIManager.put("DockViewTitleBar.menu.hide", DefaultFlatTheme.getIcon("appbar.hide.png"));
        UIManager.put("DockViewTitleBar.menu.maximize", DefaultFlatTheme.getIcon("appbar.app.tall.png"));
        UIManager.put("DockViewTitleBar.menu.restore", DefaultFlatTheme.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.menu.dock", DefaultFlatTheme.getIcon("appbar.window.restore.png"));
        UIManager.put("DockViewTitleBar.menu.float", DefaultFlatTheme.getIcon("appbar.fullscreen.png"));
        UIManager.put("DockViewTitleBar.menu.attach", DefaultFlatTheme.getIcon("appbar.dock.window.png"));
        UIManager.put("DockTabbedPane.menu.hide", DefaultFlatTheme.getIcon("appbar.hide.png"));
        UIManager.put("DockTabbedPane.menu.maximize", DefaultFlatTheme.getIcon("appbar.app.tall.png"));
        UIManager.put("DockTabbedPane.menu.float", DefaultFlatTheme.getIcon("appbar.fullscreen.png"));
        UIManager.put("DragControler.detachCursor", ResourcesUtil.getBundledImage("appbar.fullscreen.cursor32x32.png"));
        if (Platform.isMacOSX()) {
            UIManager.put("DockViewTitleBar.maximize", DefaultFlatTheme.getIcon("appbar.fullscreen.corners.inactive.png"));
            UIManager.put("DockViewTitleBar.maximize.rollover", DefaultFlatTheme.getIcon("appbar.fullscreen.corners.png"));
            UIManager.put("DockViewTitleBar.maximize.pressed", DefaultFlatTheme.getIcon("appbar.fullscreen.corners.pressed.png"));
            UIManager.put("DockViewTitleBar.restore", DefaultFlatTheme.getIcon("appbar.restore.corners.inactive.png"));
            UIManager.put("DockViewTitleBar.restore.rollover", DefaultFlatTheme.getIcon("appbar.restore.corners.png"));
            UIManager.put("DockViewTitleBar.restore.pressed", DefaultFlatTheme.getIcon("appbar.restore.corners.pressed.png"));
            UIManager.put("DockViewTitleBar.hide", DefaultFlatTheme.getIcon("appbar.minus.inactive.png"));
            UIManager.put("DockViewTitleBar.hide.rollover", DefaultFlatTheme.getIcon("appbar.minus.png"));
            UIManager.put("DockViewTitleBar.hide.pressed", DefaultFlatTheme.getIcon("appbar.minus.pressed.png"));
            UIManager.put("DockViewTitleBar.menu.hide", DefaultFlatTheme.getIcon("appbar.minus.png"));
            UIManager.put("DockViewTitleBar.menu.maximize", DefaultFlatTheme.getIcon("appbar.fullscreen.corners.png"));
            UIManager.put("DockViewTitleBar.menu.restore", DefaultFlatTheme.getIcon("appbar.restore.corners.png"));
            UIManager.put("DockTabbedPane.menu.hide", DefaultFlatTheme.getIcon("appbar.minus.png"));
            UIManager.put("DockTabbedPane.menu.maximize", DefaultFlatTheme.getIcon("appbar.fullscreen.corners.png"));
            UIManager.put("DragControler.detachCursor", ResourcesUtil.getBundledImage("appbar.fullscreen.png"));
        }
        return defaults;
    }

    private static Color adjustRGB(Color color, int adjustment) {
        Color result = new Color(Math.max(0, Math.min(255, color.getRed() + adjustment)), Math.max(0, Math.min(255, color.getGreen() + adjustment)), Math.max(0, Math.min(255, color.getBlue() + adjustment)));
        return result;
    }

    private static boolean isWindowsLAF(String systemID) {
        return systemID.equals("Windows");
    }

    private static boolean isWindowsClassicLAF(String systemID) {
        return DefaultFlatTheme.isWindowsLAF(systemID) && (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive") == false;
    }

    private static boolean isFlatWindows() {
        return System.getProperty("os.name").startsWith("Windows") && System.getProperty("os.version").matches("6\\.[23]|10\\..*");
    }
}

