/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import org.omegat.util.PatternConsts;

public class XMLReader
extends Reader {
    private BufferedReader reader;
    private String encoding;
    private String eol;
    boolean readFirstTime = true;

    public String getEncoding() {
        return this.encoding;
    }

    public String getEol() {
        return this.eol;
    }

    public XMLReader(InputStream is) throws IOException {
        this.reader = this.createReader(is, this.encoding);
    }

    public XMLReader(File file) throws IOException {
        this(file, null);
    }

    public XMLReader(File file, String encoding) throws IOException {
        this.reader = this.createReader(new FileInputStream(file), encoding);
    }

    private BufferedReader createReader(InputStream in, String defaultEncoding) throws IOException {
        String buffer;
        Matcher matcherXml;
        BufferedInputStream is = new BufferedInputStream(in);
        is.mark(65536);
        int char1 = is.read();
        int char2 = is.read();
        int char3 = is.read();
        this.encoding = null;
        if (char1 == 254 && char2 == 255) {
            this.encoding = "UTF-16BE";
        }
        if (char1 == 255 && char2 == 254) {
            this.encoding = "UTF-16LE";
        }
        if (char1 == 239 && char2 == 187 && char3 == 191) {
            this.encoding = "UTF-8";
        }
        is.reset();
        if (this.encoding != null) {
            return this.createReaderAndDetectEOL(is, this.encoding);
        }
        is.mark(65536);
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        if (len > 0 && (matcherXml = PatternConsts.XML_ENCODING.matcher(buffer = defaultEncoding == null ? new String(buf, 0, len, Charset.defaultCharset()) : new String(buf, 0, len, defaultEncoding))).find()) {
            this.encoding = matcherXml.group(1);
        }
        is.reset();
        if (this.encoding != null) {
            return this.createReaderAndDetectEOL(is, this.encoding);
        }
        try {
            return this.createReaderAndDetectEOL(is, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            return this.createReaderAndDetectEOL(is, null);
        }
    }

    private BufferedReader createReaderAndDetectEOL(InputStream is, String encoding) throws IOException {
        InputStreamReader isr = encoding == null ? new InputStreamReader(is, Charset.defaultCharset()) : new InputStreamReader(is, encoding);
        BufferedReader rd = new BufferedReader(isr, 65536);
        rd.mark(65536);
        for (int i = 0; i < 65536; ++i) {
            char ch = (char)rd.read();
            if (ch == '\r' || ch == '\n') {
                if (this.eol == null) {
                    this.eol = "";
                } else if (this.eol.codePointAt(0) == ch) {
                    rd.reset();
                    return rd;
                }
                this.eol = this.eol + ch;
                if (this.eol.codePointCount(0, this.eol.length()) != 2) continue;
                rd.reset();
                return rd;
            }
            if (this.eol == null) continue;
            rd.reset();
            return rd;
        }
        this.eol = "\n";
        rd.reset();
        return rd;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.readFirstTime) {
            this.readFirstTime = false;
            this.reader.mark(1);
            int ch = this.reader.read();
            if (ch != 65279) {
                this.reader.reset();
            }
        }
        return this.reader.read(cbuf, off, len);
    }
}

