/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.externalfinder.ExternalFinder;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.externalfinder.item.ExternalFinderItemCommand;
import org.omegat.externalfinder.item.ExternalFinderItemURL;
import org.omegat.externalfinder.item.IExternalFinderItemMenuGenerator;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DesktopWrapper;
import org.openide.awt.Mnemonics;

public class ExternalFinderItemMenuGenerator
implements IExternalFinderItemMenuGenerator {
    private final ExternalFinderItem.TARGET target;
    private final boolean popup;

    public ExternalFinderItemMenuGenerator(ExternalFinderItem.TARGET target, boolean popup) {
        this.target = target;
        this.popup = popup;
    }

    @Override
    public List<JMenuItem> generate() {
        List<ExternalFinderItem> finderItems = ExternalFinder.getItems();
        if (finderItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        for (ExternalFinderItem finderItem : finderItems) {
            if (this.popup && finderItem.isNopopup() || this.target == ExternalFinderItem.TARGET.ASCII_ONLY && finderItem.isNonAsciiOnly() || this.target == ExternalFinderItem.TARGET.NON_ASCII_ONLY && finderItem.isAsciiOnly()) continue;
            JMenuItem item = new JMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)item, (String)finderItem.getName());
            if (!this.popup) {
                item.setAccelerator(finderItem.getKeystroke());
            }
            item.addActionListener(new ExternalFinderItemActionListener(finderItem));
            menuItems.add(item);
        }
        return menuItems;
    }

    private static class ExternalFinderItemActionListener
    implements ActionListener {
        private final ExternalFinderItem.SCOPE scope;
        private final List<ExternalFinderItemURL> urls;
        private final List<ExternalFinderItemCommand> commands;

        ExternalFinderItemActionListener(ExternalFinderItem finderItem) {
            this.urls = finderItem.getURLs();
            this.commands = finderItem.getCommands();
            this.scope = finderItem.getScope();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selection = Core.getEditor().getSelectedText();
            if (selection == null) {
                return;
            }
            String targetWords = selection;
            boolean isASCII = ExternalFinderItem.isASCII(targetWords);
            new Thread(() -> {
                for (ExternalFinderItemURL url : this.urls) {
                    if (isASCII && url.getTarget() == ExternalFinderItem.TARGET.NON_ASCII_ONLY || !isASCII && url.getTarget() == ExternalFinderItem.TARGET.ASCII_ONLY) continue;
                    try {
                        DesktopWrapper.browse(url.generateURL(targetWords));
                    }
                    catch (Exception ex) {
                        Logger.getLogger(ExternalFinderItemMenuGenerator.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
                    }
                }
            }).start();
            new Thread(() -> {
                for (ExternalFinderItemCommand command : this.commands) {
                    if (isASCII && command.getTarget() == ExternalFinderItem.TARGET.NON_ASCII_ONLY || !isASCII && command.getTarget() == ExternalFinderItem.TARGET.ASCII_ONLY) continue;
                    if (this.scope == ExternalFinderItem.SCOPE.PROJECT && !Preferences.isPreference("external_finder_allow_project_commands")) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), OStrings.getString("EXTERNALFINDER_PROJECT_COMMANDS_DISALLOWED_MESSAGE"), OStrings.getString("ERROR_TITLE"), 0);
                        return;
                    }
                    try {
                        Runtime.getRuntime().exec(command.generateCommand(targetWords));
                    }
                    catch (Exception ex) {
                        Logger.getLogger(ExternalFinderItemMenuGenerator.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
                    }
                }
            }).start();
        }
    }
}

