/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.xsd.ChildType;
import com.thaiopensource.relaxng.output.xsd.SchemaInfo;
import com.thaiopensource.util.VoidValue;
import java.util.HashSet;
import java.util.Set;

public class RestrictionsChecker {
    private final SchemaInfo si;
    private final ErrorReporter er;
    private final Set<Pattern> checkedPatterns = new HashSet<Pattern>();
    private static final int DISALLOW_ELEMENT = 1;
    private static final int DISALLOW_ATTRIBUTE = 2;
    private static final int DISALLOW_LIST = 4;
    private static final int DISALLOW_TEXT = 8;
    private static final int DISALLOW_EMPTY = 16;
    private static final int DISALLOW_DATA = 32;
    private static final int DISALLOW_GROUP = 64;
    private static final int DISALLOW_INTERLEAVE = 128;
    private static final int DISALLOW_ONE_OR_MORE = 256;
    private static final int START_DISALLOW = 510;
    private static final int LIST_DISALLOW = 143;
    private static final int DATA_EXCEPT_DISALLOW = 479;
    private static final int ATTRIBUTE_DISALLOW = 3;
    private final PatternVisitor<VoidValue> startVisitor = new Visitor("start", 510);
    private final PatternVisitor<VoidValue> topLevelVisitor = new ListVisitor(null, 0);
    private final PatternVisitor<VoidValue> elementVisitor = new ElementVisitor();
    private final PatternVisitor<VoidValue> elementRepeatVisitor = new ElementRepeatVisitor();
    private final PatternVisitor<VoidValue> elementRepeatGroupVisitor = new Visitor("element_repeat_group", 2);
    private final PatternVisitor<VoidValue> elementRepeatInterleaveVisitor = new Visitor("element_repeat_interleave", 2);
    private final PatternVisitor<VoidValue> attributeVisitor = new Visitor("attribute", 3);
    private final PatternVisitor<VoidValue> listVisitor = new ListVisitor("list", 143);
    private final PatternVisitor<VoidValue> dataExceptVisitor = new Visitor("data_except", 479);

    private RestrictionsChecker(SchemaInfo schemaInfo, ErrorReporter errorReporter) {
        this.si = schemaInfo;
        this.er = errorReporter;
        Pattern pattern = schemaInfo.getStart();
        if (pattern != null) {
            pattern.accept(this.startVisitor);
        }
        schemaInfo.getGrammar().componentsAccept(new GrammarVisitor());
    }

    static void check(SchemaInfo schemaInfo, ErrorReporter errorReporter) {
        new RestrictionsChecker(schemaInfo, errorReporter);
    }

    private boolean alreadyChecked(Pattern pattern) {
        if (this.checkedPatterns.contains(pattern)) {
            return true;
        }
        this.checkedPatterns.add(pattern);
        return false;
    }

    class Visitor
    extends AbstractVisitor {
        private final String contextKey;
        private final int flags;

        Visitor(String string, int n) {
            this.contextKey = string;
            this.flags = n;
        }

        private boolean checkContext(int n, String string, Pattern pattern) {
            if ((this.flags & n) != 0) {
                RestrictionsChecker.this.er.error("illegal_contains", RestrictionsChecker.this.er.getLocalizer().message(this.contextKey), string, pattern.getSourceLocation());
                return false;
            }
            return true;
        }

        @Override
        public VoidValue visitGroup(GroupPattern groupPattern) {
            if (this.checkContext(64, "group", groupPattern)) {
                this.checkGroup(groupPattern);
                super.visitGroup(groupPattern);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitInterleave(InterleavePattern interleavePattern) {
            if (this.checkContext(128, "interleave", interleavePattern)) {
                this.checkGroup(interleavePattern);
                super.visitInterleave(interleavePattern);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitElement(ElementPattern elementPattern) {
            if (this.checkContext(1, "element", elementPattern) && !RestrictionsChecker.this.alreadyChecked(elementPattern)) {
                elementPattern.getChild().accept(RestrictionsChecker.this.elementVisitor);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitAttribute(AttributePattern attributePattern) {
            if (this.checkContext(2, "attribute", attributePattern) && !RestrictionsChecker.this.alreadyChecked(attributePattern)) {
                attributePattern.getChild().accept(RestrictionsChecker.this.attributeVisitor);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitData(DataPattern dataPattern) {
            Pattern pattern;
            if (this.checkContext(32, "data", dataPattern) && !RestrictionsChecker.this.alreadyChecked(dataPattern) && (pattern = dataPattern.getExcept()) != null) {
                pattern.accept(RestrictionsChecker.this.dataExceptVisitor);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitValue(ValuePattern valuePattern) {
            this.checkContext(32, "value", valuePattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitList(ListPattern listPattern) {
            if (this.checkContext(4, "list", listPattern) && !RestrictionsChecker.this.alreadyChecked(listPattern)) {
                listPattern.getChild().accept(RestrictionsChecker.this.listVisitor);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitEmpty(EmptyPattern emptyPattern) {
            this.checkContext(16, "empty", emptyPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOptional(OptionalPattern optionalPattern) {
            if (this.checkContext(16, "optional", optionalPattern)) {
                super.visitOptional(optionalPattern);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitText(TextPattern textPattern) {
            this.checkContext(8, "text", textPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitMixed(MixedPattern mixedPattern) {
            if (this.checkContext(8, "mixed", mixedPattern)) {
                if (RestrictionsChecker.this.si.getChildType(mixedPattern.getChild()).contains(ChildType.DATA)) {
                    RestrictionsChecker.this.er.error("mixed_data", mixedPattern.getSourceLocation());
                }
                super.visitMixed(mixedPattern);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            if (this.checkContext(256, "oneOrMore", oneOrMorePattern)) {
                this.checkNoDataUnlessInList(oneOrMorePattern, "oneOrMore");
                super.visitOneOrMore(oneOrMorePattern);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            if (this.checkContext(256, "zeroOrMore", zeroOrMorePattern)) {
                this.checkNoDataUnlessInList(zeroOrMorePattern, "zeroOrMore");
                super.visitZeroOrMore(zeroOrMorePattern);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            return RestrictionsChecker.this.si.getBody(refPattern).accept(this);
        }

        void checkNoDataUnlessInList(UnaryPattern unaryPattern, String string) {
            if (!this.inList() && RestrictionsChecker.this.si.getChildType(unaryPattern.getChild()).contains(ChildType.DATA)) {
                RestrictionsChecker.this.er.error("not_in_list", string, unaryPattern.getSourceLocation());
            }
        }

        void checkGroup(CompositePattern compositePattern) {
            int n = 0;
            boolean bl = false;
            for (Pattern pattern : compositePattern.getChildren()) {
                boolean bl2;
                ChildType childType = RestrictionsChecker.this.si.getChildType(pattern);
                boolean bl3 = childType.contains(ChildType.DATA);
                boolean bl4 = bl2 = childType.contains(ChildType.TEXT) || childType.contains(ChildType.ELEMENT);
                if (bl2 && n > 0 || bl3 && bl) {
                    RestrictionsChecker.this.er.error("group_data_other_children", compositePattern instanceof GroupPattern ? "group" : "interleave", compositePattern.getSourceLocation());
                    return;
                }
                if (bl3) {
                    ++n;
                }
                if (!bl2) continue;
                bl = true;
            }
            if (n > 1) {
                if (compositePattern instanceof InterleavePattern) {
                    RestrictionsChecker.this.er.error("interleave_data", compositePattern.getSourceLocation());
                } else if (!this.inList()) {
                    RestrictionsChecker.this.er.error("group_data", compositePattern.getSourceLocation());
                }
            }
        }

        boolean inList() {
            return false;
        }
    }

    class ListVisitor
    extends Visitor {
        public ListVisitor(String string, int n) {
            super(string, n);
        }

        @Override
        boolean inList() {
            return true;
        }
    }

    class ElementVisitor
    extends Visitor {
        ElementVisitor() {
            super(null, 0);
        }

        @Override
        public VoidValue visitAttribute(AttributePattern attributePattern) {
            attributePattern.getNameClass().accept(this);
            return super.visitAttribute(attributePattern);
        }

        @Override
        public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return (VoidValue)RestrictionsChecker.this.elementRepeatVisitor.visitZeroOrMore(zeroOrMorePattern);
        }

        @Override
        public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return (VoidValue)RestrictionsChecker.this.elementRepeatVisitor.visitOneOrMore(oneOrMorePattern);
        }

        @Override
        public VoidValue visitAnyName(AnyNameNameClass anyNameNameClass) {
            RestrictionsChecker.this.er.error("any_name_attribute_not_repeated", anyNameNameClass.getSourceLocation());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitNsName(NsNameNameClass nsNameNameClass) {
            RestrictionsChecker.this.er.error("ns_name_attribute_not_repeated", nsNameNameClass.getSourceLocation());
            return VoidValue.VOID;
        }
    }

    class ElementRepeatVisitor
    extends Visitor {
        ElementRepeatVisitor() {
            super(null, 0);
        }

        @Override
        public VoidValue visitGroup(GroupPattern groupPattern) {
            return (VoidValue)RestrictionsChecker.this.elementRepeatGroupVisitor.visitGroup(groupPattern);
        }

        @Override
        public VoidValue visitInterleave(InterleavePattern interleavePattern) {
            return (VoidValue)RestrictionsChecker.this.elementRepeatInterleaveVisitor.visitInterleave(interleavePattern);
        }
    }

    class GrammarVisitor
    implements ComponentVisitor<VoidValue> {
        GrammarVisitor() {
        }

        @Override
        public VoidValue visitDiv(DivComponent divComponent) {
            divComponent.componentsAccept(this);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitDefine(DefineComponent defineComponent) {
            if (defineComponent.getName() != DefineComponent.START) {
                defineComponent.getBody().accept(RestrictionsChecker.this.topLevelVisitor);
            }
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitInclude(IncludeComponent includeComponent) {
            RestrictionsChecker.this.si.getSchema(includeComponent.getUri()).componentsAccept(this);
            return VoidValue.VOID;
        }
    }
}

