/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferShort
extends DataBuffer {
    private short[] data;
    private short[][] bankData;

    public final short[] getData() {
        return this.data;
    }

    public final short[] getData(int bank) {
        return this.bankData[bank];
    }

    public final short[][] getBankData() {
        return this.bankData;
    }

    public final int getElem(int i) {
        return this.data[i + this.offset];
    }

    public final int getElem(int bank, int i) {
        return this.bankData[bank][i + this.offsets[bank]];
    }

    public final void setElem(int i, int val) {
        this.data[i + this.offset] = (short)val;
    }

    public final void setElem(int bank, int i, int val) {
        this.bankData[bank][i + this.offsets[bank]] = (short)val;
    }

    public DataBufferShort(int size) {
        super(2, size, 1, 0);
        this.bankData = new short[1][];
        this.data = new short[size];
        this.bankData[0] = this.data;
    }

    public DataBufferShort(int size, int numBanks) {
        super(2, size, numBanks);
        this.bankData = new short[numBanks][size];
        this.data = this.bankData[0];
    }

    public DataBufferShort(short[] dataArray, int size) {
        super(2, size, 1, 0);
        this.bankData = new short[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferShort(short[] dataArray, int size, int offset) {
        super(2, size, 1, offset);
        this.bankData = new short[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferShort(short[][] dataArray, int size) {
        super(2, size, dataArray.length);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public DataBufferShort(short[][] dataArray, int size, int[] offsets) {
        super(2, size, dataArray.length, offsets);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }
}

