/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.references.providers;

import com.intellij.lang.puppet.psi.PuppetDataType;
import com.intellij.lang.puppet.psi.PuppetDataTypeParameterInfo;
import com.intellij.lang.puppet.psi.PuppetElementPatterns;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.lang.puppet.psi.references.PuppetClassDefinitionReference;
import com.intellij.lang.puppet.psi.references.PuppetClassParameterReference;
import com.intellij.lang.puppet.psi.references.PuppetDataTypeReference;
import com.intellij.lang.puppet.psi.references.PuppetFunctionReference;
import com.intellij.lang.puppet.psi.references.PuppetNamespaceReference;
import com.intellij.lang.puppet.psi.references.PuppetResourceInstanceReference;
import com.intellij.lang.puppet.psi.references.PuppetTypeDefinitionReference;
import com.intellij.lang.puppet.psi.references.PuppetTypeParameterReference;
import com.intellij.lang.puppet.psi.references.PuppetVariableReference;
import com.intellij.lang.puppet.util.PuppetQualifiedNamesUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetFullQualifiedNamedElementsReferencesProvider
extends PsiReferenceProvider
implements PuppetElementPatterns {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PuppetDataTypeParameterInfo parameterInfo;
        if (element == null) {
            PuppetFullQualifiedNamedElementsReferencesProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PuppetFullQualifiedNamedElementsReferencesProvider.$$$reportNull$$$0(1);
        }
        if ((parameterInfo = this.getTypeParameterInfo(element)) != null && parameterInfo.isResourceInstance()) {
            String resourceDataType = parameterInfo.getResourceDataType();
            assert (resourceDataType != null);
            PsiReference[] psiReferenceArray = new PsiReference[]{new PuppetResourceInstanceReference(element, resourceDataType)};
            if (psiReferenceArray == null) {
                PuppetFullQualifiedNamedElementsReferencesProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = parameterInfo != null || this.isFullQualifiedElement(element) ? this.getFullQualifiedReferencesForElement(element, parameterInfo) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            PuppetFullQualifiedNamedElementsReferencesProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    public PsiReference[] getFullQualifiedReferencesForElement(@NotNull PsiElement element, @Nullable PuppetDataTypeParameterInfo dataTypeParameterInfo) {
        ElementManipulator manipulator;
        TextRange elementRange;
        if (element == null) {
            PuppetFullQualifiedNamedElementsReferencesProvider.$$$reportNull$$$0(4);
        }
        if ((elementRange = (manipulator = ElementManipulators.getNotNullManipulator((PsiElement)element)).getRangeInElement(element)).isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        List<TextRange> elementRanges = PuppetQualifiedNamesUtil.getQualifiedPartRanges(element, elementRange);
        String elementText = element.getText();
        String textInRange = elementRange.substring(elementText);
        int startOffset = elementRange.getStartOffset();
        if (StringUtil.startsWith((CharSequence)textInRange, (CharSequence)"::")) {
            startOffset += "::".length();
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        int rangesNumber = elementRanges.size();
        for (int i = 0; i < rangesNumber; ++i) {
            TextRange range = elementRanges.get(i);
            if (range.isEmpty()) continue;
            TextRange fullQualifiedRange = TextRange.create((int)startOffset, (int)range.getEndOffset());
            String fullQualifiedName = fullQualifiedRange.substring(elementText);
            Delegation result = i == rangesNumber - 1 ? (dataTypeParameterInfo != null ? (dataTypeParameterInfo.isClass() ? Delegation.CLASS : (dataTypeParameterInfo.isDataType() ? (dataTypeParameterInfo.isResourceType() ? Delegation.RESOURCE_OR_DATA_TYPE : Delegation.DATA_TYPE) : (dataTypeParameterInfo.isResourceType() ? Delegation.RESOURCE_TYPE : Delegation.NONE))) : this.getLastFqnPartDelegation(element, fullQualifiedName)) : Delegation.NAMESPACE;
            if (result == Delegation.NONE) continue;
            PuppetFullQualifiedNamedElementsReferencesProvider.processDelegation(element, references, range, fullQualifiedName, result);
        }
        return references.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static void processDelegation(@NotNull PsiElement element, List<PsiReference> references, TextRange range, String fullQualifiedName, Delegation delegation) {
        if (element == null) {
            PuppetFullQualifiedNamedElementsReferencesProvider.$$$reportNull$$$0(5);
        }
        if (delegation == Delegation.CLASS) {
            references.add((PsiReference)new PuppetClassDefinitionReference(element, range, fullQualifiedName));
        } else if (delegation == Delegation.NAMESPACE) {
            references.add((PsiReference)new PuppetNamespaceReference(element, range, fullQualifiedName));
        } else if (delegation == Delegation.RESOURCE_TYPE) {
            references.add((PsiReference)new PuppetTypeDefinitionReference(element, range, fullQualifiedName));
        } else if (delegation == Delegation.RESOURCE_OR_DATA_TYPE) {
            references.add((PsiReference)new PuppetTypeDefinitionReference(element, range, fullQualifiedName, true));
        } else if (delegation == Delegation.FUNCTION) {
            references.add((PsiReference)new PuppetFunctionReference(element, range, fullQualifiedName));
        } else if (delegation == Delegation.CLASS_PARAMETER) {
            references.add((PsiReference)new PuppetClassParameterReference(element));
        } else if (delegation == Delegation.TYPE_PARAMETER) {
            references.add((PsiReference)new PuppetTypeParameterReference(element));
        } else if (delegation == Delegation.DATA_TYPE) {
            references.add((PsiReference)new PuppetDataTypeReference(element, range, fullQualifiedName));
        } else if (delegation == Delegation.VARIABLE) {
            references.add((PsiReference)new PuppetVariableReference((PuppetVariable)element, range));
        }
    }

    protected boolean isFullQualifiedElement(@NotNull PsiElement element) {
        if (element == null) {
            PuppetFullQualifiedNamedElementsReferencesProvider.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Nullable
    protected PuppetDataTypeParameterInfo getTypeParameterInfo(@NotNull PsiElement element) {
        if (element == null) {
            PuppetFullQualifiedNamedElementsReferencesProvider.$$$reportNull$$$0(7);
        }
        if (!DATA_TYPE_PARAMETER_PATTERN.accepts((Object)element)) {
            return null;
        }
        PuppetDataType containingType = (PuppetDataType)PsiTreeUtil.getParentOfType((PsiElement)element, PuppetDataType.class);
        return containingType == null ? null : containingType.getParameterInfo(element);
    }

    protected abstract Delegation getLastFqnPartDelegation(@NotNull PsiElement var1, String var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/psi/references/providers/PuppetFullQualifiedNamedElementsReferencesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/psi/references/providers/PuppetFullQualifiedNamedElementsReferencesProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFullQualifiedReferencesForElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDelegation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFullQualifiedElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum Delegation {
        NONE,
        CLASS,
        RESOURCE_TYPE,
        RESOURCE_OR_DATA_TYPE,
        CLASS_PARAMETER,
        TYPE_PARAMETER,
        NAMESPACE,
        FUNCTION,
        DATA_TYPE,
        VARIABLE;

    }
}

