/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.lang.puppet.project.meta.PuppetEnvironmentMetadata;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetEnvironment
extends PuppetEntity<PuppetEnvironmentMetadata> {
    public static final String DEFAULT_DEPENDENCIES_DIR = "modules";
    private static final List<String> DEFAULT_DEPENDENCIES_DIR_LIST = Collections.singletonList("modules");
    private static final String MODULE_PATH_KEY = "modulepath";
    private static final List<String> MEANINGFUL_SUB_DIRECTORIES = Collections.singletonList("manifests");
    private final AtomicNullableLazyValue<Properties> myPropertiesProvider;

    public PuppetEnvironment(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            PuppetEnvironment.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PuppetEnvironment.$$$reportNull$$$0(1);
        }
        super(project, root, new PuppetEnvironmentMetadata(root));
        this.myPropertiesProvider = new AtomicNullableLazyValue<Properties>(){

            @Nullable
            protected Properties compute() {
                return (Properties)ReadAction.compute(() -> PuppetEnvironment.this.computeEnvironmentProperties());
            }
        };
    }

    @Override
    @NotNull
    protected List<String> getMeaningfulSubDirectoryNames() {
        List<String> list = MEANINGFUL_SUB_DIRECTORIES;
        if (list == null) {
            PuppetEnvironment.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public String getDescriptiveName() {
        String string = PuppetBundle.message("puppet.environment", new Object[0]);
        if (string == null) {
            PuppetEnvironment.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getLibrarianDependenciesRootName() {
        List<String> paths = this.getAllDependenciesRootsPaths();
        String string = paths.isEmpty() ? DEFAULT_DEPENDENCIES_DIR : paths.get(0);
        if (string == null) {
            PuppetEnvironment.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public List<VirtualFile> getAllDependenciesRoots() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.isValid()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                PuppetEnvironment.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<VirtualFile> list = this.getAllDependenciesRootsPaths().stream().map(path -> this.getRoot().findFileByRelativePath(path)).filter(file -> file != null).collect(Collectors.toList());
        if (list == null) {
            PuppetEnvironment.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<String> getAllDependenciesRootsPaths() {
        Properties environmentProperties = this.getEnvironmentProperties();
        if (environmentProperties == null) {
            List<String> list = DEFAULT_DEPENDENCIES_DIR_LIST;
            if (list == null) {
                PuppetEnvironment.$$$reportNull$$$0(7);
            }
            return list;
        }
        String userDefinedModulePath = environmentProperties.getProperty(MODULE_PATH_KEY);
        if (userDefinedModulePath == null) {
            List<String> list = DEFAULT_DEPENDENCIES_DIR_LIST;
            if (list == null) {
                PuppetEnvironment.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = StringUtil.split((String)userDefinedModulePath, (String)":");
        if (list == null) {
            PuppetEnvironment.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PuppetModule> getDependencies() {
        PuppetProjectManager puppetProjectManager = PuppetProjectManager.getInstance(this.getProject());
        List<PuppetModule> list = this.getAllDependenciesRoots().stream().flatMap(root -> puppetProjectManager.getModulesInRoot((VirtualFile)root).stream()).collect(Collectors.toList());
        if (list == null) {
            PuppetEnvironment.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    private Properties getEnvironmentProperties() {
        return (Properties)this.myPropertiesProvider.getValue();
    }

    @Nullable
    private Properties computeEnvironmentProperties() {
        return PuppetEnvironment.buildPropertiesFromConfig(this.readEnvironmentConfig());
    }

    @Nullable
    private String readEnvironmentConfig() {
        if (!this.isValid()) {
            return null;
        }
        VirtualFile puppetMetaFile = this.getRoot().findChild("environment.conf");
        if (puppetMetaFile == null) {
            return null;
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)puppetMetaFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    private static Properties buildPropertiesFromConfig(@Nullable String configContents) {
        if (configContents == null) {
            return null;
        }
        Properties result = new Properties();
        try {
            result.load(new StringReader(configContents));
        }
        catch (IOException e) {
            return null;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/PuppetEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/PuppetEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMeaningfulSubDirectoryNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrarianDependenciesRootName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependenciesRoots";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependenciesRootsPaths";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

