/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.ide.completion.PuppetLookupCachingRenderer;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.lang.puppet.psi.PuppetClassDefinition;
import com.intellij.lang.puppet.psi.PuppetDelegatingLightNamedElement;
import com.intellij.lang.puppet.psi.PuppetParametrizedDeclaration;
import com.intellij.lang.puppet.psi.PuppetTypeDefinition;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.lang.puppet.psi.PuppetVariableLightElement;
import com.intellij.lang.puppet.util.PuppetQualifiedNamesUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import icons.PuppetIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetLookupElements {
    private static final Icon VARIABLE_ICON = AllIcons.Nodes.Variable;
    private static final Icon FACT_ICON = AllIcons.Nodes.Field;
    private static final Icon PARAMETER_ICON = AllIcons.Nodes.Parameter;
    private static final Icon FUNCTION_ICON = AllIcons.Nodes.Function;
    private static final Icon MODULE_ICON = AllIcons.Nodes.Folder;
    private static final Icon CLASS_ICON = AllIcons.Nodes.Class;
    private static final PuppetLookupCachingRenderer VARIABLE_RENDERER = new PuppetLookupCachingRenderer(){

        @Override
        public void calcPresentation(LookupElement lookupElement, LookupElementPresentation presentation) {
            String typeName;
            PsiElement psiElement = lookupElement.getPsiElement();
            assert (psiElement instanceof PuppetVariable) : "Got " + psiElement + " instead of PuppetVariable";
            PuppetVariable element = (PuppetVariable)psiElement;
            boolean isBold = false;
            Icon elementIcon = VARIABLE_ICON;
            if (element.isMetaparameter()) {
                typeName = PuppetBundle.message("puppet.lookup.type.metaparameter", new Object[0]);
                elementIcon = PARAMETER_ICON;
                isBold = true;
            } else if (element.isCoreFact()) {
                typeName = PuppetBundle.message("puppet.lookup.type.core.fact", new Object[0]);
                elementIcon = FACT_ICON;
                isBold = true;
            } else if (element.isBuiltIn()) {
                typeName = PuppetBundle.message("puppet.lookup.type.builtin.variable", new Object[0]);
                isBold = true;
            } else if (element.isParameter()) {
                PsiNamedElement anchor = (PsiNamedElement)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, PuppetParametrizedDeclaration.class);
                if (anchor == null) {
                    anchor = element.getContainingFile();
                }
                typeName = anchor.getName();
                elementIcon = PARAMETER_ICON;
            } else if (element instanceof PuppetVariableLightElement) {
                typeName = ((PuppetVariableLightElement)element).getLookupTypeText();
                isBold = ((PuppetVariableLightElement)element).getLookupBoldness();
            } else {
                PsiFile containingFile = element.getContainingFile();
                typeName = containingFile == null ? "" : containingFile.getName();
            }
            presentation.setIcon(elementIcon);
            presentation.setItemText("$" + lookupElement.getLookupString());
            presentation.setItemTextBold(isBold);
            presentation.setTypeGrayed(true);
            presentation.setTypeText(typeName);
        }
    };
    private static final PuppetLookupCachingRenderer EXTERNAL_FACT_RENDERER = new PuppetLookupCachingRenderer(){

        @Override
        protected void calcPresentation(LookupElement lookupElement, LookupElementPresentation presentation) {
            PsiFile file;
            presentation.setIcon(FACT_ICON);
            presentation.setItemText("$" + lookupElement.getLookupString());
            PsiElement element = lookupElement.getPsiElement();
            if (element != null && (file = element.getContainingFile()) != null) {
                presentation.setTypeGrayed(true);
                presentation.setTypeText(file.getName());
            }
        }
    };

    public static LookupElement forModule(@NotNull PuppetModule puppetModule) {
        if (puppetModule == null) {
            PuppetLookupElements.$$$reportNull$$$0(0);
        }
        return LookupElementBuilder.create((String)puppetModule.getShortName()).withIcon(PuppetIcons.PuppetLogo).withTypeText(puppetModule.getName());
    }

    @NotNull
    public static LookupElement forExternalFact(@NotNull String name, @Nullable PsiElement reference) {
        if (name == null) {
            PuppetLookupElements.$$$reportNull$$$0(1);
        }
        LookupElementBuilder builder = reference == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)reference, (String)name);
        LookupElementBuilder lookupElementBuilder = builder.withRenderer((LookupElementRenderer)EXTERNAL_FACT_RENDERER);
        if (lookupElementBuilder == null) {
            PuppetLookupElements.$$$reportNull$$$0(2);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElementBuilder forExternalParameter(@NotNull String name, @NotNull String typeName, @Nullable PsiElement reference) {
        if (name == null) {
            PuppetLookupElements.$$$reportNull$$$0(3);
        }
        if (typeName == null) {
            PuppetLookupElements.$$$reportNull$$$0(4);
        }
        LookupElementBuilder lookupElementBuilder = (reference == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)reference, (String)name)).withIcon(PARAMETER_ICON).withPresentableText("$" + name).withTypeText(typeName, true);
        if (lookupElementBuilder == null) {
            PuppetLookupElements.$$$reportNull$$$0(5);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElement forExternalFunction(@NotNull String name, @Nullable PsiElement reference) {
        if (name == null) {
            PuppetLookupElements.$$$reportNull$$$0(6);
        }
        LookupElementBuilder lookupElementBuilder = (reference == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)reference, (String)name)).withIcon(FUNCTION_ICON).withTypeText(PuppetBundle.message("puppet.lookup.type.function", new Object[0]), true);
        if (lookupElementBuilder == null) {
            PuppetLookupElements.$$$reportNull$$$0(7);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElement forModuleDir(@NotNull PsiDirectory dir) {
        if (dir == null) {
            PuppetLookupElements.$$$reportNull$$$0(8);
        }
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)dir, (String)dir.getName()).withIcon(MODULE_ICON).withTypeText(PuppetBundle.message("puppet.lookup.type.module", new Object[0]), true);
        LookupElementBuilder lookupElementBuilder = PuppetLookupElements.addStringInsertHandler(lookup, "::", false);
        if (lookupElementBuilder == null) {
            PuppetLookupElements.$$$reportNull$$$0(9);
        }
        return lookupElementBuilder;
    }

    @Nullable
    public static LookupElementBuilder forVariable(@NotNull PuppetVariable element, boolean forceFqn) {
        if (element == null) {
            PuppetLookupElements.$$$reportNull$$$0(10);
        }
        String name = forceFqn ? element.getFullQualifiedName() : element.getName();
        return name == null ? null : LookupElementBuilder.create((Object)element, (String)name).withRenderer((LookupElementRenderer)VARIABLE_RENDERER);
    }

    @Nullable
    public static LookupElement forClass(@NotNull PuppetClassDefinition element, boolean capitalize) {
        String name;
        if (element == null) {
            PuppetLookupElements.$$$reportNull$$$0(11);
        }
        if ((name = element.getFullQualifiedName()) == null) {
            return null;
        }
        if (capitalize) {
            name = PuppetQualifiedNamesUtil.capitalizePuppetName(name);
        }
        return PuppetLookupElements.forClass((PsiElement)element, name);
    }

    @NotNull
    public static LookupElement forClass(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            PuppetLookupElements.$$$reportNull$$$0(12);
        }
        if (name == null) {
            PuppetLookupElements.$$$reportNull$$$0(13);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)element, (String)name).withIcon(CLASS_ICON).withTypeText(PuppetBundle.message("puppet.lookup.type.class", new Object[0]), true);
        if (lookupElementBuilder == null) {
            PuppetLookupElements.$$$reportNull$$$0(14);
        }
        return lookupElementBuilder;
    }

    @Nullable
    public static LookupElement forTypeDefinition(@NotNull PuppetTypeDefinition element, boolean capitalize) {
        String name;
        if (element == null) {
            PuppetLookupElements.$$$reportNull$$$0(15);
        }
        if ((name = element.getFullQualifiedName()) == null) {
            return null;
        }
        return PuppetLookupElements.forTypeDefinition(element, name, capitalize);
    }

    @Nullable
    public static LookupElement forResourceInstance(@NotNull PuppetDelegatingLightNamedElement resourceInstanceDelegate, @NotNull String type) {
        String name;
        if (resourceInstanceDelegate == null) {
            PuppetLookupElements.$$$reportNull$$$0(16);
        }
        if (type == null) {
            PuppetLookupElements.$$$reportNull$$$0(17);
        }
        return StringUtil.isEmpty((String)(name = resourceInstanceDelegate.getName())) ? null : LookupElementBuilder.create((String)name).withIcon(PuppetIcons.ResourceInstance).withTypeText(type);
    }

    @NotNull
    public static LookupElement forTypeDefinition(@NotNull PsiElement element, @NotNull String name, boolean capitalize) {
        if (element == null) {
            PuppetLookupElements.$$$reportNull$$$0(18);
        }
        if (name == null) {
            PuppetLookupElements.$$$reportNull$$$0(19);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)element, (String)(capitalize ? PuppetQualifiedNamesUtil.capitalizePuppetName(name) : name)).withIcon(PuppetIcons.ResourceType).withTypeText(PuppetBundle.message("puppet.lookup.type.resource.type", new Object[0]), true);
        if (lookupElementBuilder == null) {
            PuppetLookupElements.$$$reportNull$$$0(20);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElement forDataType(@NotNull String name) {
        if (name == null) {
            PuppetLookupElements.$$$reportNull$$$0(21);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)name).bold().withIcon(PuppetIcons.DataType).withTypeText(PuppetBundle.message("puppet.lookup.type.data.type", new Object[0]), true);
        if (lookupElementBuilder == null) {
            PuppetLookupElements.$$$reportNull$$$0(22);
        }
        return lookupElementBuilder;
    }

    @Contract(value="null, _, _ -> null; !null, _, _ -> !null")
    public static LookupElementBuilder addStringInsertHandler(@Nullable LookupElementBuilder lookupElement, final @NotNull String s, final boolean insertSpace) {
        if (s == null) {
            PuppetLookupElements.$$$reportNull$$$0(23);
        }
        if (lookupElement == null) {
            return null;
        }
        return lookupElement.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    3.$$$reportNull$$$0(1);
                }
                Document document = context.getDocument();
                int textLength = document.getTextLength();
                int tailOffset = context.getTailOffset();
                CharSequence text = document.getCharsSequence();
                int offsetToReplace = this.findNonSpaceChar(text, tailOffset);
                if ((offsetToReplace = PuppetLookupElements.normalizeSpaceBefore(document, tailOffset, offsetToReplace, insertSpace)) + s.length() > textLength || !text.subSequence(offsetToReplace, offsetToReplace + s.length()).toString().equals(s)) {
                    document.insertString(offsetToReplace, (CharSequence)s);
                }
                int endOffset = PuppetLookupElements.normalizeSpaceAfter(document, offsetToReplace + s.length(), text, insertSpace);
                context.getEditor().getCaretModel().moveToOffset(endOffset);
            }

            private int findNonSpaceChar(CharSequence text, int offset) {
                while (offset < text.length() && text.charAt(offset) == ' ') {
                    ++offset;
                }
                return offset;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/puppet/ide/completion/PuppetLookupElements$3";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static int normalizeSpaceAfter(Document document, int offsetAfterInsert, CharSequence text, boolean needSpace) {
        if (needSpace) {
            if (text.length() < offsetAfterInsert + 1 || text.charAt(offsetAfterInsert) != ' ') {
                document.insertString(offsetAfterInsert, (CharSequence)" ");
            }
            return offsetAfterInsert + 1;
        }
        return offsetAfterInsert;
    }

    private static int normalizeSpaceBefore(Document document, int tailOffset, int offsetToReplace, boolean needSpace) {
        if (needSpace) {
            if (tailOffset <= offsetToReplace - 1) {
                document.deleteString(tailOffset, offsetToReplace - 1);
            } else {
                document.insertString(tailOffset, (CharSequence)" ");
            }
            return tailOffset + 1;
        }
        document.deleteString(tailOffset, offsetToReplace);
        return tailOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "puppetModule";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 13: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/completion/PuppetLookupElements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceInstanceDelegate";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/completion/PuppetLookupElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forExternalFact";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "forExternalParameter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forExternalFunction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forModuleDir";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forClass";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "forTypeDefinition";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "forDataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forModule";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forExternalFact";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 20: 
            case 22: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forExternalParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forExternalFunction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forModuleDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forVariable";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forClass";
                break;
            }
            case 15: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forTypeDefinition";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forResourceInstance";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "forDataType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addStringInsertHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

