/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.NameChecker;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.dialects.SqlDataSourceMappings;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlImplicitDeclarationsProvider;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeCastExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlDeclareStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImplUtil {
    public static final String NULL_STRING = DasUtil.NO_NAME;
    public static final DasTable NO_TABLE = new EmptyTable();
    public static final Function<StubElement, PsiElement> STUB_TO_PSI = element2 -> element2.getPsi();
    public static final Function<SqlNameElement, String> IDENT_TO_NAME = element2 -> element2.getName();
    private static final Key<PsiElement> CURRENT_QUALIFIER = Key.create((String)"CURRENT_QUALIFIER");
    private static final Logger LOG = Logger.getInstance(SqlImplUtil.class);

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser() {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK));
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(0);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser(PsiElement element2) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoot((Object)element2);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(1);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlRevTraverser(PsiElement element2) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.revPsiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)).withRoot((Object)element2);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(2);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static Condition<PsiElement> byElementType(IElementType ... types) {
        if (types == null) {
            SqlImplUtil.$$$reportNull$$$0(3);
        }
        Condition condition = element2 -> {
            if (types == null) {
                SqlImplUtil.$$$reportNull$$$0(127);
            }
            return ArrayUtil.contains((Object)element2.getNode().getElementType(), (Object[])types);
        };
        if (condition == null) {
            SqlImplUtil.$$$reportNull$$$0(4);
        }
        return condition;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildren(@Nullable PsiElement element2) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlTraverser(element2).expandAndSkip(Conditions.is((Object)element2))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlRevChildren(@Nullable PsiElement element2) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlRevTraverser(element2).expandAndSkip(Conditions.is((Object)element2))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<SqlElement> sqlElements(@Nullable PsiElement root2) {
        SyntaxTraverser s = SqlImplUtil.sqlTraverser(root2).filterTypes(Conditions.notInstanceOf(SqlKeywordTokenType.class));
        JBIterable jBIterable = ((SyntaxTraverser)s.expand(Conditions.or((Condition)Conditions.is((Object)root2), (Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK))))).filter(SqlElement.class);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Nullable
    public static PsiElement sqlParent(@Nullable PsiElement e) {
        PsiElement tmp;
        PsiElement psiElement = tmp = e == null ? null : e.getParent();
        while (tmp != null) {
            if (PsiUtilCore.getElementType((PsiElement)tmp) != SqlElementTypes.SQL_DUMMY_BLOCK) {
                return tmp;
            }
            tmp = tmp.getParent();
        }
        return null;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlParents(@Nullable PsiElement e) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        JBIterable jBIterable = api.parents((Object)e).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.notEqualTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> revSiblings(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(9);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApiReversed();
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoots((Iterable)api.siblings((Object)e))).expand(Conditions.alwaysFalse())).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    public static PsiElement getBlockContentElement(@NotNull PsiElement block) {
        if (block == null) {
            SqlImplUtil.$$$reportNull$$$0(11);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (PsiElement)api.children((Object)block).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK))).first();
    }

    @Nullable
    public static IElementType getElementType(@Nullable PsiElement element2) {
        ASTNode node = element2 == null ? null : element2.getNode();
        return node == null ? null : node.getElementType();
    }

    @NotNull
    public static ResolveState setQualifier(@NotNull ResolveState state, @Nullable PsiElement qualifier) {
        PsiElement qual;
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(12);
        }
        if ((qual = (PsiElement)state.get(CURRENT_QUALIFIER)) != null || qualifier == null) {
            ResolveState resolveState = state;
            if (resolveState == null) {
                SqlImplUtil.$$$reportNull$$$0(13);
            }
            return resolveState;
        }
        ResolveState resolveState = state.put(CURRENT_QUALIFIER, (Object)qualifier);
        if (resolveState == null) {
            SqlImplUtil.$$$reportNull$$$0(14);
        }
        return resolveState;
    }

    @Nullable
    public static PsiElement getQualifier(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(15);
        }
        return (PsiElement)state.get(CURRENT_QUALIFIER);
    }

    @Nullable
    public static PsiElement getQualifier(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getQualifier() : null;
    }

    @NotNull
    public static List<Pair<PsiElement, PsiElement>> resolveQualified(@Nullable SqlReferenceExpression ref) {
        ResolveResult[] results2;
        ResolveResult[] resolveResultArray = results2 = ref == null ? null : ref.multiResolve(false);
        if (results2 == null || results2.length == 0) {
            List<Pair<PsiElement, PsiElement>> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        ArrayList res2 = ContainerUtil.newArrayList();
        for (ResolveResult result2 : results2) {
            res2.add(Pair.create((Object)SqlImplUtil.getQualifier(result2), (Object)result2.getElement()));
        }
        ArrayList arrayList = res2;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    public static int getParentTypes(@NotNull SqlLanguageDialectEx dialect, ObjectKind type, int minLevel, int maxLevel, @NotNull Set<ObjectKind> ignored, Set<ObjectKind> result2) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(18);
        }
        if (ignored == null) {
            SqlImplUtil.$$$reportNull$$$0(19);
        }
        if (maxLevel > 0 && minLevel > maxLevel) {
            throw new IllegalArgumentException();
        }
        if (minLevel <= 0) {
            result2.add(type);
        }
        if (maxLevel == 0) {
            return 0;
        }
        LinkedList queue = ContainerUtil.newLinkedList();
        dialect.getParentDbTypes(queue, type);
        queue.removeAll(ignored);
        int curLevel = 0;
        int curSize = queue.size();
        LinkedHashSet levelSet = ContainerUtil.newLinkedHashSet();
        while (!queue.isEmpty()) {
            ObjectKind cur = (ObjectKind)queue.removeFirst();
            boolean isAdded = levelSet.add(cur);
            if (--curSize == 0) {
                if (minLevel <= ++curLevel && (maxLevel < 0 || curLevel <= maxLevel) && !result2.addAll(levelSet)) break;
                levelSet.clear();
            }
            if (maxLevel > -1 && curLevel == maxLevel) break;
            if (isAdded) {
                dialect.getParentDbTypes(queue, cur);
            }
            if (curSize != 0) continue;
            curSize = queue.size();
        }
        return curLevel;
    }

    @NotNull
    public static CasingProvider getCasingProvider(@NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<DbDataSource> dataSources2) {
        DbDataSource dataSource;
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(20);
        }
        if (dataSources2 == null) {
            SqlImplUtil.$$$reportNull$$$0(21);
        }
        DasModel model = (dataSource = (DbDataSource)Iterables.getFirst(dataSources2, null)) == null ? DasUtil.emptyModel() : dataSource.getModel();
        SqlLanguageDialectEx sqlLanguageDialectEx = model == DasUtil.emptyModel() ? dialect : model;
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(22);
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheLeftOfType(@Nullable PsiElement element2, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(23);
        }
        if (element2 == null) {
            return null;
        }
        for (PsiElement psiElement = element2.getPrevSibling(); psiElement != null; psiElement = psiElement.getPrevSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element2, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(24);
        }
        return SqlImplUtil.getSiblingToTheRightOfType(element2, strict, null, classes);
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element2, boolean strict, @Nullable Condition<PsiElement> skip, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(25);
        }
        if (element2 == null) {
            return null;
        }
        for (PsiElement psiElement = element2.getNextSibling(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement || skip != null && skip.value((Object)psiElement)) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    public static Collection<PsiElement> getReferencedElements(@NotNull SqlDefinition o) {
        SqlNameElement nameElement;
        PsiReference reference;
        SqlFileImpl.FakeDefinition mirror;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(26);
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        Couple<SqlFileImpl.FakeDefinition> mirrorPair = SqlImplUtil.getMirror(o);
        SqlFileImpl.FakeDefinition fakeDefinition = mirrorPair.second != null ? (SqlFileImpl.FakeDefinition)((Object)mirrorPair.second) : (mirror = o.getKind() == ObjectKind.BODY ? (SqlFileImpl.FakeDefinition)((Object)mirrorPair.first) : null);
        if (mirror != null) {
            result2.add(mirror);
            mirror.delegates().addAllTo((Collection)result2);
        }
        PsiReference psiReference = reference = (nameElement = o.getNameElement()) != null && nameElement.getTextLength() > 0 ? nameElement.findReferenceAt(nameElement.getTextLength() - 1) : null;
        if (reference != null) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results2;
                for (ResolveResult resolveResult : results2 = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element2 = resolveResult.getElement();
                    result2.add(element2);
                }
            } else {
                PsiElement element3 = reference.resolve();
                result2.add(element3);
            }
        }
        return result2;
    }

    @NotNull
    public static Couple<SqlFileImpl.FakeDefinition> getMirror(@NotNull SqlDefinition o) {
        PsiFile file;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(27);
        }
        if ((file = o.getContainingFile()) instanceof SqlFileImpl) {
            Couple<SqlFileImpl.FakeDefinition> couple = ((SqlFileImpl)file).getMirror(o);
            if (couple == null) {
                SqlImplUtil.$$$reportNull$$$0(28);
            }
            return couple;
        }
        Couple couple = Couple.getEmpty();
        if (couple == null) {
            SqlImplUtil.$$$reportNull$$$0(29);
        }
        return couple;
    }

    public static boolean processObjectParents(PsiElement object, PsiScopeProcessor processor, ResolveState resolveState) {
        while (object != null) {
            if (!processor.execute(object, resolveState)) {
                return false;
            }
            if (!(object instanceof DasObject)) break;
            object = (PsiElement)ObjectUtils.tryCast((Object)((DasObject)object).getDasParent(), PsiElement.class);
        }
        return true;
    }

    public static boolean processQualifier(SqlReferenceExpression reference, PsiScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            return true;
        }
        ObjectKind kind = reference.getReferenceElementType().getTargetKind();
        if (kind != SqlDbElementType.ANY) {
            if (!SqlImplUtil.isProcessingChildOf(processor, kind)) {
                return true;
            }
        } else {
            ObjectKind expected;
            boolean found = false;
            Iterator<ObjectKind> iterator = ((SqlReferenceImpl)reference.getReference()).getExpectedTypes(true).iterator();
            while (iterator.hasNext() && !(found = SqlImplUtil.isProcessingChildOf(processor, expected = iterator.next()))) {
            }
            if (!found) {
                return true;
            }
        }
        if (PsiTreeUtil.isContextAncestor((PsiElement)reference, (PsiElement)place, (boolean)false)) {
            return true;
        }
        try {
            return SqlImplUtil.processQualifierImpl(reference, processor, resolveState, place);
        }
        catch (StackOverflowError e) {
            PsiElement placeParent = place.getParent();
            PsiElement referenceParent = reference.getParent();
            LOG.error("SOE while processing qualifier", (Throwable)e, new Attachment[]{new Attachment("place parent", SqlImplUtil.getInfo(placeParent) + "\n" + SqlImplUtil.getInfo(placeParent == null ? null : placeParent.getParent())), new Attachment("reference parent", SqlImplUtil.getInfo(referenceParent) + "\n" + SqlImplUtil.getInfo(referenceParent == null ? null : referenceParent.getParent()))});
            return true;
        }
    }

    @NotNull
    private static String getInfo(PsiElement placeParent) {
        String string = placeParent == null ? "" : placeParent.getText() + "\n" + PsiUtilCore.getElementType((PsiElement)placeParent);
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    static boolean processQualifierImpl(@NotNull SqlReferenceExpression reference, PsiScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            SqlImplUtil.$$$reportNull$$$0(31);
        }
        ResolveResult[] results2 = reference.multiResolve(false);
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class);
        if (!SqlImplUtil.processDeclarationsInType((SqlExpression)reference, processor, resolveState, place)) {
            return false;
        }
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(sqlProcessor);
        for (ResolveResult result2 : results2) {
            DbNamespaceImpl schemaElement;
            PsiElement qualifier = result2.getElement();
            ResolveState qualifiedState = SqlImplUtil.setQualifier(resolveState, qualifier);
            processor.handleEvent(SqlScopeProcessor.RESOLVE_CONTEXT, (Object)qualifier);
            if (qualifier == null || !qualifier.isValid() || qualifier instanceof DasSynonym && ((qualifier = (PsiElement)DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)qualifier))) == null || !qualifier.isValid())) continue;
            if (qualifier != reference && !qualifier.processDeclarations(processor, qualifiedState, null, place)) {
                return false;
            }
            if (qualifier instanceof DasTable) {
                if (!SqlImplUtil.processAlterStatements(processor, qualifiedState, place, (DasObject)qualifier)) {
                    return false;
                }
                PsiFile qualFile = qualifier.getContainingFile();
                PsiFile placeFile = place.getContainingFile();
                if (!SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifier, qualFile)) {
                    return false;
                }
                if (qualFile != placeFile && !SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifier, placeFile)) {
                    return false;
                }
            }
            if ((schemaElement = (DbNamespaceImpl)((Object)ObjectUtils.tryCast((Object)qualifier, DbNamespaceImpl.class))) == null || schemaElement.getKind() != ObjectKind.SCHEMA || !majorChildExpected || SqlImplUtil.processSchemaMajorChildren(sqlProcessor, schemaElement.createDeclarationProcessor(processor, qualifiedState, null, place), schemaElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMajorChildExpected(@Nullable PsiScopeProcessor processor) {
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class);
        if (sqlProcessor == null) {
            return false;
        }
        Set<ObjectKind> expectedTypes = sqlProcessor.getExpectedTypes();
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        for (ObjectKind type : expectedTypes) {
            if (!sqlProcessor.dialect.isMajorChild(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean processOnTableCreateStatements(PsiScopeProcessor processor, ResolveState resolveState, PsiElement qualifier, PsiFile containingFile) {
        PsiFile psiFile = containingFile = containingFile == null ? null : containingFile.getOriginalFile();
        if (containingFile instanceof SqlFile) {
            for (SqlElement statement : ((SqlFile)containingFile).getDdl()) {
                SqlReferenceExpression ref;
                if (!(statement instanceof SqlTargetContextProvider) || (ref = ((SqlTargetContextProvider)statement).getTargetContextExpression()) == null || !ref.getReference().isReferenceTo(qualifier) || processor.execute((PsiElement)statement, resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processAlterStatements(PsiScopeProcessor processor, ResolveState resolveState, PsiElement place, DasObject qualifier) {
        return SqlImplUtil.processAlterStatements(place.getContainingFile(), place, qualifier, (Processor<SqlAlterInstruction>)((Processor)instruction2 -> instruction2.processDeclarations(processor, resolveState, null, place)));
    }

    public static boolean processAlterStatements(PsiFile file, PsiElement place, DasObject qualifierTarget, Processor<SqlAlterInstruction> processor) {
        if (!(file instanceof SqlFile)) {
            return true;
        }
        SqlFile original = (SqlFile)ObjectUtils.tryCast((Object)file.getOriginalFile(), SqlFile.class);
        if (original == null) {
            return true;
        }
        NameChecker checker = new NameChecker(qualifierTarget, original.getSqlLanguage());
        for (SqlElement ddl : original.getDdl()) {
            SqlReferenceExpression target;
            SqlAlterStatement statement = (SqlAlterStatement)ObjectUtils.tryCast((Object)ddl, SqlAlterStatement.class);
            if (statement == null || place != null && PsiTreeUtil.isContextAncestor((PsiElement)statement, (PsiElement)place, (boolean)false) || (target = statement.getAlterTargetReference()) == null || !checker.checkName(target, null) || !(qualifierTarget instanceof PsiElement) || !target.getReference().isReferenceTo((PsiElement)qualifierTarget) || ContainerUtil.process((Object[])statement.getAlterInstructions(), processor)) continue;
            return false;
        }
        return true;
    }

    public static List<PsiColumn> createColumnInfos(DasTable tableInfo, SqlTableType tableType) {
        assert (tableInfo instanceof PsiElement);
        int count2 = tableType.getColumnCount();
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            result2.add(new MyColumnInfo(tableInfo, i2, tableType));
        }
        return result2;
    }

    public static boolean processFromReferences(PsiScopeProcessor processor, ResolveState state, SqlExpression fromExpression, PsiElement place, PsiElement lastParent) {
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.COLUMN, ObjectKind.TABLE)) {
            return true;
        }
        SqlType type = fromExpression == null ? null : SqlImplUtil.getTypeLateralAware(fromExpression, place);
        return !(type instanceof SqlTableType) || SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state, place);
    }

    @NotNull
    public static SqlType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement end) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(32);
        }
        Object object = expression instanceof SqlLateralAwareExpression ? ((SqlLateralAwareExpression)expression).getSqlType(end) : (end != null && PsiTreeUtil.isContextAncestor((PsiElement)expression, (PsiElement)end, (boolean)false) ? SqlTableTypeBase.EMPTY_TABLE : expression.getSqlType());
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(33);
        }
        return object;
    }

    @NotNull
    public static SqlTableType createType(@NotNull List<Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(34);
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(null, result2, qualifier);
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(35);
        }
        return sqlTableType;
    }

    @NotNull
    public static SqlTableType createType(final String name, final @NotNull List<Column> result2, final @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(36);
        }
        StringBuilder args2 = new StringBuilder();
        for (Column column2 : result2) {
            if (args2.length() != 0) {
                args2.append(",");
            }
            if (column2.name != null) {
                args2.append(column2.name).append(" ");
            }
            args2.append(column2.type.getDataType().getSpecification());
        }
        final DataType dataType = DataTypeFactory.ofArgs(null, "table", args2.toString(), false);
        Object object = result2.isEmpty() ? SqlTableTypeBase.EMPTY_TABLE : new SqlTableTypeBase(){

            @NotNull
            public DataType getDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            @NotNull
            public List<PsiObject> getMethods() {
                List<PsiObject> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            @Nullable
            public String getTypeName() {
                return name;
            }

            public int getColumnCount() {
                return result2.size();
            }

            public String getColumnName(int i2) {
                return ((Column)result2.get((int)i2)).name;
            }

            public SqlType getColumnType(int i2) {
                return ((Column)result2.get((int)i2)).type;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                PsiElement psiElement = ((Column)result2.get((int)i2)).element;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return ((Column)result2.get((int)i2)).sourceElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethods";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(37);
        }
        return object;
    }

    @NotNull
    public static SqlTableType getSelectType(@NotNull List<SqlExpression> list, @Nullable PsiElement qualifier) {
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(38);
        }
        SqlTableType result2 = SqlTableTypeBase.EMPTY_TABLE;
        for (SqlExpression e : list) {
            boolean flatten;
            SqlColumnAliasListImpl aliasList;
            if (e instanceof SqlAsExpression && (aliasList = (SqlColumnAliasListImpl)PsiTreeUtil.getChildOfType((PsiElement)e, SqlColumnAliasListImpl.class)) != null) {
                for (SqlColumnAliasDefinition alias : aliasList.getColumnAliasList()) {
                    result2 = result2.add(SqlTableTypeBase.ensureTableType(aliasList.getAliasedSqlType(alias), (SqlElement)alias, qualifier));
                }
                continue;
            }
            Object type = e.getSqlType();
            SqlTypeCastExpression cast = (SqlTypeCastExpression)ObjectUtils.tryCast((Object)e, SqlTypeCastExpression.class);
            String name = null;
            if (cast != null) {
                e = cast.getExpression();
                SqlTypeElement element2 = cast.getTypeElement();
                if (element2 != null) {
                    name = element2.getDisplayName();
                }
            }
            if (e instanceof SqlFunctionCallExpression) {
                String fooName;
                SqlReferenceExpression fooRef = ((SqlFunctionCallExpression)e).getNameElement();
                String string = fooName = fooRef == null ? null : fooRef.getName();
                if (fooName != null && fooName.equalsIgnoreCase("cast")) {
                    List args2;
                    SqlExpressionList params = ((SqlFunctionCallExpression)e).getParameterList();
                    List list2 = args2 = params == null ? null : params.getExpressionList();
                    if (!ContainerUtil.isEmpty((Collection)args2)) {
                        e = (SqlExpression)args2.get(0);
                    }
                }
            }
            if (name == null) {
                name = e instanceof SqlNameElement ? e.getName() : (e instanceof SqlDefinition ? e.getName() : e.getText());
            }
            boolean bl = flatten = "*".equals(name) || list.size() == 1 && SqlImplUtil.getSqlDialectSafe((PsiElement)e).getDbms() != Dbms.CLICKHOUSE;
            type = flatten && type instanceof SqlTableType ? (name == null ? type : ((SqlTableType)type).alias(name, qualifier, Collections.emptyList())) : SqlTableTypeBase.createType((SqlElement)e, type, name, qualifier);
            result2 = result2.add(SqlTableTypeBase.ensureTableType(type, (SqlElement)e, qualifier));
        }
        if (result2 != SqlTableTypeBase.EMPTY_TABLE) {
            result2 = result2.alias(null, qualifier, Collections.emptyList());
        }
        SqlTableType sqlTableType = result2;
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(39);
        }
        return sqlTableType;
    }

    public static boolean processDeclarationsInType(SqlExpression expression, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.COLUMN, ObjectKind.TABLE, ObjectKind.ROUTINE)) {
            return true;
        }
        SqlType t = expression.getSqlType();
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)t, SqlTableType.class);
        return type == null || SqlImplUtil.processDeclarationsInType(type, processor, state, place);
    }

    public static boolean processDeclarationsInType(SqlTableType tableType, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        if (SqlImplUtil.isProcessingOneOf(processor, ObjectKind.ROUTINE)) {
            ResolveState qualifiedState = SqlImplUtil.setQualifier(state, tableType.getTypeElement());
            for (PsiObject m : tableType.getMethods()) {
                if (processor.execute((PsiElement)m, qualifiedState)) continue;
                return false;
            }
        }
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.COLUMN, ObjectKind.TABLE, ObjectKind.OBJECT_ATTRIBUTE)) {
            return true;
        }
        PsiElement prevQualifier = null;
        for (int i2 = 0; i2 < tableType.getColumnCount(); ++i2) {
            ResolveResult[] results2;
            PsiElement columnQualifier = tableType.getColumnQualifier(i2);
            ResolveState qualifiedState = SqlImplUtil.setQualifier(state, columnQualifier);
            processor.handleEvent(SqlScopeProcessor.RESOLVE_CONTEXT, (Object)columnQualifier);
            PsiElement element2 = tableType.getColumnElement(i2);
            PsiElement sourceElement = tableType.getSourceColumnElement(i2);
            PsiElement source = element2 instanceof SqlDefinition || sourceElement == null ? element2 : sourceElement;
            ResolveResult[] resolveResultArray = results2 = source instanceof SqlReferenceExpression ? ((SqlReferenceExpression)source).multiResolve(false) : ResolveResult.EMPTY_ARRAY;
            if (results2.length > 0) {
                for (ResolveResult result2 : results2) {
                    PsiElement target = result2.getElement();
                    if (target == null || processor.execute(target, qualifiedState)) continue;
                    return false;
                }
            } else if (!processor.execute(source, qualifiedState)) {
                return false;
            }
            if (columnQualifier == null || columnQualifier == prevQualifier) continue;
            prevQualifier = columnQualifier;
            if (!SqlImplUtil.hasAcceptedCompletionSuggestions(processor) || !SqlImplUtil.isQualifiedContext(place)) {
                processor.execute(columnQualifier, state);
            }
            if (SqlImplUtil.hasAcceptedCompletionSuggestions(processor) || !(columnQualifier instanceof DasTable) || SqlImplUtil.processAlterStatements(processor, state, place, (DasObject)columnQualifier)) continue;
            return false;
        }
        return SqlImplUtil.getSqlDialectSafe(place).processTypeExtra(tableType, processor, state, place);
    }

    private static boolean isQualifiedContext(@Nullable PsiElement place) {
        return place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getQualifierExpression() != null;
    }

    private static boolean hasAcceptedCompletionSuggestions(@Nullable PsiScopeProcessor processor) {
        return processor instanceof SqlCompletionScopeProcessor && ((SqlCompletionScopeProcessor)processor).hasAcceptedCompletionVariants();
    }

    public static void acceptChildren(SqlElement parent2, SqlVisitor visitor2) {
        for (PsiElement element2 = parent2.getFirstChild(); element2 != null; element2 = element2.getNextSibling()) {
            if (!(element2 instanceof SqlElement)) continue;
            ((SqlElement)element2).accept(visitor2);
        }
    }

    @NotNull
    public static SqlType getSqlType(@NotNull SqlTypedDefinition definition, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement place) {
        SqlType type;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(40);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(41);
        }
        if ((type = definition.getSqlType()) == SqlType.UNKNOWN || type.getCategory() == SqlType.Category.RECORD) {
            SqlType res2 = dialect.getDefinitionType(definition, place);
            SqlType sqlType = res2 == SqlType.UNKNOWN ? type : res2;
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(42);
            }
            return sqlType;
        }
        SqlType sqlType = type;
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(43);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(44);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(45);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(46);
        }
        if (object instanceof SqlTypedDefinition) {
            SqlType sqlType = ((SqlTypedDefinition)object).getSqlType();
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(47);
            }
            return sqlType;
        }
        SqlType sqlType = SqlImplUtil.getSqlType(context.getProject(), object.getDataType(), dialect, context);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(48);
        }
        return sqlType;
    }

    @NotNull
    public static DataType getArrayElement(@NotNull DataType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(49);
        }
        if (type.getSpecification().equalsIgnoreCase("anyarray")) {
            DataType dataType = DataTypeFactory.of("anyelement");
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(50);
            }
            return dataType;
        }
        DataType dataType = DataTypeFactory.of(StringUtil.trimEnd((String)type.getSpecification(), (String)"[]"));
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(51);
        }
        return dataType;
    }

    @NotNull
    public static DataType getArrayTypeOf(@NotNull DataType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(52);
        }
        if (type == DataType.UNKNOWN || type.getSpecification().equalsIgnoreCase("anyelement")) {
            DataType dataType = DataTypeFactory.of("anyarray");
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(53);
            }
            return dataType;
        }
        DataType dataType = DataTypeFactory.of(type.getSpecification() + "[]");
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(54);
        }
        return dataType;
    }

    @NotNull
    public static SqlType getArrayTypeOf(@NotNull SqlType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(55);
        }
        SqlType sqlType = SqlTypeFactory.of(SqlImplUtil.getArrayTypeOf(type.getDataType()), SqlType.Category.ARRAY);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(56);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasUserDefinedType type, @NotNull PsiElement element2, @NotNull SqlLanguageDialectEx dialect) {
        JBIterable children2;
        List columns;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(57);
        }
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(58);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(59);
        }
        if (!(columns = (children2 = type.getDasChildren(null).filter(DasTypedObject.class)).filter(PsiObject.class).transform(e -> {
            if (dialect == null) {
                SqlImplUtil.$$$reportNull$$$0(126);
            }
            return new Column(e.getName(), SqlImplUtil.getSqlType((DasTypedObject)e, dialect, (PsiElement)e), (PsiElement)e, (PsiElement)e);
        }).toList()).isEmpty()) {
            SqlTableType sqlTableType = SqlImplUtil.createType(columns, element2);
            if (sqlTableType == null) {
                SqlImplUtil.$$$reportNull$$$0(60);
            }
            return sqlTableType;
        }
        DataType dataType = DataTypeFactory.of(type.getName());
        SqlType sqlType = type.getKind() == ObjectKind.COLLECTION_TYPE ? SqlTypeFactory.of(dataType, SqlType.Category.COLLECTION) : SqlTypeFactory.of(dataType, dialect);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(61);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull Project project, @NotNull DataType dataType, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(62);
        }
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(63);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(64);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(65);
        }
        SqlType sqlType = (SqlType)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)context, () -> {
            if (context == null) {
                SqlImplUtil.$$$reportNull$$$0(124);
            }
            return CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(p2 -> {
                if (context == null) {
                    SqlImplUtil.$$$reportNull$$$0(125);
                }
                return SqlImplUtil.computeSqlType(context, (DataType)p2.first, (SqlLanguageDialect)p2.second);
            }, ContainerUtil::createConcurrentSoftValueMap), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        })).get(Pair.create((Object)dataType, (Object)((Object)dialect)));
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(66);
        }
        return sqlType;
    }

    @NotNull
    private static SqlType computeSqlType(@NotNull PsiElement context, DataType dataType, SqlLanguageDialect language) {
        SqlTypeElement unwrapped;
        SqlTypeElement type;
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(67);
        }
        if ((type = SqlPsiElementFactory.createDataTypeFromText(dataType.getSpecification(), language, context, true)) != null) {
            SqlReferenceImpl.IGNORE_DATA_SOURCES.set((UserDataHolder)type.getContainingFile(), (Object)true);
        }
        Object object = (unwrapped = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)type, SqlTypeElement.class)) == null ? SqlType.UNKNOWN : unwrapped.findSqlType();
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(68);
        }
        return object;
    }

    public static boolean processDeclarationsDefault(SqlElement element2, boolean processChildrenDeclarations, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return SqlImplUtil.processDeclarationsDefault(element2, SqlImplUtil.childrenTreeIt((PsiElement)element2), processChildrenDeclarations, processor, state, lastParent, place, !(element2 instanceof SqlExpression) && !(element2 instanceof SqlFromClause));
    }

    public static boolean processDeclarationsDefault(SqlElement element2, JBIterable<? extends PsiElement> notableChildren, boolean processChildrenDeclarations, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, boolean allowForwardReferences) {
        if (lastParent instanceof SqlWithClause || lastParent instanceof SqlOnTargetClauseImpl) {
            return true;
        }
        ObjectKind kind = element2 instanceof DasObject ? ((DasObject)element2).getKind() : ObjectKind.NONE;
        boolean checkLastParent = kind != ObjectKind.PACKAGE && kind != ObjectKind.OBJECT_TYPE && kind != ObjectKind.BODY && !(element2 instanceof SqlAlterInstruction);
        for (PsiElement psiElement : notableChildren) {
            PsiElement scope;
            if (checkLastParent && psiElement == lastParent) {
                if (allowForwardReferences) continue;
                break;
            }
            PsiElement psiElement2 = scope = psiElement instanceof SqlLocalDefinition ? ((SqlLocalDefinition)psiElement).getDefinitionScope() : null;
            if (scope != null && !PsiTreeUtil.isContextAncestor((PsiElement)scope, (PsiElement)place, (boolean)true) || psiElement instanceof SqlQueryExpression) continue;
            if (psiElement instanceof PsiNamedElement ? !processor.execute(psiElement, state) : (psiElement instanceof SqlDeclareStatementImpl || processChildrenDeclarations && (!(psiElement instanceof SqlStatement) || psiElement instanceof SqlDefinitionHolder)) && !psiElement.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            if (!(psiElement instanceof SqlExtraDeclarationsProvider)) continue;
            ((SqlExtraDeclarationsProvider)psiElement).processExtraDeclarations(processor, state, lastParent, place);
        }
        if (element2 instanceof SqlImplicitDeclarationsProvider && lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)element2, (PsiElement)lastParent, (boolean)true)) {
            SqlImplicitDeclarationsProvider provider = (SqlImplicitDeclarationsProvider)element2;
            processor.handleEvent(SqlScopeProcessor.RESOLVE_CONTEXT, (Object)element2);
            SqlScopeProcessor proc = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class);
            boolean stopIfFound = proc != null && proc.referenceName != null && proc.isResultEmpty() && provider.stopProcessingIfFoundInImplicitContext();
            boolean resume = provider.processImplicitContextDeclarations(processor, state, lastParent, place);
            return resume &= !stopIfFound || proc.isResultEmpty();
        }
        return true;
    }

    @NotNull
    public static <T> T[] toArray(@Nullable Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (factory == null) {
            SqlImplUtil.$$$reportNull$$$0(69);
        }
        Object[] objectArray = c2 != null ? c2.toArray(factory.create(c2.size())) : factory.create(0);
        if (objectArray == null) {
            SqlImplUtil.$$$reportNull$$$0(70);
        }
        return objectArray;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlReferenceList list) {
        List list2 = list == null ? Collections.emptyList() : list.getReferenceList();
        if (list2 == null) {
            SqlImplUtil.$$$reportNull$$$0(71);
        }
        return list2;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlTableColumnsList list) {
        List<SqlReferenceExpression> list2 = list == null ? Collections.emptyList() : SqlImplUtil.getReferenceList(list.getColumnsReferenceList());
        if (list2 == null) {
            SqlImplUtil.$$$reportNull$$$0(72);
        }
        return list2;
    }

    @NotNull
    public static List<DbDataSource> getDataSources(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(73);
        }
        PsiFile containingFile = element2.getContainingFile();
        List<DbDataSource> list = SqlDataSourceMappings.getInstance(containingFile.getProject()).getDataSources(containingFile);
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(74);
        }
        return list;
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialectSafe(@Nullable PsiElement element2) {
        SqlLanguageDialect dialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtil.getSqlDialect(element2), (Object)SqlDialectMappings.getDefaultSqlDialect());
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)dialect;
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(75);
        }
        return sqlLanguageDialectEx;
    }

    @NotNull
    public static ObjectKind getKindSynonymAware(@Nullable DasObject obj2) {
        if (obj2 instanceof SqlSynonymDefinition) {
            ObjectKind synonymTargetType;
            SqlReferenceExpression ref = ((SqlSynonymDefinition)obj2).getTargetReference();
            ObjectKind objectKind = synonymTargetType = ref != null ? ref.getReferenceElementType().getTargetKind() : null;
            if (synonymTargetType != null && synonymTargetType != SqlDbElementType.ANY) {
                ObjectKind objectKind2 = synonymTargetType;
                if (objectKind2 == null) {
                    SqlImplUtil.$$$reportNull$$$0(76);
                }
                return objectKind2;
            }
        } else if (obj2 instanceof SqlAsExpression) {
            SqlType type = ((SqlAsExpression)obj2).getSqlType();
            boolean isTable = type instanceof SqlTableType;
            if (type == SqlType.UNKNOWN) {
                PsiElement parent2 = ((SqlAsExpression)obj2).getParent();
                isTable = parent2 instanceof SqlJoinExpression || parent2 instanceof SqlFromClause;
            }
            ObjectKind objectKind = isTable ? ObjectKind.TABLE : ObjectKind.COLUMN;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(77);
            }
            return objectKind;
        }
        DasObject target = obj2 instanceof DasSynonym ? DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)obj2)) : obj2;
        ObjectKind objectKind = target == null ? SqlDbElementType.ANY : target.getKind();
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(78);
        }
        return objectKind;
    }

    public static JBIterable<? extends PsiElement> childrenStubIt(StubElement<?> element2) {
        return JBIterable.from((Iterable)element2.getChildrenStubs()).transform(STUB_TO_PSI);
    }

    public static JBIterable<? extends PsiElement> childrenTreeIt(PsiElement element2) {
        return SqlImplUtil.sqlChildren(element2).filter(SqlCompositeElement.class);
    }

    public static JBIterable<? extends PsiElement> childrenIt(PsiElement element2) {
        StubElement stub;
        Object object = element2 instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element2).getStub() : (stub = element2 instanceof PsiFileImpl ? ((PsiFileImpl)element2).getStub() : null);
        if (stub != null) {
            return SqlImplUtil.childrenStubIt(stub);
        }
        return SqlImplUtil.childrenTreeIt(element2);
    }

    @NotNull
    static List<SqlLabelDefinitionImpl> getLabels(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(79);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)element2, () -> {
            if (element2 == null) {
                SqlImplUtil.$$$reportNull$$$0(123);
            }
            return CachedValueProvider.Result.create(SqlImplUtil.calcLabels(element2), (Object[])new Object[]{element2});
        });
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(80);
        }
        return list;
    }

    @NotNull
    private static List<SqlLabelDefinitionImpl> calcLabels(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(81);
        }
        List list = SqlImplUtil.sqlTraverser(element2).filter(SqlLabelDefinitionImpl.class).toList();
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(82);
        }
        return list;
    }

    static boolean processSchemaMajorChildren(SqlScopeProcessor processor, Processor<DbElement> wrapper, DbElement schemaElement) {
        Condition majorChildCondition = element2 -> processor.dialect.isMajorChild(element2.getKind());
        for (DbTable child : schemaElement.getDasChildren(ObjectKind.TABLE).filter(DbTable.class)) {
            if (ContainerUtil.process((Iterable)child.getDasChildren(null).filter(majorChildCondition), wrapper)) continue;
            return false;
        }
        return true;
    }

    public static void quoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{identifier.getContainingFile()}).run(() -> identifier.setName(dialect.getDatabaseDialect().quoteIdentifier(identifier.getName(), true, false)));
    }

    public static void unquoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{identifier.getContainingFile()}).run(() -> {
            SqlIdentifier newId = SqlPsiElementFactory.createIdentifierFromText(identifier.getName(), dialect, project);
            if (newId != null) {
                identifier.replace((PsiElement)newId);
            }
        });
    }

    public static boolean canUnquote(@NotNull String newText, @NotNull DatabaseDialect dialect) {
        if (newText == null) {
            SqlImplUtil.$$$reportNull$$$0(83);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(84);
        }
        return StringUtil.equals((CharSequence)dialect.quoteIdentifier(newText, false, false), (CharSequence)newText);
    }

    @Nullable
    public static PsiElement getResolveScope(@Nullable PsiFile tmpFile) {
        if (tmpFile == null) {
            return null;
        }
        PsiFile file = SqlImplUtil.getTopLevelSqlFile(tmpFile);
        PsiElement context = file.getContext();
        return context instanceof DbElement ? ((DbElement)context).getDataSource() : file;
    }

    public static PsiFile getTopLevelSqlFile(@NotNull PsiFile tmpFile) {
        PsiFile topLevelFile;
        boolean sql;
        PsiFile contextFile;
        if (tmpFile == null) {
            SqlImplUtil.$$$reportNull$$$0(85);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)tmpFile)) {
            PsiElement context = tmpFile.getContext();
            PsiFile contextFile2 = context == null ? null : context.getContainingFile();
            return contextFile2 == null ? tmpFile : contextFile2;
        }
        if (tmpFile.getContext() != null && SqlImplUtil.isSameSqlFileDialect(tmpFile, contextFile = tmpFile.getContext().getContainingFile())) {
            tmpFile = contextFile;
        }
        if (sql = SqlImplUtil.isSameSqlFileDialect(tmpFile, topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile))) {
            return topLevelFile;
        }
        return tmpFile;
    }

    private static boolean isSameSqlFileDialect(@NotNull PsiFile child, @Nullable PsiFile parent2) {
        if (child == null) {
            SqlImplUtil.$$$reportNull$$$0(86);
        }
        SqlLanguageDialect fileDialect = parent2 instanceof SqlFile ? ((SqlFile)parent2).getSqlLanguage() : null;
        return fileDialect != null && fileDialect.getClass().isInstance((Object)SqlImplUtil.getSqlDialectSafe((PsiElement)child));
    }

    @Nullable
    public static VirtualFile getTopLevelFile(@NotNull PsiFile file) {
        PsiFile tmpFile;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(87);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)(tmpFile = file))) {
            PsiElement context = tmpFile.getContext();
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)(context == null ? null : context.getContainingFile()), (Object)tmpFile);
        } else {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile);
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)topLevelFile, (Object)tmpFile);
        }
        return tmpFile.getOriginalFile().getVirtualFile();
    }

    @NotNull
    public static String getCasedPart(@Nullable SqlReferenceExpression tableRef, @NotNull ObjectKind kind) {
        if (kind == null) {
            SqlImplUtil.$$$reportNull$$$0(88);
        }
        if (tableRef == null) {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(89);
            }
            return string;
        }
        ArrayList parts = ContainerUtil.newArrayList();
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.tryCast((Object)tableRef.getContainingFile(), SqlFile.class);
        if (casingProvider == null) {
            casingProvider = SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef).getDatabaseDialect();
        }
        SqlFileImpl.splitRef(SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef), tableRef, parts);
        for (Trinity part : parts) {
            if (part.first != kind) continue;
            String string = casingProvider.getCasing(kind, null).choose((Boolean)part.second == false).apply((String)part.third);
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(90);
            }
            return string;
        }
        String string = DasUtil.NO_NAME;
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(91);
        }
        return string;
    }

    @NotNull
    public static ObjectKind getQualifierKind(@NotNull PsiElement element2) {
        PsiElement target;
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(92);
        }
        SqlExpression qualifier = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getQualifierExpression() : null;
        PsiElement psiElement = target = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : null;
        if (qualifier == null && PsiTreeUtil.getParentOfType((PsiElement)element2, SqlQueryClause.class) != null) {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(93);
            }
            return objectKind;
        }
        ObjectKind objectKind = target instanceof DasObject ? SqlImplUtil.getKindSynonymAware((DasObject)target) : ObjectKind.NONE;
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(94);
        }
        return objectKind;
    }

    @NotNull
    public static SqlType getQualifierType(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(95);
        }
        SqlExpression qualifier = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getQualifierExpression() : null;
        Object object = qualifier != null ? qualifier.getSqlType() : SqlType.UNKNOWN;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(96);
        }
        return object;
    }

    public static boolean isAutoVal(@NotNull SqlColumnDefinition col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(97);
        }
        return SqlImplUtil.getSqlDialectSafe((PsiElement)col).isAutoIncrementColumn((DasColumn)col);
    }

    public static boolean isComputedVal(@NotNull SqlColumnDefinition col) {
        SqlColumnStub stub;
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(98);
        }
        SqlColumnStub sqlColumnStub = stub = col instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)col).getStub() : null;
        if (stub != null) {
            return stub.isComputed();
        }
        ASTNode node = col.getNode();
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE) != null;
    }

    @NotNull
    public static JBIterable<SqlStatement> iterateStatementsBackward(@NotNull PsiFile file, int offset) {
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(99);
        }
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)file)).expand(element2 -> element2.getTextRange().getStartOffset() < offset && (!(element2 instanceof SqlStatement) || element2.getTextRange().getEndOffset() >= offset))).postOrderDfsTraversal().filter(SqlStatement.class).filter(stmt -> stmt.getTextRange().getEndOffset() <= offset);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(100);
        }
        return jBIterable;
    }

    @NotNull
    public static List<PsiColumn> mergeColumnListInto(@NotNull List<PsiColumn> a, @NotNull List<? extends PsiColumn> b2, boolean caseSensitive, @Nullable PairFunction<PsiColumn, PsiColumn, Boolean> mergeCheck) {
        if (a == null) {
            SqlImplUtil.$$$reportNull$$$0(101);
        }
        if (b2 == null) {
            SqlImplUtil.$$$reportNull$$$0(102);
        }
        a.addAll(SqlImplUtil.processColumnList(b2, a, caseSensitive, mergeCheck, true));
        List<PsiColumn> list = a;
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(103);
        }
        return list;
    }

    @NotNull
    public static List<PsiColumn> processColumnList(@NotNull List<? extends PsiColumn> tgt, @NotNull List<? extends PsiColumn> src, boolean caseSensitive, @Nullable PairFunction<PsiColumn, PsiColumn, Boolean> check, boolean skip) {
        if (tgt == null) {
            SqlImplUtil.$$$reportNull$$$0(104);
        }
        if (src == null) {
            SqlImplUtil.$$$reportNull$$$0(105);
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)tgt.size());
        Map tgtMap = DasUtil.newCaseAwareMap((boolean)caseSensitive);
        for (PsiColumn psiColumn : src) {
            tgtMap.put(psiColumn.getName(), psiColumn);
        }
        for (PsiColumn psiColumn : tgt) {
            boolean matched;
            PsiColumn old = (PsiColumn)tgtMap.remove(psiColumn.getName());
            boolean bl = matched = old != null && (check == null || (Boolean)check.fun((Object)old, (Object)psiColumn) != false);
            if (matched && skip) continue;
            result2.add(matched ? old : psiColumn);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(106);
        }
        return arrayList;
    }

    public static boolean hasSameTypes(@Nullable PsiColumn a, @Nullable PsiColumn b2) {
        if (a == null || b2 == null) {
            return a == b2;
        }
        return a.getDataType().equals(b2.getDataType());
    }

    public static ObjectKind getBodyParentKind(@Nullable SqlDefinition o) {
        SqlNameElement nameElement = o != null ? o.getNameElement() : null;
        PsiElement lastChild = nameElement == null ? null : nameElement.getLastChild();
        return lastChild instanceof SqlReferenceExpression ? ((SqlReferenceExpression)lastChild).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
    }

    public static boolean equalsInsensitiveOrTrue(@Nullable String a, @Nullable String b2, boolean compare) {
        return !compare || Comparing.strEqual((String)a, (String)b2, (boolean)false);
    }

    public static boolean forbidGlobalTablesResolve(PsiElement place) {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
        if (ref == null) {
            return false;
        }
        if (SqlImplUtil.getSqlDialectSafe(place).allowGlobalTableResolve(place)) {
            return false;
        }
        if (ref.getReferenceElementType().getTargetKind() == ObjectKind.COLUMN) {
            return true;
        }
        SqlReferenceExpression parentRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getParent(), SqlReferenceExpression.class);
        if (parentRef == null) {
            return false;
        }
        if (parentRef.getParent() instanceof SqlTypeElement) {
            return false;
        }
        return parentRef.getReferenceElementType().getTargetKind() == ObjectKind.COLUMN;
    }

    @NotNull
    public static PsiElement[] getRelatedElements(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(107);
        }
        PsiElement[] psiElementArray = (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)definition, () -> {
            if (definition == null) {
                SqlImplUtil.$$$reportNull$$$0(122);
            }
            return CachedValueProvider.Result.create((Object)SqlImplUtil.calcRelatedElements(definition), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (psiElementArray == null) {
            SqlImplUtil.$$$reportNull$$$0(108);
        }
        return psiElementArray;
    }

    @NotNull
    private static PsiElement[] calcRelatedElements(@NotNull SqlDefinition definition) {
        SqlReferenceExpression ref;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(109);
        }
        if ((ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)definition.getNameElement(), SqlReferenceExpression.class)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(110);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(ref.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)definition), ref.getReferenceElementType(), (PsiElement)definition);
        if (newRef == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(111);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ResolveResult[] results2 = newRef.multiResolve(false);
        if (results2.length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(112);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] related = new PsiElement[results2.length];
        for (int i2 = 0; i2 < results2.length; ++i2) {
            related[i2] = results2[i2].getElement();
        }
        if (related == null) {
            SqlImplUtil.$$$reportNull$$$0(113);
        }
        return related;
    }

    public static boolean isProcessingOneOf(@NotNull PsiScopeProcessor processor, ObjectKind ... kinds) {
        SqlScopeProcessor sqlProcessor;
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(114);
        }
        if (kinds == null) {
            SqlImplUtil.$$$reportNull$$$0(115);
        }
        if ((sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class)) == null) {
            return true;
        }
        for (ObjectKind kind : kinds) {
            if (kind != SqlDbElementType.ANY && !sqlProcessor.mayAccept(kind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProcessingChildOf(@NotNull PsiScopeProcessor processor, @NotNull ObjectKind parent2) {
        SqlScopeProcessor sqlProcessor;
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(116);
        }
        if (parent2 == null) {
            SqlImplUtil.$$$reportNull$$$0(117);
        }
        if ((sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class)) == null || parent2 == SqlDbElementType.ANY) {
            return true;
        }
        return sqlProcessor.mayAcceptParent(parent2);
    }

    public static boolean ignoreKinds(@NotNull PsiScopeProcessor processor, @NotNull Collection<ObjectKind> types) {
        SqlScopeProcessor sqlProcessor;
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(118);
        }
        if (types == null) {
            SqlImplUtil.$$$reportNull$$$0(119);
        }
        if ((sqlProcessor = (SqlScopeProcessor)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class)) == null) {
            return true;
        }
        sqlProcessor.handleEvent(SqlScopeProcessor.IGNORE_TYPE, types);
        return !sqlProcessor.getExpectedTypes().isEmpty();
    }

    public static boolean canResolveToPgFunctionColumn(@Nullable PsiElement expr) {
        if (!(expr instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expr).getQualifierExpression() == null) {
            return false;
        }
        if (expr.getParent() instanceof SqlFunctionCallExpression) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expr, SqlSelectClause.class) != null;
    }

    @Nullable
    public static PomTarget getPomTarget(@Nullable Object element2) {
        return element2 instanceof PomTargetPsiElement ? ((PomTargetPsiElement)element2).getTarget() : null;
    }

    @Nullable
    public static PsiElement getChildOfType(@Nullable PsiElement e, @Nullable IElementType type) {
        if (e == null || type == null) {
            return null;
        }
        PsiElement child = e.getFirstChild();
        return child == null ? null : PsiTreeUtil.findSiblingForward((PsiElement)child, (IElementType)type, (boolean)false, null);
    }

    @Nullable
    public static PsiReference getReference(@NotNull PsiElement element2, @Nullable SqlIdentifier nameElement) {
        if (element2 == null) {
            SqlImplUtil.$$$reportNull$$$0(120);
        }
        if (nameElement == null) {
            return null;
        }
        PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)element2, (PsiElement)element2);
        ref.setRangeInElement(nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent()));
        return ref;
    }

    public static SqlTableType getTableTypeOfColumnList(@NotNull List<SqlReferenceExpression> colList, @Nullable SqlExpression tableExpression) {
        PsiElement table;
        if (colList == null) {
            SqlImplUtil.$$$reportNull$$$0(121);
        }
        if (colList.isEmpty()) {
            SqlType type;
            SqlType sqlType = type = tableExpression == null ? null : tableExpression.getSqlType();
            if (type instanceof SqlTableType) {
                return (SqlTableType)type;
            }
            return SqlTableTypeBase.EMPTY_TABLE;
        }
        ArrayList columns = ContainerUtil.newArrayList();
        for (SqlReferenceExpression col : colList) {
            PsiElement element2 = col.resolve();
            if (element2 instanceof SqlColumnDefinition) {
                columns.add(new Column(((SqlColumnDefinition)element2).getName(), ((SqlColumnDefinition)element2).getSqlType(), (PsiElement)col, element2));
                continue;
            }
            columns.add(new Column(col.getName(), (SqlType)SqlType.UNKNOWN, (PsiElement)col, null));
        }
        PsiElement qualifier = null;
        if (tableExpression instanceof SqlReferenceExpression && (table = ((SqlReferenceExpression)tableExpression).resolve()) instanceof SqlCreateTableStatement) {
            qualifier = table;
        }
        return SqlImplUtil.createType(columns, qualifier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 3: 
            case 119: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: 
            case 20: 
            case 41: 
            case 45: 
            case 59: 
            case 64: 
            case 84: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 40: 
            case 107: 
            case 109: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 46: 
            case 65: 
            case 67: 
            case 124: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 49: 
            case 52: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 58: 
            case 73: 
            case 79: 
            case 81: 
            case 92: 
            case 95: 
            case 120: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpFile";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 87: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 97: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgt";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 114: 
            case 116: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTraverser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevTraverser";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "byElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlParents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "revSiblings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setQualifier";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualified";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeLateralAware";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectType";
                break;
            }
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 60: 
            case 61: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElement";
                break;
            }
            case 53: 
            case 54: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeOf";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSqlType";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceList";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectSafe";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindSynonymAware";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabels";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLabels";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasedPart";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierKind";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierType";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateStatementsBackward";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeColumnListInto";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "processColumnList";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedElements";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRelatedElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "byElementType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "revSiblings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBlockContentElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCasingProvider";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheLeftOfType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheRightOfType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedElements";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMirror";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processQualifierImpl";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTypeLateralAware";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getSelectType";
                break;
            }
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElement";
                break;
            }
            case 52: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeOf";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "computeSqlType";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getLabels";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "calcLabels";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "canUnquote";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelSqlFile";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isSameSqlFileDialect";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getCasedPart";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierKind";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierType";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isAutoVal";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isComputedVal";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "iterateStatementsBackward";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "mergeColumnListInto";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "processColumnList";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedElements";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "calcRelatedElements";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingOneOf";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingChildOf";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "ignoreKinds";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getTableTypeOfColumnList";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRelatedElements$13";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLabels$7";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSqlType$6";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSqlType$4";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "lambda$byElementType$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 92: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyTable
    implements DasTable {
        private EmptyTable() {
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                EmptyTable.$$$reportNull$$$0(0);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                EmptyTable.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c2) {
            if (c2 instanceof PsiElement && SqlImplUtil.getSqlDialectSafe((PsiElement)c2).isAutoIncrementColumn(c2)) {
                EnumSet<DasColumn.Attribute> enumSet = EnumSet.of(DasColumn.Attribute.AUTO_GENERATED);
                if (enumSet == null) {
                    EmptyTable.$$$reportNull$$$0(2);
                }
                return enumSet;
            }
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                EmptyTable.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$EmptyTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Column {
        public final String name;
        public final SqlType type;
        public final PsiElement element;
        public final PsiElement sourceElement;

        public Column(String name, SqlType type, @NotNull PsiElement element2, PsiElement sourceElement) {
            if (element2 == null) {
                Column.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.type = type;
            this.element = element2;
            this.sourceElement = sourceElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil$Column", "<init>"));
        }
    }

    private static class MyColumnInfo
    extends RenameableFakePsiElement
    implements PsiColumn,
    SqlTypedDefinition {
        final DasTable myTableInfo;
        final int myIndex;
        final SqlTableType myTableType;
        final DasObject myInfo;

        MyColumnInfo(DasTable parent2, int index2, SqlTableType tableType) {
            super((PsiElement)((PsiElement)parent2).getContainingFile());
            this.myTableInfo = parent2;
            this.myIndex = index2;
            this.myTableType = tableType;
            PsiElement columnElement = tableType.getSourceColumnElement(index2);
            this.myInfo = (DasObject)ObjectUtils.tryCast((Object)columnElement, DasObject.class);
        }

        public boolean isNameQuoted() {
            if (this.myInfo != null) {
                return DbSqlUtil.isQuoted(this.myInfo);
            }
            return DbSqlUtil.isQuoted((SqlNameElement)ObjectUtils.tryCast((Object)this.myTableType.getColumnElement(this.myIndex), SqlNameElement.class));
        }

        public String getTableName() {
            return this.myTableInfo.getName();
        }

        public DasTable getTable() {
            return this.myTableInfo;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                MyColumnInfo.$$$reportNull$$$0(0);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myTableType.getColumnName(this.myIndex), (String)DasUtil.NO_NAME);
            if (string == null) {
                MyColumnInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String getComment() {
            return this.myInfo == null ? null : this.myInfo.getComment();
        }

        public DasObject getDasParent() {
            return this.getTable();
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDataType() : DataTypeFactory.of(this.myTableType.getColumnType(this.myIndex).getDisplayName());
            if (dataType == null) {
                MyColumnInfo.$$$reportNull$$$0(2);
            }
            return dataType;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = this.myTableType.getColumnType(this.myIndex);
            if (sqlType == null) {
                MyColumnInfo.$$$reportNull$$$0(3);
            }
            return sqlType;
        }

        public boolean isNotNull() {
            return this.myInfo instanceof DasTypedObject && ((DasTypedObject)this.myInfo).isNotNull();
        }

        public String getDefault() {
            return this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDefault() : null;
        }

        public PsiElement getParent() {
            return (PsiElement)this.myTableInfo;
        }

        public String getTypeName() {
            return DbPresentation.getPresentableName(this.getKind(), DatabaseDialects.getGenericDialect());
        }

        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myTableType.getColumnElement(this.myIndex);
            if (psiElement == null) {
                MyColumnInfo.$$$reportNull$$$0(4);
            }
            return psiElement;
        }

        public short getPosition() {
            return (short)(this.myIndex + 1);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return null;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return null;
        }

        public void accept(SqlVisitor visitor2) {
            visitor2.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor2) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

